/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.event.EventDispatcher;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.topo.model.UiModelEvent;
import org.onosproject.ui.model.ServiceBundle;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiEdgeLink;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;
import org.onosproject.ui.model.topo.UiTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelCache {
    private static final String E_NO_ELEMENT = "Tried to remove non-member {}: {}";
    private static final Logger log = LoggerFactory.getLogger(ModelCache.class);
    private final ServiceBundle services;
    private final EventDispatcher dispatcher;
    private final UiTopology uiTopology = new UiTopology();

    ModelCache(ServiceBundle services, EventDispatcher eventDispatcher) {
        this.services = services;
        this.dispatcher = eventDispatcher;
    }

    public String toString() {
        return "ModelCache{" + this.uiTopology + "}";
    }

    private void postEvent(UiModelEvent.Type type, UiElement subject) {
        this.dispatcher.post((Event)new UiModelEvent(type, subject));
    }

    void clear() {
        this.uiTopology.clear();
    }

    void load() {
        this.loadClusterMembers();
        this.loadRegions();
        this.loadDevices();
        this.loadDeviceLinks();
        this.loadHosts();
    }

    private UiClusterMember addNewClusterMember(ControllerNode n) {
        UiClusterMember member = new UiClusterMember(this.uiTopology, n);
        this.uiTopology.add(member);
        return member;
    }

    private void updateClusterMember(UiClusterMember member) {
        ControllerNode.State state = this.services.cluster().getState(member.id());
        member.setState(state);
        member.setMastership(this.services.mastership().getDevicesOf(member.id()));
    }

    private void loadClusterMembers() {
        for (ControllerNode n : this.services.cluster().getNodes()) {
            UiClusterMember member = this.addNewClusterMember(n);
            this.updateClusterMember(member);
        }
    }

    void addOrUpdateClusterMember(ControllerNode cnode) {
        NodeId id = cnode.id();
        UiClusterMember member = this.uiTopology.findClusterMember(id);
        if (member == null) {
            member = this.addNewClusterMember(cnode);
        }
        this.updateClusterMember(member);
        this.postEvent(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, (UiElement)member);
    }

    UiClusterMember accessClusterMember(NodeId id) {
        return this.uiTopology.findClusterMember(id);
    }

    void removeClusterMember(ControllerNode cnode) {
        NodeId id = cnode.id();
        UiClusterMember member = this.uiTopology.findClusterMember(id);
        if (member != null) {
            this.uiTopology.remove(member);
            this.postEvent(UiModelEvent.Type.CLUSTER_MEMBER_REMOVED, (UiElement)member);
        } else {
            log.warn(E_NO_ELEMENT, (Object)"cluster node", (Object)id);
        }
    }

    List<UiClusterMember> getAllClusterMembers() {
        return this.uiTopology.allClusterMembers();
    }

    void updateMasterships(DeviceId deviceId, RoleInfo roleInfo) {
    }

    UiRegion nullRegion() {
        return this.uiTopology.nullRegion();
    }

    private UiRegion addNewRegion(Region r) {
        UiRegion region = new UiRegion(this.uiTopology, r);
        this.uiTopology.add(region);
        log.debug("Region {} added to topology", (Object)region);
        return region;
    }

    private void updateRegion(UiRegion region) {
        RegionId rid = region.id();
        Set deviceIds = this.services.region().getRegionDevices(rid);
        Set hostIds = this.services.region().getRegionHosts(rid);
        deviceIds.forEach(d -> {
            UiDevice dev = this.uiTopology.findDevice(d);
            if (dev != null) {
                dev.setRegionId(rid);
            } else {
                log.warn("Region device {}, but we don't have UiDevice in topology", d);
            }
        });
        hostIds.forEach(d -> {
            UiHost host = this.uiTopology.findHost(d);
            if (host != null) {
                host.setRegionId(rid);
            } else {
                log.warn("Region host {}, but we don't have UiHost in topology", d);
            }
        });
        region.reconcileDevices(deviceIds);
        region.reconcileHosts(hostIds);
        this.fixupContainmentHierarchy(region);
    }

    private void fixupContainmentHierarchy(UiRegion region) {
        RegionId regionId;
        UiTopoLayoutService ls = this.services.layout();
        UiTopoLayout layout = ls.getLayout(regionId = region.id());
        if (layout == null) {
            log.warn("No layout backed by region {}", (Object)regionId);
            return;
        }
        UiTopoLayoutId layoutId = layout.id();
        if (!layout.isRoot()) {
            UiTopoLayoutId parentId = layout.parent();
            UiTopoLayout parentLayout = ls.getLayout(parentId);
            RegionId parentRegionId = parentLayout.regionId();
            region.setParent(parentRegionId);
        }
        Set kids = ls.getChildren(layoutId);
        HashSet kidRegionIds = new HashSet(kids.size());
        kids.forEach(k -> kidRegionIds.add(k.regionId()));
        region.setChildren(kidRegionIds);
    }

    private void loadRegions() {
        for (Region r : this.services.region().getRegions()) {
            UiRegion region = this.addNewRegion(r);
            this.updateRegion(region);
        }
    }

    void addOrUpdateRegion(Region region) {
        RegionId id = region.id();
        UiRegion uiRegion = this.uiTopology.findRegion(id);
        if (uiRegion == null) {
            uiRegion = this.addNewRegion(region);
        }
        this.updateRegion(uiRegion);
        this.postEvent(UiModelEvent.Type.REGION_ADDED_OR_UPDATED, (UiElement)uiRegion);
    }

    UiRegion accessRegion(RegionId id) {
        return id == null ? null : this.uiTopology.findRegion(id);
    }

    void removeRegion(Region region) {
        RegionId id = region.id();
        UiRegion uiRegion = this.uiTopology.findRegion(id);
        if (uiRegion != null) {
            this.uiTopology.remove(uiRegion);
            this.postEvent(UiModelEvent.Type.REGION_REMOVED, (UiElement)uiRegion);
        } else {
            log.warn(E_NO_ELEMENT, (Object)"region", (Object)id);
        }
    }

    Set<UiRegion> getAllRegions() {
        return this.uiTopology.allRegions();
    }

    private UiDevice addNewDevice(Device d) {
        UiDevice device = new UiDevice(this.uiTopology, d);
        this.updateDevice(device);
        this.uiTopology.add(device);
        log.debug("Device {} added to topology", (Object)device);
        return device;
    }

    private void updateDevice(UiDevice device) {
        Region r = this.services.region().getRegionForDevice(device.id());
        RegionId rid = r == null ? UiRegion.NULL_ID : r.id();
        device.setRegionId(rid);
    }

    private void loadDevices() {
        for (Device d : this.services.device().getDevices()) {
            this.addNewDevice(d);
        }
    }

    void addOrUpdateDevice(Device device) {
        DeviceId id = device.id();
        UiDevice uiDevice = this.uiTopology.findDevice(id);
        if (uiDevice == null) {
            uiDevice = this.addNewDevice(device);
        } else {
            this.updateDevice(uiDevice);
        }
        this.postEvent(UiModelEvent.Type.DEVICE_ADDED_OR_UPDATED, (UiElement)uiDevice);
    }

    UiDevice accessDevice(DeviceId id) {
        return this.uiTopology.findDevice(id);
    }

    void removeDevice(Device device) {
        DeviceId id = device.id();
        UiDevice uiDevice = this.uiTopology.findDevice(id);
        if (uiDevice != null) {
            this.uiTopology.remove(uiDevice);
            this.postEvent(UiModelEvent.Type.DEVICE_REMOVED, (UiElement)uiDevice);
        } else {
            log.warn(E_NO_ELEMENT, (Object)"device", (Object)id);
        }
    }

    Set<UiDevice> getAllDevices() {
        return this.uiTopology.allDevices();
    }

    private UiDeviceLink addNewDeviceLink(UiLinkId id) {
        UiDeviceLink uiDeviceLink = new UiDeviceLink(this.uiTopology, id);
        this.uiTopology.add(uiDeviceLink);
        return uiDeviceLink;
    }

    private UiEdgeLink addNewEdgeLink(UiLinkId id) {
        UiEdgeLink uiEdgeLink = new UiEdgeLink(this.uiTopology, id);
        this.uiTopology.add(uiEdgeLink);
        return uiEdgeLink;
    }

    private void updateDeviceLink(UiDeviceLink uiDeviceLink, Link link) {
        uiDeviceLink.attachBackingLink(link);
    }

    private void loadDeviceLinks() {
        for (Link link : this.services.link().getLinks()) {
            UiLinkId id = UiLinkId.uiLinkId((Link)link);
            UiDeviceLink uiDeviceLink = this.uiTopology.findDeviceLink(id);
            if (uiDeviceLink == null) {
                uiDeviceLink = this.addNewDeviceLink(id);
            }
            this.updateDeviceLink(uiDeviceLink, link);
        }
    }

    void addOrUpdateDeviceLink(Link link) {
        UiLinkId id = UiLinkId.uiLinkId((Link)link);
        UiDeviceLink uiDeviceLink = this.uiTopology.findDeviceLink(id);
        if (uiDeviceLink == null) {
            uiDeviceLink = this.addNewDeviceLink(id);
        }
        this.updateDeviceLink(uiDeviceLink, link);
        this.postEvent(UiModelEvent.Type.LINK_ADDED_OR_UPDATED, (UiElement)uiDeviceLink);
    }

    UiDeviceLink accessDeviceLink(UiLinkId id) {
        return this.uiTopology.findDeviceLink(id);
    }

    void removeDeviceLink(Link link) {
        UiLinkId id = UiLinkId.uiLinkId((Link)link);
        UiDeviceLink uiDeviceLink = this.uiTopology.findDeviceLink(id);
        if (uiDeviceLink != null) {
            boolean remaining = uiDeviceLink.detachBackingLink(link);
            if (remaining) {
                this.postEvent(UiModelEvent.Type.LINK_ADDED_OR_UPDATED, (UiElement)uiDeviceLink);
            } else {
                this.uiTopology.remove(uiDeviceLink);
                this.postEvent(UiModelEvent.Type.LINK_REMOVED, (UiElement)uiDeviceLink);
            }
        } else {
            log.warn(E_NO_ELEMENT, (Object)"Device link", (Object)id);
        }
    }

    Set<UiDeviceLink> getAllDeviceLinks() {
        return this.uiTopology.allDeviceLinks();
    }

    private EdgeLink synthesizeLink(Host h) {
        return DefaultEdgeLink.createEdgeLink((Host)h, (boolean)true);
    }

    private UiHost addNewHost(Host h) {
        UiHost host = new UiHost(this.uiTopology, h);
        this.uiTopology.add(host);
        EdgeLink elink = this.synthesizeLink(h);
        UiLinkId elinkId = UiLinkId.uiLinkId((Link)elink);
        host.setEdgeLinkId(elinkId);
        this.addNewEdgeLink(elinkId);
        return host;
    }

    private void insertNewUiEdgeLink(UiLinkId id) {
        this.addNewEdgeLink(id);
    }

    private void updateHost(UiHost uiHost, Host h) {
        UiEdgeLink existing = this.uiTopology.findEdgeLink(uiHost.edgeLinkId());
        EdgeLink currentElink = this.synthesizeLink(h);
        UiLinkId currentElinkId = UiLinkId.uiLinkId((Link)currentElink);
        if (existing != null) {
            if (!currentElinkId.equals((Object)existing.id())) {
                this.insertNewUiEdgeLink(currentElinkId);
                uiHost.setEdgeLinkId(currentElinkId);
                this.uiTopology.remove(existing);
            }
        } else {
            this.insertNewUiEdgeLink(currentElinkId);
            uiHost.setEdgeLinkId(currentElinkId);
        }
        HostLocation hloc = h.location();
        uiHost.setLocation(hloc.deviceId(), hloc.port());
    }

    private void loadHosts() {
        for (Host h : this.services.host().getHosts()) {
            UiHost host = this.addNewHost(h);
            this.updateHost(host, h);
        }
    }

    void addOrUpdateHost(Host host) {
        HostId id = host.id();
        UiHost uiHost = this.uiTopology.findHost(id);
        if (uiHost == null) {
            uiHost = this.addNewHost(host);
        }
        this.updateHost(uiHost, host);
        this.postEvent(UiModelEvent.Type.HOST_ADDED_OR_UPDATED, (UiElement)uiHost);
    }

    void moveHost(Host host, Host prevHost) {
        UiHost uiHost = this.uiTopology.findHost(prevHost.id());
        if (uiHost != null) {
            this.updateHost(uiHost, host);
            this.postEvent(UiModelEvent.Type.HOST_MOVED, (UiElement)uiHost);
        } else {
            log.warn(E_NO_ELEMENT, (Object)"host", (Object)prevHost.id());
        }
    }

    UiHost accessHost(HostId id) {
        return this.uiTopology.findHost(id);
    }

    void removeHost(Host host) {
        HostId id = host.id();
        UiHost uiHost = this.uiTopology.findHost(id);
        if (uiHost != null) {
            UiEdgeLink edgeLink = this.uiTopology.findEdgeLink(uiHost.edgeLinkId());
            this.uiTopology.remove(edgeLink);
            this.uiTopology.remove(uiHost);
            this.postEvent(UiModelEvent.Type.HOST_REMOVED, (UiElement)uiHost);
        } else {
            log.warn(E_NO_ELEMENT, (Object)"host", (Object)id);
        }
    }

    Set<UiHost> getAllHosts() {
        return this.uiTopology.allHosts();
    }

    List<UiSynthLink> getSynthLinks(RegionId regionId) {
        return this.uiTopology.findSynthLinks(regionId);
    }

    public void refresh() {
        this.fixupContainmentHierarchy(this.uiTopology.nullRegion());
        this.uiTopology.allRegions().forEach(arg_0 -> this.fixupContainmentHierarchy(arg_0));
        Set allDevices = this.uiTopology.allDevices();
        Set allHosts = this.uiTopology.allHosts();
        this.services.region().getRegions().forEach(r -> {
            RegionId rid = r.id();
            UiRegion region = this.uiTopology.findRegion(rid);
            if (region != null) {
                this.reconcileDevicesAndHostsWithRegion(allDevices, allHosts, rid, region);
            } else {
                log.warn("No UiRegion in topology for ID {}", (Object)rid);
            }
        });
        HashSet leftOver = new HashSet(allDevices.size());
        allDevices.forEach(d -> leftOver.add(d.id()));
        this.uiTopology.nullRegion().reconcileDevices(leftOver);
        HashSet leftOverHosts = new HashSet(allHosts.size());
        allHosts.forEach(h -> leftOverHosts.add(h.id()));
        this.uiTopology.nullRegion().reconcileHosts(leftOverHosts);
        this.uiTopology.computeSynthLinks();
    }

    private void reconcileDevicesAndHostsWithRegion(Set<UiDevice> allDevices, Set<UiHost> allHosts, RegionId rid, UiRegion region) {
        Set deviceIds = this.services.region().getRegionDevices(rid);
        HashSet hostIds = new HashSet();
        region.reconcileDevices(deviceIds);
        deviceIds.forEach(devId -> {
            UiDevice dev = this.uiTopology.findDevice(devId);
            if (dev != null) {
                dev.setRegionId(rid);
                allDevices.remove(dev);
            } else {
                log.warn("Region device ID {} but no UiDevice in topology", devId);
            }
            Set hosts = this.services.host().getConnectedHosts(devId);
            for (Host h : hosts) {
                HostId hid = h.id();
                hostIds.add(hid);
                UiHost host = this.uiTopology.findHost(hid);
                if (host != null) {
                    host.setRegionId(rid);
                    allHosts.remove(host);
                    continue;
                }
                log.warn("Region host ID {} but no UiHost in topology", (Object)hid);
            }
        });
        region.reconcileHosts(hostIds);
    }

    public String dumpString() {
        return this.uiTopology.dumpString();
    }

    public int clusterMemberCount() {
        return this.uiTopology.clusterMemberCount();
    }

    public int regionCount() {
        return this.uiTopology.regionCount();
    }

    public int deviceCount() {
        return this.uiTopology.deviceCount();
    }

    public int deviceLinkCount() {
        return this.uiTopology.deviceLinkCount();
    }

    public int edgeLinkCount() {
        return this.uiTopology.edgeLinkCount();
    }

    public int hostCount() {
        return this.uiTopology.hostCount();
    }

    public int synthLinkCount() {
        return this.uiTopology.synthLinkCount();
    }
}

