/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.birds;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.junit.Ignore;
import org.junit.Test;

public class BirdEncoderTest {
    private static final String ORIG = "  original> ";
    private static final String DATA = "  data> ";
    private static final String BEAN = "  bean> ";
    private static final String SAUCE = "  sauce> ";
    private static final String NONE = "(none)";
    private static final String PNG = ".png";
    private static final String FOO = ".foo";
    private static final FilenameFilter FOO_FILTER = (dir, name) -> name.endsWith(FOO);
    private static final FilenameFilter PNG_FILTER = (dir, name) -> name.endsWith(PNG);
    private static final Comparator<File> FILE_COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private static final File DIR = new File("src/test/java/org/onosproject/ui/impl/birds");
    private static final File FOO_DIR = new File(DIR, "foo");
    private static final File ORIG_DIR = new File(DIR, "orig");
    private static final byte UPPER = -16;
    private static final byte LOWER = 15;
    private final Random random = new Random(new Date().getTime());
    private final byte[] rbytes = new byte[2];
    private int r1;
    private int r2;

    private static void print(String fmt, Object ... params) {
        System.out.println(String.format(fmt, params));
    }

    private List<File> filesIn(File dir, FilenameFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, FILE_COMPARATOR);
        return Arrays.asList(files);
    }

    private String basename(File f) {
        String name = f.getName();
        int i = name.indexOf(PNG);
        return name.substring(0, i);
    }

    private boolean dataRequired(Encoding encoding, List<String> dataFiles) {
        return !dataFiles.contains(encoding.dataName());
    }

    private List<String> makeFileNames(List<File> dataFiles) {
        ArrayList<String> names = new ArrayList<String>(dataFiles.size());
        for (File f : dataFiles) {
            names.add(f.getName());
        }
        return names;
    }

    private void randomBytes() {
        this.random.nextBytes(this.rbytes);
        this.r1 = this.rbytes[0];
        this.r2 = this.rbytes[1];
    }

    private void addNoise(ByteBuffer bb, byte b) {
        this.randomBytes();
        int upper = b & 0xFFFFFFF0;
        int lower = b & 0xF;
        int uNoise = this.r1 & 0xF;
        int lNoise = this.r2 & 0xFFFFFFF0;
        int uEnc = upper | uNoise;
        int lEnc = lower | lNoise;
        bb.put((byte)uEnc);
        bb.put((byte)lEnc);
    }

    private ByteBuffer encodePng(File file) throws IOException {
        byte[] bytes = Files.toByteArray((File)file);
        int size = bytes.length;
        ByteBuffer bb = ByteBuffer.allocate(size * 2);
        for (int i = 0; i < size; ++i) {
            this.addNoise(bb, bytes[i]);
        }
        return bb;
    }

    private void generateDataFile(Encoding encoding) {
        File png = new File(ORIG_DIR, encoding.pngName());
        File foo = new File(FOO_DIR, encoding.dataName());
        try {
            ByteBuffer bb = this.encodePng(png);
            this.writeBufferToFile(bb, foo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeBufferToFile(ByteBuffer bb, File file) throws IOException {
        bb.flip();
        FileChannel chan = new FileOutputStream(file, false).getChannel();
        chan.write(bb);
        chan.close();
        BirdEncoderTest.print("    Wrote file: %s  (%d bytes)", file, bb.capacity());
    }

    @Test
    @Ignore
    public void encodeThings() {
        BirdEncoderTest.print("Encoding things...", new Object[0]);
        List<File> originals = this.filesIn(ORIG_DIR, PNG_FILTER);
        List<File> dataFiles = this.filesIn(FOO_DIR, FOO_FILTER);
        List<String> fileNames = this.makeFileNames(dataFiles);
        int count = 0;
        for (File f : originals) {
            Encoding encoding = new Encoding(this.basename(f)).encode();
            BirdEncoderTest.print("%n%s", encoding);
            if (!this.dataRequired(encoding, fileNames)) continue;
            this.generateDataFile(encoding);
            ++count;
        }
        BirdEncoderTest.print("%nFoo files generated: %d", count);
    }

    private static class Encoding {
        private final String name;
        private String bean = "(none)";
        private String sauce = "(none)";

        Encoding(String name) {
            this.name = name;
        }

        public String toString() {
            return BirdEncoderTest.ORIG + this.name + BirdEncoderTest.PNG + BirdEncoderTest.DATA + this.bean + BirdEncoderTest.FOO + BirdEncoderTest.BEAN + this.bean + BirdEncoderTest.SAUCE + this.sauce;
        }

        private Encoding encode() {
            String u = this.name.toUpperCase();
            int x = u.codePointAt(1) - 64;
            int r = x * 7 % 26;
            String uc = this.doTransform(r, u);
            this.bean = uc.toLowerCase();
            StringBuilder sauceSb = new StringBuilder();
            sauceSb.append(r).append(":");
            for (String q : uc.split("")) {
                sauceSb.append(q.codePointAt(0));
            }
            this.sauce = sauceSb.toString();
            return this;
        }

        private String doTransform(int r, String u) {
            int m = 65;
            int x = 90;
            int d = 26;
            int s = 155;
            String[] letters = u.split("");
            StringBuilder sb = new StringBuilder();
            for (String j : letters) {
                int k = j.codePointAt(0);
                int e = s - k + r;
                e = e > 90 ? e - d : e;
                sb.append(Character.toChars(e));
            }
            return sb.toString();
        }

        String dataName() {
            return this.bean + BirdEncoderTest.FOO;
        }

        String pngName() {
            return this.name + BirdEncoderTest.PNG;
        }
    }
}

