/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Accumulator;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.Key;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.impl.TopoOverlayCache;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.TopologyViewMessageHandlerBase;
import org.onosproject.ui.impl.TrafficMonitor;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.PropertyPanel;
import org.onosproject.ui.topo.TopoJson;
import org.slf4j.Logger;

public class TopologyViewMessageHandler
extends TopologyViewMessageHandlerBase {
    private static final String REQ_DETAILS = "requestDetails";
    private static final String UPDATE_META = "updateMeta";
    private static final String ADD_HOST_INTENT = "addHostIntent";
    private static final String REMOVE_INTENT = "removeIntent";
    private static final String RESUBMIT_INTENT = "resubmitIntent";
    private static final String ADD_MULTI_SRC_INTENT = "addMultiSourceIntent";
    private static final String REQ_RELATED_INTENTS = "requestRelatedIntents";
    private static final String REQ_NEXT_INTENT = "requestNextRelatedIntent";
    private static final String REQ_PREV_INTENT = "requestPrevRelatedIntent";
    private static final String REQ_SEL_INTENT_TRAFFIC = "requestSelectedIntentTraffic";
    private static final String SEL_INTENT = "selectIntent";
    private static final String REQ_ALL_FLOW_TRAFFIC = "requestAllFlowTraffic";
    private static final String REQ_ALL_PORT_TRAFFIC = "requestAllPortTraffic";
    private static final String REQ_DEV_LINK_FLOWS = "requestDeviceLinkFlows";
    private static final String CANCEL_TRAFFIC = "cancelTraffic";
    private static final String REQ_SUMMARY = "requestSummary";
    private static final String CANCEL_SUMMARY = "cancelSummary";
    private static final String EQ_MASTERS = "equalizeMasters";
    private static final String SPRITE_LIST_REQ = "spriteListRequest";
    private static final String SPRITE_DATA_REQ = "spriteDataRequest";
    private static final String TOPO_START = "topoStart";
    private static final String TOPO_SELECT_OVERLAY = "topoSelectOverlay";
    private static final String TOPO_STOP = "topoStop";
    private static final String SHOW_SUMMARY = "showSummary";
    private static final String SHOW_DETAILS = "showDetails";
    private static final String SPRITE_LIST_RESPONSE = "spriteListResponse";
    private static final String SPRITE_DATA_RESPONSE = "spriteDataResponse";
    private static final String UPDATE_INSTANCE = "updateInstance";
    private static final String TOPO_START_DONE = "topoStartDone";
    private static final String PAYLOAD = "payload";
    private static final String EXTRA = "extra";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String APP_ID = "appId";
    private static final String APP_NAME = "appName";
    private static final String DEVICE = "device";
    private static final String HOST = "host";
    private static final String CLASS = "class";
    private static final String UNKNOWN = "unknown";
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String SRC = "src";
    private static final String DST = "dst";
    private static final String DATA = "data";
    private static final String NAME = "name";
    private static final String NAMES = "names";
    private static final String ACTIVATE = "activate";
    private static final String DEACTIVATE = "deactivate";
    private static final String PURGE = "purge";
    private static final String MY_APP_ID = "org.onosproject.gui";
    private static final long TRAFFIC_PERIOD = 5000L;
    private static final long SUMMARY_PERIOD = 30000L;
    private static final Comparator<? super ControllerNode> NODE_COMPARATOR = (o1, o2) -> o1.id().toString().compareTo(o2.id().toString());
    private final Timer timer = new Timer("onos-topology-view");
    private static final int MAX_EVENTS = 1000;
    private static final int MAX_BATCH_MS = 5000;
    private static final int MAX_IDLE_MS = 1000;
    private ApplicationId appId;
    private final ClusterEventListener clusterListener = new InternalClusterListener(this, null);
    private final MastershipListener mastershipListener = new InternalMastershipListener(this, null);
    private final DeviceListener deviceListener = new InternalDeviceListener(this, null);
    private final LinkListener linkListener = new InternalLinkListener(this, null);
    private final HostListener hostListener = new InternalHostListener(this, null);
    private final IntentListener intentListener = new InternalIntentListener(this, null);
    private final FlowRuleListener flowListener = new InternalFlowListener(this, null);
    private final Accumulator<Event> eventAccummulator = new InternalEventAccummulator(this);
    private final ExecutorService msgSender = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/gui", (String)"msg-sender", (Logger)log));
    private TopoOverlayCache overlayCache;
    private TrafficMonitor traffic;
    private TimerTask summaryTask = null;
    private boolean summaryRunning = false;
    private volatile boolean listenersRemoved = false;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.appId = ((CoreService)directory.get(CoreService.class)).registerApplication(MY_APP_ID);
        this.traffic = new TrafficMonitor(5000L, this.servicesBundle, this);
    }

    public void destroy() {
        this.cancelAllRequests();
        this.removeListeners();
        super.destroy();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new TopoStart(this, null), (Object)new TopoSelectOverlay(this, null), (Object)new TopoStop(this, null), (Object)new ReqSummary(this, null), (Object)new CancelSummary(this, null), (Object)new SpriteListReq(this, null), (Object[])new RequestHandler[]{new SpriteDataReq(this, null), new RequestDetails(this, null), new UpdateMeta(this, null), new EqMasters(this, null), new AddHostIntent(this, null), new AddMultiSourceIntent(this, null), new RemoveIntent(this, null), new ResubmitIntent(this, null), new ReqAllFlowTraffic(this, null), new ReqAllPortTraffic(this, null), new ReqDevLinkFlows(this, null), new ReqRelatedIntents(this, null), new ReqNextIntent(this, null), new ReqPrevIntent(this, null), new ReqSelectedIntentTraffic(this, null), new SelIntent(this, null), new CancelTraffic(this, null)});
    }

    void setOverlayCache(TopoOverlayCache overlayCache) {
        this.overlayCache = overlayCache;
    }

    private Intent findIntentByPayload(ObjectNode payload) {
        int appId = Integer.parseInt(JsonUtils.string((ObjectNode)payload, (String)APP_ID));
        String appName = JsonUtils.string((ObjectNode)payload, (String)APP_NAME);
        DefaultApplicationId applicId = new DefaultApplicationId(appId, appName);
        long intentKey = Long.decode(JsonUtils.string((ObjectNode)payload, (String)KEY));
        Key key = Key.of((long)intentKey, (ApplicationId)applicId);
        log.debug("Attempting to select intent by key={}", (Object)key);
        return this.intentService.getIntent(key);
    }

    protected void sendHighlights(Highlights highlights) {
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private synchronized void requestSummary(long sid) {
        PropertyPanel pp = this.summmaryMessage(sid);
        this.overlayCache.currentOverlay().modifySummary(pp);
        this.sendMessage(JsonUtils.envelope((String)SHOW_SUMMARY, (long)sid, (ObjectNode)TopoJson.json((PropertyPanel)pp)));
    }

    private void cancelAllRequests() {
        this.stopSummaryMonitoring();
        this.traffic.stopMonitoring();
    }

    private void sendAllInstances(String messageType) {
        ArrayList nodes = new ArrayList(this.clusterService.getNodes());
        Collections.sort(nodes, NODE_COMPARATOR);
        for (ControllerNode node : nodes) {
            this.sendMessage(this.instanceMessage(new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node), messageType));
        }
    }

    private void sendAllDevices() {
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() != Device.Type.ROADM && device.type() != Device.Type.OTN) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() == Device.Type.ROADM || device.type() == Device.Type.OTN) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
    }

    private void sendAllLinks() {
        for (Link link : this.linkService.getLinks()) {
            if (link.type() != Link.Type.OPTICAL) continue;
            this.sendMessage(this.composeLinkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
        for (Link link : this.linkService.getLinks()) {
            if (link.type() == Link.Type.OPTICAL) continue;
            this.sendMessage(this.composeLinkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
    }

    private ObjectNode composeLinkMessage(LinkEvent event) {
        ObjectNode msg = this.linkMessage(event);
        Map additional = this.overlayCache.currentOverlay().additionalLinkData(event);
        if (additional != null) {
            ObjectNode payload = (ObjectNode)msg.get(PAYLOAD);
            payload.set(EXTRA, (JsonNode)this.createExtra(additional));
        }
        return msg;
    }

    private ObjectNode createExtra(Map<String, String> additional) {
        ObjectNode extra = this.objectNode();
        for (Map.Entry<String, String> entry : additional.entrySet()) {
            extra.put(entry.getKey(), entry.getValue());
        }
        return extra;
    }

    private void sendAllHosts() {
        for (Host host : this.hostService.getHosts()) {
            this.sendMessage(this.hostMessage(new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        }
    }

    private Set<ConnectPoint> getHostLocations(Set<HostId> hostIds) {
        HashSet<ConnectPoint> points = new HashSet<ConnectPoint>();
        for (HostId hostId : hostIds) {
            points.add((ConnectPoint)this.getHostLocation(hostId));
        }
        return points;
    }

    private HostLocation getHostLocation(HostId hostId) {
        return this.hostService.getHost(hostId).location();
    }

    private Set<HostId> getHostIds(ArrayNode ids) {
        HashSet<HostId> hostIds = new HashSet<HostId>();
        for (JsonNode id : ids) {
            hostIds.add(HostId.hostId((String)id.asText()));
        }
        return hostIds;
    }

    private void sendTopoStartDone() {
        this.sendMessage(JsonUtils.envelope((String)TOPO_START_DONE, (ObjectNode)this.objectNode()));
    }

    private synchronized void startSummaryMonitoring() {
        this.stopSummaryMonitoring();
        this.summaryTask = new SummaryMonitor(this, null);
        this.timer.schedule(this.summaryTask, 30000L, 30000L);
        this.summaryRunning = true;
    }

    private synchronized void stopSummaryMonitoring() {
        if (this.summaryTask != null) {
            this.summaryTask.cancel();
            this.summaryTask = null;
        }
        this.summaryRunning = false;
    }

    private synchronized void addListeners() {
        this.listenersRemoved = false;
        this.clusterService.addListener((EventListener)this.clusterListener);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.intentService.addListener((EventListener)this.intentListener);
        this.flowService.addListener((EventListener)this.flowListener);
    }

    private synchronized void removeListeners() {
        if (!this.listenersRemoved) {
            this.listenersRemoved = true;
            this.clusterService.removeListener((EventListener)this.clusterListener);
            this.mastershipService.removeListener((EventListener)this.mastershipListener);
            this.deviceService.removeListener((EventListener)this.deviceListener);
            this.linkService.removeListener((EventListener)this.linkListener);
            this.hostService.removeListener((EventListener)this.hostListener);
            this.intentService.removeListener((EventListener)this.intentListener);
            this.flowService.removeListener((EventListener)this.flowListener);
        }
    }

    static /* synthetic */ void access$3000(TopologyViewMessageHandler x0) {
        x0.addListeners();
    }

    static /* synthetic */ void access$3100(TopologyViewMessageHandler x0, String x1) {
        x0.sendAllInstances(x1);
    }

    static /* synthetic */ void access$3200(TopologyViewMessageHandler x0) {
        x0.sendAllDevices();
    }

    static /* synthetic */ void access$3300(TopologyViewMessageHandler x0) {
        x0.sendAllLinks();
    }

    static /* synthetic */ void access$3400(TopologyViewMessageHandler x0) {
        x0.sendAllHosts();
    }

    static /* synthetic */ void access$3500(TopologyViewMessageHandler x0) {
        x0.sendTopoStartDone();
    }

    static /* synthetic */ TopoOverlayCache access$3600(TopologyViewMessageHandler x0) {
        return x0.overlayCache;
    }

    static /* synthetic */ void access$3700(TopologyViewMessageHandler x0) {
        x0.removeListeners();
    }

    static /* synthetic */ void access$3800(TopologyViewMessageHandler x0) {
        x0.stopSummaryMonitoring();
    }

    static /* synthetic */ TrafficMonitor access$3900(TopologyViewMessageHandler x0) {
        return x0.traffic;
    }

    static /* synthetic */ void access$4000(TopologyViewMessageHandler x0, long x1) {
        x0.requestSummary(x1);
    }

    static /* synthetic */ void access$4100(TopologyViewMessageHandler x0) {
        x0.startSummaryMonitoring();
    }

    static /* synthetic */ ObjectNode access$4200(TopologyViewMessageHandler x0) {
        return x0.objectNode();
    }

    static /* synthetic */ ArrayNode access$4300(TopologyViewMessageHandler x0) {
        return x0.arrayNode();
    }

    static /* synthetic */ ObjectNode access$4400(TopologyViewMessageHandler x0) {
        return x0.objectNode();
    }

    static /* synthetic */ ApplicationId access$4500(TopologyViewMessageHandler x0) {
        return x0.appId;
    }

    static /* synthetic */ Intent access$4600(TopologyViewMessageHandler x0, ObjectNode x1) {
        return x0.findIntentByPayload(x1);
    }

    static /* synthetic */ Set access$4700(TopologyViewMessageHandler x0, ArrayNode x1) {
        return x0.getHostIds(x1);
    }

    static /* synthetic */ Set access$4800(TopologyViewMessageHandler x0, Set x1) {
        return x0.getHostLocations(x1);
    }

    static /* synthetic */ ExecutorService access$5000(TopologyViewMessageHandler x0) {
        return x0.msgSender;
    }

    static /* synthetic */ void access$5100(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.sendMessage(x1);
    }

    static /* synthetic */ void access$5200(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.sendMessage(x1);
    }

    static /* synthetic */ Accumulator access$5300(TopologyViewMessageHandler x0) {
        return x0.eventAccummulator;
    }

    static /* synthetic */ void access$5400(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.sendMessage(x1);
    }

    static /* synthetic */ ObjectNode access$5500(TopologyViewMessageHandler x0, LinkEvent x1) {
        return x0.composeLinkMessage(x1);
    }

    static /* synthetic */ void access$5600(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.sendMessage(x1);
    }

    static /* synthetic */ void access$5700(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.sendMessage(x1);
    }

    static /* synthetic */ boolean access$5800(TopologyViewMessageHandler x0) {
        return x0.summaryRunning;
    }
}

