/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.statistic.Load;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.TrafficMonitor;
import org.onosproject.ui.impl.topo.util.IntentSelection;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.impl.topo.util.TopoIntentFilter;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.impl.topo.util.TrafficLinkMap;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.NodeHighlight;
import org.onosproject.ui.topo.NodeSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficMonitor {
    private static final double BPS_THRESHOLD = 4096.0;
    private static final Logger log = LoggerFactory.getLogger(TrafficMonitor.class);
    private final long trafficPeriod;
    private final ServicesBundle servicesBundle;
    private final TopologyViewMessageHandler msgHandler;
    private final TopoIntentFilter intentFilter;
    private final Timer timer = new Timer("topo-traffic");
    private TimerTask trafficTask = null;
    private Mode mode = Mode.IDLE;
    private NodeSelection selectedNodes = null;
    private IntentSelection selectedIntents = null;

    public TrafficMonitor(long trafficPeriod, ServicesBundle servicesBundle, TopologyViewMessageHandler msgHandler) {
        this.trafficPeriod = trafficPeriod;
        this.servicesBundle = servicesBundle;
        this.msgHandler = msgHandler;
        this.intentFilter = new TopoIntentFilter(servicesBundle);
    }

    public synchronized void monitor(Mode mode) {
        log.debug("monitor: {}", (Object)mode);
        this.mode = mode;
        switch (1.$SwitchMap$org$onosproject$ui$impl$TrafficMonitor$Mode[mode.ordinal()]) {
            case 1: {
                this.clearSelection();
                this.scheduleTask();
                this.sendAllFlowTraffic();
                break;
            }
            case 2: {
                this.clearSelection();
                this.scheduleTask();
                this.sendAllPortTraffic();
                break;
            }
            case 3: {
                this.scheduleTask();
                this.sendSelectedIntentTraffic();
                break;
            }
            default: {
                log.debug("Unexpected call to monitor({})", (Object)mode);
                this.clearAll();
            }
        }
    }

    public synchronized void monitor(Mode mode, NodeSelection nodeSelection) {
        log.debug("monitor: {} -- {}", (Object)mode, (Object)nodeSelection);
        this.mode = mode;
        this.selectedNodes = nodeSelection;
        switch (1.$SwitchMap$org$onosproject$ui$impl$TrafficMonitor$Mode[mode.ordinal()]) {
            case 4: {
                if (this.selectedNodes.devicesWithHover().isEmpty()) {
                    this.sendClearAll();
                    break;
                }
                this.scheduleTask();
                this.sendDeviceLinkFlows();
                break;
            }
            case 5: {
                if (this.selectedNodes.none()) {
                    this.sendClearAll();
                    break;
                }
                this.selectedIntents = new IntentSelection(this.selectedNodes, this.intentFilter);
                if (this.selectedIntents.none()) {
                    this.sendClearAll();
                    break;
                }
                this.sendSelectedIntents();
                break;
            }
            default: {
                log.debug("Unexpected call to monitor({}, {})", (Object)mode, (Object)nodeSelection);
                this.clearAll();
            }
        }
    }

    public synchronized void monitor(Intent intent) {
        log.debug("monitor intent: {}", (Object)intent.id());
        this.selectedNodes = null;
        this.selectedIntents = new IntentSelection(intent);
        this.mode = Mode.SELECTED_INTENT;
        this.scheduleTask();
        this.sendSelectedIntentTraffic();
    }

    public synchronized void selectNextIntent() {
        if (this.selectedIntents != null) {
            this.selectedIntents.next();
            this.sendSelectedIntents();
            if (this.mode == Mode.SELECTED_INTENT) {
                this.mode = Mode.RELATED_INTENTS;
            }
        }
    }

    public synchronized void selectPreviousIntent() {
        if (this.selectedIntents != null) {
            this.selectedIntents.prev();
            this.sendSelectedIntents();
            if (this.mode == Mode.SELECTED_INTENT) {
                this.mode = Mode.RELATED_INTENTS;
            }
        }
    }

    public synchronized void pokeIntent() {
        if (this.mode == Mode.SELECTED_INTENT) {
            this.sendSelectedIntentTraffic();
        }
    }

    public synchronized void stopMonitoring() {
        log.debug("STOP monitoring");
        if (this.mode != Mode.IDLE) {
            this.sendClearAll();
        }
    }

    private void sendClearAll() {
        this.clearAll();
        this.sendClearHighlights();
    }

    private void clearAll() {
        this.mode = Mode.IDLE;
        this.clearSelection();
        this.cancelTask();
    }

    private void clearSelection() {
        this.selectedNodes = null;
        this.selectedIntents = null;
    }

    private synchronized void scheduleTask() {
        if (this.trafficTask == null) {
            log.debug("Starting up background traffic task...");
            this.trafficTask = new TrafficUpdateTask(this, null);
            this.timer.schedule(this.trafficTask, this.trafficPeriod, this.trafficPeriod);
        } else {
            log.debug("(traffic task already running)");
        }
    }

    private synchronized void cancelTask() {
        if (this.trafficTask != null) {
            this.trafficTask.cancel();
            this.trafficTask = null;
        }
    }

    private void sendAllFlowTraffic() {
        log.debug("sendAllFlowTraffic");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.FLOW_STATS));
    }

    private void sendAllPortTraffic() {
        log.debug("sendAllPortTraffic");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.PORT_STATS));
    }

    private void sendDeviceLinkFlows() {
        log.debug("sendDeviceLinkFlows: {}", (Object)this.selectedNodes);
        this.msgHandler.sendHighlights(this.deviceLinkFlows());
    }

    private void sendSelectedIntents() {
        log.debug("sendSelectedIntents: {}", (Object)this.selectedIntents);
        this.msgHandler.sendHighlights(this.intentGroup());
    }

    private void sendSelectedIntentTraffic() {
        log.debug("sendSelectedIntentTraffic: {}", (Object)this.selectedIntents);
        this.msgHandler.sendHighlights(this.intentTraffic());
    }

    private void sendClearHighlights() {
        log.debug("sendClearHighlights");
        this.msgHandler.sendHighlights(new Highlights());
    }

    private Highlights trafficSummary(TrafficLink.StatsType type) {
        Highlights highlights = new Highlights();
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.compileLinks(linkMap);
        this.addEdgeLinks(linkMap);
        for (TrafficLink tlink : linkMap.biLinks()) {
            if (type == TrafficLink.StatsType.FLOW_STATS) {
                this.attachFlowLoad(tlink);
            } else if (type == TrafficLink.StatsType.PORT_STATS) {
                this.attachPortLoad(tlink);
            }
            if (!tlink.hasTraffic()) continue;
            highlights.add(tlink.highlight((Enum)type));
        }
        return highlights;
    }

    private Highlights deviceLinkFlows() {
        Highlights highlights = new Highlights();
        if (this.selectedNodes != null && !this.selectedNodes.devicesWithHover().isEmpty()) {
            TrafficLinkMap linkMap = new TrafficLinkMap();
            for (Device device : this.selectedNodes.devicesWithHover()) {
                Map counts = this.getLinkFlowCounts(device.id());
                for (Link link : counts.keySet()) {
                    TrafficLink tlink = (TrafficLink)linkMap.add(link);
                    tlink.addFlows(((Integer)counts.get(link)).intValue());
                }
            }
            for (TrafficLink tlink : linkMap.biLinks()) {
                highlights.add(tlink.highlight((Enum)TrafficLink.StatsType.FLOW_COUNT));
            }
        }
        return highlights;
    }

    private Highlights intentGroup() {
        Highlights highlights = new Highlights();
        if (this.selectedIntents != null && !this.selectedIntents.none()) {
            Set secondary;
            HashSet primary;
            int count = this.selectedIntents.size();
            HashSet allBut = new HashSet(this.selectedIntents.intents());
            if (this.selectedIntents.all()) {
                primary = allBut;
                secondary = Collections.emptySet();
                log.debug("Highlight all intents ({})", (Object)count);
            } else {
                Intent current = this.selectedIntents.current();
                primary = new HashSet();
                primary.add(current);
                allBut.remove(current);
                secondary = allBut;
                log.debug("Highlight intent: {} ([{}] of {})", new Object[]{current.id(), this.selectedIntents.index(), count});
            }
            this.highlightIntentLinks(highlights, primary, secondary);
        }
        return highlights;
    }

    private Highlights intentTraffic() {
        Highlights highlights = new Highlights();
        if (this.selectedIntents != null && this.selectedIntents.single()) {
            Intent current = this.selectedIntents.current();
            HashSet<Intent> primary = new HashSet<Intent>();
            primary.add(current);
            log.debug("Highlight traffic for intent: {} ([{}] of {})", new Object[]{current.id(), this.selectedIntents.index(), this.selectedIntents.size()});
            this.highlightIntentLinksWithTraffic(highlights, primary);
            highlights.subdueAllElse(Highlights.Amount.MINIMALLY);
        }
        return highlights;
    }

    private void compileLinks(TrafficLinkMap linkMap) {
        this.servicesBundle.linkService().getLinks().forEach(arg_0 -> ((TrafficLinkMap)linkMap).add(arg_0));
    }

    private void addEdgeLinks(TrafficLinkMap linkMap) {
        this.servicesBundle.hostService().getHosts().forEach(host -> {
            linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)true));
            linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)false));
        });
    }

    private Load getLinkFlowLoad(Link link) {
        if (link != null && link.src().elementId() instanceof DeviceId) {
            return this.servicesBundle.flowStatsService().load(link);
        }
        return null;
    }

    private void attachFlowLoad(TrafficLink link) {
        link.addLoad(this.getLinkFlowLoad(link.one()));
        link.addLoad(this.getLinkFlowLoad(link.two()));
    }

    private void attachPortLoad(TrafficLink link) {
        Link one = link.one();
        Load egressSrc = this.servicesBundle.portStatsService().load(one.src());
        Load egressDst = this.servicesBundle.portStatsService().load(one.dst());
        link.addLoad(this.maxLoad(egressSrc, egressDst), 4096.0);
    }

    private Load maxLoad(Load a, Load b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.rate() > b.rate() ? a : b;
    }

    private Map<Link, Integer> getLinkFlowCounts(DeviceId deviceId) {
        ArrayList<FlowEntry> entries = new ArrayList<FlowEntry>();
        for (FlowEntry flowEntry : this.servicesBundle.flowService().getFlowEntries(deviceId)) {
            entries.add(flowEntry);
        }
        HashSet<DefaultEdgeLink> links = new HashSet<DefaultEdgeLink>(this.servicesBundle.linkService().getDeviceEgressLinks(deviceId));
        Set hosts = this.servicesBundle.hostService().getConnectedHosts(deviceId);
        if (hosts != null) {
            for (Host host : hosts) {
                links.add(DefaultEdgeLink.createEdgeLink((Host)host, (boolean)false));
            }
        }
        HashMap<Link, Integer> counts = new HashMap<Link, Integer>();
        for (Link link : links) {
            counts.put(link, this.getEgressFlows(link, entries));
        }
        return counts;
    }

    private int getEgressFlows(Link link, List<FlowEntry> entries) {
        int count = 0;
        PortNumber out = link.src().port();
        for (FlowEntry entry : entries) {
            TrafficTreatment treatment = entry.treatment();
            for (Instruction instruction : treatment.allInstructions()) {
                if (instruction.type() != Instruction.Type.OUTPUT || !((Instructions.OutputInstruction)instruction).port().equals((Object)out)) continue;
                ++count;
            }
        }
        return count;
    }

    private void highlightIntentLinks(Highlights highlights, Set<Intent> primary, Set<Intent> secondary) {
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.createTrafficLinks(highlights, linkMap, secondary, LinkHighlight.Flavor.SECONDARY_HIGHLIGHT, false);
        this.createTrafficLinks(highlights, linkMap, primary, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, false);
        this.colorLinks(highlights, linkMap);
    }

    private void highlightIntentLinksWithTraffic(Highlights highlights, Set<Intent> primary) {
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.createTrafficLinks(highlights, linkMap, primary, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, true);
        this.colorLinks(highlights, linkMap);
    }

    private void createTrafficLinks(Highlights highlights, TrafficLinkMap linkMap, Set<Intent> intents, LinkHighlight.Flavor flavor, boolean showTraffic) {
        for (Intent intent : intents) {
            List installables = this.servicesBundle.intentService().getInstallableIntents(intent.key());
            Collection links = null;
            if (installables == null) continue;
            for (Intent installable : installables) {
                if (installable instanceof PathIntent) {
                    links = ((PathIntent)installable).path().links();
                } else if (installable instanceof FlowRuleIntent) {
                    links = this.linkResources(installable);
                } else if (installable instanceof FlowObjectiveIntent) {
                    links = this.linkResources(installable);
                } else if (installable instanceof LinkCollectionIntent) {
                    links = ((LinkCollectionIntent)installable).links();
                } else if (installable instanceof OpticalPathIntent) {
                    links = ((OpticalPathIntent)installable).path().links();
                }
                boolean isOptical = intent instanceof OpticalConnectivityIntent;
                this.processLinks(linkMap, (Iterable)links, flavor, isOptical, showTraffic);
                this.updateHighlights(highlights, (Iterable)links);
            }
        }
    }

    private void updateHighlights(Highlights highlights, Iterable<Link> links) {
        for (Link link : links) {
            this.ensureNodePresent(highlights, link.src().elementId());
            this.ensureNodePresent(highlights, link.dst().elementId());
        }
    }

    private void ensureNodePresent(Highlights highlights, ElementId eid) {
        String id = eid.toString();
        NodeHighlight nh = highlights.getNode(id);
        if (nh == null) {
            if (eid instanceof DeviceId) {
                nh = new DeviceHighlight(id);
                highlights.add((DeviceHighlight)nh);
            } else if (eid instanceof HostId) {
                nh = new HostHighlight(id);
                highlights.add((HostHighlight)nh);
            }
        }
    }

    private Collection<Link> linkResources(Intent installable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        installable.resources().stream().filter(r -> r instanceof Link).forEach(r -> builder.add((Object)((Link)r)));
        return builder.build();
    }

    private void processLinks(TrafficLinkMap linkMap, Iterable<Link> links, LinkHighlight.Flavor flavor, boolean isOptical, boolean showTraffic) {
        if (links != null) {
            for (Link link : links) {
                TrafficLink tlink = (TrafficLink)linkMap.add(link);
                tlink.tagFlavor(flavor);
                tlink.optical(isOptical);
                if (!showTraffic) continue;
                tlink.addLoad(this.getLinkFlowLoad(link));
                tlink.antMarch(true);
            }
        }
    }

    private void colorLinks(Highlights highlights, TrafficLinkMap linkMap) {
        for (TrafficLink tlink : linkMap.biLinks()) {
            highlights.add(tlink.highlight((Enum)TrafficLink.StatsType.TAGGED));
        }
    }

    static /* synthetic */ Mode access$100(TrafficMonitor x0) {
        return x0.mode;
    }

    static /* synthetic */ void access$200(TrafficMonitor x0) {
        x0.sendAllFlowTraffic();
    }

    static /* synthetic */ void access$300(TrafficMonitor x0) {
        x0.sendAllPortTraffic();
    }

    static /* synthetic */ void access$400(TrafficMonitor x0) {
        x0.sendDeviceLinkFlows();
    }

    static /* synthetic */ void access$500(TrafficMonitor x0) {
        x0.sendSelectedIntentTraffic();
    }

    static /* synthetic */ Logger access$600() {
        return log;
    }
}

