/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.websocket.WebSocket;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiSessionToken;
import org.onosproject.ui.UiTokenService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.UiTopoOverlayFactory;
import org.onosproject.ui.impl.TopoOverlayCache;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.topo.UiTopoSession;
import org.onosproject.ui.impl.topo.model.UiSharedTopologyModel;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiWebSocket
implements UiConnection,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger log = LoggerFactory.getLogger(UiWebSocket.class);
    private static final String EVENT = "event";
    private static final String SID = "sid";
    private static final String PAYLOAD = "payload";
    private static final String UNKNOWN = "unknown";
    private static final String AUTHENTICATION = "authentication";
    private static final String TOKEN = "token";
    private static final String ERROR = "error";
    private static final String ID = "id";
    private static final String IP = "ip";
    private static final String CLUSTER_NODES = "clusterNodes";
    private static final String USER = "user";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String TOPO = "topo";
    private static final long MAX_AGE_MS = 30000L;
    private static final byte PING = 9;
    private static final byte PONG = 10;
    private static final byte[] PING_DATA = new byte[]{-34, -83};
    private final ObjectMapper mapper = new ObjectMapper();
    private final ServiceDirectory directory;
    private final UiTopoSession topoSession;
    private WebSocket.Connection connection;
    private WebSocket.FrameConnection control;
    private String userName;
    private String currentView;
    private long lastActive = System.currentTimeMillis();
    private Map<String, UiMessageHandler> handlers;
    private TopoOverlayCache overlayCache;
    private UiSessionToken sessionToken;

    public UiWebSocket(ServiceDirectory directory, String userName) {
        this.directory = directory;
        this.userName = userName;
        this.topoSession = new UiTopoSession(this, (UiSharedTopologyModel)directory.get(UiSharedTopologyModel.class), (UiTopoLayoutService)directory.get(UiTopoLayoutService.class));
        this.sessionToken = null;
    }

    public String userName() {
        return this.userName;
    }

    public UiTopoLayout currentLayout() {
        return this.topoSession.currentLayout();
    }

    public void setCurrentLayout(UiTopoLayout topoLayout) {
        this.topoSession.setCurrentLayout(topoLayout);
    }

    public String currentView() {
        return this.currentView;
    }

    public void setCurrentView(String viewId) {
        this.currentView = viewId;
        this.topoSession.enableEvent(viewId.equals(TOPO));
    }

    public UiTopoSession topoSession() {
        return this.topoSession;
    }

    synchronized void close() {
        this.destroyHandlersAndOverlays();
        if (this.connection.isOpen()) {
            this.connection.close();
        }
    }

    synchronized boolean isIdle() {
        boolean idle;
        long quietFor = System.currentTimeMillis() - this.lastActive;
        boolean bl = idle = quietFor > 30000L;
        if (idle || this.connection != null && !this.connection.isOpen()) {
            log.debug("IDLE (or closed) websocket [{} ms]", (Object)quietFor);
            return true;
        }
        if (this.connection != null) {
            try {
                this.control.sendControl((byte)9, PING_DATA, 0, PING_DATA.length);
            }
            catch (IOException e) {
                log.warn("Unable to send ping message due to: ", (Throwable)e);
            }
        }
        return false;
    }

    public synchronized void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.control = (WebSocket.FrameConnection)connection;
        try {
            this.topoSession.init();
            this.createHandlersAndOverlays();
            this.sendBootstrapData();
            log.info("GUI client connected -- user <{}>", (Object)this.userName);
        }
        catch (ServiceNotFoundException e) {
            log.warn("Unable to open GUI connection; services have been shut-down", (Throwable)e);
            this.connection.close();
            this.connection = null;
            this.control = null;
        }
    }

    public synchronized void onClose(int closeCode, String message) {
        this.tokenService().revokeToken(this.sessionToken);
        log.info("Session token revoked");
        this.sessionToken = null;
        this.topoSession.destroy();
        this.destroyHandlersAndOverlays();
        log.info("GUI client disconnected [close-code={}, message={}]", (Object)closeCode, (Object)message);
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        this.lastActive = System.currentTimeMillis();
        return true;
    }

    public void onMessage(String data) {
        this.lastActive = System.currentTimeMillis();
        try {
            ObjectNode message = (ObjectNode)this.mapper.reader().readTree(data);
            String type = message.path(EVENT).asText(UNKNOWN);
            if (this.sessionToken == null) {
                this.authenticate(type, message);
            } else {
                UiMessageHandler handler = (UiMessageHandler)this.handlers.get(type);
                if (handler != null) {
                    log.debug("RX message: {}", (Object)message);
                    handler.process(message);
                } else {
                    log.warn("No GUI message handler for type {}", (Object)type);
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to parse GUI message {} due to {}", (Object)data, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    public synchronized void sendMessage(ObjectNode message) {
        try {
            if (this.connection.isOpen()) {
                this.connection.sendMessage(message.toString());
                log.debug("TX message: {}", (Object)message);
            }
        }
        catch (IOException e) {
            log.warn("Unable to send message {} to GUI due to {}", (Object)message, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    public synchronized void sendMessage(String type, long sid, ObjectNode payload) {
        ObjectNode message = this.mapper.createObjectNode();
        message.put(EVENT, type);
        if (sid > 0L) {
            message.put(SID, sid);
        }
        message.set(PAYLOAD, (JsonNode)(payload != null ? payload : this.mapper.createObjectNode()));
        this.sendMessage(message);
    }

    private synchronized void createHandlersAndOverlays() {
        log.debug("Creating handlers and overlays...");
        this.handlers = new HashMap();
        this.overlayCache = new TopoOverlayCache();
        UiExtensionService service = (UiExtensionService)this.directory.get(UiExtensionService.class);
        service.getExtensions().forEach(ext -> {
            UiTopoOverlayFactory overlayFactory;
            UiMessageHandlerFactory factory = ext.messageHandlerFactory();
            if (factory != null) {
                factory.newHandlers().forEach(handler -> {
                    try {
                        handler.init((UiConnection)this, this.directory);
                        handler.messageTypes().forEach(type -> this.handlers.put(type, handler));
                        if (handler instanceof TopologyViewMessageHandler) {
                            ((TopologyViewMessageHandler)handler).setOverlayCache(this.overlayCache);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Unable to setup handler {} due to", handler, (Object)e);
                    }
                });
            }
            if ((overlayFactory = ext.topoOverlayFactory()) != null) {
                overlayFactory.newOverlays().forEach(arg_0 -> ((TopoOverlayCache)this.overlayCache).add(arg_0));
            }
        });
        log.debug("#handlers = {}, #overlays = {}", (Object)this.handlers.size(), (Object)this.overlayCache.size());
    }

    private void authenticate(String type, ObjectNode message) {
        if (!AUTHENTICATION.equals(type)) {
            log.warn("Non-Authenticated Web Socket: {}", (Object)message);
            return;
        }
        String tokstr = message.path(PAYLOAD).path(TOKEN).asText(UNKNOWN);
        UiSessionToken token = new UiSessionToken(tokstr);
        if (this.tokenService().isTokenValid(token)) {
            this.sessionToken = token;
            log.info("Session token authenticated");
            log.debug("WebSocket authenticated: {}", (Object)message);
        } else {
            log.warn("Invalid Authentication Token: {}", (Object)message);
            this.sendMessage(ERROR, 0L, this.notAuthorized(token));
        }
    }

    private ObjectNode notAuthorized(UiSessionToken token) {
        return this.mapper.createObjectNode().put("message", "invalid authentication token").put("badToken", token.toString());
    }

    private synchronized void destroyHandlersAndOverlays() {
        log.debug("Destroying handlers and overlays...");
        this.handlers.forEach((type, handler) -> handler.destroy());
        this.handlers.clear();
        if (this.overlayCache != null) {
            this.overlayCache.destroy();
            this.overlayCache = null;
        }
    }

    private void sendBootstrapData() {
        ClusterService service = (ClusterService)this.directory.get(ClusterService.class);
        ArrayNode instances = this.mapper.createArrayNode();
        for (ControllerNode node : service.getNodes()) {
            ObjectNode instance = this.mapper.createObjectNode().put(ID, node.id().toString()).put(IP, node.ip().toString()).put("m_uiAttached", node.equals(service.getLocalNode()));
            instances.add((JsonNode)instance);
        }
        ObjectNode payload = this.mapper.createObjectNode();
        payload.set(CLUSTER_NODES, (JsonNode)instances);
        payload.put(USER, this.userName);
        this.sendMessage(BOOTSTRAP, 0L, payload);
    }

    private UiTokenService tokenService() {
        UiTokenService service = (UiTokenService)this.directory.get(UiTokenService.class);
        if (service == null) {
            log.error("Unable to reference UiTokenService");
        }
        return service;
    }
}

