/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.host.impl;

import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HostLocationProvider
extends AbstractProvider
implements HostProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService pktService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private HostProviderService providerService;
    private final InternalHostProvider processor = new InternalHostProvider();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    @Property(name="hostRemovalEnabled", boolValue={true}, label="Enable host removal on port/device down events")
    private boolean hostRemovalEnabled = true;

    public HostLocationProvider() {
        super(new ProviderId("of", "org.onosproject.provider.host"));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.modified(context);
        this.providerService = (HostProviderService)this.providerRegistry.register((Provider)this);
        this.pktService.addProcessor((PacketProcessor)this.processor, 1);
        this.deviceService.addListener(this.deviceListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.pktService.removeProcessor((PacketProcessor)this.processor);
        this.deviceService.removeListener(this.deviceListener);
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        try {
            String flag = (String)properties.get("hostRemovalEnabled");
            if (flag != null) {
                this.hostRemovalEnabled = flag.equals("true");
            }
        }
        catch (Exception e) {
            this.hostRemovalEnabled = true;
        }
        this.log.info("Host removal is {}", (Object)(this.hostRemovalEnabled ? "enabled" : "disabled"));
    }

    public void triggerProbe(Host host) {
        this.log.info("Triggering probe on device {}", (Object)host);
    }

    private void removeHosts(Set<Host> hosts) {
        for (Host host : hosts) {
            this.providerService.hostVanished(host.id());
        }
    }

    protected void bindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.providerRegistry = hostProviderRegistry;
    }

    protected void unbindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.providerRegistry == hostProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindPktService(PacketService packetService) {
        this.pktService = packetService;
    }

    protected void unbindPktService(PacketService packetService) {
        if (this.pktService == packetService) {
            this.pktService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (!HostLocationProvider.this.hostRemovalEnabled) {
                return;
            }
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            DeviceId deviceId = ((Device)event.subject()).id();
            if (type == DeviceEvent.Type.PORT_UPDATED) {
                ConnectPoint point = new ConnectPoint((ElementId)deviceId, event.port().number());
                HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(point));
            } else if (type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED) {
                if (!HostLocationProvider.this.deviceService.isAvailable(deviceId)) {
                    HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(deviceId));
                }
            } else if (type == DeviceEvent.Type.DEVICE_REMOVED) {
                HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(deviceId));
            }
        }
    }

    private class InternalHostProvider
    implements PacketProcessor {
        private InternalHostProvider() {
        }

        public void process(PacketContext context) {
            if (context == null) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            VlanId vlan = VlanId.vlanId((short)eth.getVlanID());
            ConnectPoint heardOn = context.inPacket().receivedFrom();
            Topology topology = HostLocationProvider.this.topologyService.currentTopology();
            if (HostLocationProvider.this.topologyService.isInfrastructure(topology, heardOn)) {
                return;
            }
            HostLocation hloc = new HostLocation(heardOn, System.currentTimeMillis());
            HostId hid = HostId.hostId((MacAddress)eth.getSourceMAC(), (VlanId)vlan);
            if (eth.getEtherType() == 2054) {
                ARP arp = (ARP)eth.getPayload();
                IpAddress ip = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])arp.getSenderProtocolAddress());
                DefaultHostDescription hdescr = new DefaultHostDescription(eth.getSourceMAC(), vlan, hloc, ip, new SparseAnnotations[0]);
                HostLocationProvider.this.providerService.hostDetected(hid, (HostDescription)hdescr);
            } else if (eth.getEtherType() == 2048) {
                DefaultHostDescription hdescr = new DefaultHostDescription(eth.getSourceMAC(), vlan, hloc, new SparseAnnotations[0]);
                HostLocationProvider.this.providerService.hostDetected(hid, (HostDescription)hdescr);
            }
        }
    }
}

