/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.host.impl;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.ARP;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.provider.host.impl.HostLocationProvider;
import org.osgi.service.component.ComponentContext;

public class HostLocationProviderTest {
    private static final Integer INPORT = 10;
    private static final String DEV1 = "of:1";
    private static final String DEV2 = "of:2";
    private static final String DEV3 = "of:3";
    private static final VlanId VLAN = VlanId.vlanId();
    private static final MacAddress MAC = MacAddress.valueOf((String)"00:00:11:00:00:01");
    private static final MacAddress BCMAC = MacAddress.valueOf((String)"ff:ff:ff:ff:ff:ff");
    private static final byte[] IP = new byte[]{10, 0, 0, 1};
    private static final IpAddress IP_ADDRESS = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])IP);
    private static final HostLocation LOCATION = new HostLocation(DeviceId.deviceId((String)"of:1"), PortNumber.portNumber((long)INPORT.intValue()), 0L);
    private static final DefaultHost HOST = new DefaultHost(ProviderId.NONE, HostId.hostId((MacAddress)MAC), MAC, VlanId.vlanId((short)-1), LOCATION, (Set)ImmutableSet.of((Object)IP_ADDRESS), new Annotations[0]);
    private static final ComponentContextAdapter CTX_FOR_REMOVE = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("hostRemovalEnabled", "true");
            return props;
        }
    };
    public static final ComponentContextAdapter CTX_FOR_NO_REMOVE = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            return new Hashtable();
        }
    };
    private final HostLocationProvider provider = new HostLocationProvider();
    private final TestHostRegistry hostRegistry = new TestHostRegistry();
    private final TestTopologyService topoService = new TestTopologyService();
    private final TestDeviceService deviceService = new TestDeviceService();
    private final TestHostService hostService = new TestHostService();
    private final TestPacketService packetService = new TestPacketService();
    private PacketProcessor testProcessor;
    private CoreService coreService;
    private TestHostProviderService providerService;
    private ApplicationId appId = new DefaultApplicationId(100, "org.onosproject.provider.host");

    @Before
    public void setUp() {
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication(this.appId.name())).andReturn((Object)this.appId).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coreService});
        this.provider.cfgService = new ComponentConfigAdapter();
        this.provider.coreService = this.coreService;
        this.provider.providerRegistry = this.hostRegistry;
        this.provider.topologyService = this.topoService;
        this.provider.packetService = this.packetService;
        this.provider.deviceService = this.deviceService;
        this.provider.hostService = this.hostService;
        this.provider.activate((ComponentContext)CTX_FOR_NO_REMOVE);
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)((Object)this.providerService));
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void events() {
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV1));
        Assert.assertNotNull((String)"new host expected", (Object)this.providerService.added);
        Assert.assertNull((String)"host motion unexpected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV2));
        Assert.assertNotNull((String)"host motion expected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV3));
        Assert.assertNull((String)"host misheard on spine switch", (Object)this.providerService.spine);
    }

    @Test
    public void removeHostByDeviceRemove() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV1));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
    }

    @Test
    public void removeHostByDeviceOffline() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV1));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
    }

    @Test
    public void removeHostByDevicePortDown() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestPacketContext(DEV1));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, (Device)device, (Port)new DefaultPort((Element)device, PortNumber.portNumber((long)INPORT.intValue()), false, new Annotations[0])));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.coreService = null;
        this.provider.providerRegistry = null;
    }

    private class TestHostService
    extends HostServiceAdapter {
        private TestHostService() {
        }

        public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
            return ImmutableSet.of((Object)HOST);
        }

        public Set<Host> getConnectedHosts(DeviceId deviceId) {
            return ImmutableSet.of((Object)HOST);
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private DeviceListener listener;

        private TestDeviceService() {
        }

        public void addListener(DeviceListener listener) {
            this.listener = listener;
        }

        public Iterable<Device> getDevices() {
            return Collections.emptyList();
        }
    }

    private class TestPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            ARP arp = new ARP();
            arp.setSenderProtocolAddress(IP).setSenderHardwareAddress(MAC.toBytes()).setTargetHardwareAddress(BCMAC.toBytes()).setTargetProtocolAddress(IP);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_ARP).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC.toBytes()).setDestinationMACAddress(BCMAC).setPayload((IPacket)arp);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestTopologyService
    extends TopologyServiceAdapter {
        private TestTopologyService() {
        }

        public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
            return connectPoint.deviceId().equals((Object)DeviceId.deviceId((String)HostLocationProviderTest.DEV3));
        }
    }

    private class TestPacketService
    extends PacketServiceAdapter {
        private TestPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            HostLocationProviderTest.this.testProcessor = processor;
        }
    }

    private class TestHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        DeviceId added;
        DeviceId moved;
        DeviceId spine;
        public int removeCount;

        protected TestHostProviderService(HostProvider provider) {
            super((Provider)provider);
            this.added = null;
            this.moved = null;
            this.spine = null;
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription) {
            DeviceId descr = hostDescription.location().deviceId();
            if (this.added == null) {
                this.added = descr;
            } else if (this.moved == null && !descr.equals((Object)this.added)) {
                this.moved = descr;
            } else {
                this.spine = descr;
            }
        }

        public void hostVanished(HostId hostId) {
            ++this.removeCount;
        }
    }

    private class TestHostRegistry
    implements HostProviderRegistry {
        private TestHostRegistry() {
        }

        public HostProviderService register(HostProvider provider) {
            HostLocationProviderTest.this.providerService = new TestHostProviderService(provider);
            return HostLocationProviderTest.this.providerService;
        }

        public void unregister(HostProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }
}

