/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.host.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.ARP;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.packet.ndp.RouterAdvertisement;
import org.onlab.packet.ndp.RouterSolicitation;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.provider.host.impl.HostLocationProvider;
import org.osgi.service.component.ComponentContext;

public class HostLocationProviderTest {
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "org.onosproject.provider.host");
    private static final Integer INPORT = 10;
    private static final String DEV1 = "of:1";
    private static final String DEV2 = "of:2";
    private static final String DEV3 = "of:3";
    private static final String DEV4 = "of:4";
    private static final String DEV5 = "of:5";
    private static final String DEV6 = "of:6";
    private static final VlanId VLAN = VlanId.vlanId();
    private static final MacAddress MAC = MacAddress.valueOf((String)"00:00:11:00:00:01");
    private static final MacAddress BCMAC = MacAddress.valueOf((String)"ff:ff:ff:ff:ff:ff");
    private static final byte[] IP = new byte[]{10, 0, 0, 1};
    private static final IpAddress IP_ADDRESS = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])IP);
    private static final HostLocation LOCATION = new HostLocation(DeviceId.deviceId((String)"of:1"), PortNumber.portNumber((long)INPORT.intValue()), 0L);
    private static final DefaultHost HOST = new DefaultHost(PROVIDER_ID, HostId.hostId((MacAddress)MAC), MAC, VlanId.vlanId((short)-1), LOCATION, (Set)ImmutableSet.of((Object)IP_ADDRESS), new Annotations[0]);
    private static final MacAddress MAC2 = MacAddress.valueOf((String)"00:00:22:00:00:02");
    private static final MacAddress BCMAC2 = MacAddress.valueOf((String)"33:33:00:00:00:01");
    private static final byte[] IP2 = Ip6Address.valueOf((String)"1000::1").toOctets();
    private static final IpAddress IP_ADDRESS2 = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])IP2);
    private static final HostLocation LOCATION2 = new HostLocation(DeviceId.deviceId((String)"of:4"), PortNumber.portNumber((long)INPORT.intValue()), 0L);
    private static final DefaultHost HOST2 = new DefaultHost(PROVIDER_ID, HostId.hostId((MacAddress)MAC2), MAC2, VlanId.vlanId((short)-1), LOCATION2, (Set)ImmutableSet.of((Object)IP_ADDRESS2), new Annotations[0]);
    private static final ComponentContextAdapter CTX_FOR_REMOVE = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("hostRemovalEnabled", "true");
            return props;
        }
    };
    public static final ComponentContextAdapter CTX_FOR_NO_REMOVE = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            return new Hashtable();
        }
    };
    private final HostLocationProvider provider = new HostLocationProvider();
    private final TestHostRegistry hostRegistry = new TestHostRegistry();
    private final TestTopologyService topoService = new TestTopologyService();
    private final TestDeviceService deviceService = new TestDeviceService();
    private final TestHostService hostService = new TestHostService();
    private final TestPacketService packetService = new TestPacketService();
    private PacketProcessor testProcessor;
    private CoreService coreService;
    private TestHostProviderService providerService;
    private ApplicationId appId = new DefaultApplicationId(100, "org.onosproject.provider.host");

    @Before
    public void setUp() {
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication(this.appId.name())).andReturn((Object)this.appId).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coreService});
        this.provider.cfgService = new ComponentConfigAdapter();
        this.provider.coreService = this.coreService;
        this.provider.providerRegistry = this.hostRegistry;
        this.provider.topologyService = this.topoService;
        this.provider.packetService = this.packetService;
        this.provider.deviceService = this.deviceService;
        this.provider.hostService = this.hostService;
        this.provider.activate((ComponentContext)CTX_FOR_NO_REMOVE);
        this.provider.eventHandler = MoreExecutors.newDirectExecutorService();
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)((Object)this.providerService));
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void events() {
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV1));
        Assert.assertNotNull((String)"new host expected", (Object)this.providerService.added);
        Assert.assertNull((String)"host motion unexpected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV2));
        Assert.assertNotNull((String)"host motion expected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV3));
        Assert.assertNull((String)"host misheard on spine switch", (Object)this.providerService.spine);
        this.providerService.clear();
        this.testProcessor.process((PacketContext)new TestNaPacketContext(DEV4));
        Assert.assertNotNull((String)"new host expected", (Object)this.providerService.added);
        Assert.assertNull((String)"host motion unexpected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestNaPacketContext(DEV5));
        Assert.assertNotNull((String)"host motion expected", (Object)this.providerService.moved);
        this.testProcessor.process((PacketContext)new TestNaPacketContext(DEV6));
        Assert.assertNull((String)"host misheard on spine switch", (Object)this.providerService.spine);
    }

    @Test
    public void removeHostByDeviceRemove() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV1));
        this.testProcessor.process((PacketContext)new TestNaPacketContext(DEV4));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
        device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV4), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)2L, (long)this.providerService.removeCount);
    }

    @Test
    public void removeHostByDeviceOffline() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV1));
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV4));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
        device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV4), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Device)device));
        Assert.assertEquals((String)"incorrect remove count", (long)2L, (long)this.providerService.removeCount);
    }

    @Test
    public void removeHostByDevicePortDown() {
        this.provider.modified((ComponentContext)CTX_FOR_REMOVE);
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV1));
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV4));
        DefaultDevice device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV1), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, (Device)device, (Port)new DefaultPort((Element)device, PortNumber.portNumber((long)INPORT.intValue()), false, new Annotations[0])));
        Assert.assertEquals((String)"incorrect remove count", (long)1L, (long)this.providerService.removeCount);
        device = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)DEV4), Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
        this.deviceService.listener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, (Device)device, (Port)new DefaultPort((Element)device, PortNumber.portNumber((long)INPORT.intValue()), false, new Annotations[0])));
        Assert.assertEquals((String)"incorrect remove count", (long)2L, (long)this.providerService.removeCount);
    }

    @Test
    public void testReceiveArp() {
        this.testProcessor.process((PacketContext)new TestArpPacketContext(DEV1));
        HostDescription descr = this.providerService.added;
        Assert.assertThat((Object)descr.location(), (Matcher)Matchers.is((Object)LOCATION));
        Assert.assertThat((Object)descr.hwAddress(), (Matcher)Matchers.is((Object)MAC));
        Assert.assertThat((Object)descr.ipAddress().toArray()[0], (Matcher)Matchers.is((Object)IP_ADDRESS));
        Assert.assertThat((Object)descr.vlan(), (Matcher)Matchers.is((Object)VLAN));
    }

    @Test
    public void testReceiveIpv4() {
        this.testProcessor.process((PacketContext)new TestIpv4PacketContext(DEV1));
        HostDescription descr = this.providerService.added;
        Assert.assertThat((Object)descr.location(), (Matcher)Matchers.is((Object)LOCATION));
        Assert.assertThat((Object)descr.hwAddress(), (Matcher)Matchers.is((Object)MAC));
        Assert.assertThat((Object)descr.ipAddress().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)descr.vlan(), (Matcher)Matchers.is((Object)VLAN));
    }

    @Test
    public void testReceiveNa() {
        this.testProcessor.process((PacketContext)new TestNaPacketContext(DEV4));
        Assert.assertNotNull((Object)this.providerService.added);
        HostDescription descr = this.providerService.added;
        Assert.assertThat((Object)descr.location(), (Matcher)Matchers.is((Object)LOCATION2));
        Assert.assertThat((Object)descr.hwAddress(), (Matcher)Matchers.is((Object)MAC2));
        Assert.assertThat((Object)descr.ipAddress().toArray()[0], (Matcher)Matchers.is((Object)IP_ADDRESS2));
        Assert.assertThat((Object)descr.vlan(), (Matcher)Matchers.is((Object)VLAN));
    }

    @Test
    public void testReceiveNs() {
        this.testProcessor.process((PacketContext)new TestNsPacketContext(DEV4));
        HostDescription descr = this.providerService.added;
        Assert.assertThat((Object)descr.location(), (Matcher)Matchers.is((Object)LOCATION2));
        Assert.assertThat((Object)descr.hwAddress(), (Matcher)Matchers.is((Object)MAC2));
        Assert.assertThat((Object)descr.ipAddress().toArray()[0], (Matcher)Matchers.is((Object)IP_ADDRESS2));
        Assert.assertThat((Object)descr.vlan(), (Matcher)Matchers.is((Object)VLAN));
    }

    @Test
    public void testReceivesRa() {
        this.testProcessor.process((PacketContext)new TestRAPacketContext(DEV4));
        Assert.assertNull((Object)this.providerService.added);
    }

    @Test
    public void testReceiveRs() {
        this.testProcessor.process((PacketContext)new TestRSPacketContext(DEV4));
        Assert.assertNull((Object)this.providerService.added);
    }

    @Test
    public void testReceiveDad() {
        this.testProcessor.process((PacketContext)new TestDadPacketContext(DEV4));
        Assert.assertNull((Object)this.providerService.added);
    }

    @Test
    public void testReceiveIpv6Multicast() {
        this.testProcessor.process((PacketContext)new TestIpv6McastPacketContext(DEV4));
        Assert.assertNull((Object)this.providerService.added);
    }

    @Test
    public void testReceiveIpv6Unicast() {
        this.testProcessor.process((PacketContext)new TestIpv6PacketContext(DEV4));
        Assert.assertNotNull((Object)this.providerService.added);
        HostDescription descr = this.providerService.added;
        Assert.assertThat((Object)descr.location(), (Matcher)Matchers.is((Object)LOCATION2));
        Assert.assertThat((Object)descr.hwAddress(), (Matcher)Matchers.is((Object)MAC2));
        Assert.assertThat((Object)descr.ipAddress().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)descr.vlan(), (Matcher)Matchers.is((Object)VLAN));
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.coreService = null;
        this.provider.providerRegistry = null;
    }

    private class TestHostService
    extends HostServiceAdapter {
        private TestHostService() {
        }

        public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
            ConnectPoint cp1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)HostLocationProviderTest.DEV1), PortNumber.portNumber((long)INPORT.intValue()));
            ConnectPoint cp2 = new ConnectPoint((ElementId)DeviceId.deviceId((String)HostLocationProviderTest.DEV4), PortNumber.portNumber((long)INPORT.intValue()));
            if (connectPoint.equals((Object)cp1)) {
                return ImmutableSet.of((Object)HOST);
            }
            if (connectPoint.equals((Object)cp2)) {
                return ImmutableSet.of((Object)HOST2);
            }
            return ImmutableSet.of();
        }

        public Set<Host> getConnectedHosts(DeviceId deviceId) {
            if (deviceId.equals((Object)DeviceId.deviceId((String)HostLocationProviderTest.DEV1))) {
                return ImmutableSet.of((Object)HOST);
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)HostLocationProviderTest.DEV4))) {
                return ImmutableSet.of((Object)HOST2);
            }
            return ImmutableSet.of();
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private DeviceListener listener;

        private TestDeviceService() {
        }

        public void addListener(DeviceListener listener) {
            this.listener = listener;
        }

        public Iterable<Device> getDevices() {
            return Collections.emptyList();
        }
    }

    private class TestIpv6PacketContext
    implements PacketContext {
        private final String deviceId;

        public TestIpv6PacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            IPv6 ipv6 = new IPv6();
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"1000::1").toOctets());
            ipv6.setSourceAddress(IP2);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2).setDestinationMACAddress(MacAddress.valueOf((String)"00:00:00:00:00:01")).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestIpv6McastPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestIpv6McastPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            IPv6 ipv6 = new IPv6();
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::1").toOctets());
            ipv6.setSourceAddress(IP2);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(MacAddress.valueOf((String)"33:33:00:00:00:01")).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestRAPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestRAPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            RouterAdvertisement ns = new RouterAdvertisement();
            ICMP6 icmp6 = new ICMP6();
            icmp6.setPayload((IPacket)ns);
            IPv6 ipv6 = new IPv6();
            ipv6.setPayload((IPacket)icmp6);
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::1").toOctets());
            ipv6.setSourceAddress(IP2);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(MacAddress.valueOf((String)"33:33:00:00:00:01")).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestRSPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestRSPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            RouterSolicitation ns = new RouterSolicitation();
            ICMP6 icmp6 = new ICMP6();
            icmp6.setPayload((IPacket)ns);
            IPv6 ipv6 = new IPv6();
            ipv6.setPayload((IPacket)icmp6);
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::2").toOctets());
            ipv6.setSourceAddress(Ip6Address.valueOf((String)"::").toOctets());
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(MacAddress.valueOf((String)"33:33:00:00:00:02")).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestDadPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestDadPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            NeighborSolicitation ns = new NeighborSolicitation();
            ICMP6 icmp6 = new ICMP6();
            icmp6.setPayload((IPacket)ns);
            IPv6 ipv6 = new IPv6();
            ipv6.setPayload((IPacket)icmp6);
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::1").toOctets());
            ipv6.setSourceAddress(Ip6Address.valueOf((String)"::").toOctets());
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(BCMAC2).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestNsPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestNsPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            NeighborSolicitation ns = new NeighborSolicitation();
            ICMP6 icmp6 = new ICMP6();
            icmp6.setPayload((IPacket)ns);
            IPv6 ipv6 = new IPv6();
            ipv6.setPayload((IPacket)icmp6);
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::1:ff00:0000").toOctets());
            ipv6.setSourceAddress(IP2);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(BCMAC2).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestNaPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestNaPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            NeighborAdvertisement na = new NeighborAdvertisement();
            ICMP6 icmp6 = new ICMP6();
            icmp6.setPayload((IPacket)na);
            IPv6 ipv6 = new IPv6();
            ipv6.setPayload((IPacket)icmp6);
            ipv6.setDestinationAddress(Ip6Address.valueOf((String)"ff02::1").toOctets());
            ipv6.setSourceAddress(IP2);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV6).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC2.toBytes()).setDestinationMACAddress(BCMAC2).setPayload((IPacket)ipv6);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestIpv4PacketContext
    implements PacketContext {
        private final String deviceId;

        public TestIpv4PacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            IPv4 ipv4 = new IPv4();
            ipv4.setDestinationAddress("10.0.0.1");
            ipv4.setSourceAddress(IP_ADDRESS.toString());
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV4).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC).setDestinationMACAddress(MacAddress.valueOf((String)"00:00:00:00:00:01")).setPayload((IPacket)ipv4);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestArpPacketContext
    implements PacketContext {
        private final String deviceId;

        public TestArpPacketContext(String deviceId) {
            this.deviceId = deviceId;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            ARP arp = new ARP();
            arp.setSenderProtocolAddress(IP).setSenderHardwareAddress(MAC.toBytes()).setTargetHardwareAddress(BCMAC.toBytes()).setTargetProtocolAddress(IP);
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_ARP).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC.toBytes()).setDestinationMACAddress(BCMAC).setPayload((IPacket)arp);
            ConnectPoint receivedFrom = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)INPORT.intValue()));
            return new DefaultInboundPacket(receivedFrom, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }
    }

    private class TestTopologyService
    extends TopologyServiceAdapter {
        private TestTopologyService() {
        }

        public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
            return connectPoint.deviceId().equals((Object)DeviceId.deviceId((String)HostLocationProviderTest.DEV3)) || connectPoint.deviceId().equals((Object)DeviceId.deviceId((String)HostLocationProviderTest.DEV6));
        }
    }

    private class TestPacketService
    extends PacketServiceAdapter {
        private TestPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            HostLocationProviderTest.this.testProcessor = processor;
        }
    }

    private class TestHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        HostDescription added;
        HostDescription moved;
        HostDescription spine;
        public int removeCount;

        public void clear() {
            this.added = null;
            this.moved = null;
            this.spine = null;
            this.removeCount = 0;
        }

        protected TestHostProviderService(HostProvider provider) {
            super((Provider)provider);
            this.added = null;
            this.moved = null;
            this.spine = null;
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription, boolean replaceIps) {
            if (this.added == null) {
                this.added = hostDescription;
            } else if (this.moved == null && hostDescription != this.added) {
                this.moved = hostDescription;
            } else {
                this.spine = hostDescription;
            }
        }

        public void hostVanished(HostId hostId) {
            ++this.removeCount;
        }

        public void removeIpFromHost(HostId hostId, IpAddress ipAddress) {
        }
    }

    private class TestHostRegistry
    implements HostProviderRegistry {
        private TestHostRegistry() {
        }

        public HostProviderService register(HostProvider provider) {
            HostLocationProviderTest.this.providerService = new TestHostProviderService(provider);
            return HostLocationProviderTest.this.providerService;
        }

        public void unregister(HostProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }
}

