/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.rpc.impl;

import com.google.common.annotations.Beta;
import java.net.URI;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.rpc.RemoteServiceContext;
import org.onosproject.incubator.rpc.RemoteServiceContextProvider;
import org.onosproject.incubator.rpc.RemoteServiceContextProviderService;
import org.onosproject.incubator.rpc.RemoteServiceDirectory;
import org.onosproject.incubator.rpc.RemoteServiceProviderRegistry;
import org.onosproject.incubator.rpc.impl.AbstractProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
@Service
public class RemoteServiceManager
extends AbstractProviderRegistry
implements RemoteServiceDirectory,
RemoteServiceProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    protected void activate() {
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    public RemoteServiceContext get(URI uri) {
        RemoteServiceContextProvider factory = this.getProvider(uri.getScheme());
        if (factory != null) {
            return factory.get(uri);
        }
        throw new UnsupportedOperationException(uri.getScheme() + " not supported");
    }

    @Override
    protected RemoteServiceContextProviderService createProviderService(RemoteServiceContextProvider provider) {
        return new InternalRemoteServiceContextProviderService(provider);
    }

    private final class InternalRemoteServiceContextProviderService
    extends AbstractProviderService<RemoteServiceContextProvider>
    implements RemoteServiceContextProviderService {
        public InternalRemoteServiceContextProviderService(RemoteServiceContextProvider provider) {
            super((Provider)provider);
        }
    }
}

