/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.rpc.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.incubator.rpc.RemoteServiceContext;
import org.onosproject.incubator.rpc.RemoteServiceContextProvider;
import org.onosproject.incubator.rpc.RemoteServiceContextProviderService;
import org.onosproject.incubator.rpc.RemoteServiceProviderRegistry;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public class LocalRemoteServiceProvider
implements RemoteServiceContextProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RemoteServiceContext theOne = new LocalServiceContext();
    private static final ProviderId PID = new ProviderId("local", "org.onosproject.rpc.provider.local");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RemoteServiceProviderRegistry rpcRegistry;
    private final Map<Class<? extends Object>, Object> services = new ConcurrentHashMap<Class<? extends Object>, Object>();
    private RemoteServiceContextProviderService providerService;

    @Activate
    protected void activate() {
        this.services.put(SomeOtherService.class, new SomeOtherServiceImpl());
        this.providerService = (RemoteServiceContextProviderService)this.rpcRegistry.register((Provider)this);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.rpcRegistry.unregister((Provider)this);
        this.log.info("Stopped");
    }

    public ProviderId id() {
        return PID;
    }

    public RemoteServiceContext get(URI uri) {
        Preconditions.checkArgument((boolean)Objects.equals(uri.getScheme(), "local"));
        return this.theOne;
    }

    protected void bindRpcRegistry(RemoteServiceProviderRegistry remoteServiceProviderRegistry) {
        this.rpcRegistry = remoteServiceProviderRegistry;
    }

    protected void unbindRpcRegistry(RemoteServiceProviderRegistry remoteServiceProviderRegistry) {
        if (this.rpcRegistry == remoteServiceProviderRegistry) {
            this.rpcRegistry = null;
        }
    }

    public static class SomeOtherServiceImpl
    implements SomeOtherService {
        @Override
        public String hello() {
            return "Goodbye";
        }
    }

    public static interface SomeOtherService {
        public String hello();
    }

    private final class LocalServiceContext
    implements RemoteServiceContext {
        private final ServiceDirectory directory = new DefaultServiceDirectory();

        private LocalServiceContext() {
        }

        public <T> T get(Class<T> serviceClass) {
            Object service = LocalRemoteServiceProvider.this.services.get(serviceClass);
            if (service != null) {
                return (T)service;
            }
            return (T)this.directory.get(serviceClass);
        }
    }
}

