/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.rpc.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.onosproject.incubator.rpc.RemoteServiceContextProvider;
import org.onosproject.incubator.rpc.RemoteServiceContextProviderService;
import org.onosproject.incubator.rpc.RemoteServiceProviderRegistry;
import org.onosproject.net.provider.ProviderId;

@Beta
abstract class AbstractProviderRegistry
implements RemoteServiceProviderRegistry {
    private final Map<ProviderId, RemoteServiceContextProvider> pidToProvider = Maps.newConcurrentMap();
    private final Map<String, RemoteServiceContextProvider> schemeToProvider = Maps.newConcurrentMap();

    protected abstract RemoteServiceContextProviderService createProviderService(RemoteServiceContextProvider var1);

    public synchronized RemoteServiceContextProviderService register(RemoteServiceContextProvider provider) {
        this.pidToProvider.put(provider.id(), provider);
        this.schemeToProvider.put(provider.id().scheme(), provider);
        return this.createProviderService(provider);
    }

    public synchronized void unregister(RemoteServiceContextProvider provider) {
        this.pidToProvider.remove(provider.id(), provider);
        this.schemeToProvider.remove(provider.id().scheme(), provider);
    }

    public Set<ProviderId> getProviders() {
        return ImmutableSet.copyOf(this.pidToProvider.keySet());
    }

    protected RemoteServiceContextProvider getProvider(ProviderId pid) {
        return this.pidToProvider.get(pid);
    }

    protected RemoteServiceContextProvider getProvider(String scheme) {
        return this.schemeToProvider.get(scheme);
    }
}

