/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.rpc.impl;

import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.incubator.rpc.RemoteServiceContext;
import org.onosproject.incubator.rpc.RemoteServiceDirectory;
import org.onosproject.incubator.rpc.impl.LocalRemoteServiceProvider;
import org.onosproject.incubator.rpc.impl.RemoteServiceManager;

public class RemoteServiceManagerTest {
    private static final URI LOCAL_URI = URI.create("local://whateverIgnored");
    private RemoteServiceManager rpcManager;
    private RemoteServiceDirectory rpcDirectory;
    private LocalRemoteServiceProvider rpcProvider;

    @Before
    public void setUp() {
        this.rpcManager = new RemoteServiceManager();
        this.rpcManager.activate();
        this.rpcDirectory = this.rpcManager;
        this.rpcProvider = new LocalRemoteServiceProvider();
        this.rpcProvider.rpcRegistry = this.rpcManager;
        this.rpcProvider.activate();
    }

    @After
    public void tearDown() {
        this.rpcProvider.deactivate();
        this.rpcManager.deactivate();
    }

    @Test
    public void basics() {
        RemoteServiceContext remoteServiceContext = this.rpcDirectory.get(LOCAL_URI);
        Assert.assertNotNull((String)"Expecting valid RPC context", (Object)remoteServiceContext);
        LocalRemoteServiceProvider.SomeOtherService someService = (LocalRemoteServiceProvider.SomeOtherService)remoteServiceContext.get(LocalRemoteServiceProvider.SomeOtherService.class);
        Assert.assertNotNull((String)"Expecting reference to sample service", (Object)someService);
        Assert.assertEquals((Object)"Goodbye", (Object)someService.hello());
    }
}

