/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.meter.impl;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.incubator.store.meter.impl.MeterData;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.DefaultMeterFeatures;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterEvent;
import org.onosproject.net.meter.MeterFailReason;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterFeaturesKey;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterKey;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.meter.MeterStore;
import org.onosproject.net.meter.MeterStoreDelegate;
import org.onosproject.net.meter.MeterStoreResult;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedMeterStore
extends AbstractStore<MeterEvent, MeterStoreDelegate>
implements MeterStore {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String METERSTORE = "onos-meter-store";
    private static final String METERFEATURESSTORE = "onos-meter-features-store";
    private static final String AVAILABLEMETERIDSTORE = "onos-meters-available-store";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    private ConsistentMap<MeterKey, MeterData> meters;
    private NodeId local;
    private ConsistentMap<MeterFeaturesKey, MeterFeatures> meterFeatures;
    private MapEventListener<MeterKey, MeterData> mapListener = new InternalMapEventListener();
    private Map<MeterKey, CompletableFuture<MeterStoreResult>> futures = Maps.newConcurrentMap();
    private ConsistentMap<DeviceId, BitSet> availableMeterIds;

    @Activate
    public void activate() {
        this.local = this.clusterService.getLocalNode().id();
        this.meters = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(METERSTORE)).withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{MeterKey.class, MeterData.class, DefaultMeter.class, DefaultBand.class, Band.Type.class, MeterState.class, Meter.Unit.class, MeterFailReason.class}))).build();
        this.meters.addListener(this.mapListener);
        this.meterFeatures = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(METERFEATURESSTORE)).withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{MeterFeaturesKey.class, MeterFeatures.class, DefaultMeterFeatures.class, Band.Type.class, Meter.Unit.class, MeterFailReason.class}))).build();
        this.availableMeterIds = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(AVAILABLEMETERIDSTORE)).withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{DeviceId.class, BitSet.class}))).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.meters.removeListener(this.mapListener);
        this.log.info("Stopped");
    }

    private void updateMeterIdAvailability(DeviceId deviceId, MeterId id, boolean available) {
        this.availableMeterIds.compute((Object)deviceId, (k, v) -> {
            v = v == null ? new BitSet() : v;
            v.set(((Long)id.id()).intValue(), available);
            return v;
        });
    }

    public MeterId firstReusableMeterId(DeviceId deviceId) {
        Versioned bitSetVersioned = this.availableMeterIds.get((Object)deviceId);
        if (bitSetVersioned == null) {
            return null;
        }
        BitSet value = (BitSet)bitSetVersioned.value();
        int nextSetBit = value.nextSetBit(1);
        if (nextSetBit < 0) {
            return null;
        }
        return MeterId.meterId((long)nextSetBit);
    }

    public CompletableFuture<MeterStoreResult> storeMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.updateMeterIdAvailability(meter.deviceId(), meter.id(), false);
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            this.meters.put((Object)key, (Object)data);
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<MeterStoreResult> deleteMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (this.meters.computeIfPresent((Object)key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.success());
            }
            this.updateMeterIdAvailability(meter.deviceId(), meter.id(), true);
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public MeterStoreResult storeMeterFeatures(MeterFeatures meterfeatures) {
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)meterfeatures.deviceId());
        try {
            this.meterFeatures.putIfAbsent((Object)key, (Object)meterfeatures);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public MeterStoreResult deleteMeterFeatures(DeviceId deviceId) {
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)deviceId);
        try {
            this.meterFeatures.remove((Object)key);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public CompletableFuture<MeterStoreResult> updateMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (this.meters.computeIfPresent((Object)key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.fail((MeterFailReason)MeterFailReason.INVALID_METER));
            }
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateMeterState(Meter meter) {
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.meters.computeIfPresent((Object)key, (k, v) -> {
            DefaultMeter m = (DefaultMeter)v.meter();
            m.setState(meter.state());
            m.setProcessedPackets(meter.packetsSeen());
            m.setProcessedBytes(meter.bytesSeen());
            m.setLife(meter.life());
            m.setReferenceCount(meter.referenceCount());
            return new MeterData((Meter)m, null, v.origin());
        });
    }

    public Meter getMeter(MeterKey key) {
        MeterData data = (MeterData)Versioned.valueOrElse((Versioned)this.meters.get((Object)key), null);
        return data == null ? null : data.meter();
    }

    public Collection<Meter> getAllMeters() {
        return Collections2.transform(this.meters.asJavaMap().values(), MeterData::meter);
    }

    public void failedMeter(MeterOperation op, MeterFailReason reason) {
        MeterKey key = MeterKey.key((DeviceId)op.meter().deviceId(), (MeterId)op.meter().id());
        this.meters.computeIfPresent((Object)key, (k, v) -> new MeterData(v.meter(), reason, v.origin()));
    }

    public void deleteMeterNow(Meter m) {
        MeterKey key = MeterKey.key((DeviceId)m.deviceId(), (MeterId)m.id());
        this.futures.remove(key);
        this.meters.remove((Object)key);
        this.notifyDelegate((Event)new MeterEvent(MeterEvent.Type.METER_REMOVED, m));
    }

    public long getMaxMeters(MeterFeaturesKey key) {
        MeterFeatures features = (MeterFeatures)Versioned.valueOrElse((Versioned)this.meterFeatures.get((Object)key), null);
        return features == null ? 0L : features.maxMeter();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class InternalMapEventListener
    implements MapEventListener<MeterKey, MeterData> {
        private InternalMapEventListener() {
        }

        public void event(MapEvent<MeterKey, MeterData> event) {
            MeterKey key = (MeterKey)event.key();
            MeterData data = (MeterData)event.value().value();
            NodeId master = DistributedMeterStore.this.mastershipService.getMasterFor(data.meter().deviceId());
            block0 : switch (event.type()) {
                case INSERT: 
                case UPDATE: {
                    switch (data.meter().state()) {
                        case PENDING_ADD: 
                        case PENDING_REMOVE: {
                            if (!data.reason().isPresent() && DistributedMeterStore.this.local.equals((Object)master)) {
                                DistributedMeterStore.this.notifyDelegate((Event)new MeterEvent(data.meter().state() == MeterState.PENDING_ADD ? MeterEvent.Type.METER_ADD_REQ : MeterEvent.Type.METER_REM_REQ, data.meter()));
                                break;
                            }
                            if (!data.reason().isPresent() || !DistributedMeterStore.this.local.equals((Object)data.origin())) break block0;
                            MeterStoreResult msr = MeterStoreResult.fail((MeterFailReason)data.reason().get());
                            ((CompletableFuture)DistributedMeterStore.this.futures.get(key)).complete(msr);
                            break;
                        }
                        case ADDED: {
                            if (!DistributedMeterStore.this.local.equals((Object)data.origin()) || data.meter().state() != MeterState.PENDING_ADD && data.meter().state() != MeterState.ADDED) break block0;
                            DistributedMeterStore.this.futures.computeIfPresent(key, (k, v) -> {
                                DistributedMeterStore.this.notifyDelegate((Event)new MeterEvent(MeterEvent.Type.METER_ADDED, data.meter()));
                                return null;
                            });
                            break;
                        }
                        case REMOVED: {
                            if (!DistributedMeterStore.this.local.equals((Object)data.origin()) || data.meter().state() != MeterState.PENDING_REMOVE) break block0;
                            ((CompletableFuture)DistributedMeterStore.this.futures.remove(key)).complete(MeterStoreResult.success());
                            break;
                        }
                        default: {
                            DistributedMeterStore.this.log.warn("Unknown meter state type {}", (Object)data.meter().state());
                            break;
                        }
                    }
                    break;
                }
                case REMOVE: {
                    break;
                }
                default: {
                    DistributedMeterStore.this.log.warn("Unknown Map event type {}", (Object)event.type());
                }
            }
        }
    }
}

