/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.routing.InternalRouteEvent;
import org.onosproject.incubator.net.routing.NextHopData;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteSet;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.store.routing.impl.DefaultRouteTable;
import org.onosproject.incubator.store.routing.impl.EmptyRouteTable;
import org.onosproject.incubator.store.routing.impl.RouteTable;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouteStore
extends AbstractStore<InternalRouteEvent, RouteStoreDelegate>
implements RouteStore {
    protected StorageService storageService;
    private static final RouteTableId IPV4 = new RouteTableId("ipv4");
    private static final RouteTableId IPV6 = new RouteTableId("ipv6");
    private static final Logger log = LoggerFactory.getLogger(DistributedRouteStore.class);
    private final SetEventListener<RouteTableId> masterRouteTableListener = new MasterRouteTableListener();
    private final RouteStoreDelegate ourDelegate = new InternalRouteStoreDelegate();
    private DistributedSet<RouteTableId> masterRouteTable;
    private Map<RouteTableId, RouteTable> routeTables;
    private ExecutorService executor;

    public DistributedRouteStore(StorageService storageService) {
        this.storageService = storageService;
    }

    public void activate() {
        this.routeTables = new ConcurrentHashMap<RouteTableId, RouteTable>();
        this.executor = Executors.newSingleThreadExecutor();
        KryoNamespace masterRouteTableSerializer = KryoNamespace.newBuilder().register(new Class[]{RouteTableId.class}).build();
        this.masterRouteTable = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("onos-master-route-table")).withSerializer(Serializer.using((KryoNamespace)masterRouteTableSerializer))).build()).asDistributedSet();
        this.masterRouteTable.forEach(this::createRouteTable);
        this.masterRouteTable.addListener(this.masterRouteTableListener);
        this.masterRouteTable.add((Object)IPV4);
        this.masterRouteTable.add((Object)IPV6);
        log.info("Started");
    }

    public void deactivate() {
        this.masterRouteTable.removeListener(this.masterRouteTableListener);
        this.routeTables.values().forEach(RouteTable::shutdown);
        log.info("Stopped");
    }

    public void updateRoute(Route route) {
        this.getDefaultRouteTable(route).update(route);
    }

    public void removeRoute(Route route) {
        this.getDefaultRouteTable(route).remove(route);
    }

    public Set<RouteTableId> getRouteTables() {
        return ImmutableSet.copyOf(this.masterRouteTable);
    }

    public Collection<RouteSet> getRoutes(RouteTableId table) {
        RouteTable routeTable = this.routeTables.get(table);
        if (routeTable == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(routeTable.getRoutes());
    }

    public Route longestPrefixMatch(IpAddress ip) {
        return null;
    }

    public Collection<Route> getRoutesForNextHop(IpAddress ip) {
        return this.getDefaultRouteTable(ip).getRoutesForNextHop(ip);
    }

    public RouteSet getRoutes(IpPrefix prefix) {
        return this.getDefaultRouteTable(prefix.address()).getRoutes(prefix);
    }

    public void updateNextHop(IpAddress ip, NextHopData nextHopData) {
    }

    public void removeNextHop(IpAddress ip, NextHopData nextHopData) {
    }

    public NextHopData getNextHop(IpAddress ip) {
        return null;
    }

    public Map<IpAddress, NextHopData> getNextHops() {
        return Collections.emptyMap();
    }

    private void createRouteTable(RouteTableId tableId) {
        this.routeTables.computeIfAbsent(tableId, id -> new DefaultRouteTable((RouteTableId)id, this.ourDelegate, this.storageService));
    }

    private void destroyRouteTable(RouteTableId tableId) {
        RouteTable table = this.routeTables.remove(tableId);
        if (table != null) {
            table.destroy();
        }
    }

    private RouteTable getDefaultRouteTable(Route route) {
        return this.getDefaultRouteTable(route.prefix().address());
    }

    private RouteTable getDefaultRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.routeTables.getOrDefault(routeTableId, EmptyRouteTable.instance());
    }

    private class MasterRouteTableListener
    implements SetEventListener<RouteTableId> {
        private MasterRouteTableListener() {
        }

        public void event(SetEvent<RouteTableId> event) {
            switch (event.type()) {
                case ADD: {
                    DistributedRouteStore.this.executor.execute(() -> DistributedRouteStore.this.createRouteTable((RouteTableId)event.entry()));
                    break;
                }
                case REMOVE: {
                    DistributedRouteStore.this.executor.execute(() -> DistributedRouteStore.this.destroyRouteTable((RouteTableId)event.entry()));
                    break;
                }
            }
        }
    }

    private class InternalRouteStoreDelegate
    implements RouteStoreDelegate {
        private InternalRouteStoreDelegate() {
        }

        public void notify(InternalRouteEvent event) {
            DistributedRouteStore.this.executor.execute(() -> DistributedRouteStore.this.notifyDelegate((Event)event));
        }
    }
}

