/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import com.google.common.base.Preconditions;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.routing.InternalRouteEvent;
import org.onosproject.incubator.net.routing.NextHopData;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteSet;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.net.routing.RouteTools;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRouteStore
extends AbstractStore<InternalRouteEvent, RouteStoreDelegate>
implements RouteStore {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<RouteTableId, RouteTable> routeTables;
    private static final RouteTableId IPV4 = new RouteTableId("ipv4");
    private static final RouteTableId IPV6 = new RouteTableId("ipv6");

    public void activate() {
        this.routeTables = new ConcurrentHashMap<RouteTableId, RouteTable>();
        this.routeTables.put(IPV4, new RouteTable(IPV4));
        this.routeTables.put(IPV6, new RouteTable(IPV6));
        this.log.info("Started");
    }

    public void deactivate() {
        this.log.info("Stopped");
    }

    public void updateRoute(Route route) {
        this.getDefaultRouteTable(route).update(route);
    }

    public void removeRoute(Route route) {
        this.getDefaultRouteTable(route).remove(route);
    }

    public Set<RouteTableId> getRouteTables() {
        return this.routeTables.keySet();
    }

    public Collection<RouteSet> getRoutes(RouteTableId table) {
        RouteTable routeTable = this.routeTables.get(table);
        if (routeTable != null) {
            return routeTable.getRouteSets();
        }
        return null;
    }

    public Route longestPrefixMatch(IpAddress ip) {
        return this.getDefaultRouteTable(ip).longestPrefixMatch(ip);
    }

    public Collection<Route> getRoutesForNextHop(IpAddress ip) {
        return this.getDefaultRouteTable(ip).getRoutesForNextHop(ip);
    }

    public RouteSet getRoutes(IpPrefix prefix) {
        return this.getDefaultRouteTable(prefix.address()).getRoutes(prefix);
    }

    public void updateNextHop(IpAddress ip, NextHopData nextHopData) {
    }

    public void removeNextHop(IpAddress ip, NextHopData nextHopData) {
    }

    public NextHopData getNextHop(IpAddress ip) {
        return null;
    }

    public Map<IpAddress, NextHopData> getNextHops() {
        return Collections.emptyMap();
    }

    private RouteTable getDefaultRouteTable(Route route) {
        return this.getDefaultRouteTable(route.prefix().address());
    }

    private RouteTable getDefaultRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.routeTables.get(routeTableId);
    }

    private class RouteTable {
        private final InvertedRadixTree<Route> routeTable;
        private final Map<IpPrefix, Route> routes = new ConcurrentHashMap<IpPrefix, Route>();
        private final RouteTableId id;

        public RouteTable(RouteTableId id) {
            this.id = (RouteTableId)Preconditions.checkNotNull((Object)id);
            this.routeTable = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Route route) {
            RouteTable routeTable = this;
            synchronized (routeTable) {
                Route oldRoute = this.routes.put(route.prefix(), route);
                if (route.equals((Object)oldRoute)) {
                    return;
                }
                this.routeTable.put((CharSequence)RouteTools.createBinaryString((IpPrefix)route.prefix()), (Object)route);
                LocalRouteStore.this.notifyDelegate((Event)new InternalRouteEvent(InternalRouteEvent.Type.ROUTE_ADDED, this.singletonRouteSet(route)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Route route) {
            RouteTable routeTable = this;
            synchronized (routeTable) {
                Route removed = this.routes.remove(route.prefix());
                this.routeTable.remove((CharSequence)RouteTools.createBinaryString((IpPrefix)route.prefix()));
                if (removed != null) {
                    LocalRouteStore.this.notifyDelegate((Event)new InternalRouteEvent(InternalRouteEvent.Type.ROUTE_REMOVED, this.emptyRouteSet(route.prefix())));
                }
            }
        }

        public Collection<Route> getRoutesForNextHop(IpAddress ip) {
            return this.routes.values().stream().filter(route -> route.nextHop().equals((Object)ip)).collect(Collectors.toSet());
        }

        public RouteSet getRoutes(IpPrefix prefix) {
            Route route = this.routes.get(prefix);
            if (route != null) {
                return this.singletonRouteSet(route);
            }
            return null;
        }

        public Collection<RouteSet> getRouteSets() {
            return this.routes.values().stream().map(this::singletonRouteSet).collect(Collectors.toSet());
        }

        public Collection<Route> getRoutes() {
            Iterator it = this.routeTable.getKeyValuePairsForKeysStartingWith((CharSequence)"").iterator();
            LinkedList<Route> routes = new LinkedList<Route>();
            while (it.hasNext()) {
                KeyValuePair entry = (KeyValuePair)it.next();
                routes.add((Route)entry.getValue());
            }
            return routes;
        }

        public Route longestPrefixMatch(IpAddress ip) {
            Iterable prefixes = this.routeTable.getValuesForKeysPrefixing((CharSequence)RouteTools.createBinaryString((IpPrefix)ip.toIpPrefix()));
            Iterator it = prefixes.iterator();
            Route route = null;
            while (it.hasNext()) {
                route = (Route)it.next();
            }
            return route;
        }

        private RouteSet singletonRouteSet(Route route) {
            return new RouteSet(this.id, route.prefix(), Collections.singleton(route));
        }

        private RouteSet emptyRouteSet(IpPrefix prefix) {
            return new RouteSet(this.id, prefix, Collections.emptySet());
        }
    }
}

