/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowRuleStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.store.service.StorageService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualFlowRuleStore
extends AbstractVirtualStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements VirtualNetworkFlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final ConcurrentMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<FlowId, List<StoredFlowEntry>>>> flowEntries = new ConcurrentHashMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<FlowId, List<StoredFlowEntry>>>>();
    private final AtomicInteger localBatchIdGen = new AtomicInteger();
    private static final int DEFAULT_PENDING_FUTURE_TIMEOUT_MINUTES = 5;
    @Property(name="pendingFutureTimeoutMinutes", intValue={5}, label="Expiration time after an entry is created that it should be automatically removed")
    private int pendingFutureTimeoutMinutes = 5;
    private Cache<Integer, SettableFuture<CompletedBatchOperation>> pendingFutures = CacheBuilder.newBuilder().expireAfterWrite((long)this.pendingFutureTimeoutMinutes, TimeUnit.MINUTES).removalListener((RemovalListener)new TimeoutFuture()).build();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.flowEntries.clear();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        Cache<Integer, SettableFuture<CompletedBatchOperation>> prevFutures = this.pendingFutures;
        this.pendingFutures = CacheBuilder.newBuilder().expireAfterWrite((long)this.pendingFutureTimeoutMinutes, TimeUnit.MINUTES).removalListener((RemovalListener)new TimeoutFuture()).build();
        this.pendingFutures.putAll((Map)prevFutures.asMap());
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Integer newPendingFutureTimeoutMinutes = Tools.getIntegerProperty((Dictionary)properties, (String)"pendingFutureTimeoutMinutes");
        if (newPendingFutureTimeoutMinutes == null) {
            this.pendingFutureTimeoutMinutes = 5;
            this.log.info("Pending future timeout is not configured, using current value of {}", (Object)this.pendingFutureTimeoutMinutes);
        } else {
            this.pendingFutureTimeoutMinutes = newPendingFutureTimeoutMinutes;
            this.log.info("Configured. Pending future timeout is configured to {}", (Object)this.pendingFutureTimeoutMinutes);
        }
    }

    public int getFlowRuleCount(NetworkId networkId) {
        int sum = 0;
        if (this.flowEntries.get(networkId) == null) {
            return 0;
        }
        for (ConcurrentMap ft : ((ConcurrentMap)this.flowEntries.get(networkId)).values()) {
            for (List fes : ft.values()) {
                sum += fes.size();
            }
        }
        return sum;
    }

    public FlowEntry getFlowEntry(NetworkId networkId, FlowRule rule) {
        return this.getFlowEntryInternal(networkId, rule.deviceId(), rule);
    }

    public Iterable<FlowEntry> getFlowEntries(NetworkId networkId, DeviceId deviceId) {
        return FluentIterable.from(this.getFlowTable(networkId, deviceId).values()).transformAndConcat(Collections::unmodifiableList);
    }

    public void storeFlowRule(NetworkId networkId, FlowRule rule) {
        this.storeFlowRuleInternal(networkId, rule);
    }

    public void storeBatch(NetworkId networkId, FlowRuleBatchOperation batchOperation) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<FlowRuleBatchEntry> toRemove = new ArrayList<FlowRuleBatchEntry>();
        for (FlowRuleBatchEntry entry : batchOperation.getOperations()) {
            FlowRule flowRule = (FlowRule)entry.target();
            if (((FlowRuleBatchEntry.FlowRuleOperation)entry.operator()).equals((Object)FlowRuleBatchEntry.FlowRuleOperation.ADD)) {
                if (this.getFlowEntries(networkId, flowRule.deviceId(), flowRule.id()).contains(flowRule)) continue;
                this.storeFlowRule(networkId, flowRule);
                toAdd.add(entry);
                continue;
            }
            if (((FlowRuleBatchEntry.FlowRuleOperation)entry.operator()).equals((Object)FlowRuleBatchEntry.FlowRuleOperation.REMOVE)) {
                if (!this.getFlowEntries(networkId, flowRule.deviceId(), flowRule.id()).contains(flowRule)) continue;
                this.deleteFlowRule(networkId, flowRule);
                toRemove.add(entry);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported operation type");
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            this.notifyDelegate(networkId, FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(batchOperation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), batchOperation.deviceId())));
            return;
        }
        SettableFuture r = SettableFuture.create();
        int futureId = this.localBatchIdGen.incrementAndGet();
        this.pendingFutures.put((Object)futureId, (Object)r);
        toAdd.addAll(toRemove);
        this.notifyDelegate(networkId, FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest(batchOperation.id(), (Set)Sets.newHashSet(toAdd)), (DeviceId)batchOperation.deviceId()));
    }

    public void batchOperationComplete(NetworkId networkId, FlowRuleBatchEvent event) {
        Long batchId = ((FlowRuleBatchRequest)event.subject()).batchId();
        SettableFuture future = (SettableFuture)this.pendingFutures.getIfPresent((Object)batchId);
        if (future != null) {
            future.set((Object)event.result());
            this.pendingFutures.invalidate((Object)batchId);
        }
        this.notifyDelegate(networkId, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFlowRule(NetworkId networkId, FlowRule rule) {
        List<StoredFlowEntry> entries;
        List<StoredFlowEntry> list = entries = this.getFlowEntries(networkId, rule.deviceId(), rule.id());
        synchronized (list) {
            for (StoredFlowEntry entry : entries) {
                if (!entry.equals(rule)) continue;
                StoredFlowEntry storedFlowEntry = entry;
                synchronized (storedFlowEntry) {
                    entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowRuleEvent addOrUpdateFlowRule(NetworkId networkId, FlowEntry rule) {
        List<StoredFlowEntry> entries;
        List<StoredFlowEntry> list = entries = this.getFlowEntries(networkId, rule.deviceId(), rule.id());
        synchronized (list) {
            StoredFlowEntry stored;
            Iterator<StoredFlowEntry> iterator = entries.iterator();
            do {
                if (iterator.hasNext()) continue;
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var4_4
                this.log.error("FlowRule was not found in store {} to update", (Object)rule);
                return null;
            } while (!(stored = iterator.next()).equals(rule));
            StoredFlowEntry storedFlowEntry = stored;
            synchronized (storedFlowEntry) {
                stored.setBytes(rule.bytes());
                stored.setLife(rule.life());
                stored.setPackets(rule.packets());
                if (stored.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                    stored.setState(FlowEntry.FlowEntryState.ADDED);
                    return new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
                }
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowRuleEvent removeFlowRule(NetworkId networkId, FlowEntry rule) {
        List<StoredFlowEntry> entries;
        DeviceId did = rule.deviceId();
        List<StoredFlowEntry> list = entries = this.getFlowEntries(networkId, did, rule.id());
        synchronized (list) {
            if (entries.remove(rule)) {
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)rule);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowRuleEvent pendingFlowRule(NetworkId networkId, FlowEntry rule) {
        List<StoredFlowEntry> entries;
        List<StoredFlowEntry> list = entries = this.getFlowEntries(networkId, rule.deviceId(), rule.id());
        synchronized (list) {
            for (StoredFlowEntry entry : entries) {
                if (!entry.equals(rule) || entry.state() == FlowEntry.FlowEntryState.PENDING_ADD) continue;
                StoredFlowEntry storedFlowEntry = entry;
                synchronized (storedFlowEntry) {
                    entry.setState(FlowEntry.FlowEntryState.PENDING_ADD);
                    return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
                }
            }
        }
        return null;
    }

    public void purgeFlowRule(NetworkId networkId, DeviceId deviceId) {
        ((ConcurrentMap)this.flowEntries.get(networkId)).remove(deviceId);
    }

    public void purgeFlowRules(NetworkId networkId) {
        ((ConcurrentMap)this.flowEntries.get(networkId)).clear();
    }

    public FlowRuleEvent updateTableStatistics(NetworkId networkId, DeviceId deviceId, List<TableStatisticsEntry> tableStats) {
        return null;
    }

    public Iterable<TableStatisticsEntry> getTableStatistics(NetworkId networkId, DeviceId deviceId) {
        return null;
    }

    private ConcurrentMap<FlowId, List<StoredFlowEntry>> getFlowTable(NetworkId networkId, DeviceId deviceId) {
        return this.flowEntries.computeIfAbsent(networkId, n -> new ConcurrentHashMap()).computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    private List<StoredFlowEntry> getFlowEntries(NetworkId networkId, DeviceId deviceId, FlowId flowId) {
        List concurrentlyAdded;
        ConcurrentMap<FlowId, List<StoredFlowEntry>> flowTable = this.getFlowTable(networkId, deviceId);
        CopyOnWriteArrayList r = (CopyOnWriteArrayList)flowTable.get(flowId);
        if (r == null && (concurrentlyAdded = (List)flowTable.putIfAbsent(flowId, r = new CopyOnWriteArrayList())) != null) {
            return concurrentlyAdded;
        }
        return r;
    }

    private FlowEntry getFlowEntryInternal(NetworkId networkId, DeviceId deviceId, FlowRule rule) {
        List<StoredFlowEntry> fes = this.getFlowEntries(networkId, deviceId, rule.id());
        for (StoredFlowEntry fe : fes) {
            if (!fe.equals(rule)) continue;
            return fe;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFlowRuleInternal(NetworkId networkId, FlowRule rule) {
        List<StoredFlowEntry> existing;
        DefaultFlowEntry f = new DefaultFlowEntry(rule);
        DeviceId did = f.deviceId();
        FlowId fid = f.id();
        List<StoredFlowEntry> list = existing = this.getFlowEntries(networkId, did, fid);
        synchronized (list) {
            for (StoredFlowEntry fe : existing) {
                if (!fe.equals(rule)) continue;
                return;
            }
            existing.add((StoredFlowEntry)f);
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private static final class TimeoutFuture
    implements RemovalListener<Integer, SettableFuture<CompletedBatchOperation>> {
        private TimeoutFuture() {
        }

        public void onRemoval(RemovalNotification<Integer, SettableFuture<CompletedBatchOperation>> notification) {
            if (notification.wasEvicted()) {
                ((SettableFuture)notification.getValue()).setException((Throwable)new ExecutionException("Timed out", new TimeoutException()));
            }
        }
    }
}

