/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkPacketStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketEvent;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketStoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualPacketStore
extends AbstractVirtualStore<PacketEvent, PacketStoreDelegate>
implements VirtualNetworkPacketStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<NetworkId, Map<TrafficSelector, Set<PacketRequest>>> requests = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void emit(NetworkId networkId, OutboundPacket packet) {
        this.notifyDelegate(networkId, new PacketEvent(PacketEvent.Type.EMIT, packet));
    }

    public void requestPackets(NetworkId networkId, PacketRequest request) {
        this.requests.computeIfAbsent(networkId, k -> Maps.newConcurrentMap());
        this.requests.get(networkId).compute(request.selector(), (s, existingRequests) -> {
            if (existingRequests == null) {
                if (this.hasDelegate(networkId)) {
                    ((PacketStoreDelegate)this.delegateMap.get(networkId)).requestPackets(request);
                }
                return ImmutableSet.of((Object)request);
            }
            if (!existingRequests.contains(request)) {
                if (this.hasDelegate(networkId)) {
                    ((PacketStoreDelegate)this.delegateMap.get(networkId)).requestPackets(request);
                }
                return ImmutableSet.builder().addAll((Iterable)existingRequests).add((Object)request).build();
            }
            return existingRequests;
        });
    }

    public void cancelPackets(NetworkId networkId, PacketRequest request) {
        this.requests.get(networkId).computeIfPresent(request.selector(), (s, existingRequests) -> {
            if (existingRequests.contains(request)) {
                HashSet newRequests = Sets.newHashSet((Iterable)existingRequests);
                newRequests.remove(request);
                if (this.hasDelegate(networkId)) {
                    ((PacketStoreDelegate)this.delegateMap.get(networkId)).cancelPackets(request);
                }
                if (newRequests.size() > 0) {
                    return ImmutableSet.copyOf((Collection)newRequests);
                }
                return null;
            }
            return existingRequests;
        });
    }

    public List<PacketRequest> existingRequests(NetworkId networkId) {
        ArrayList list = Lists.newArrayList();
        if (this.requests.get(networkId) != null) {
            this.requests.get(networkId).values().forEach(list::addAll);
            list.sort((o1, o2) -> o1.priority().priorityValue() - o2.priority().priorityValue());
        }
        return list;
    }
}

