/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.routing.InternalRouteEvent;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteSet;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.store.routing.impl.RouteTable;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;

public class DefaultRouteTable
implements RouteTable {
    private final RouteTableId id;
    private final ConsistentMap<IpPrefix, Set<Route>> routes;
    private final RouteStoreDelegate delegate;
    private final ExecutorService executor;
    private final RouteTableListener listener = new RouteTableListener();
    private final Consumer<DistributedPrimitive.Status> statusChangeListener;

    public DefaultRouteTable(RouteTableId id, RouteStoreDelegate delegate, StorageService storageService, ExecutorService executor) {
        this.delegate = (RouteStoreDelegate)Preconditions.checkNotNull((Object)delegate);
        this.id = (RouteTableId)Preconditions.checkNotNull((Object)id);
        this.routes = this.buildRouteMap((StorageService)Preconditions.checkNotNull((Object)storageService));
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.statusChangeListener = status -> {
            if (status.equals((Object)DistributedPrimitive.Status.ACTIVE)) {
                executor.execute(this::notifyExistingRoutes);
            }
        };
        this.routes.addStatusChangeListener(this.statusChangeListener);
        this.notifyExistingRoutes();
        this.routes.addListener((MapEventListener)this.listener);
    }

    private void notifyExistingRoutes() {
        this.routes.entrySet().stream().map(e -> new InternalRouteEvent(InternalRouteEvent.Type.ROUTE_ADDED, new RouteSet(this.id, (IpPrefix)e.getKey(), (Set)((Versioned)e.getValue()).value()))).forEach(arg_0 -> ((RouteStoreDelegate)this.delegate).notify(arg_0));
    }

    private ConsistentMap<IpPrefix, Set<Route>> buildRouteMap(StorageService storageService) {
        KryoNamespace routeTableSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Route.class}).register(new Class[]{Route.Source.class}).build();
        return (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)storageService.consistentMapBuilder().withName("onos-routes-" + this.id.name())).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)routeTableSerializer))).build();
    }

    @Override
    public RouteTableId id() {
        return this.id;
    }

    @Override
    public void shutdown() {
        this.routes.removeStatusChangeListener(this.statusChangeListener);
        this.routes.removeListener((MapEventListener)this.listener);
    }

    @Override
    public void destroy() {
        this.shutdown();
        this.routes.destroy();
    }

    @Override
    public void update(Route route) {
        this.routes.compute((Object)route.prefix(), (prefix, set) -> {
            if (set == null) {
                set = new HashSet<Route>();
            }
            set.add(route);
            return set;
        });
    }

    @Override
    public void remove(Route route) {
        this.routes.compute((Object)route.prefix(), (prefix, set) -> {
            if (set != null) {
                set.remove(route);
                if (set.isEmpty()) {
                    return null;
                }
                return set;
            }
            return null;
        });
    }

    @Override
    public Collection<RouteSet> getRoutes() {
        return this.routes.entrySet().stream().map(e -> new RouteSet(this.id, (IpPrefix)e.getKey(), (Set)((Versioned)e.getValue()).value())).collect(Collectors.toSet());
    }

    @Override
    public RouteSet getRoutes(IpPrefix prefix) {
        Versioned routeSet = this.routes.get((Object)prefix);
        if (routeSet != null) {
            return new RouteSet(this.id, prefix, (Set)routeSet.value());
        }
        return null;
    }

    @Override
    public Collection<Route> getRoutesForNextHop(IpAddress nextHop) {
        return this.routes.values().stream().flatMap(v -> ((Set)v.value()).stream()).filter(r -> r.nextHop().equals((Object)nextHop)).collect(Collectors.toSet());
    }

    private class RouteTableListener
    implements MapEventListener<IpPrefix, Set<Route>> {
        private RouteTableListener() {
        }

        private InternalRouteEvent createRouteEvent(InternalRouteEvent.Type type, MapEvent<IpPrefix, Set<Route>> event) {
            Set currentRoutes = event.newValue() == null ? Collections.emptySet() : (Set)event.newValue().value();
            return new InternalRouteEvent(type, new RouteSet(DefaultRouteTable.this.id, (IpPrefix)event.key(), currentRoutes));
        }

        public void event(MapEvent<IpPrefix, Set<Route>> event) {
            InternalRouteEvent ire = null;
            switch (event.type()) {
                case INSERT: {
                    ire = this.createRouteEvent(InternalRouteEvent.Type.ROUTE_ADDED, event);
                    break;
                }
                case UPDATE: {
                    if (((Set)event.newValue().value()).size() > ((Set)event.oldValue().value()).size()) {
                        ire = this.createRouteEvent(InternalRouteEvent.Type.ROUTE_ADDED, event);
                        break;
                    }
                    ire = this.createRouteEvent(InternalRouteEvent.Type.ROUTE_REMOVED, event);
                    break;
                }
                case REMOVE: {
                    ire = this.createRouteEvent(InternalRouteEvent.Type.ROUTE_REMOVED, event);
                    break;
                }
            }
            if (ire != null) {
                DefaultRouteTable.this.delegate.notify((Event)ire);
            }
        }
    }
}

