/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.incubator.net.routing.InternalRouteEvent;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteSet;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.store.routing.impl.DistributedRouteStore;
import org.onosproject.incubator.store.routing.impl.LocalRouteStore;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.service.StorageService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class RouteStoreImpl
extends AbstractStore<InternalRouteEvent, RouteStoreDelegate>
implements RouteStore {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public StorageService storageService;
    @Property(name="distributed", boolValue={false}, label="Enable distributed route store")
    private boolean distributed;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RouteStore currentRouteStore;
    private DistributedRouteStore distributedRouteStore;
    private LocalRouteStore localRouteStore;

    @Activate
    public void activate(ComponentContext context) {
        this.distributedRouteStore = new DistributedRouteStore(this.storageService);
        this.distributedRouteStore.activate();
        this.localRouteStore = new LocalRouteStore();
        this.localRouteStore.activate();
        this.componentConfigService.registerProperties(((Object)((Object)this)).getClass());
        this.modified(context);
    }

    @Deactivate
    public void deactivate() {
        this.localRouteStore.deactivate();
        this.distributedRouteStore.deactivate();
        this.componentConfigService.unregisterProperties(((Object)((Object)this)).getClass(), false);
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        if (properties == null) {
            return;
        }
        String strDistributed = Tools.get((Dictionary)properties, (String)"distributed");
        boolean expectDistributed = Boolean.parseBoolean(strDistributed);
        if (this.currentRouteStore == null || expectDistributed != this.distributed) {
            this.currentRouteStore = expectDistributed ? this.distributedRouteStore : this.localRouteStore;
            this.distributed = expectDistributed;
            this.log.info("Switched to {} route store", (Object)(this.distributed ? "distributed" : "local"));
        }
    }

    public void setDelegate(RouteStoreDelegate delegate) {
        super.setDelegate((StoreDelegate)delegate);
        this.localRouteStore.setDelegate((StoreDelegate)delegate);
        this.distributedRouteStore.setDelegate((StoreDelegate)delegate);
    }

    public void unsetDelegate(RouteStoreDelegate delegate) {
        super.unsetDelegate((StoreDelegate)delegate);
        this.localRouteStore.unsetDelegate((StoreDelegate)delegate);
        this.distributedRouteStore.unsetDelegate((StoreDelegate)delegate);
    }

    public void updateRoute(Route route) {
        this.currentRouteStore.updateRoute(route);
    }

    public void removeRoute(Route route) {
        this.currentRouteStore.removeRoute(route);
    }

    public Set<RouteTableId> getRouteTables() {
        return this.currentRouteStore.getRouteTables();
    }

    public Collection<RouteSet> getRoutes(RouteTableId table) {
        return this.currentRouteStore.getRoutes(table);
    }

    public Collection<Route> getRoutesForNextHop(IpAddress ip) {
        return this.currentRouteStore.getRoutesForNextHop(ip);
    }

    public RouteSet getRoutes(IpPrefix prefix) {
        return this.currentRouteStore.getRoutes(prefix);
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

