/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualStore;
import org.onosproject.store.StoreDelegate;

public class AbstractVirtualStore<E extends Event, D extends StoreDelegate<E>>
implements VirtualStore<E, D> {
    protected Map<NetworkId, D> delegateMap = Maps.newConcurrentMap();

    public void setDelegate(NetworkId networkId, D delegate) {
        Preconditions.checkState((this.delegateMap.get(networkId) == null || this.delegateMap.get(networkId) == delegate ? 1 : 0) != 0, (Object)"Store delegate already set");
        this.delegateMap.putIfAbsent(networkId, delegate);
    }

    public void unsetDelegate(NetworkId networkId, D delegate) {
        if (this.delegateMap.get(networkId) == delegate) {
            this.delegateMap.remove(networkId, delegate);
        }
    }

    public boolean hasDelegate(NetworkId networkId) {
        return this.delegateMap.get(networkId) != null;
    }

    protected void notifyDelegate(NetworkId networkId, E event) {
        if (this.delegateMap.get(networkId) != null) {
            ((StoreDelegate)this.delegateMap.get(networkId)).notify(event);
        }
    }

    protected void notifyDelegate(NetworkId networkId, List<E> events) {
        for (Event event : events) {
            this.notifyDelegate(networkId, event);
        }
    }
}

