/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkPacketStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketEvent;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketStoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class DistributedVirtualPacketStore
extends AbstractVirtualStore<PacketEvent, PacketStoreDelegate>
implements VirtualNetworkPacketStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String FORMAT = "Setting: messageHandlerThreadPoolSize={}";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private PacketRequestTracker tracker;
    private static final MessageSubject PACKET_OUT_SUBJECT = new MessageSubject("virtual-packet-out");
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ExecutorService messageHandlingExecutor;
    private static final int DEFAULT_MESSAGE_HANDLER_THREAD_POOL_SIZE = 4;
    @Property(name="messageHandlerThreadPoolSize", intValue={4}, label="Size of thread pool to assign message handler")
    private static int messageHandlerThreadPoolSize = 4;

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.modified(context);
        this.messageHandlingExecutor = Executors.newFixedThreadPool(messageHandlerThreadPoolSize, Tools.groupedThreads((String)"onos/store/packet", (String)"message-handlers", (Logger)this.log));
        this.communicationService.addSubscriber(PACKET_OUT_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), packetWrapper -> this.notifyDelegate(((OutboundPacketWrapper)packetWrapper).networkId, new PacketEvent(PacketEvent.Type.EMIT, ((OutboundPacketWrapper)packetWrapper).outboundPacket)), (Executor)this.messageHandlingExecutor);
        this.tracker = new PacketRequestTracker();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.communicationService.removeSubscriber(PACKET_OUT_SUBJECT);
        this.messageHandlingExecutor.shutdown();
        this.tracker = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newMessageHandlerThreadPoolSize;
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"messageHandlerThreadPoolSize");
            newMessageHandlerThreadPoolSize = Strings.isNullOrEmpty((String)s) ? messageHandlerThreadPoolSize : Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            this.log.warn(e.getMessage());
            newMessageHandlerThreadPoolSize = messageHandlerThreadPoolSize;
        }
        if (newMessageHandlerThreadPoolSize != messageHandlerThreadPoolSize) {
            this.setMessageHandlerThreadPoolSize(newMessageHandlerThreadPoolSize);
            this.restartMessageHandlerThreadPool();
        }
        this.log.info(FORMAT, (Object)messageHandlerThreadPoolSize);
    }

    public void emit(NetworkId networkId, OutboundPacket packet) {
        NodeId myId = this.clusterService.getLocalNode().id();
    }

    public void requestPackets(NetworkId networkId, PacketRequest request) {
        this.tracker.add(networkId, request);
    }

    public void cancelPackets(NetworkId networkId, PacketRequest request) {
        this.tracker.remove(networkId, request);
    }

    public List<PacketRequest> existingRequests(NetworkId networkId) {
        return this.tracker.requests(networkId);
    }

    private static RequestKey key(PacketRequest request) {
        return new RequestKey(request.selector(), request.priority());
    }

    private static OutboundPacketWrapper wrapper(NetworkId networkId, OutboundPacket outboundPacket) {
        return new OutboundPacketWrapper(networkId, outboundPacket);
    }

    private void setMessageHandlerThreadPoolSize(int poolSize) {
        Preconditions.checkArgument((poolSize >= 0 ? 1 : 0) != 0, (Object)"Message handler pool size must be 0 or more");
        messageHandlerThreadPoolSize = poolSize;
    }

    private void restartMessageHandlerThreadPool() {
        ExecutorService prevExecutor = this.messageHandlingExecutor;
        this.messageHandlingExecutor = Executors.newFixedThreadPool(this.getMessageHandlerThreadPoolSize(), Tools.groupedThreads((String)"DistPktStore", (String)"messageHandling-%d", (Logger)this.log));
        prevExecutor.shutdown();
    }

    private int getMessageHandlerThreadPoolSize() {
        return messageHandlerThreadPoolSize;
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private static final class OutboundPacketWrapper {
        private NetworkId networkId;
        private OutboundPacket outboundPacket;

        private OutboundPacketWrapper(NetworkId networkId, OutboundPacket outboundPacket) {
            this.networkId = networkId;
            this.outboundPacket = outboundPacket;
        }
    }

    private static final class RequestKey {
        private final TrafficSelector selector;
        private final PacketPriority priority;

        private RequestKey(TrafficSelector selector, PacketPriority priority) {
            this.selector = selector;
            this.priority = priority;
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.priority);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof RequestKey)) {
                return false;
            }
            RequestKey that = (RequestKey)other;
            return Objects.equals(this.selector, that.selector) && Objects.equals(this.priority, that.priority);
        }
    }

    private final class PacketRequestTracker {
        private ConsistentMap<NetworkId, Map<RequestKey, Set<PacketRequest>>> distRequests;
        private Map<NetworkId, Map<RequestKey, Set<PacketRequest>>> requests;

        private PacketRequestTracker() {
            this.distRequests = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)DistributedVirtualPacketStore.this.storageService.consistentMapBuilder().withName("onos-virtual-packet-requests")).withSerializer(Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{RequestKey.class}).register(new Class[]{NetworkId.class}).build()))).build();
            this.requests = this.distRequests.asJavaMap();
        }

        private void add(NetworkId networkId, PacketRequest request) {
            AtomicBoolean firstRequest = this.addInternal(networkId, request);
            PacketStoreDelegate delegate = (PacketStoreDelegate)DistributedVirtualPacketStore.this.delegateMap.get(networkId);
            if (firstRequest.get() && delegate != null) {
                delegate.requestPackets(request);
            }
        }

        private AtomicBoolean addInternal(NetworkId networkId, PacketRequest request) {
            AtomicBoolean firstRequest = new AtomicBoolean(false);
            AtomicBoolean changed = new AtomicBoolean(true);
            Map<RequestKey, Set<PacketRequest>> requestsForNetwork = this.getMap(networkId);
            requestsForNetwork.compute(DistributedVirtualPacketStore.key(request), (s, existingRequests) -> {
                firstRequest.set(false);
                if (existingRequests == null) {
                    firstRequest.set(true);
                    return ImmutableSet.of((Object)request);
                }
                if (!existingRequests.contains(request)) {
                    firstRequest.set(true);
                    return ImmutableSet.builder().addAll((Iterable)existingRequests).add((Object)request).build();
                }
                changed.set(false);
                return existingRequests;
            });
            if (changed.get()) {
                this.requests.put(networkId, requestsForNetwork);
            }
            return firstRequest;
        }

        private void remove(NetworkId networkId, PacketRequest request) {
            AtomicBoolean removedLast = this.removeInternal(networkId, request);
            PacketStoreDelegate delegate = (PacketStoreDelegate)DistributedVirtualPacketStore.this.delegateMap.get(networkId);
            if (removedLast.get() && delegate != null) {
                delegate.cancelPackets(request);
            }
        }

        private AtomicBoolean removeInternal(NetworkId networkId, PacketRequest request) {
            AtomicBoolean removedLast = new AtomicBoolean(false);
            AtomicBoolean changed = new AtomicBoolean(true);
            Map<RequestKey, Set<PacketRequest>> requestsForNetwork = this.getMap(networkId);
            requestsForNetwork.computeIfPresent(DistributedVirtualPacketStore.key(request), (s, existingRequests) -> {
                removedLast.set(false);
                if (existingRequests.contains(request)) {
                    HashSet newRequests = Sets.newHashSet((Iterable)existingRequests);
                    newRequests.remove(request);
                    if (newRequests.size() > 0) {
                        return ImmutableSet.copyOf((Collection)newRequests);
                    }
                    removedLast.set(true);
                    return null;
                }
                changed.set(false);
                return existingRequests;
            });
            if (changed.get()) {
                this.requests.put(networkId, requestsForNetwork);
            }
            return removedLast;
        }

        private List<PacketRequest> requests(NetworkId networkId) {
            Map<RequestKey, Set<PacketRequest>> requestsForNetwork = this.getMap(networkId);
            ArrayList list = Lists.newArrayList();
            requestsForNetwork.values().forEach(v -> list.addAll(v));
            list.sort((o1, o2) -> o1.priority().priorityValue() - o2.priority().priorityValue());
            return list;
        }

        private Map<RequestKey, Set<PacketRequest>> getMap(NetworkId networkId) {
            return this.requests.computeIfAbsent(networkId, networkId1 -> {
                DistributedVirtualPacketStore.this.log.debug("Creating new map for {}", networkId1);
                HashMap newMap = Maps.newHashMap();
                return newMap;
            });
        }
    }
}

