/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowObjectiveStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.behaviour.DefaultNextGroup;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualFlowObjectiveStore
extends AbstractVirtualStore<ObjectiveEvent, FlowObjectiveStoreDelegate>
implements VirtualNetworkFlowObjectiveStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ConcurrentMap<NetworkId, ConcurrentMap<Integer, byte[]>> nextGroupsMap;
    private AtomicCounter nextIds;
    private BlockingQueue<VirtualObjectiveEvent> eventQ;
    private ExecutorService tpool;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.tpool = Executors.newFixedThreadPool(4, Tools.groupedThreads((String)"onos/virtual/flobj-notifier", (String)"%d", (Logger)this.log));
        this.eventQ = new LinkedBlockingQueue<VirtualObjectiveEvent>();
        this.tpool.execute(new FlowObjectiveNotifier());
        this.initNextGroupsMap();
        this.nextIds = this.storageService.getAtomicCounter("next-objective-counter");
        this.log.info("Started");
    }

    public void deactivate() {
        this.log.info("Stopped");
    }

    protected void initNextGroupsMap() {
        this.nextGroupsMap = Maps.newConcurrentMap();
    }

    protected void updateNextGroupsMap(NetworkId networkId, ConcurrentMap<Integer, byte[]> nextGroups) {
    }

    protected ConcurrentMap<Integer, byte[]> getNextGroups(NetworkId networkId) {
        this.nextGroupsMap.computeIfAbsent(networkId, n -> Maps.newConcurrentMap());
        return (ConcurrentMap)this.nextGroupsMap.get(networkId);
    }

    public void putNextGroup(NetworkId networkId, Integer nextId, NextGroup group) {
        ConcurrentMap<Integer, byte[]> nextGroups = this.getNextGroups(networkId);
        nextGroups.put(nextId, group.data());
        this.updateNextGroupsMap(networkId, nextGroups);
        this.eventQ.add(new VirtualObjectiveEvent(networkId, ObjectiveEvent.Type.ADD, nextId));
    }

    public NextGroup getNextGroup(NetworkId networkId, Integer nextId) {
        ConcurrentMap<Integer, byte[]> nextGroups = this.getNextGroups(networkId);
        byte[] groupData = (byte[])nextGroups.get(nextId);
        if (groupData != null) {
            return new DefaultNextGroup(groupData);
        }
        return null;
    }

    public NextGroup removeNextGroup(NetworkId networkId, Integer nextId) {
        ConcurrentMap<Integer, byte[]> nextGroups = this.getNextGroups(networkId);
        byte[] nextGroup = (byte[])nextGroups.remove(nextId);
        this.updateNextGroupsMap(networkId, nextGroups);
        this.eventQ.add(new VirtualObjectiveEvent(networkId, ObjectiveEvent.Type.REMOVE, nextId));
        return new DefaultNextGroup(nextGroup);
    }

    public Map<Integer, NextGroup> getAllGroups(NetworkId networkId) {
        ConcurrentMap<Integer, byte[]> nextGroups = this.getNextGroups(networkId);
        HashMap<Integer, NextGroup> nextGroupMappings = new HashMap<Integer, NextGroup>();
        Iterator iterator = nextGroups.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            NextGroup nextGroup = this.getNextGroup(networkId, key);
            if (nextGroup == null) continue;
            nextGroupMappings.put(key, nextGroup);
        }
        return nextGroupMappings;
    }

    public int allocateNextId(NetworkId networkId) {
        return (int)this.nextIds.incrementAndGet();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class VirtualObjectiveEvent
    extends ObjectiveEvent {
        NetworkId networkId;

        public VirtualObjectiveEvent(NetworkId networkId, ObjectiveEvent.Type type, Integer objective) {
            super(type, objective);
            this.networkId = networkId;
        }

        NetworkId networkId() {
            return this.networkId;
        }
    }

    private class FlowObjectiveNotifier
    implements Runnable {
        private FlowObjectiveNotifier() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    VirtualObjectiveEvent vEvent = (VirtualObjectiveEvent)((Object)SimpleVirtualFlowObjectiveStore.this.eventQ.take());
                    SimpleVirtualFlowObjectiveStore.this.notifyDelegate(vEvent.networkId(), vEvent);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

