/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkMeterStore;
import org.onosproject.incubator.store.meter.impl.MeterData;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterEvent;
import org.onosproject.net.meter.MeterFailReason;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterFeaturesKey;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterKey;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterStoreDelegate;
import org.onosproject.net.meter.MeterStoreResult;
import org.onosproject.store.service.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualMeterStore
extends AbstractVirtualStore<MeterEvent, MeterStoreDelegate>
implements VirtualNetworkMeterStore {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private ConcurrentMap<NetworkId, ConcurrentMap<MeterKey, MeterData>> meterMap = Maps.newConcurrentMap();
    private NodeId local;
    private ConcurrentMap<NetworkId, ConcurrentMap<MeterFeaturesKey, MeterFeatures>> meterFeatureMap = Maps.newConcurrentMap();
    private ConcurrentMap<NetworkId, ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>>> futuresMap = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
        this.local = this.clusterService.getLocalNode().id();
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private ConcurrentMap<MeterKey, MeterData> getMetersByNetwork(NetworkId networkId) {
        this.meterMap.computeIfAbsent(networkId, m -> new ConcurrentHashMap());
        return (ConcurrentMap)this.meterMap.get(networkId);
    }

    private ConcurrentMap<MeterFeaturesKey, MeterFeatures> getMeterFeaturesByNetwork(NetworkId networkId) {
        this.meterFeatureMap.computeIfAbsent(networkId, f -> new ConcurrentHashMap());
        return (ConcurrentMap)this.meterFeatureMap.get(networkId);
    }

    private ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>> getFuturesByNetwork(NetworkId networkId) {
        this.futuresMap.computeIfAbsent(networkId, f -> new ConcurrentHashMap());
        return (ConcurrentMap)this.futuresMap.get(networkId);
    }

    public CompletableFuture<MeterStoreResult> storeMeter(NetworkId networkId, Meter meter) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>> futures = this.getFuturesByNetwork(networkId);
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            meters.put(key, data);
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<MeterStoreResult> deleteMeter(NetworkId networkId, Meter meter) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>> futures = this.getFuturesByNetwork(networkId);
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (meters.computeIfPresent(key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.success());
            }
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public MeterStoreResult storeMeterFeatures(NetworkId networkId, MeterFeatures meterfeatures) {
        ConcurrentMap<MeterFeaturesKey, MeterFeatures> meterFeatures = this.getMeterFeaturesByNetwork(networkId);
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)meterfeatures.deviceId());
        try {
            meterFeatures.putIfAbsent(key, meterfeatures);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public MeterStoreResult deleteMeterFeatures(NetworkId networkId, DeviceId deviceId) {
        ConcurrentMap<MeterFeaturesKey, MeterFeatures> meterFeatures = this.getMeterFeaturesByNetwork(networkId);
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)deviceId);
        try {
            meterFeatures.remove(key);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public CompletableFuture<MeterStoreResult> updateMeter(NetworkId networkId, Meter meter) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>> futures = this.getFuturesByNetwork(networkId);
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (meters.computeIfPresent(key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.fail((MeterFailReason)MeterFailReason.INVALID_METER));
            }
        }
        catch (StorageException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateMeterState(NetworkId networkId, Meter meter) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        meters.computeIfPresent(key, (k, v) -> {
            DefaultMeter m = (DefaultMeter)v.meter();
            m.setState(meter.state());
            m.setProcessedPackets(meter.packetsSeen());
            m.setProcessedBytes(meter.bytesSeen());
            m.setLife(meter.life());
            m.setReferenceCount(meter.referenceCount());
            return new MeterData((Meter)m, null, v.origin());
        });
    }

    public Meter getMeter(NetworkId networkId, MeterKey key) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        MeterData data = (MeterData)meters.get(key);
        return data == null ? null : data.meter();
    }

    public Collection<Meter> getAllMeters(NetworkId networkId) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        return Collections2.transform(meters.values(), MeterData::meter);
    }

    public void failedMeter(NetworkId networkId, MeterOperation op, MeterFailReason reason) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        MeterKey key = MeterKey.key((DeviceId)op.meter().deviceId(), (MeterId)op.meter().id());
        meters.computeIfPresent(key, (k, v) -> new MeterData(v.meter(), reason, v.origin()));
    }

    public void deleteMeterNow(NetworkId networkId, Meter m) {
        ConcurrentMap<MeterKey, MeterData> meters = this.getMetersByNetwork(networkId);
        ConcurrentMap<MeterKey, CompletableFuture<MeterStoreResult>> futures = this.getFuturesByNetwork(networkId);
        MeterKey key = MeterKey.key((DeviceId)m.deviceId(), (MeterId)m.id());
        futures.remove(key);
        meters.remove(key);
    }

    public long getMaxMeters(NetworkId networkId, MeterFeaturesKey key) {
        ConcurrentMap<MeterFeaturesKey, MeterFeatures> meterFeatures = this.getMeterFeaturesByNetwork(networkId);
        MeterFeatures features = (MeterFeatures)meterFeatures.get(key);
        return features == null ? 0L : features.maxMeter();
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

