/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.core.Version;
import org.onosproject.core.VersionService;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkMastershipStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualMastershipStore
extends AbstractVirtualStore<MastershipEvent, MastershipStoreDelegate>
implements VirtualNetworkMastershipStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int NOTHING = 0;
    private static final int INIT = 1;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VersionService versionService;
    protected final Map<NetworkId, Map<DeviceId, NodeId>> masterMapByNetwork = new HashMap<NetworkId, Map<DeviceId, NodeId>>();
    protected final Map<NetworkId, Map<DeviceId, List<NodeId>>> backupsByNetwork = new HashMap<NetworkId, Map<DeviceId, List<NodeId>>>();
    protected final Map<NetworkId, Map<DeviceId, AtomicInteger>> termMapByNetwork = new HashMap<NetworkId, Map<DeviceId, AtomicInteger>>();

    @Activate
    public void activate() {
        if (this.clusterService == null) {
            this.clusterService = this.createFakeClusterService();
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public CompletableFuture<MastershipRole> requestRole(NetworkId networkId, DeviceId deviceId) {
        NodeId node = this.clusterService.getLocalNode().id();
        MastershipRole role = this.getRole(networkId, node, deviceId);
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        switch (role) {
            case MASTER: {
                return CompletableFuture.completedFuture(MastershipRole.MASTER);
            }
            case STANDBY: {
                if (this.getMaster(networkId, deviceId) == null) {
                    masterMap.put(deviceId, node);
                    this.incrementTerm(networkId, deviceId);
                    this.removeFromBackups(networkId, deviceId, node);
                    this.notifyDelegate(networkId, new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
                    return CompletableFuture.completedFuture(MastershipRole.MASTER);
                }
                return CompletableFuture.completedFuture(MastershipRole.STANDBY);
            }
            case NONE: {
                if (this.getMaster(networkId, deviceId) == null) {
                    masterMap.put(deviceId, node);
                    this.incrementTerm(networkId, deviceId);
                    this.notifyDelegate(networkId, new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
                    return CompletableFuture.completedFuture(MastershipRole.MASTER);
                }
                if (this.addToBackup(networkId, deviceId, node)) {
                    this.notifyDelegate(networkId, new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
                }
                return CompletableFuture.completedFuture(MastershipRole.STANDBY);
            }
        }
        this.log.warn("unknown Mastership Role {}", (Object)role);
        return CompletableFuture.completedFuture(role);
    }

    public MastershipRole getRole(NetworkId networkId, NodeId nodeId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        NodeId current = masterMap.get(deviceId);
        if (current != null && current.equals((Object)nodeId)) {
            return MastershipRole.MASTER;
        }
        MastershipRole role = backups.getOrDefault(deviceId, Collections.emptyList()).contains(nodeId) ? MastershipRole.STANDBY : MastershipRole.NONE;
        return role;
    }

    public NodeId getMaster(NetworkId networkId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        return masterMap.get(deviceId);
    }

    public RoleInfo getNodes(NetworkId networkId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        return new RoleInfo(masterMap.get(deviceId), backups.getOrDefault(deviceId, (List<NodeId>)ImmutableList.of()));
    }

    public MastershipInfo getMastership(NetworkId networkId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        Map<DeviceId, AtomicInteger> termMap = this.getTermMap(networkId);
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        ImmutableMap.Builder roleBuilder = ImmutableMap.builder();
        NodeId master = masterMap.get(deviceId);
        if (master != null) {
            roleBuilder.put((Object)master, (Object)MastershipRole.MASTER);
        }
        backups.getOrDefault(master, Collections.emptyList()).forEach(nodeId -> roleBuilder.put(nodeId, (Object)MastershipRole.STANDBY));
        this.clusterService.getNodes().stream().filter(node -> !masterMap.containsValue(node.id())).forEach(node -> roleBuilder.put((Object)node.id(), (Object)MastershipRole.NONE));
        return new MastershipInfo((long)termMap.getOrDefault(deviceId, new AtomicInteger(0)).get(), Optional.ofNullable(master), roleBuilder.build());
    }

    public Set<DeviceId> getDevices(NetworkId networkId, NodeId nodeId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        HashSet<DeviceId> ids = new HashSet<DeviceId>();
        for (Map.Entry<DeviceId, NodeId> d : masterMap.entrySet()) {
            if (!Objects.equals(d.getValue(), nodeId)) continue;
            ids.add(d.getKey());
        }
        return ids;
    }

    public synchronized CompletableFuture<MastershipEvent> setMaster(NetworkId networkId, NodeId nodeId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        MastershipRole role = this.getRole(networkId, nodeId, deviceId);
        switch (role) {
            case MASTER: {
                return CompletableFuture.completedFuture(null);
            }
            case STANDBY: 
            case NONE: {
                NodeId prevMaster = masterMap.put(deviceId, nodeId);
                this.incrementTerm(networkId, deviceId);
                this.removeFromBackups(networkId, deviceId, nodeId);
                this.addToBackup(networkId, deviceId, prevMaster);
                break;
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
                return null;
            }
        }
        return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
    }

    public MastershipTerm getTermFor(NetworkId networkId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        Map<DeviceId, AtomicInteger> termMap = this.getTermMap(networkId);
        if (termMap.get(deviceId) == null) {
            return MastershipTerm.of((NodeId)masterMap.get(deviceId), (long)0L);
        }
        return MastershipTerm.of((NodeId)masterMap.get(deviceId), (long)termMap.get(deviceId).get());
    }

    public CompletableFuture<MastershipEvent> setStandby(NetworkId networkId, NodeId nodeId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        MastershipRole role = this.getRole(networkId, nodeId, deviceId);
        switch (role) {
            case MASTER: {
                NodeId backup = this.reelect(networkId, deviceId, nodeId);
                if (backup == null) {
                    masterMap.remove(deviceId);
                    return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
                }
                NodeId prevMaster = masterMap.put(deviceId, backup);
                this.incrementTerm(networkId, deviceId);
                this.addToBackup(networkId, deviceId, prevMaster);
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
            }
            case STANDBY: 
            case NONE: {
                boolean modified = this.addToBackup(networkId, deviceId, nodeId);
                if (!modified) break;
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
            }
        }
        return null;
    }

    private synchronized NodeId reelect(NetworkId networkId, DeviceId deviceId, NodeId nodeId) {
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        List stbys = backups.getOrDefault(deviceId, Collections.emptyList());
        NodeId backup = null;
        for (NodeId n : stbys) {
            if (n.equals((Object)nodeId)) continue;
            backup = n;
            break;
        }
        stbys.remove(backup);
        return backup;
    }

    public synchronized CompletableFuture<MastershipEvent> relinquishRole(NetworkId networkId, NodeId nodeId, DeviceId deviceId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        MastershipRole role = this.getRole(networkId, nodeId, deviceId);
        switch (role) {
            case MASTER: {
                NodeId backup = this.reelect(networkId, deviceId, nodeId);
                masterMap.put(deviceId, backup);
                this.incrementTerm(networkId, deviceId);
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
            }
            case STANDBY: {
                if (!this.removeFromBackups(networkId, deviceId, nodeId)) break;
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getMastership(networkId, deviceId)));
            }
            case NONE: {
                break;
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public void relinquishAllRole(NetworkId networkId, NodeId nodeId) {
        Map<DeviceId, NodeId> masterMap = this.getMasterMap(networkId);
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        ArrayList eventFutures = new ArrayList();
        HashSet toRelinquish = new HashSet();
        masterMap.entrySet().stream().filter(entry -> nodeId.equals(entry.getValue())).forEach(entry -> toRelinquish.add(entry.getKey()));
        backups.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(nodeId)).forEach(entry -> toRelinquish.add(entry.getKey()));
        toRelinquish.forEach(deviceId -> eventFutures.add(this.relinquishRole(networkId, nodeId, (DeviceId)deviceId)));
        eventFutures.forEach(future -> future.whenComplete((event, error) -> this.notifyDelegate(networkId, event)));
    }

    private synchronized void incrementTerm(NetworkId networkId, DeviceId deviceId) {
        Map<DeviceId, AtomicInteger> termMap = this.getTermMap(networkId);
        AtomicInteger term = termMap.getOrDefault(deviceId, new AtomicInteger(0));
        term.incrementAndGet();
        termMap.put(deviceId, term);
    }

    private synchronized boolean removeFromBackups(NetworkId networkId, DeviceId deviceId, NodeId nodeId) {
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        List stbys = backups.getOrDefault(deviceId, new ArrayList());
        boolean modified = stbys.remove(nodeId);
        backups.put(deviceId, stbys);
        return modified;
    }

    private synchronized boolean addToBackup(NetworkId networkId, DeviceId deviceId, NodeId nodeId) {
        Map<DeviceId, List<NodeId>> backups = this.getBackups(networkId);
        boolean modified = false;
        List stbys = backups.getOrDefault(deviceId, new ArrayList());
        if (nodeId != null && !stbys.contains(nodeId)) {
            stbys.add(nodeId);
            backups.put(deviceId, stbys);
            modified = true;
        }
        return modified;
    }

    private Map<DeviceId, NodeId> getMasterMap(NetworkId networkId) {
        return this.masterMapByNetwork.computeIfAbsent(networkId, k -> new HashMap());
    }

    private Map<DeviceId, List<NodeId>> getBackups(NetworkId networkId) {
        return this.backupsByNetwork.computeIfAbsent(networkId, k -> new HashMap());
    }

    private Map<DeviceId, AtomicInteger> getTermMap(NetworkId networkId) {
        return this.termMapByNetwork.computeIfAbsent(networkId, k -> new HashMap());
    }

    private ClusterService createFakeClusterService() {
        DefaultControllerNode instance = new DefaultControllerNode(new NodeId("local"), IpAddress.valueOf((String)"127.0.0.1"));
        ClusterService faceClusterService = new ClusterService((ControllerNode)instance){
            private final Instant creationTime = Instant.now();
            final /* synthetic */ ControllerNode val$instance;
            {
                this.val$instance = controllerNode;
            }

            public ControllerNode getLocalNode() {
                return this.val$instance;
            }

            public Set<ControllerNode> getNodes() {
                return ImmutableSet.of((Object)this.val$instance);
            }

            public ControllerNode getNode(NodeId nodeId) {
                if (this.val$instance.id().equals((Object)nodeId)) {
                    return this.val$instance;
                }
                return null;
            }

            public ControllerNode.State getState(NodeId nodeId) {
                if (this.val$instance.id().equals((Object)nodeId)) {
                    return ControllerNode.State.ACTIVE;
                }
                return ControllerNode.State.INACTIVE;
            }

            public Version getVersion(NodeId nodeId) {
                if (this.val$instance.id().equals((Object)nodeId)) {
                    return SimpleVirtualMastershipStore.this.versionService.version();
                }
                return null;
            }

            public Instant getLastUpdatedInstant(NodeId nodeId) {
                return this.creationTime;
            }

            public void addListener(ClusterEventListener listener) {
            }

            public void removeListener(ClusterEventListener listener) {
            }
        };
        return faceClusterService;
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected void unbindVersionService(VersionService versionService) {
        if (this.versionService == versionService) {
            this.versionService = null;
        }
    }
}

