/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.GroupId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkGroupStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.group.StoredGroupBucketEntry;
import org.onosproject.net.group.StoredGroupEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualGroupStore
extends AbstractVirtualStore<GroupEvent, GroupStoreDelegate>
implements VirtualNetworkGroupStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int dummyId = -1;
    private final GroupId dummyGroupId = new GroupId(-1);
    private final ConcurrentMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>> groupEntriesByKey = new ConcurrentHashMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>>();
    private final ConcurrentMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>>> groupEntriesById = new ConcurrentHashMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>>>();
    private final ConcurrentMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>> pendingGroupEntriesByKey = new ConcurrentHashMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>>();
    private final ConcurrentMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupId, Group>>> extraneousGroupEntriesById = new ConcurrentHashMap<NetworkId, ConcurrentMap<DeviceId, ConcurrentMap<GroupId, Group>>>();
    private final ConcurrentMap<NetworkId, HashMap<DeviceId, Boolean>> deviceAuditStatus = new ConcurrentHashMap<NetworkId, HashMap<DeviceId, Boolean>>();
    private final AtomicInteger groupIdGen = new AtomicInteger();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.groupEntriesByKey.clear();
        this.groupEntriesById.clear();
        this.log.info("Stopped");
    }

    private ConcurrentMap<GroupKey, StoredGroupEntry> getGroupKeyTable(NetworkId networkId, DeviceId deviceId) {
        this.groupEntriesByKey.computeIfAbsent(networkId, n -> new ConcurrentHashMap());
        return ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    private ConcurrentMap<GroupId, StoredGroupEntry> getGroupIdTable(NetworkId networkId, DeviceId deviceId) {
        this.groupEntriesById.computeIfAbsent(networkId, n -> new ConcurrentHashMap());
        return ((ConcurrentMap)this.groupEntriesById.get(networkId)).computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    private ConcurrentMap<GroupKey, StoredGroupEntry> getPendingGroupKeyTable(NetworkId networkId, DeviceId deviceId) {
        this.pendingGroupEntriesByKey.computeIfAbsent(networkId, n -> new ConcurrentHashMap());
        return ((ConcurrentMap)this.pendingGroupEntriesByKey.get(networkId)).computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    private ConcurrentMap<GroupId, Group> getExtraneousGroupIdTable(NetworkId networkId, DeviceId deviceId) {
        this.extraneousGroupEntriesById.computeIfAbsent(networkId, n -> new ConcurrentHashMap());
        return ((ConcurrentMap)this.extraneousGroupEntriesById.get(networkId)).computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    public int getGroupCount(NetworkId networkId, DeviceId deviceId) {
        return ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId) != null ? ((ConcurrentMap)((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId)).size() : 0;
    }

    public Iterable<Group> getGroups(NetworkId networkId, DeviceId deviceId) {
        return FluentIterable.from(this.getGroupKeyTable(networkId, deviceId).values()).transform(input -> input);
    }

    public Group getGroup(NetworkId networkId, DeviceId deviceId, GroupKey appCookie) {
        if (this.groupEntriesByKey.get(networkId) != null && ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId) != null) {
            return (Group)((ConcurrentMap)((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId)).get(appCookie);
        }
        return null;
    }

    public Group getGroup(NetworkId networkId, DeviceId deviceId, GroupId groupId) {
        if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId) != null) {
            return (Group)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId)).get(groupId);
        }
        return null;
    }

    private int getFreeGroupIdValue(NetworkId networkId, DeviceId deviceId) {
        int freeId = this.groupIdGen.incrementAndGet();
        while (true) {
            Group existing = null;
            if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId) != null) {
                existing = (Group)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId)).get(new GroupId(freeId));
            }
            if (existing == null && this.extraneousGroupEntriesById.get(networkId) != null && ((ConcurrentMap)this.extraneousGroupEntriesById.get(networkId)).get(deviceId) != null) {
                existing = (Group)((ConcurrentMap)((ConcurrentMap)this.extraneousGroupEntriesById.get(networkId)).get(deviceId)).get(new GroupId(freeId));
            }
            if (existing == null) break;
            freeId = this.groupIdGen.incrementAndGet();
        }
        return freeId;
    }

    public void storeGroupDescription(NetworkId networkId, GroupDescription groupDesc) {
        if (this.getGroup(networkId, groupDesc.deviceId(), groupDesc.appCookie()) != null) {
            return;
        }
        if (this.deviceAuditStatus.get(networkId) == null || ((HashMap)this.deviceAuditStatus.get(networkId)).get(groupDesc.deviceId()) == null) {
            DefaultGroup group = new DefaultGroup(this.dummyGroupId, groupDesc);
            group.setState(Group.GroupState.WAITING_AUDIT_COMPLETE);
            ConcurrentMap<GroupKey, StoredGroupEntry> pendingKeyTable = this.getPendingGroupKeyTable(networkId, groupDesc.deviceId());
            pendingKeyTable.put(groupDesc.appCookie(), (StoredGroupEntry)group);
            return;
        }
        this.storeGroupDescriptionInternal(networkId, groupDesc);
    }

    private void storeGroupDescriptionInternal(NetworkId networkId, GroupDescription groupDesc) {
        if (this.getGroup(networkId, groupDesc.deviceId(), groupDesc.appCookie()) != null) {
            return;
        }
        GroupId id = null;
        id = groupDesc.givenGroupId() == null ? new GroupId(this.getFreeGroupIdValue(networkId, groupDesc.deviceId())) : new GroupId(groupDesc.givenGroupId().intValue());
        DefaultGroup group = new DefaultGroup(id, groupDesc);
        ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(networkId, groupDesc.deviceId());
        keyTable.put(groupDesc.appCookie(), (StoredGroupEntry)group);
        ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(networkId, groupDesc.deviceId());
        idTable.put(id, (StoredGroupEntry)group);
        this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_ADD_REQUESTED, (Group)group));
    }

    public void updateGroupDescription(NetworkId networkId, DeviceId deviceId, GroupKey oldAppCookie, VirtualNetworkGroupStore.UpdateType type, GroupBuckets newBuckets, GroupKey newAppCookie) {
        Group oldGroup = this.getGroup(networkId, deviceId, oldAppCookie);
        if (oldGroup == null) {
            return;
        }
        List<GroupBucket> newBucketList = this.getUpdatedBucketList(oldGroup, type, newBuckets);
        if (newBucketList != null) {
            GroupBuckets updatedBuckets = new GroupBuckets(newBucketList);
            GroupKey newCookie = newAppCookie != null ? newAppCookie : oldAppCookie;
            DefaultGroupDescription updatedGroupDesc = new DefaultGroupDescription(oldGroup.deviceId(), oldGroup.type(), updatedBuckets, newCookie, oldGroup.givenGroupId(), oldGroup.appId());
            DefaultGroup newGroup = new DefaultGroup(oldGroup.id(), (GroupDescription)updatedGroupDesc);
            newGroup.setState(Group.GroupState.PENDING_UPDATE);
            newGroup.setLife(oldGroup.life());
            newGroup.setPackets(oldGroup.packets());
            newGroup.setBytes(oldGroup.bytes());
            ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(networkId, oldGroup.deviceId());
            ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(networkId, oldGroup.deviceId());
            keyTable.remove(oldGroup.appCookie());
            idTable.remove(oldGroup.id());
            keyTable.put(newGroup.appCookie(), (StoredGroupEntry)newGroup);
            idTable.put(newGroup.id(), (StoredGroupEntry)newGroup);
            this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_UPDATE_REQUESTED, (Group)newGroup));
        }
    }

    private List<GroupBucket> getUpdatedBucketList(Group oldGroup, VirtualNetworkGroupStore.UpdateType type, GroupBuckets buckets) {
        if (type == VirtualNetworkGroupStore.UpdateType.SET) {
            return buckets.buckets();
        }
        List oldBuckets = oldGroup.buckets().buckets();
        ArrayList<GroupBucket> updatedBucketList = new ArrayList<GroupBucket>();
        boolean groupDescUpdated = false;
        if (type == VirtualNetworkGroupStore.UpdateType.ADD) {
            List newBuckets = buckets.buckets();
            for (GroupBucket oldBucket : oldBuckets) {
                int newBucketIndex = newBuckets.indexOf(oldBucket);
                if (newBucketIndex != -1) {
                    GroupBucket newBucket = (GroupBucket)newBuckets.get(newBucketIndex);
                    if (newBucket.hasSameParameters(oldBucket)) continue;
                    groupDescUpdated = true;
                    continue;
                }
                updatedBucketList.add(oldBucket);
            }
            updatedBucketList.addAll(newBuckets);
            if (!oldBuckets.containsAll(newBuckets)) {
                groupDescUpdated = true;
            }
        } else if (type == VirtualNetworkGroupStore.UpdateType.REMOVE) {
            List bucketsToRemove = buckets.buckets();
            for (GroupBucket oldBucket : oldBuckets) {
                if (!bucketsToRemove.contains(oldBucket)) {
                    updatedBucketList.add(oldBucket);
                    continue;
                }
                groupDescUpdated = true;
            }
        }
        if (groupDescUpdated) {
            return updatedBucketList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroupDescription(NetworkId networkId, DeviceId deviceId, GroupKey appCookie) {
        StoredGroupEntry existing = null;
        if (this.groupEntriesByKey.get(networkId) != null && ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId) != null) {
            existing = (StoredGroupEntry)((ConcurrentMap)((ConcurrentMap)this.groupEntriesByKey.get(networkId)).get(deviceId)).get(appCookie);
        }
        if (existing == null) {
            return;
        }
        StoredGroupEntry storedGroupEntry = existing;
        synchronized (storedGroupEntry) {
            existing.setState(Group.GroupState.PENDING_DELETE);
        }
        this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, (Group)existing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateGroupEntry(NetworkId networkId, Group group) {
        StoredGroupEntry existing = null;
        if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId()) != null) {
            existing = (StoredGroupEntry)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId())).get(group.id());
        }
        GroupEvent event = null;
        if (existing != null) {
            StoredGroupEntry storedGroupEntry = existing;
            synchronized (storedGroupEntry) {
                for (GroupBucket bucket : group.buckets().buckets()) {
                    Optional<GroupBucket> matchingBucket = existing.buckets().buckets().stream().filter(existingBucket -> existingBucket.equals(bucket)).findFirst();
                    if (matchingBucket.isPresent()) {
                        ((StoredGroupBucketEntry)matchingBucket.get()).setPackets(bucket.packets());
                        ((StoredGroupBucketEntry)matchingBucket.get()).setBytes(bucket.bytes());
                        continue;
                    }
                    this.log.warn("addOrUpdateGroupEntry: No matching buckets to update stats");
                }
                existing.setLife(group.life());
                existing.setPackets(group.packets());
                existing.setBytes(group.bytes());
                if (existing.state() == Group.GroupState.PENDING_ADD) {
                    existing.setState(Group.GroupState.ADDED);
                    event = new GroupEvent(GroupEvent.Type.GROUP_ADDED, (Group)existing);
                } else {
                    if (existing.state() == Group.GroupState.PENDING_UPDATE) {
                        existing.setState(Group.GroupState.ADDED);
                    }
                    event = new GroupEvent(GroupEvent.Type.GROUP_UPDATED, (Group)existing);
                }
            }
        }
        if (event != null) {
            this.notifyDelegate(networkId, event);
        }
    }

    public void removeGroupEntry(NetworkId networkId, Group group) {
        StoredGroupEntry existing = null;
        if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId()) != null) {
            existing = (StoredGroupEntry)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId())).get(group.id());
        }
        if (existing != null) {
            ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(networkId, existing.deviceId());
            ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(networkId, existing.deviceId());
            idTable.remove(existing.id());
            keyTable.remove(existing.appCookie());
            this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)existing));
        }
    }

    public void purgeGroupEntry(NetworkId networkId, DeviceId deviceId) {
        if (this.groupEntriesById.get(networkId) != null) {
            Set entryPendingRemove = ((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId)).entrySet();
            ((ConcurrentMap)this.groupEntriesById.get(networkId)).remove(deviceId);
            ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).remove(deviceId);
            entryPendingRemove.forEach(entry -> this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)entry.getValue())));
        }
    }

    public void purgeGroupEntries(NetworkId networkId) {
        if (this.groupEntriesById.get(networkId) != null) {
            ((ConcurrentMap)this.groupEntriesById.get(networkId)).values().forEach(groupEntries -> groupEntries.entrySet().forEach(entry -> this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)entry.getValue()))));
            ((ConcurrentMap)this.groupEntriesById.get(networkId)).clear();
            ((ConcurrentMap)this.groupEntriesByKey.get(networkId)).clear();
        }
    }

    public void addOrUpdateExtraneousGroupEntry(NetworkId networkId, Group group) {
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(networkId, group.deviceId());
        extraneousIdTable.put(group.id(), group);
        if (group.referenceCount() == 0L) {
            this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, group));
        }
    }

    public void removeExtraneousGroupEntry(NetworkId networkId, Group group) {
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(networkId, group.deviceId());
        extraneousIdTable.remove(group.id());
    }

    public Iterable<Group> getExtraneousGroups(NetworkId networkId, DeviceId deviceId) {
        return FluentIterable.from(this.getExtraneousGroupIdTable(networkId, deviceId).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceInitialAuditCompleted(NetworkId networkId, DeviceId deviceId, boolean completed) {
        HashMap deviceAuditStatusByNetwork;
        this.deviceAuditStatus.computeIfAbsent(networkId, k -> new HashMap());
        HashMap hashMap = deviceAuditStatusByNetwork = (HashMap)this.deviceAuditStatus.get(networkId);
        synchronized (hashMap) {
            if (completed) {
                this.log.debug("deviceInitialAuditCompleted: AUDIT completed for device {}", (Object)deviceId);
                deviceAuditStatusByNetwork.put(deviceId, true);
                ConcurrentMap<GroupKey, StoredGroupEntry> pendingGroupRequests = this.getPendingGroupKeyTable(networkId, deviceId);
                for (Group group : pendingGroupRequests.values()) {
                    DefaultGroupDescription tmp = new DefaultGroupDescription(group.deviceId(), group.type(), group.buckets(), group.appCookie(), group.givenGroupId(), group.appId());
                    this.storeGroupDescriptionInternal(networkId, (GroupDescription)tmp);
                }
                this.getPendingGroupKeyTable(networkId, deviceId).clear();
            } else if (((Boolean)deviceAuditStatusByNetwork.get(deviceId)).booleanValue()) {
                this.log.debug("deviceInitialAuditCompleted: Clearing AUDIT status for device {}", (Object)deviceId);
                deviceAuditStatusByNetwork.put(deviceId, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deviceInitialAuditStatus(NetworkId networkId, DeviceId deviceId) {
        HashMap deviceAuditStatusByNetwork;
        this.deviceAuditStatus.computeIfAbsent(networkId, k -> new HashMap());
        HashMap hashMap = deviceAuditStatusByNetwork = (HashMap)this.deviceAuditStatus.get(networkId);
        synchronized (hashMap) {
            return deviceAuditStatusByNetwork.get(deviceId) != null ? (Boolean)deviceAuditStatusByNetwork.get(deviceId) : false;
        }
    }

    public void groupOperationFailed(NetworkId networkId, DeviceId deviceId, GroupOperation operation) {
        StoredGroupEntry existing = null;
        if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId) != null) {
            existing = (StoredGroupEntry)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(deviceId)).get(operation.groupId());
        }
        if (existing == null) {
            this.log.warn("No group entry with ID {} found ", (Object)operation.groupId());
            return;
        }
        switch (operation.opType()) {
            case ADD: {
                this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_ADD_FAILED, existing));
                break;
            }
            case MODIFY: {
                this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_UPDATE_FAILED, existing));
                break;
            }
            case DELETE: {
                this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_REMOVE_FAILED, existing));
                break;
            }
            default: {
                this.log.warn("Unknown group operation type {}", (Object)operation.opType());
            }
        }
        ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(networkId, existing.deviceId());
        ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(networkId, existing.deviceId());
        idTable.remove(existing.id());
        keyTable.remove(existing.appCookie());
    }

    public void pushGroupMetrics(NetworkId networkId, DeviceId deviceId, Collection<Group> groupEntries) {
        boolean deviceInitialAuditStatus = this.deviceInitialAuditStatus(networkId, deviceId);
        HashSet southboundGroupEntries = Sets.newHashSet(groupEntries);
        HashSet storedGroupEntries = Sets.newHashSet(this.getGroups(networkId, deviceId));
        HashSet extraneousStoredEntries = Sets.newHashSet(this.getExtraneousGroups(networkId, deviceId));
        if (this.log.isTraceEnabled()) {
            this.log.trace("pushGroupMetrics: Displaying all ({}) southboundGroupEntries for device {}", (Object)southboundGroupEntries.size(), (Object)deviceId);
            for (Group group : southboundGroupEntries) {
                this.log.trace("Group {} in device {}", (Object)group, (Object)deviceId);
            }
            this.log.trace("Displaying all ({}) stored group entries for device {}", (Object)storedGroupEntries.size(), (Object)deviceId);
            for (Group group : storedGroupEntries) {
                this.log.trace("Stored Group {} for device {}", (Object)group, (Object)deviceId);
            }
        }
        Iterator it2 = southboundGroupEntries.iterator();
        while (it2.hasNext()) {
            Group group;
            group = (Group)it2.next();
            if (!storedGroupEntries.remove(group)) continue;
            this.log.trace("Group AUDIT: group {} exists in both planes for device {}", (Object)group.id(), (Object)deviceId);
            this.groupAdded(networkId, group);
            it2.remove();
        }
        for (Group group : southboundGroupEntries) {
            if (this.getGroup(networkId, group.deviceId(), group.id()) != null) {
                if (storedGroupEntries.remove(this.getGroup(networkId, group.deviceId(), group.id()))) continue;
                this.log.warn("Group AUDIT: Inconsistent state:Group exists in ID based table while not present in key based table");
                continue;
            }
            this.log.trace("Group AUDIT: extraneous group {} exists in data plane for device {}", (Object)group.id(), (Object)deviceId);
            extraneousStoredEntries.remove(group);
            this.extraneousGroup(networkId, group);
        }
        for (Group group : storedGroupEntries) {
            this.log.trace("Group AUDIT: group {} missing in data plane for device {}", (Object)group.id(), (Object)deviceId);
            this.groupMissing(networkId, group);
        }
        for (Group group : extraneousStoredEntries) {
            this.log.trace("Group AUDIT: clearing extransoeus group {} from store for device {}", (Object)group.id(), (Object)deviceId);
            this.removeExtraneousGroupEntry(networkId, group);
        }
        if (!deviceInitialAuditStatus) {
            this.log.debug("Group AUDIT: Setting device {} initial AUDIT completed", (Object)deviceId);
            this.deviceInitialAuditCompleted(networkId, deviceId, true);
        }
    }

    public void notifyOfFailovers(NetworkId networkId, Collection<Group> failoverGroups) {
        ArrayList failoverEvents = new ArrayList();
        failoverGroups.forEach(group -> {
            if (group.type() == GroupDescription.Type.FAILOVER) {
                failoverEvents.add(new GroupEvent(GroupEvent.Type.GROUP_BUCKET_FAILOVER, group));
            }
        });
        this.notifyDelegate(networkId, failoverEvents);
    }

    private void groupMissing(NetworkId networkId, Group group) {
        switch (group.state()) {
            case PENDING_DELETE: {
                this.log.debug("Group {} delete confirmation from device {} of virtaual network {}", new Object[]{group, group.deviceId(), networkId});
                this.removeGroupEntry(networkId, group);
                break;
            }
            case ADDED: 
            case PENDING_ADD: 
            case PENDING_UPDATE: {
                this.log.debug("Group {} is in store but not on device {}", (Object)group, (Object)group.deviceId());
                StoredGroupEntry existing = null;
                if (this.groupEntriesById.get(networkId) != null && ((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId()) != null) {
                    existing = (StoredGroupEntry)((ConcurrentMap)((ConcurrentMap)this.groupEntriesById.get(networkId)).get(group.deviceId())).get(group.id());
                }
                if (existing == null) break;
                this.log.trace("groupMissing: group entry {} in device {} moving from {} to PENDING_ADD", new Object[]{existing.id(), existing.deviceId(), existing.state()});
                existing.setState(Group.GroupState.PENDING_ADD);
                this.notifyDelegate(networkId, new GroupEvent(GroupEvent.Type.GROUP_ADD_REQUESTED, group));
                break;
            }
            default: {
                this.log.debug("Virtual network {} : Group {} has not been installed.", (Object)networkId, (Object)group);
            }
        }
    }

    private void extraneousGroup(NetworkId networkId, Group group) {
        this.log.debug("Group {} is on device {} of virtual network{}, but not in store.", new Object[]{group, group.deviceId(), networkId});
        this.addOrUpdateExtraneousGroupEntry(networkId, group);
    }

    private void groupAdded(NetworkId networkId, Group group) {
        this.log.trace("Group {} Added or Updated in device {} of virtual network {}", new Object[]{group, group.deviceId(), networkId});
        this.addOrUpdateGroupEntry(networkId, group);
    }
}

