/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.meter.impl;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.incubator.store.meter.impl.MeterData;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.MeterQuery;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.DefaultMeterFeatures;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterEvent;
import org.onosproject.net.meter.MeterFailReason;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterFeaturesFlag;
import org.onosproject.net.meter.MeterFeaturesKey;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterKey;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.meter.MeterStore;
import org.onosproject.net.meter.MeterStoreDelegate;
import org.onosproject.net.meter.MeterStoreResult;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.primitives.DefaultDistributedSet;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMapBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedMeterStore
extends AbstractStore<MeterEvent, MeterStoreDelegate>
implements MeterStore {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String METERSTORE = "onos-meter-store";
    private static final String METERFEATURESSTORE = "onos-meter-features-store";
    private static final String AVAILABLEMETERIDSTORE = "onos-meters-available-store";
    private static final String METERIDSTORE = "onos-meters-id-store";
    private static final KryoNamespace.Builder APP_KRYO_BUILDER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MeterKey.class}).register(new Class[]{MeterData.class}).register(new Class[]{DefaultMeter.class}).register(new Class[]{DefaultBand.class}).register(new Class[]{Band.Type.class}).register(new Class[]{MeterState.class}).register(new Class[]{Meter.Unit.class});
    private Serializer serializer = Serializer.using((List)Lists.newArrayList((Object[])new KryoNamespace[]{APP_KRYO_BUILDER.build()}), (Class[])new Class[0]);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private ConsistentMap<MeterKey, MeterData> meters;
    private NodeId local;
    private ConsistentMap<MeterFeaturesKey, MeterFeatures> meterFeatures;
    private MapEventListener<MeterKey, MeterData> mapListener = new InternalMapEventListener();
    private Map<MeterKey, CompletableFuture<MeterStoreResult>> futures = Maps.newConcurrentMap();
    private DistributedSet<MeterKey> availableMeterIds;
    private AtomicCounterMap<DeviceId> meterIdGenerators;
    private ReuseStrategy reuseStrategy = ReuseStrategy.FIRST_FIT;

    @Activate
    public void activate() {
        this.local = this.clusterService.getLocalNode().id();
        this.meters = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(METERSTORE)).withSerializer(this.serializer)).build();
        this.meters.addListener(this.mapListener);
        this.meterFeatures = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(METERFEATURESSTORE)).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{MeterFeaturesKey.class, MeterFeatures.class, DefaultMeterFeatures.class, Band.Type.class, Meter.Unit.class, MeterFailReason.class, MeterFeaturesFlag.class}))).build();
        this.availableMeterIds = new DefaultDistributedSet((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName(AVAILABLEMETERIDSTORE)).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{MeterKey.class}))).build(), 15000L);
        this.meterIdGenerators = (AtomicCounterMap)((AtomicCounterMapBuilder)((AtomicCounterMapBuilder)this.storageService.atomicCounterMapBuilder().withName(METERIDSTORE)).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.meters.removeListener(this.mapListener);
        this.log.info("Stopped");
    }

    public CompletableFuture<MeterStoreResult> storeMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            this.meters.put((Object)key, (Object)data);
        }
        catch (StorageException e) {
            this.futures.remove(key);
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<MeterStoreResult> deleteMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (this.meters.computeIfPresent((Object)key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.success());
            }
        }
        catch (StorageException e) {
            this.futures.remove(key);
            future.completeExceptionally(e);
        }
        return future;
    }

    public MeterStoreResult storeMeterFeatures(MeterFeatures meterfeatures) {
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)meterfeatures.deviceId());
        try {
            this.meterFeatures.putIfAbsent((Object)key, (Object)meterfeatures);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public MeterStoreResult deleteMeterFeatures(DeviceId deviceId) {
        MeterStoreResult result = MeterStoreResult.success();
        MeterFeaturesKey key = MeterFeaturesKey.key((DeviceId)deviceId);
        try {
            this.meterFeatures.remove((Object)key);
        }
        catch (StorageException e) {
            result = MeterStoreResult.fail((MeterFailReason)MeterFailReason.TIMEOUT);
        }
        return result;
    }

    public CompletableFuture<MeterStoreResult> updateMeter(Meter meter) {
        CompletableFuture<MeterStoreResult> future = new CompletableFuture<MeterStoreResult>();
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.futures.put(key, future);
        MeterData data = new MeterData(meter, null, this.local);
        try {
            if (this.meters.computeIfPresent((Object)key, (k, v) -> data) == null) {
                future.complete(MeterStoreResult.fail((MeterFailReason)MeterFailReason.INVALID_METER));
            }
        }
        catch (StorageException e) {
            this.futures.remove(key);
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateMeterState(Meter meter) {
        MeterKey key = MeterKey.key((DeviceId)meter.deviceId(), (MeterId)meter.id());
        this.meters.computeIfPresent((Object)key, (k, v) -> {
            DefaultMeter m = (DefaultMeter)v.meter();
            m.setState(meter.state());
            m.setProcessedPackets(meter.packetsSeen());
            m.setProcessedBytes(meter.bytesSeen());
            m.setLife(meter.life());
            m.setReferenceCount(meter.referenceCount());
            if (meter.referenceCount() == 0L) {
                this.notifyDelegate((Event)new MeterEvent(MeterEvent.Type.METER_REFERENCE_COUNT_ZERO, (Meter)m));
            }
            return new MeterData((Meter)m, null, v.origin());
        });
    }

    public Meter getMeter(MeterKey key) {
        MeterData data = (MeterData)Versioned.valueOrElse((Versioned)this.meters.get((Object)key), null);
        return data == null ? null : data.meter();
    }

    public Collection<Meter> getAllMeters() {
        return Collections2.transform(this.meters.asJavaMap().values(), MeterData::meter);
    }

    public Collection<Meter> getAllMeters(DeviceId deviceId) {
        return Collections2.transform((Collection)Collections2.filter(this.meters.asJavaMap().values(), m -> m.meter().deviceId().equals((Object)deviceId)), MeterData::meter);
    }

    public void failedMeter(MeterOperation op, MeterFailReason reason) {
        MeterKey key = MeterKey.key((DeviceId)op.meter().deviceId(), (MeterId)op.meter().id());
        this.meters.computeIfPresent((Object)key, (k, v) -> new MeterData(v.meter(), reason, v.origin()));
    }

    public void deleteMeterNow(Meter m) {
        MeterKey key = MeterKey.key((DeviceId)m.deviceId(), (MeterId)m.id());
        this.futures.remove(key);
        this.meters.remove((Object)key);
        this.freeMeterId(m.deviceId(), m.id());
        this.notifyDelegate((Event)new MeterEvent(MeterEvent.Type.METER_REMOVED, m));
    }

    public long getMaxMeters(MeterFeaturesKey key) {
        MeterFeatures features = (MeterFeatures)Versioned.valueOrElse((Versioned)this.meterFeatures.get((Object)key), null);
        return features == null ? 0L : features.maxMeter();
    }

    private long queryMaxMeters(DeviceId device) {
        DriverHandler handler = this.driverService.createHandler(device, new String[0]);
        if (handler == null || !handler.hasBehaviour(MeterQuery.class)) {
            return 0L;
        }
        MeterQuery query = (MeterQuery)handler.behaviour(MeterQuery.class);
        return query.getMaxMeters();
    }

    private boolean updateMeterIdAvailability(DeviceId deviceId, MeterId id, boolean available) {
        return available ? this.availableMeterIds.add((Object)MeterKey.key((DeviceId)deviceId, (MeterId)id)) : this.availableMeterIds.remove((Object)MeterKey.key((DeviceId)deviceId, (MeterId)id));
    }

    private MeterId getNextAvailableId(Set<MeterId> availableIds) {
        if (availableIds.isEmpty()) {
            return null;
        }
        if (this.reuseStrategy == ReuseStrategy.FIRST_FIT || availableIds.size() == 1) {
            return availableIds.iterator().next();
        }
        int size = availableIds.size();
        return (MeterId)Iterables.get(availableIds, (int)RandomUtils.nextInt((int)size));
    }

    private MeterId firstReusableMeterId(DeviceId deviceId) {
        Set<MeterId> localAvailableMeterIds = this.availableMeterIds.stream().filter(meterKey -> meterKey.deviceId().equals((Object)deviceId)).map(MeterKey::meterId).collect(Collectors.toSet());
        MeterId meterId = this.getNextAvailableId(localAvailableMeterIds);
        while (meterId != null) {
            if (this.updateMeterIdAvailability(deviceId, meterId, false)) {
                return meterId;
            }
            localAvailableMeterIds.remove(meterId);
            meterId = this.getNextAvailableId(localAvailableMeterIds);
        }
        return null;
    }

    public MeterId allocateMeterId(DeviceId deviceId) {
        MeterId meterId = this.firstReusableMeterId(deviceId);
        if (meterId != null) {
            return meterId;
        }
        long maxMeters = this.getMaxMeters(MeterFeaturesKey.key((DeviceId)deviceId));
        if (maxMeters == 0L) {
            maxMeters = this.queryMaxMeters(deviceId);
        }
        if (maxMeters == 0L) {
            return null;
        }
        long id = this.meterIdGenerators.incrementAndGet((Object)deviceId);
        if (id >= maxMeters) {
            return null;
        }
        return MeterId.meterId((long)id);
    }

    public void freeMeterId(DeviceId deviceId, MeterId meterId) {
        if (this.meterIdGenerators.get((Object)deviceId) < (Long)meterId.id()) {
            return;
        }
        this.updateMeterIdAvailability(deviceId, meterId, true);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalMapEventListener
    implements MapEventListener<MeterKey, MeterData> {
        private InternalMapEventListener() {
        }

        public void event(MapEvent<MeterKey, MeterData> event) {
            MeterKey key = (MeterKey)event.key();
            MeterData data = (MeterData)event.value().value();
            NodeId master = DistributedMeterStore.this.mastershipService.getMasterFor(data.meter().deviceId());
            block0 : switch (event.type()) {
                case INSERT: 
                case UPDATE: {
                    switch (data.meter().state()) {
                        case PENDING_ADD: 
                        case PENDING_REMOVE: {
                            if (!data.reason().isPresent() && DistributedMeterStore.this.local.equals((Object)master)) {
                                DistributedMeterStore.this.notifyDelegate((Event)new MeterEvent(data.meter().state() == MeterState.PENDING_ADD ? MeterEvent.Type.METER_ADD_REQ : MeterEvent.Type.METER_REM_REQ, data.meter()));
                                break;
                            }
                            if (!data.reason().isPresent() || !DistributedMeterStore.this.local.equals((Object)data.origin())) break block0;
                            MeterStoreResult msr = MeterStoreResult.fail((MeterFailReason)data.reason().get());
                            ((CompletableFuture)DistributedMeterStore.this.futures.get(key)).complete(msr);
                            break;
                        }
                        case ADDED: {
                            if (!DistributedMeterStore.this.local.equals((Object)data.origin()) || data.meter().state() != MeterState.PENDING_ADD && data.meter().state() != MeterState.ADDED) break block0;
                            DistributedMeterStore.this.futures.computeIfPresent(key, (k, v) -> {
                                DistributedMeterStore.this.notifyDelegate((Event)new MeterEvent(MeterEvent.Type.METER_ADDED, data.meter()));
                                return null;
                            });
                            break;
                        }
                        case REMOVED: {
                            if (!DistributedMeterStore.this.local.equals((Object)data.origin()) || data.meter().state() != MeterState.PENDING_REMOVE) break block0;
                            ((CompletableFuture)DistributedMeterStore.this.futures.remove(key)).complete(MeterStoreResult.success());
                            break;
                        }
                        default: {
                            DistributedMeterStore.this.log.warn("Unknown meter state type {}", (Object)data.meter().state());
                            break;
                        }
                    }
                    break;
                }
                case REMOVE: {
                    break;
                }
                default: {
                    DistributedMeterStore.this.log.warn("Unknown Map event type {}", (Object)event.type());
                }
            }
        }
    }

    static enum ReuseStrategy {
        RANDOM,
        FIRST_FIT;

    }
}

