/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowObjectiveStore;
import org.onosproject.incubator.store.virtual.impl.SimpleVirtualFlowObjectiveStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class DistributedVirtualFlowObjectiveStore
extends SimpleVirtualFlowObjectiveStore
implements VirtualNetworkFlowObjectiveStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ConsistentMap<NetworkId, ConcurrentMap<Integer, byte[]>> nextGroupsMap;
    private static final String VNET_FLOW_OBJ_GROUP_MAP_NAME = "onos-networkId-flowobjective-groups";
    private static final String VNET_FLOW_OBJ_GROUP_MAP_FRIENDLYNAME = "DistributedVirtualFlowObjectiveStore";

    @Override
    protected void initNextGroupsMap() {
        this.nextGroupsMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(VNET_FLOW_OBJ_GROUP_MAP_NAME)).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{NetworkId.class}).build(VNET_FLOW_OBJ_GROUP_MAP_FRIENDLYNAME)))).build();
    }

    @Override
    protected ConcurrentMap<Integer, byte[]> getNextGroups(NetworkId networkId) {
        this.nextGroupsMap.computeIfAbsent((Object)networkId, n -> {
            this.log.debug("getNextGroups - creating new ConcurrentMap");
            return Maps.newConcurrentMap();
        });
        return (ConcurrentMap)this.nextGroupsMap.get((Object)networkId).value();
    }

    @Override
    protected void updateNextGroupsMap(NetworkId networkId, ConcurrentMap<Integer, byte[]> nextGroups) {
        this.nextGroupsMap.put((Object)networkId, nextGroups);
    }
}

