/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowRuleStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.incubator.store.virtual.impl.primitives.VirtualDeviceId;
import org.onosproject.incubator.store.virtual.impl.primitives.VirtualFlowEntry;
import org.onosproject.incubator.store.virtual.impl.primitives.VirtualFlowRule;
import org.onosproject.incubator.store.virtual.impl.primitives.VirtualFlowRuleBatchEvent;
import org.onosproject.incubator.store.virtual.impl.primitives.VirtualFlowRuleBatchOperation;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.BatchOperationEntry;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.flow.oldbatch.FlowRuleBatchEntry;
import org.onosproject.net.flow.oldbatch.FlowRuleBatchEvent;
import org.onosproject.net.flow.oldbatch.FlowRuleBatchOperation;
import org.onosproject.net.flow.oldbatch.FlowRuleBatchRequest;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class DistributedVirtualFlowRuleStore
extends AbstractVirtualStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements VirtualNetworkFlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MESSAGE_HANDLER_THREAD_POOL_SIZE = 1;
    private static final boolean DEFAULT_PERSISTENCE_ENABLED = false;
    private static final int DEFAULT_BACKUP_PERIOD_MILLIS = 2000;
    private static final long FLOW_RULE_STORE_TIMEOUT_MILLIS = 5000L;
    private static final String FLOW_OP_TOPIC = "virtual-flow-ops-ids";
    private static final MessageSubject APPLY_BATCH_FLOWS = new MessageSubject("virtual-peer-forward-apply-batch");
    private static final MessageSubject GET_FLOW_ENTRY = new MessageSubject("virtual-peer-forward-get-flow-entry");
    private static final MessageSubject GET_DEVICE_FLOW_ENTRIES = new MessageSubject("virtual-peer-forward-get-device-flow-entries");
    private static final MessageSubject REMOVE_FLOW_ENTRY = new MessageSubject("virtual-peer-forward-remove-flow-entry");
    private static final MessageSubject REMOTE_APPLY_COMPLETED = new MessageSubject("virtual-peer-apply-completed");
    @Property(name="msgHandlerPoolSize", intValue={1}, label="Number of threads in the message handler pool")
    private int msgHandlerPoolSize = 1;
    @Property(name="backupPeriod", intValue={2000}, label="Delay in ms between successive backup runs")
    private int backupPeriod = 2000;
    @Property(name="persistenceEnabled", boolValue={false}, label="Indicates whether or not changes in the flow table should be persisted to disk.")
    private boolean persistenceEnabled = false;
    private InternalFlowTable flowTable = new InternalFlowTable();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkService vnaService;
    private Map<Long, NodeId> pendingResponses = Maps.newConcurrentMap();
    private ExecutorService messageHandlingExecutor;
    private ExecutorService eventHandler;
    private EventuallyConsistentMap<NetworkId, Map<DeviceId, List<TableStatisticsEntry>>> deviceTableStats;
    private final EventuallyConsistentMapListener<NetworkId, Map<DeviceId, List<TableStatisticsEntry>>> tableStatsListener = new InternalTableStatsListener();
    protected final Serializer serializer = Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{NetworkId.class}).register(new Class[]{VirtualFlowRuleBatchOperation.class}).register(new Class[]{VirtualFlowRuleBatchEvent.class}).build());
    protected final KryoNamespace.Builder serializerBuilder = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipBasedTimestamp.class});
    private IdGenerator idGenerator;
    private NodeId local;

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(this.getClass());
        this.idGenerator = this.coreService.getIdGenerator(FLOW_OP_TOPIC);
        this.local = this.clusterService.getLocalNode().id();
        this.eventHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/virtual-flow", (String)"event-handler", (Logger)this.log));
        this.messageHandlingExecutor = Executors.newFixedThreadPool(this.msgHandlerPoolSize, Tools.groupedThreads((String)"onos/store/virtual-flow", (String)"message-handlers", (Logger)this.log));
        this.registerMessageHandlers(this.messageHandlingExecutor);
        this.deviceTableStats = this.storageService.eventuallyConsistentMapBuilder().withName("onos-virtual-flow-table-stats").withSerializer(this.serializerBuilder).withAntiEntropyPeriod(5L, TimeUnit.SECONDS).withTimestampProvider((k, v) -> new WallClockTimestamp()).withTombstonesDisabled().build();
        this.deviceTableStats.addListener(this.tableStatsListener);
        this.logConfig("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configService.unregisterProperties(this.getClass(), false);
        this.unregisterMessageHandlers();
        this.deviceTableStats.removeListener(this.tableStatsListener);
        this.deviceTableStats.destroy();
        this.eventHandler.shutdownNow();
        this.messageHandlingExecutor.shutdownNow();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newBackupPeriod;
        int newPoolSize;
        if (context == null) {
            this.logConfig("Default config");
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"msgHandlerPoolSize");
            newPoolSize = Strings.isNullOrEmpty((String)s) ? this.msgHandlerPoolSize : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"backupPeriod");
            newBackupPeriod = Strings.isNullOrEmpty((String)s) ? this.backupPeriod : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPoolSize = 1;
            newBackupPeriod = 2000;
        }
        boolean restartBackupTask = false;
        if (newBackupPeriod != this.backupPeriod) {
            this.backupPeriod = newBackupPeriod;
            restartBackupTask = true;
        }
        if (restartBackupTask) {
            this.log.warn("Currently, backup tasks are not supported.");
        }
        if (newPoolSize != this.msgHandlerPoolSize) {
            this.msgHandlerPoolSize = newPoolSize;
            ExecutorService oldMsgHandler = this.messageHandlingExecutor;
            this.messageHandlingExecutor = Executors.newFixedThreadPool(this.msgHandlerPoolSize, Tools.groupedThreads((String)"onos/store/virtual-flow", (String)"message-handlers", (Logger)this.log));
            this.registerMessageHandlers(this.messageHandlingExecutor);
            oldMsgHandler.shutdown();
        }
        this.logConfig("Reconfigured");
    }

    public int getFlowRuleCount(NetworkId networkId) {
        AtomicInteger sum = new AtomicInteger(0);
        DeviceService deviceService = (DeviceService)this.vnaService.get(networkId, DeviceService.class);
        deviceService.getDevices().forEach(device -> sum.addAndGet(Iterables.size(this.getFlowEntries(networkId, device.id()))));
        return sum.get();
    }

    public FlowEntry getFlowEntry(NetworkId networkId, FlowRule rule) {
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(rule.deviceId());
        if (master == null) {
            this.log.debug("Failed to getFlowEntry: No master for {}, vnet {}", (Object)rule.deviceId(), (Object)networkId);
            return null;
        }
        if (Objects.equals(this.local, master)) {
            return this.flowTable.getFlowEntry(networkId, rule);
        }
        this.log.trace("Forwarding getFlowEntry to {}, which is the primary (master) for device {}, vnet {}", new Object[]{master, rule.deviceId(), networkId});
        VirtualFlowRule vRule = new VirtualFlowRule(networkId, rule);
        return (FlowEntry)Tools.futureGetOrElse((Future)this.clusterCommunicator.sendAndReceive((Object)vRule, GET_FLOW_ENTRY, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), master), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public Iterable<FlowEntry> getFlowEntries(NetworkId networkId, DeviceId deviceId) {
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.debug("Failed to getFlowEntries: No master for {}, vnet {}", (Object)deviceId, (Object)networkId);
            return Collections.emptyList();
        }
        if (Objects.equals(this.local, master)) {
            return this.flowTable.getFlowEntries(networkId, deviceId);
        }
        this.log.trace("Forwarding getFlowEntries to {}, which is the primary (master) for device {}", (Object)master, (Object)deviceId);
        return (Iterable)Tools.futureGetOrElse((Future)this.clusterCommunicator.sendAndReceive((Object)deviceId, GET_DEVICE_FLOW_ENTRIES, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), master), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS, Collections.emptyList());
    }

    public void storeBatch(NetworkId networkId, FlowRuleBatchOperation operation) {
        if (operation.getOperations().isEmpty()) {
            this.notifyDelegate(networkId, FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        DeviceId deviceId = operation.deviceId();
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.warn("No master for {}, vnet {} : flows will be marked for removal", (Object)deviceId, (Object)networkId);
            this.updateStoreInternal(networkId, operation);
            this.notifyDelegate(networkId, FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        if (Objects.equals(this.local, master)) {
            this.storeBatchInternal(networkId, operation);
            return;
        }
        this.log.trace("Forwarding storeBatch to {}, which is the primary (master) for device {}, vent {}", new Object[]{master, deviceId, networkId});
        this.clusterCommunicator.unicast((Object)new VirtualFlowRuleBatchOperation(networkId, operation), APPLY_BATCH_FLOWS, arg_0 -> ((Serializer)this.serializer).encode(arg_0), master).whenComplete((result, error) -> {
            if (error != null) {
                this.log.warn("Failed to storeBatch: {} to {}", new Object[]{operation, master, error});
                Set allFailures = operation.getOperations().stream().map(BatchOperationEntry::target).collect(Collectors.toSet());
                this.notifyDelegate(networkId, FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(false, allFailures, deviceId)));
            }
        });
    }

    public void batchOperationComplete(NetworkId networkId, FlowRuleBatchEvent event) {
        NodeId nodeId = this.pendingResponses.remove(((FlowRuleBatchRequest)event.subject()).batchId());
        if (nodeId == null) {
            this.notifyDelegate(networkId, event);
        } else {
            this.clusterCommunicator.unicast((Object)new VirtualFlowRuleBatchEvent(networkId, event), REMOTE_APPLY_COMPLETED, arg_0 -> ((Serializer)this.serializer).encode(arg_0), nodeId);
        }
    }

    public void deleteFlowRule(NetworkId networkId, FlowRule rule) {
        this.storeBatch(networkId, new FlowRuleBatchOperation(Collections.singletonList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, rule)), rule.deviceId(), this.idGenerator.getNewId()));
    }

    public FlowRuleEvent addOrUpdateFlowRule(NetworkId networkId, FlowEntry rule) {
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(rule.deviceId());
        if (Objects.equals(this.local, master)) {
            return this.addOrUpdateFlowRuleInternal(networkId, rule);
        }
        this.log.warn("Tried to update FlowRule {} state, while the Node was not the master.", (Object)rule);
        return null;
    }

    private FlowRuleEvent addOrUpdateFlowRuleInternal(NetworkId networkId, FlowEntry rule) {
        StoredFlowEntry stored = this.flowTable.getFlowEntry(networkId, (FlowRule)rule);
        if (stored != null) {
            stored.setBytes(rule.bytes());
            stored.setLife(rule.life(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            stored.setLiveType(rule.liveType());
            stored.setPackets(rule.packets());
            stored.setLastSeen();
            if (stored.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                stored.setState(FlowEntry.FlowEntryState.ADDED);
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
            }
            return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
        }
        this.flowTable.add(networkId, rule);
        return null;
    }

    public FlowRuleEvent removeFlowRule(NetworkId networkId, FlowEntry rule) {
        DeviceId deviceId = rule.deviceId();
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(deviceId);
        if (Objects.equals(this.local, master)) {
            return this.removeFlowRuleInternal(new VirtualFlowEntry(networkId, rule));
        }
        if (master == null) {
            this.log.warn("Failed to removeFlowRule: No master for {}", (Object)deviceId);
            return null;
        }
        this.log.trace("Forwarding removeFlowRule to {}, which is the master for device {}", (Object)master, (Object)deviceId);
        return (FlowRuleEvent)Futures.getUnchecked((Future)this.clusterCommunicator.sendAndReceive((Object)new VirtualFlowEntry(networkId, rule), REMOVE_FLOW_ENTRY, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), master));
    }

    public FlowRuleEvent pendingFlowRule(NetworkId networkId, FlowEntry rule) {
        StoredFlowEntry stored;
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        if (mastershipService.isLocalMaster(rule.deviceId()) && (stored = this.flowTable.getFlowEntry(networkId, (FlowRule)rule)) != null && stored.state() != FlowEntry.FlowEntryState.PENDING_ADD) {
            stored.setState(FlowEntry.FlowEntryState.PENDING_ADD);
            return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
        }
        return null;
    }

    public void purgeFlowRules(NetworkId networkId) {
        this.flowTable.purgeFlowRules(networkId);
    }

    public FlowRuleEvent updateTableStatistics(NetworkId networkId, DeviceId deviceId, List<TableStatisticsEntry> tableStats) {
        if (this.deviceTableStats.get((Object)networkId) == null) {
            this.deviceTableStats.put((Object)networkId, (Object)Maps.newConcurrentMap());
        }
        ((Map)this.deviceTableStats.get((Object)networkId)).put(deviceId, tableStats);
        return null;
    }

    public Iterable<TableStatisticsEntry> getTableStatistics(NetworkId networkId, DeviceId deviceId) {
        List tableStats;
        MastershipService mastershipService = (MastershipService)this.vnaService.get(networkId, MastershipService.class);
        NodeId master = mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.debug("Failed to getTableStats: No master for {}", (Object)deviceId);
            return Collections.emptyList();
        }
        if (this.deviceTableStats.get((Object)networkId) == null) {
            this.deviceTableStats.put((Object)networkId, (Object)Maps.newConcurrentMap());
        }
        if ((tableStats = (List)((Map)this.deviceTableStats.get((Object)networkId)).get(deviceId)) == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)tableStats);
    }

    private void registerMessageHandlers(ExecutorService executor) {
        this.clusterCommunicator.addSubscriber(APPLY_BATCH_FLOWS, (ClusterMessageHandler)new OnStoreBatch(), executor);
        this.clusterCommunicator.addSubscriber(REMOTE_APPLY_COMPLETED, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::notifyDelicateByNetwork, (Executor)executor);
        this.clusterCommunicator.addSubscriber(GET_FLOW_ENTRY, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::getFlowEntryByNetwork, arg_0 -> ((Serializer)this.serializer).encode(arg_0), (Executor)executor);
        this.clusterCommunicator.addSubscriber(GET_DEVICE_FLOW_ENTRIES, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::getFlowEntriesByNetwork, arg_0 -> ((Serializer)this.serializer).encode(arg_0), (Executor)executor);
        this.clusterCommunicator.addSubscriber(REMOVE_FLOW_ENTRY, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::removeFlowRuleInternal, arg_0 -> ((Serializer)this.serializer).encode(arg_0), (Executor)executor);
    }

    private void unregisterMessageHandlers() {
        this.clusterCommunicator.removeSubscriber(REMOVE_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(GET_DEVICE_FLOW_ENTRIES);
        this.clusterCommunicator.removeSubscriber(GET_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(APPLY_BATCH_FLOWS);
        this.clusterCommunicator.removeSubscriber(REMOTE_APPLY_COMPLETED);
    }

    private void logConfig(String prefix) {
        this.log.info("{} with msgHandlerPoolSize = {}; backupPeriod = {}", new Object[]{prefix, this.msgHandlerPoolSize, this.backupPeriod});
    }

    private void storeBatchInternal(NetworkId networkId, FlowRuleBatchOperation operation) {
        DeviceId did = operation.deviceId();
        Set<FlowRuleBatchEntry> currentOps = this.updateStoreInternal(networkId, operation);
        if (currentOps.isEmpty()) {
            this.batchOperationComplete(networkId, FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), did)));
            return;
        }
        this.vnaService.get(networkId, FlowRuleService.class);
        this.notifyDelegate(networkId, FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), currentOps), (DeviceId)operation.deviceId()));
    }

    private Set<FlowRuleBatchEntry> updateStoreInternal(NetworkId networkId, FlowRuleBatchOperation operation) {
        return operation.getOperations().stream().map(op -> {
            switch ((FlowRuleBatchEntry.FlowRuleOperation)op.operator()) {
                case ADD: {
                    DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)op.target());
                    this.flowTable.remove(networkId, entry.deviceId(), (FlowEntry)entry);
                    this.flowTable.add(networkId, (FlowEntry)entry);
                    return op;
                }
                case REMOVE: {
                    StoredFlowEntry entry = this.flowTable.getFlowEntry(networkId, (FlowRule)op.target());
                    if (entry == null) break;
                    entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                    this.log.debug("Setting state of rule to pending remove: {}", (Object)entry);
                    return op;
                }
                case MODIFY: {
                    break;
                }
                default: {
                    this.log.warn("Unknown flow operation operator: {}", (Object)op.operator());
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private FlowRuleEvent removeFlowRuleInternal(VirtualFlowEntry rule) {
        DeviceId deviceId = rule.flowEntry().deviceId();
        FlowEntry removed = this.flowTable.remove(rule.networkId(), deviceId, rule.flowEntry());
        return removed != null ? new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)removed) : null;
    }

    private FlowEntry getFlowEntryByNetwork(VirtualFlowRule rule) {
        return this.flowTable.getFlowEntry(rule.networkId(), rule.rule());
    }

    private Set<FlowEntry> getFlowEntriesByNetwork(VirtualDeviceId deviceId) {
        return this.flowTable.getFlowEntries(deviceId.networkId(), deviceId.deviceId());
    }

    private void notifyDelicateByNetwork(VirtualFlowRuleBatchEvent event) {
        this.batchOperationComplete(event.networkId(), event.event());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindVnaService(VirtualNetworkService virtualNetworkService) {
        this.vnaService = virtualNetworkService;
    }

    protected void unbindVnaService(VirtualNetworkService virtualNetworkService) {
        if (this.vnaService == virtualNetworkService) {
            this.vnaService = null;
        }
    }

    public final class MastershipBasedTimestamp
    implements Timestamp {
        private final long termNumber;
        private final long sequenceNumber;

        protected MastershipBasedTimestamp() {
            this.termNumber = -1L;
            this.sequenceNumber = -1L;
        }

        public MastershipBasedTimestamp(long termNumber, long sequenceNumber) {
            this.termNumber = termNumber;
            this.sequenceNumber = sequenceNumber;
        }

        public int compareTo(Timestamp o) {
            Preconditions.checkArgument((boolean)(o instanceof MastershipBasedTimestamp), (String)"Must be MastershipBasedTimestamp", (Object)o);
            MastershipBasedTimestamp that = (MastershipBasedTimestamp)o;
            return ComparisonChain.start().compare(this.termNumber, that.termNumber).compare(this.sequenceNumber, that.sequenceNumber).result();
        }

        public int hashCode() {
            return Objects.hash(this.termNumber, this.sequenceNumber);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MastershipBasedTimestamp)) {
                return false;
            }
            MastershipBasedTimestamp that = (MastershipBasedTimestamp)obj;
            return Objects.equals(this.termNumber, that.termNumber) && Objects.equals(this.sequenceNumber, that.sequenceNumber);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("termNumber", this.termNumber).add("sequenceNumber", this.sequenceNumber).toString();
        }

        public long termNumber() {
            return this.termNumber;
        }

        public long sequenceNumber() {
            return this.sequenceNumber;
        }
    }

    private class InternalTableStatsListener
    implements EventuallyConsistentMapListener<NetworkId, Map<DeviceId, List<TableStatisticsEntry>>> {
        private InternalTableStatsListener() {
        }

        public void event(EventuallyConsistentMapEvent<NetworkId, Map<DeviceId, List<TableStatisticsEntry>>> event) {
        }
    }

    private class InternalFlowTable {
        private final Map<NetworkId, Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>>> flowEntriesMap = Maps.newConcurrentMap();
        private final Map<NetworkId, Map<DeviceId, Long>> lastUpdateTimesMap = Maps.newConcurrentMap();

        private InternalFlowTable() {
        }

        private Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>> getFlowEntriesByNetwork(NetworkId networkId) {
            return this.flowEntriesMap.computeIfAbsent(networkId, k -> Maps.newConcurrentMap());
        }

        private Map<DeviceId, Long> getLastUpdateTimesByNetwork(NetworkId networkId) {
            return this.lastUpdateTimesMap.computeIfAbsent(networkId, k -> Maps.newConcurrentMap());
        }

        private Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>> getFlowTable(NetworkId networkId, DeviceId deviceId) {
            Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>> flowEntries = this.getFlowEntriesByNetwork(networkId);
            if (DistributedVirtualFlowRuleStore.this.persistenceEnabled) {
                DistributedVirtualFlowRuleStore.this.log.warn("Persistent is not supported");
                return null;
            }
            return flowEntries.computeIfAbsent(deviceId, id -> Maps.newConcurrentMap());
        }

        private Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>> getFlowTableCopy(NetworkId networkId, DeviceId deviceId) {
            Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>> flowEntries = this.getFlowEntriesByNetwork(networkId);
            HashMap copy = Maps.newHashMap();
            if (DistributedVirtualFlowRuleStore.this.persistenceEnabled) {
                DistributedVirtualFlowRuleStore.this.log.warn("Persistent is not supported");
                return null;
            }
            flowEntries.computeIfAbsent(deviceId, id -> Maps.newConcurrentMap()).forEach((k, v) -> copy.put(k, Maps.newHashMap((Map)v)));
            return copy;
        }

        private Map<StoredFlowEntry, StoredFlowEntry> getFlowEntriesInternal(NetworkId networkId, DeviceId deviceId, FlowId flowId) {
            return this.getFlowTable(networkId, deviceId).computeIfAbsent(flowId, id -> Maps.newConcurrentMap());
        }

        private StoredFlowEntry getFlowEntryInternal(NetworkId networkId, FlowRule rule) {
            return this.getFlowEntriesInternal(networkId, rule.deviceId(), rule.id()).get(rule);
        }

        private Set<FlowEntry> getFlowEntriesInternal(NetworkId networkId, DeviceId deviceId) {
            return this.getFlowTable(networkId, deviceId).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
        }

        public StoredFlowEntry getFlowEntry(NetworkId networkId, FlowRule rule) {
            return this.getFlowEntryInternal(networkId, rule);
        }

        public Set<FlowEntry> getFlowEntries(NetworkId networkId, DeviceId deviceId) {
            return this.getFlowEntriesInternal(networkId, deviceId);
        }

        public void add(NetworkId networkId, FlowEntry rule) {
            Map<DeviceId, Long> lastUpdateTimes = this.getLastUpdateTimesByNetwork(networkId);
            this.getFlowEntriesInternal(networkId, rule.deviceId(), rule.id()).compute((StoredFlowEntry)rule, (k, stored) -> (StoredFlowEntry)rule);
            lastUpdateTimes.put(rule.deviceId(), System.currentTimeMillis());
        }

        public FlowEntry remove(NetworkId networkId, DeviceId deviceId, FlowEntry rule) {
            AtomicReference removedRule = new AtomicReference();
            Map<DeviceId, Long> lastUpdateTimes = this.getLastUpdateTimesByNetwork(networkId);
            this.getFlowEntriesInternal(networkId, rule.deviceId(), rule.id()).computeIfPresent((StoredFlowEntry)rule, (k, stored) -> {
                if (rule instanceof DefaultFlowEntry) {
                    DefaultFlowEntry toRemove = (DefaultFlowEntry)rule;
                    if (stored instanceof DefaultFlowEntry) {
                        DefaultFlowEntry storedEntry = (DefaultFlowEntry)stored;
                        if (toRemove.created() < storedEntry.created()) {
                            DistributedVirtualFlowRuleStore.this.log.debug("Trying to remove more recent flow entry {} (stored: {})", (Object)toRemove, stored);
                            return stored;
                        }
                    }
                }
                removedRule.set(stored);
                return null;
            });
            if (removedRule.get() != null) {
                lastUpdateTimes.put(deviceId, System.currentTimeMillis());
                return (FlowEntry)removedRule.get();
            }
            return null;
        }

        public void purgeFlowRule(NetworkId networkId, DeviceId deviceId) {
            Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>> flowEntries = this.getFlowEntriesByNetwork(networkId);
            flowEntries.remove(deviceId);
        }

        public void purgeFlowRules(NetworkId networkId) {
            Map<DeviceId, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>>> flowEntries = this.getFlowEntriesByNetwork(networkId);
            flowEntries.clear();
        }
    }

    private final class OnStoreBatch
    implements ClusterMessageHandler {
        private OnStoreBatch() {
        }

        public void handle(ClusterMessage message) {
            VirtualFlowRuleBatchOperation vOperation = (VirtualFlowRuleBatchOperation)DistributedVirtualFlowRuleStore.this.serializer.decode(message.payload());
            DistributedVirtualFlowRuleStore.this.log.debug("received batch request {}", (Object)vOperation);
            FlowRuleBatchOperation operation = vOperation.operation();
            DeviceId deviceId = operation.deviceId();
            MastershipService mastershipService = (MastershipService)DistributedVirtualFlowRuleStore.this.vnaService.get(vOperation.networkId(), MastershipService.class);
            NodeId master = mastershipService.getMasterFor(deviceId);
            if (!Objects.equals(DistributedVirtualFlowRuleStore.this.local, master)) {
                HashSet<FlowRule> failures = new HashSet<FlowRule>(operation.size());
                for (FlowRuleBatchEntry op : operation.getOperations()) {
                    failures.add((FlowRule)op.target());
                }
                CompletedBatchOperation allFailed = new CompletedBatchOperation(false, failures, deviceId);
                message.respond(DistributedVirtualFlowRuleStore.this.serializer.encode((Object)allFailed));
                return;
            }
            DistributedVirtualFlowRuleStore.this.pendingResponses.put(operation.id(), message.sender());
            DistributedVirtualFlowRuleStore.this.storeBatchInternal(vOperation.networkId(), operation);
        }
    }
}

