/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntentStore;
import org.onosproject.incubator.store.virtual.impl.AbstractVirtualStore;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.net.intent.Key;
import org.onosproject.store.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleVirtualIntentStore
extends AbstractVirtualStore<IntentEvent, IntentStoreDelegate>
implements VirtualNetworkIntentStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<NetworkId, Map<Key, IntentData>> currentByNetwork = Maps.newConcurrentMap();
    private final Map<NetworkId, Map<Key, IntentData>> pendingByNetwork = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public long getIntentCount(NetworkId networkId) {
        return this.getCurrentMap(networkId).size();
    }

    public Iterable<Intent> getIntents(NetworkId networkId) {
        return this.getCurrentMap(networkId).values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getIntentData(NetworkId networkId, boolean localOnly, long olderThan) {
        if (localOnly || olderThan > 0L) {
            long older = System.nanoTime() - olderThan * 1000000L;
            SystemClockTimestamp time = new SystemClockTimestamp(older);
            return this.getCurrentMap(networkId).values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(networkId, data.key()))).collect(Collectors.toList());
        }
        return Lists.newArrayList(this.getCurrentMap(networkId).values());
    }

    public IntentState getIntentState(NetworkId networkId, Key intentKey) {
        IntentData data = this.getCurrentMap(networkId).get(intentKey);
        return data != null ? data.state() : null;
    }

    public List<Intent> getInstallableIntents(NetworkId networkId, Key intentKey) {
        IntentData data = this.getCurrentMap(networkId).get(intentKey);
        if (data != null) {
            return data.installables();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(NetworkId networkId, IntentData newData) {
        Preconditions.checkNotNull((Object)newData);
        SimpleVirtualIntentStore simpleVirtualIntentStore = this;
        synchronized (simpleVirtualIntentStore) {
            IntentData currentData = this.getCurrentMap(networkId).get(newData.key());
            IntentData pendingData = this.getPendingMap(networkId).get(newData.key());
            if (IntentData.isUpdateAcceptable((IntentData)currentData, (IntentData)newData)) {
                if (pendingData != null) {
                    if (pendingData.state() == IntentState.PURGE_REQ) {
                        this.getCurrentMap(networkId).remove(newData.key(), newData);
                    } else {
                        this.getCurrentMap(networkId).put(newData.key(), IntentData.copy((IntentData)newData));
                    }
                    if (pendingData.version().compareTo((Object)newData.version()) <= 0) {
                        this.getPendingMap(networkId).remove(newData.key());
                    }
                }
                IntentEvent.getEvent((IntentData)newData).ifPresent(e -> this.notifyDelegate(networkId, e));
            }
        }
    }

    public void batchWrite(NetworkId networkId, Iterable<IntentData> updates) {
        for (IntentData data : updates) {
            this.write(networkId, data);
        }
    }

    public Intent getIntent(NetworkId networkId, Key key) {
        IntentData data = this.getCurrentMap(networkId).get(key);
        return data != null ? data.intent() : null;
    }

    public IntentData getIntentData(NetworkId networkId, Key key) {
        IntentData currentData = this.getCurrentMap(networkId).get(key);
        if (currentData == null) {
            return null;
        }
        return IntentData.copy((IntentData)currentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(NetworkId networkId, IntentData data) {
        if (data.version() == null) {
            data = new IntentData(data.intent(), data.state(), (Timestamp)new SystemClockTimestamp());
        }
        SimpleVirtualIntentStore simpleVirtualIntentStore = this;
        synchronized (simpleVirtualIntentStore) {
            IntentData existingData = this.getPendingMap(networkId).get(data.key());
            if (existingData == null || existingData.version().compareTo((Object)data.version()) < 0) {
                this.getPendingMap(networkId).put(data.key(), data);
                ((IntentStoreDelegate)Preconditions.checkNotNull((Object)((IntentStoreDelegate)this.delegateMap.get(networkId)), (Object)"Store delegate is not set")).process(IntentData.copy((IntentData)data));
                IntentEvent.getEvent((IntentData)data).ifPresent(e -> this.notifyDelegate(networkId, e));
            } else {
                this.log.debug("IntentData {} is older than existing: {}", (Object)data, (Object)existingData);
            }
        }
    }

    public boolean isMaster(NetworkId networkId, Key intentKey) {
        return true;
    }

    public Iterable<Intent> getPending(NetworkId networkId) {
        return this.getPendingMap(networkId).values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getPendingData(NetworkId networkId) {
        return Lists.newArrayList(this.getPendingMap(networkId).values());
    }

    public IntentData getPendingData(NetworkId networkId, Key intentKey) {
        return this.getPendingMap(networkId).get(intentKey);
    }

    public Iterable<IntentData> getPendingData(NetworkId networkId, boolean localOnly, long olderThan) {
        long older = System.nanoTime() - olderThan * 1000000L;
        SystemClockTimestamp time = new SystemClockTimestamp(older);
        return this.getPendingMap(networkId).values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(networkId, data.key()))).collect(Collectors.toList());
    }

    private Map<Key, IntentData> getCurrentMap(NetworkId networkId) {
        this.currentByNetwork.computeIfAbsent(networkId, n -> Maps.newConcurrentMap());
        return this.currentByNetwork.get(networkId);
    }

    private Map<Key, IntentData> getPendingMap(NetworkId networkId) {
        this.pendingByNetwork.computeIfAbsent(networkId, n -> Maps.newConcurrentMap());
        return this.pendingByNetwork.get(networkId);
    }

    public class SystemClockTimestamp
    implements Timestamp {
        private final long nanoTimestamp;

        public SystemClockTimestamp() {
            this.nanoTimestamp = System.nanoTime();
        }

        public SystemClockTimestamp(long timestamp) {
            this.nanoTimestamp = timestamp;
        }

        public int compareTo(Timestamp o) {
            Preconditions.checkArgument((boolean)(o instanceof SystemClockTimestamp), (String)"Must be SystemClockTimestamp", (Object)o);
            SystemClockTimestamp that = (SystemClockTimestamp)o;
            return ComparisonChain.start().compare(this.nanoTimestamp, that.nanoTimestamp).result();
        }
    }
}

