/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.resource.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceDelegate;
import org.onosproject.incubator.net.resource.label.LabelResourceEvent;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourcePool;
import org.onosproject.incubator.net.resource.label.LabelResourceRequest;
import org.onosproject.incubator.net.resource.label.LabelResourceStore;
import org.onosproject.incubator.store.resource.impl.LabelResourceMessageSubjects;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DistributedLabelResourceStore
extends AbstractStore<LabelResourceEvent, LabelResourceDelegate>
implements LabelResourceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String POOL_MAP_NAME = "labelresourcepool";
    private static final String GLOBAL_RESOURCE_POOL_DEVICE_ID = "global_resource_pool_device_id";
    private ConsistentMap<DeviceId, LabelResourcePool> resourcePool = null;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private ExecutorService messageHandlingExecutor;
    private static final int MESSAGE_HANDLER_THREAD_POOL_SIZE = 8;
    private static final long PEER_REQUEST_TIMEOUT_MS = 5000L;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{LabelResourceEvent.class}).register(new Class[]{LabelResourcePool.class}).register(new Class[]{DeviceId.class}).register(new Class[]{LabelResourceRequest.class}).register(new Class[]{LabelResourceRequest.Type.class}).register(new Class[]{LabelResourceEvent.Type.class}).register(new Class[]{DefaultLabelResource.class}).register(new Class[]{LabelResourceId.class}).nextId(300).build());

    @Activate
    public void activate() {
        this.resourcePool = this.storageService.consistentMapBuilder().withName(POOL_MAP_NAME).withSerializer(SERIALIZER).withPartitionsDisabled().build();
        this.messageHandlingExecutor = Executors.newFixedThreadPool(8, Tools.groupedThreads((String)"onos/store/flow", (String)"message-handlers"));
        this.clusterCommunicator.addSubscriber(LabelResourceMessageSubjects.LABEL_POOL_CREATED, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                LabelResourcePool operation = (LabelResourcePool)SERIALIZER.decode(message.payload());
                DistributedLabelResourceStore.this.log.trace("received get flow entry request for {}", (Object)operation);
                boolean b = DistributedLabelResourceStore.this.internalCreate(operation);
                message.respond(SERIALIZER.encode((Object)b));
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(LabelResourceMessageSubjects.LABEL_POOL_DESTROYED, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                DeviceId deviceId = (DeviceId)SERIALIZER.decode(message.payload());
                DistributedLabelResourceStore.this.log.trace("received get flow entry request for {}", (Object)deviceId);
                boolean b = DistributedLabelResourceStore.this.internalDestroy(deviceId);
                message.respond(SERIALIZER.encode((Object)b));
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(LabelResourceMessageSubjects.LABEL_POOL_APPLY, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                LabelResourceRequest request = (LabelResourceRequest)SERIALIZER.decode(message.payload());
                DistributedLabelResourceStore.this.log.trace("received get flow entry request for {}", (Object)request);
                Collection resource = DistributedLabelResourceStore.this.internalApply(request);
                message.respond(SERIALIZER.encode((Object)resource));
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(LabelResourceMessageSubjects.LABEL_POOL_RELEASE, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                LabelResourceRequest request = (LabelResourceRequest)SERIALIZER.decode(message.payload());
                DistributedLabelResourceStore.this.log.trace("received get flow entry request for {}", (Object)request);
                boolean isSuccess = DistributedLabelResourceStore.this.internalRelease(request);
                message.respond(SERIALIZER.encode((Object)isSuccess));
            }
        }, this.messageHandlingExecutor);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(LabelResourceMessageSubjects.LABEL_POOL_CREATED);
        this.clusterCommunicator.removeSubscriber(LabelResourceMessageSubjects.LABEL_POOL_APPLY);
        this.clusterCommunicator.removeSubscriber(LabelResourceMessageSubjects.LABEL_POOL_DESTROYED);
        this.clusterCommunicator.removeSubscriber(LabelResourceMessageSubjects.LABEL_POOL_RELEASE);
        this.messageHandlingExecutor.shutdown();
        this.log.info("Stopped");
    }

    public boolean createDevicePool(DeviceId deviceId, LabelResourceId beginLabel, LabelResourceId endLabel) {
        LabelResourcePool pool = new LabelResourcePool(deviceId.toString(), beginLabel.labelId(), endLabel.labelId());
        return this.create(pool);
    }

    public boolean createGlobalPool(LabelResourceId beginLabel, LabelResourceId endLabel) {
        LabelResourcePool pool = new LabelResourcePool(GLOBAL_RESOURCE_POOL_DEVICE_ID, beginLabel.labelId(), endLabel.labelId());
        return this.internalCreate(pool);
    }

    private boolean create(LabelResourcePool pool) {
        Device device = this.deviceService.getDevice(pool.deviceId());
        if (device == null) {
            return false;
        }
        NodeId master = this.mastershipService.getMasterFor(pool.deviceId());
        if (master == null) {
            this.log.warn("Failed to create label resource pool: No master for {}", (Object)pool);
            return false;
        }
        if (master.equals((Object)this.clusterService.getLocalNode().id())) {
            return this.internalCreate(pool);
        }
        this.log.trace("Forwarding getFlowEntries to {}, which is the primary (master) for device {}", (Object)master, (Object)pool.deviceId());
        return (Boolean)this.complete(this.clusterCommunicator.sendAndReceive((Object)pool, LabelResourceMessageSubjects.LABEL_POOL_CREATED, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), master));
    }

    private boolean internalCreate(LabelResourcePool pool) {
        Versioned poolOld = this.resourcePool.get((Object)pool.deviceId());
        if (poolOld == null) {
            this.resourcePool.put((Object)pool.deviceId(), (Object)pool);
            LabelResourceEvent event = new LabelResourceEvent(LabelResourceEvent.Type.POOL_CREATED, pool);
            this.notifyDelegate((Event)event);
            return true;
        }
        return false;
    }

    public boolean destroyDevicePool(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            return false;
        }
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.warn("Failed to destroyDevicePool. No master for {}", (Object)deviceId);
            return false;
        }
        if (master.equals((Object)this.clusterService.getLocalNode().id())) {
            return this.internalDestroy(deviceId);
        }
        this.log.trace("Forwarding request to {}, which is the primary (master) for device {}", (Object)master, (Object)deviceId);
        return (Boolean)this.complete(this.clusterCommunicator.sendAndReceive((Object)deviceId, LabelResourceMessageSubjects.LABEL_POOL_DESTROYED, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), master));
    }

    private boolean internalDestroy(DeviceId deviceId) {
        Versioned poolOld = this.resourcePool.get((Object)deviceId);
        if (poolOld != null) {
            this.resourcePool.remove((Object)deviceId);
            LabelResourceEvent event = new LabelResourceEvent(LabelResourceEvent.Type.POOL_DESTROYED, (LabelResourcePool)poolOld.value());
            this.notifyDelegate((Event)event);
        }
        this.log.info("success to destroy the label resource pool of device id {}", (Object)deviceId);
        return true;
    }

    public Collection<LabelResource> applyFromDevicePool(DeviceId deviceId, long applyNum) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            return Collections.emptyList();
        }
        LabelResourceRequest request = new LabelResourceRequest(deviceId, LabelResourceRequest.Type.APPLY, applyNum, null);
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.warn("Failed to applyFromDevicePool: No master for {}", (Object)deviceId);
            return Collections.emptyList();
        }
        if (master.equals((Object)this.clusterService.getLocalNode().id())) {
            return this.internalApply(request);
        }
        this.log.trace("Forwarding request to {}, which is the primary (master) for device {}", (Object)master, (Object)deviceId);
        return (Collection)this.complete(this.clusterCommunicator.sendAndReceive((Object)request, LabelResourceMessageSubjects.LABEL_POOL_APPLY, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), master));
    }

    private Collection<LabelResource> internalApply(LabelResourceRequest request) {
        DeviceId deviceId = request.deviceId();
        long applyNum = request.applyNum();
        Versioned poolOld = this.resourcePool.get((Object)deviceId);
        LabelResourcePool pool = (LabelResourcePool)poolOld.value();
        HashSet<LabelResource> result = new HashSet<LabelResource>();
        long freeNum = this.getFreeNumOfDevicePool(deviceId);
        if (applyNum > freeNum) {
            this.log.info("the free number of the label resource pool of deviceId {} is not enough.");
            return Collections.emptyList();
        }
        HashSet releaseLabels = new HashSet(pool.releaseLabelId());
        long tmp = (long)releaseLabels.size() > applyNum ? applyNum : (long)releaseLabels.size();
        LabelResource resource = null;
        int i = 0;
        while ((long)i < tmp) {
            Iterator it = releaseLabels.iterator();
            if (it.hasNext()) {
                resource = (LabelResource)it.next();
                releaseLabels.remove(resource);
            }
            result.add(resource);
            ++i;
        }
        for (long j = pool.currentUsedMaxLabelId().labelId(); j < pool.currentUsedMaxLabelId().labelId() + applyNum - tmp; ++j) {
            resource = new DefaultLabelResource(deviceId, LabelResourceId.labelResourceId((long)j));
            result.add(resource);
        }
        long beginLabel = pool.beginLabel().labelId();
        long endLabel = pool.endLabel().labelId();
        long totalNum = pool.totalNum();
        long current = pool.currentUsedMaxLabelId().labelId() + applyNum - tmp;
        long usedNum = pool.usedNum() + applyNum;
        ImmutableSet freeLabel = ImmutableSet.copyOf(releaseLabels);
        LabelResourcePool newPool = new LabelResourcePool(deviceId.toString(), beginLabel, endLabel, totalNum, usedNum, current, freeLabel);
        this.resourcePool.put((Object)deviceId, (Object)newPool);
        this.log.info("success to apply label resource");
        return result;
    }

    public boolean releaseToDevicePool(Multimap<DeviceId, LabelResource> release) {
        Map maps = release.asMap();
        Set deviceIdSet = maps.keySet();
        LabelResourceRequest request = null;
        for (DeviceId deviceId : deviceIdSet) {
            Device device = this.deviceService.getDevice(deviceId);
            if (device == null) continue;
            ImmutableSet collection = ImmutableSet.copyOf((Collection)((Collection)maps.get(deviceId)));
            request = new LabelResourceRequest(deviceId, LabelResourceRequest.Type.RELEASE, 0L, collection);
            NodeId master = this.mastershipService.getMasterFor(deviceId);
            if (master == null) {
                this.log.warn("Failed to releaseToDevicePool: No master for {}", (Object)deviceId);
                return false;
            }
            if (master.equals((Object)this.clusterService.getLocalNode().id())) {
                return this.internalRelease(request);
            }
            this.log.trace("Forwarding request to {}, which is the primary (master) for device {}", (Object)master, (Object)deviceId);
            return (Boolean)this.complete(this.clusterCommunicator.sendAndReceive((Object)request, LabelResourceMessageSubjects.LABEL_POOL_RELEASE, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), master));
        }
        return false;
    }

    private boolean internalRelease(LabelResourceRequest request) {
        DeviceId deviceId = request.deviceId();
        Collection release = request.releaseCollection();
        Versioned poolOld = this.resourcePool.get((Object)deviceId);
        LabelResourcePool pool = (LabelResourcePool)poolOld.value();
        if (pool == null) {
            this.log.info("the label resource pool of device id {} does not exist");
            return false;
        }
        HashSet<LabelResource> storeSet = new HashSet<LabelResource>(pool.releaseLabelId());
        LabelResource labelResource2 = null;
        long realReleasedNum = 0L;
        for (LabelResource labelResource2 : release) {
            if (labelResource2.labelResourceId().labelId() < pool.beginLabel().labelId() || labelResource2.labelResourceId().labelId() > pool.endLabel().labelId() || pool.currentUsedMaxLabelId().labelId() <= labelResource2.labelResourceId().labelId() && storeSet.contains(labelResource2)) continue;
            storeSet.add(labelResource2);
            ++realReleasedNum;
        }
        long beginNum = pool.beginLabel().labelId();
        long endNum = pool.endLabel().labelId();
        long totalNum = pool.totalNum();
        long usedNum = pool.usedNum() - realReleasedNum;
        long current = pool.currentUsedMaxLabelId().labelId();
        ImmutableSet s = ImmutableSet.copyOf(storeSet);
        LabelResourcePool newPool = new LabelResourcePool(deviceId.toString(), beginNum, endNum, totalNum, usedNum, current, s);
        this.resourcePool.put((Object)deviceId, (Object)newPool);
        this.log.info("success to release label resource");
        return true;
    }

    public boolean isDevicePoolFull(DeviceId deviceId) {
        Versioned pool = this.resourcePool.get((Object)deviceId);
        if (pool == null) {
            return true;
        }
        return ((LabelResourcePool)pool.value()).currentUsedMaxLabelId() == ((LabelResourcePool)pool.value()).endLabel() && ((LabelResourcePool)pool.value()).releaseLabelId().size() == 0;
    }

    public long getFreeNumOfDevicePool(DeviceId deviceId) {
        Versioned pool = this.resourcePool.get((Object)deviceId);
        if (pool == null) {
            return 0L;
        }
        return ((LabelResourcePool)pool.value()).endLabel().labelId() - ((LabelResourcePool)pool.value()).currentUsedMaxLabelId().labelId() + (long)((LabelResourcePool)pool.value()).releaseLabelId().size();
    }

    public LabelResourcePool getDeviceLabelResourcePool(DeviceId deviceId) {
        Versioned pool = this.resourcePool.get((Object)deviceId);
        return pool == null ? null : (LabelResourcePool)pool.value();
    }

    public boolean destroyGlobalPool() {
        return this.internalDestroy(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID));
    }

    public Collection<LabelResource> applyFromGlobalPool(long applyNum) {
        LabelResourceRequest request = new LabelResourceRequest(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID), LabelResourceRequest.Type.APPLY, applyNum, null);
        return this.internalApply(request);
    }

    public boolean releaseToGlobalPool(Set<LabelResourceId> release) {
        HashSet<DefaultLabelResource> set = new HashSet<DefaultLabelResource>();
        DefaultLabelResource resource = null;
        for (LabelResourceId labelResource : release) {
            resource = new DefaultLabelResource(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID), labelResource);
            set.add(resource);
        }
        LabelResourceRequest request = new LabelResourceRequest(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID), LabelResourceRequest.Type.APPLY, 0L, ImmutableSet.copyOf(set));
        return this.internalRelease(request);
    }

    public boolean isGlobalPoolFull() {
        return this.isDevicePoolFull(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID));
    }

    public long getFreeNumOfGlobalPool() {
        return this.getFreeNumOfDevicePool(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID));
    }

    public LabelResourcePool getGlobalLabelResourcePool() {
        return this.getDeviceLabelResourcePool(DeviceId.deviceId((String)GLOBAL_RESOURCE_POOL_DEVICE_ID));
    }

    private <T> T complete(Future<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Interrupted while waiting for operation to complete.", (Throwable)e);
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            this.log.error("Failed remote operation", (Throwable)e);
            return null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

