/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.tunnel.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelStore;
import org.onosproject.incubator.net.tunnel.TunnelStoreDelegate;
import org.onosproject.incubator.net.tunnel.TunnelSubscription;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.app.GossipApplicationStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedTunnelStore
extends AbstractStore<TunnelEvent, TunnelStoreDelegate>
implements TunnelStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String runnelOpTopoic = "tunnel-ops-ids";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private EventuallyConsistentMap<TunnelId, Tunnel> tunnelIdAsKeyStore;
    private EventuallyConsistentMap<TunnelName, Set<TunnelId>> tunnelNameAsKeyStore;
    private EventuallyConsistentMap<TunnelKey, Set<TunnelId>> srcAndDstKeyStore;
    private EventuallyConsistentMap<Tunnel.Type, Set<TunnelId>> typeKeyStore;
    private EventuallyConsistentMap<ApplicationId, Set<TunnelSubscription>> orderRelationship;
    private IdGenerator idGenerator;

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{GossipApplicationStore.InternalState.class});
        this.tunnelIdAsKeyStore = this.storageService.eventuallyConsistentMapBuilder().withName("all_tunnel").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.tunnelNameAsKeyStore = this.storageService.eventuallyConsistentMapBuilder().withName("tunnel_name_tunnel").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.srcAndDstKeyStore = this.storageService.eventuallyConsistentMapBuilder().withName("src_dst_tunnel").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.typeKeyStore = this.storageService.eventuallyConsistentMapBuilder().withName("type_tunnel").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.orderRelationship = this.storageService.eventuallyConsistentMapBuilder().withName("type_tunnel").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.idGenerator = this.coreService.getIdGenerator(this.runnelOpTopoic);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.orderRelationship.destroy();
        this.tunnelIdAsKeyStore.destroy();
        this.srcAndDstKeyStore.destroy();
        this.typeKeyStore.destroy();
        this.tunnelNameAsKeyStore.destroy();
        this.log.info("Stopped");
    }

    public TunnelId createOrUpdateTunnel(Tunnel tunnel) {
        if (tunnel.tunnelId() != null && !"".equals(tunnel.tunnelId().toString())) {
            Tunnel old = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnel.tunnelId());
            if (old == null) {
                this.log.info("This tunnel[" + tunnel.tunnelId() + "] is not available.");
                return tunnel.tunnelId();
            }
            DefaultAnnotations oldAnno = (DefaultAnnotations)old.annotations();
            SparseAnnotations newAnno = (SparseAnnotations)tunnel.annotations();
            DefaultTunnel newT = new DefaultTunnel(old.providerId(), old.src(), old.dst(), old.type(), old.state(), old.groupId(), old.tunnelId(), old.tunnelName(), old.path(), new Annotations[]{DefaultAnnotations.merge((DefaultAnnotations)oldAnno, (SparseAnnotations)newAnno)});
            this.tunnelIdAsKeyStore.put((Object)tunnel.tunnelId(), (Object)newT);
            TunnelEvent event = new TunnelEvent(TunnelEvent.Type.TUNNEL_UPDATED, tunnel);
            this.notifyDelegate((Event)event);
            return tunnel.tunnelId();
        }
        TunnelId tunnelId = TunnelId.valueOf((long)this.idGenerator.getNewId());
        DefaultTunnel newT = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.state(), tunnel.groupId(), tunnelId, tunnel.tunnelName(), tunnel.path(), new Annotations[]{tunnel.annotations()});
        TunnelKey key = TunnelKey.tunnelKey(tunnel.src(), tunnel.dst());
        this.tunnelIdAsKeyStore.put((Object)tunnelId, (Object)newT);
        HashSet<TunnelId> tunnelnameSet = (HashSet<TunnelId>)this.tunnelNameAsKeyStore.get((Object)tunnel.tunnelName());
        if (tunnelnameSet == null) {
            tunnelnameSet = new HashSet<TunnelId>();
        }
        tunnelnameSet.add(tunnelId);
        this.tunnelNameAsKeyStore.put((Object)tunnel.tunnelName(), tunnelnameSet);
        HashSet<TunnelId> srcAndDstKeySet = (HashSet<TunnelId>)this.srcAndDstKeyStore.get((Object)key);
        if (srcAndDstKeySet == null) {
            srcAndDstKeySet = new HashSet<TunnelId>();
        }
        srcAndDstKeySet.add(tunnelId);
        this.srcAndDstKeyStore.put((Object)key, srcAndDstKeySet);
        HashSet<TunnelId> typeKeySet = (HashSet<TunnelId>)this.typeKeyStore.get((Object)tunnel.type());
        if (typeKeySet == null) {
            typeKeySet = new HashSet<TunnelId>();
        }
        typeKeySet.add(tunnelId);
        this.typeKeyStore.put((Object)tunnel.type(), typeKeySet);
        TunnelEvent event = new TunnelEvent(TunnelEvent.Type.TUNNEL_ADDED, tunnel);
        this.notifyDelegate((Event)event);
        return tunnelId;
    }

    public void deleteTunnel(TunnelId tunnelId) {
        Tunnel deletedTunnel = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
        if (deletedTunnel == null) {
            return;
        }
        ((Set)this.tunnelNameAsKeyStore.get((Object)deletedTunnel.tunnelName())).remove(tunnelId);
        this.tunnelIdAsKeyStore.remove((Object)tunnelId);
        TunnelKey key = new TunnelKey(deletedTunnel.src(), deletedTunnel.dst());
        ((Set)this.srcAndDstKeyStore.get((Object)key)).remove(tunnelId);
        ((Set)this.typeKeyStore.get((Object)deletedTunnel.type())).remove(tunnelId);
        TunnelEvent event = new TunnelEvent(TunnelEvent.Type.TUNNEL_REMOVED, deletedTunnel);
        this.notifyDelegate((Event)event);
    }

    public void deleteTunnel(TunnelEndPoint src, TunnelEndPoint dst, ProviderId producerName) {
        TunnelKey key = TunnelKey.tunnelKey(src, dst);
        Set idSet = (Set)this.srcAndDstKeyStore.get((Object)key);
        if (idSet == null) {
            return;
        }
        Tunnel deletedTunnel = null;
        TunnelEvent event = null;
        ArrayList<TunnelEvent> ls = new ArrayList<TunnelEvent>();
        for (TunnelId id : idSet) {
            deletedTunnel = (Tunnel)this.tunnelIdAsKeyStore.get((Object)id);
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_REMOVED, deletedTunnel);
            ls.add(event);
            if (!producerName.equals((Object)deletedTunnel.providerId())) continue;
            this.tunnelIdAsKeyStore.remove((Object)deletedTunnel.tunnelId());
            ((Set)this.tunnelNameAsKeyStore.get((Object)deletedTunnel.tunnelName())).remove(deletedTunnel.tunnelId());
            ((Set)this.srcAndDstKeyStore.get((Object)key)).remove(deletedTunnel.tunnelId());
            ((Set)this.typeKeyStore.get((Object)deletedTunnel.type())).remove(deletedTunnel.tunnelId());
        }
        this.notifyDelegate(ls);
    }

    public void deleteTunnel(TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, ProviderId producerName) {
        TunnelKey key = TunnelKey.tunnelKey(src, dst);
        Set idSet = (Set)this.srcAndDstKeyStore.get((Object)key);
        if (idSet == null) {
            return;
        }
        Tunnel deletedTunnel = null;
        TunnelEvent event = null;
        ArrayList<TunnelEvent> ls = new ArrayList<TunnelEvent>();
        for (TunnelId id : idSet) {
            deletedTunnel = (Tunnel)this.tunnelIdAsKeyStore.get((Object)id);
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_REMOVED, deletedTunnel);
            ls.add(event);
            if (!producerName.equals((Object)deletedTunnel.providerId()) || !type.equals((Object)deletedTunnel.type())) continue;
            this.tunnelIdAsKeyStore.remove((Object)deletedTunnel.tunnelId());
            ((Set)this.tunnelNameAsKeyStore.get((Object)deletedTunnel.tunnelName())).remove(deletedTunnel.tunnelId());
            ((Set)this.srcAndDstKeyStore.get((Object)key)).remove(deletedTunnel.tunnelId());
            ((Set)this.typeKeyStore.get((Object)deletedTunnel.type())).remove(deletedTunnel.tunnelId());
        }
        this.notifyDelegate(ls);
    }

    public Tunnel borrowTunnel(ApplicationId appId, TunnelId tunnelId, Annotations ... annotations) {
        HashSet<TunnelSubscription> orderSet = (HashSet<TunnelSubscription>)this.orderRelationship.get((Object)appId);
        if (orderSet == null) {
            orderSet = new HashSet<TunnelSubscription>();
        }
        TunnelSubscription order = new TunnelSubscription(appId, null, null, tunnelId, null, null, annotations);
        Tunnel result = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
        if (result == null || Tunnel.State.INACTIVE.equals((Object)result.state())) {
            return null;
        }
        orderSet.add(order);
        this.orderRelationship.put((Object)appId, orderSet);
        return result;
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId appId, TunnelEndPoint src, TunnelEndPoint dst, Annotations ... annotations) {
        TunnelSubscription order;
        boolean isExist;
        HashSet<TunnelSubscription> orderSet = (HashSet<TunnelSubscription>)this.orderRelationship.get((Object)appId);
        if (orderSet == null) {
            orderSet = new HashSet<TunnelSubscription>();
        }
        if (!(isExist = orderSet.contains(order = new TunnelSubscription(appId, src, dst, null, null, null, annotations)))) {
            orderSet.add(order);
        }
        this.orderRelationship.put((Object)appId, orderSet);
        TunnelKey key = TunnelKey.tunnelKey(src, dst);
        Set idSet = (Set)this.srcAndDstKeyStore.get((Object)key);
        if (idSet == null || idSet.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Tunnel> tunnelSet = new HashSet<Tunnel>();
        for (TunnelId tunnelId : idSet) {
            Tunnel result = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
            if (!Tunnel.State.ACTIVE.equals((Object)result.state())) continue;
            tunnelSet.add(result);
        }
        return tunnelSet;
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId appId, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Annotations ... annotations) {
        TunnelSubscription order;
        boolean isExist;
        HashSet<TunnelSubscription> orderSet = (HashSet<TunnelSubscription>)this.orderRelationship.get((Object)appId);
        if (orderSet == null) {
            orderSet = new HashSet<TunnelSubscription>();
        }
        if (!(isExist = orderSet.contains(order = new TunnelSubscription(appId, src, dst, null, type, null, annotations)))) {
            orderSet.add(order);
        }
        this.orderRelationship.put((Object)appId, orderSet);
        TunnelKey key = TunnelKey.tunnelKey(src, dst);
        Set idSet = (Set)this.srcAndDstKeyStore.get((Object)key);
        if (idSet == null || idSet.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Tunnel> tunnelSet = new HashSet<Tunnel>();
        for (TunnelId tunnelId : idSet) {
            Tunnel result = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
            if (!type.equals((Object)result.type()) || !Tunnel.State.ACTIVE.equals((Object)result.state())) continue;
            tunnelSet.add(result);
        }
        return tunnelSet;
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId appId, TunnelName tunnelName, Annotations ... annotations) {
        TunnelSubscription order;
        boolean isExist;
        HashSet<TunnelSubscription> orderSet = (HashSet<TunnelSubscription>)this.orderRelationship.get((Object)appId);
        if (orderSet == null) {
            orderSet = new HashSet<TunnelSubscription>();
        }
        if (!(isExist = orderSet.contains(order = new TunnelSubscription(appId, null, null, null, null, tunnelName, annotations)))) {
            orderSet.add(order);
        }
        this.orderRelationship.put((Object)appId, orderSet);
        Set idSet = (Set)this.tunnelNameAsKeyStore.get((Object)tunnelName);
        if (idSet == null || idSet.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Tunnel> tunnelSet = new HashSet<Tunnel>();
        for (TunnelId tunnelId : idSet) {
            Tunnel result = (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
            if (!Tunnel.State.ACTIVE.equals((Object)result.state())) continue;
            tunnelSet.add(result);
        }
        return tunnelSet;
    }

    public boolean returnTunnel(ApplicationId appId, TunnelName tunnelName, Annotations ... annotations) {
        TunnelSubscription order = new TunnelSubscription(appId, null, null, null, null, tunnelName, annotations);
        return this.deleteOrder(order);
    }

    public boolean returnTunnel(ApplicationId appId, TunnelId tunnelId, Annotations ... annotations) {
        TunnelSubscription order = new TunnelSubscription(appId, null, null, tunnelId, null, null, annotations);
        return this.deleteOrder(order);
    }

    public boolean returnTunnel(ApplicationId appId, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Annotations ... annotations) {
        TunnelSubscription order = new TunnelSubscription(appId, src, dst, null, type, null, annotations);
        return this.deleteOrder(order);
    }

    public boolean returnTunnel(ApplicationId appId, TunnelEndPoint src, TunnelEndPoint dst, Annotations ... annotations) {
        TunnelSubscription order = new TunnelSubscription(appId, src, dst, null, null, null, annotations);
        return this.deleteOrder(order);
    }

    private boolean deleteOrder(TunnelSubscription order) {
        Set orderSet = (Set)this.orderRelationship.get((Object)order.consumerId());
        if (orderSet == null) {
            return true;
        }
        if (orderSet.contains(order)) {
            orderSet.remove(order);
            return true;
        }
        return false;
    }

    public Tunnel queryTunnel(TunnelId tunnelId) {
        return (Tunnel)this.tunnelIdAsKeyStore.get((Object)tunnelId);
    }

    public Collection<TunnelSubscription> queryTunnelSubscription(ApplicationId appId) {
        return this.orderRelationship.get((Object)appId) != null ? ImmutableSet.copyOf((Collection)((Collection)this.orderRelationship.get((Object)appId))) : Collections.emptySet();
    }

    public Collection<Tunnel> queryTunnel(Tunnel.Type type) {
        HashSet<Object> result = new HashSet<Object>();
        Set tunnelIds = (Set)this.typeKeyStore.get((Object)type);
        if (tunnelIds == null) {
            return Collections.emptySet();
        }
        for (TunnelId id : tunnelIds) {
            result.add(this.tunnelIdAsKeyStore.get((Object)id));
        }
        return result.size() == 0 ? Collections.emptySet() : ImmutableSet.copyOf(result);
    }

    public Collection<Tunnel> queryTunnel(TunnelEndPoint src, TunnelEndPoint dst) {
        HashSet<Object> result = new HashSet<Object>();
        TunnelKey key = TunnelKey.tunnelKey(src, dst);
        Set tunnelIds = (Set)this.srcAndDstKeyStore.get((Object)key);
        if (tunnelIds == null) {
            return Collections.emptySet();
        }
        for (TunnelId id : tunnelIds) {
            result.add(this.tunnelIdAsKeyStore.get((Object)id));
        }
        return result.size() == 0 ? Collections.emptySet() : ImmutableSet.copyOf(result);
    }

    public Collection<Tunnel> queryAllTunnels() {
        return this.tunnelIdAsKeyStore.values();
    }

    public int tunnelCount() {
        return this.tunnelIdAsKeyStore.size();
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private static final class TunnelKey {
        private final TunnelEndPoint src;
        private final TunnelEndPoint dst;

        private TunnelKey(TunnelEndPoint src, TunnelEndPoint dst) {
            this.src = src;
            this.dst = dst;
        }

        static TunnelKey tunnelKey(TunnelEndPoint src, TunnelEndPoint dst) {
            return new TunnelKey(src, dst);
        }

        public int hashCode() {
            return Objects.hash(this.src, this.dst);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TunnelKey) {
                TunnelKey other = (TunnelKey)obj;
                return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("src", (Object)this.src).add("dst", (Object)this.dst).toString();
        }
    }
}

