/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.DefaultVirtualDevice;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.DefaultVirtualNetwork;
import org.onosproject.incubator.net.virtual.DefaultVirtualPort;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkStoreDelegate;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedVirtualNetworkStore
extends AbstractStore<VirtualNetworkEvent, VirtualNetworkStoreDelegate>
implements VirtualNetworkStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private IdGenerator idGenerator;
    private DistributedSet<TenantId> tenantIdSet;
    private final SetEventListener<TenantId> setListener = new InternalSetListener();
    private ConsistentMap<NetworkId, VirtualNetwork> networkIdVirtualNetworkConsistentMap;
    private Map<NetworkId, VirtualNetwork> networkIdVirtualNetworkMap;
    private final MapEventListener<NetworkId, VirtualNetwork> virtualMapListener = new InternalMapListener();
    private ConsistentMap<TenantId, Set<NetworkId>> tenantIdNetworkIdSetConsistentMap;
    private Map<TenantId, Set<NetworkId>> tenantIdNetworkIdSetMap;
    private ConsistentMap<DeviceId, VirtualDevice> deviceIdVirtualDeviceConsistentMap;
    private Map<DeviceId, VirtualDevice> deviceIdVirtualDeviceMap;
    private ConsistentMap<NetworkId, Set<DeviceId>> networkIdDeviceIdSetConsistentMap;
    private Map<NetworkId, Set<DeviceId>> networkIdDeviceIdSetMap;
    private ConsistentMap<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetConsistentMap;
    private Map<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetMap;
    private ConsistentMap<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetConsistentMap;
    private Map<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetMap;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TenantId.class}).register(new Class[]{NetworkId.class}).register(new Class[]{DeviceId.class}).register(new Class[]{VirtualNetwork.class}).register(new Class[]{VirtualDevice.class}).register(new Class[]{VirtualLink.class}).register(new Class[]{VirtualPort.class}).register(new Class[]{DeviceId.class}).register(new Class[]{Device.class}).nextId(300).build());

    @Activate
    public void activate() {
        this.idGenerator = this.coreService.getIdGenerator("virtual-network-ids");
        this.tenantIdSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId")).withRelaxedReadConsistency()).build()).asDistributedSet();
        this.tenantIdSet.addListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualnetwork")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualNetworkConsistentMap.addListener(this.virtualMapListener);
        this.networkIdVirtualNetworkMap = this.networkIdVirtualNetworkConsistentMap.asJavaMap();
        this.tenantIdNetworkIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId-networkIds")).withRelaxedReadConsistency()).build();
        this.tenantIdNetworkIdSetMap = this.tenantIdNetworkIdSetConsistentMap.asJavaMap();
        this.deviceIdVirtualDeviceConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-deviceId-virtualdevice")).withRelaxedReadConsistency()).build();
        this.deviceIdVirtualDeviceMap = this.deviceIdVirtualDeviceConsistentMap.asJavaMap();
        this.networkIdDeviceIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-deviceIds")).withRelaxedReadConsistency()).build();
        this.networkIdDeviceIdSetMap = this.networkIdDeviceIdSetConsistentMap.asJavaMap();
        this.networkIdVirtualLinkSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtuallinks")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualLinkSetMap = this.networkIdVirtualLinkSetConsistentMap.asJavaMap();
        this.networkIdVirtualPortSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualportss")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualPortSetMap = this.networkIdVirtualPortSetConsistentMap.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tenantIdSet.removeListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap.removeListener(this.virtualMapListener);
        this.log.info("Stopped");
    }

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    public void addTenantId(TenantId tenantId) {
        this.tenantIdSet.add((Object)tenantId);
    }

    public void removeTenantId(TenantId tenantId) {
        this.tenantIdSet.remove((Object)tenantId);
    }

    public Set<TenantId> getTenantIds() {
        return ImmutableSet.copyOf(this.tenantIdSet);
    }

    public VirtualNetwork addNetwork(TenantId tenantId) {
        Preconditions.checkState((boolean)this.tenantIdSet.contains((Object)tenantId), (Object)("The tenant has not been registered. " + (String)tenantId.id()));
        DefaultVirtualNetwork virtualNetwork = new DefaultVirtualNetwork(this.genNetworkId(), tenantId);
        this.networkIdVirtualNetworkMap.put(virtualNetwork.id(), (VirtualNetwork)virtualNetwork);
        Set<NetworkId> virtualNetworkSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        if (virtualNetworkSet == null) {
            virtualNetworkSet = new HashSet<NetworkId>();
        }
        virtualNetworkSet.add(virtualNetwork.id());
        this.tenantIdNetworkIdSetMap.put(tenantId, virtualNetworkSet);
        return virtualNetwork;
    }

    private NetworkId genNetworkId() {
        return NetworkId.networkId((long)this.idGenerator.getNewId());
    }

    public void removeNetwork(NetworkId networkId) {
        if (this.networkExists(networkId)) {
            VirtualNetwork virtualNetwork = this.networkIdVirtualNetworkMap.get(networkId);
            if (virtualNetwork == null) {
                return;
            }
            TenantId tenantId = virtualNetwork.tenantId();
            this.networkIdVirtualNetworkMap.compute(networkId, (id, existingVirtualNetwork) -> null);
            Set<NetworkId> virtualNetworkSet = this.tenantIdNetworkIdSetMap.get(tenantId);
            this.tenantIdNetworkIdSetMap.compute(virtualNetwork.tenantId(), (id, existingNetworkIds) -> {
                if (existingNetworkIds == null || existingNetworkIds.isEmpty()) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.builder().addAll((Iterable)Sets.difference((Set)existingNetworkIds, (Set)ImmutableSet.copyOf((Collection)virtualNetworkSet))).build();
            });
        }
    }

    private boolean networkExists(NetworkId networkId) {
        return this.networkIdVirtualNetworkMap.containsKey(networkId);
    }

    public VirtualDevice addDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        if (deviceIdSet == null) {
            deviceIdSet = new HashSet<DeviceId>();
        }
        DefaultVirtualDevice virtualDevice = new DefaultVirtualDevice(networkId, deviceId);
        this.deviceIdVirtualDeviceMap.put(deviceId, (VirtualDevice)virtualDevice);
        deviceIdSet.add(deviceId);
        this.networkIdDeviceIdSetMap.put(networkId, deviceIdSet);
        return virtualDevice;
    }

    public void removeDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        if (deviceIdSet != null) {
            this.networkIdDeviceIdSetMap.compute(networkId, (id, existingDeviceIds) -> {
                if (existingDeviceIds == null || existingDeviceIds.isEmpty()) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.builder().addAll((Iterable)Sets.difference((Set)existingDeviceIds, (Set)ImmutableSet.copyOf((Collection)deviceIdSet))).build();
            });
            this.deviceIdVirtualDeviceMap.compute(deviceId, (id, existingVirtualDevice) -> null);
            this.log.info("The deviceIdVirtualDeviceMap size is: " + this.getDevices(networkId));
        }
    }

    public VirtualLink addLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst, TunnelId realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        DefaultVirtualLink virtualLink = new DefaultVirtualLink(networkId, src, dst, realizedBy);
        virtualLinkSet.add((VirtualLink)virtualLink);
        this.networkIdVirtualLinkSetMap.put(networkId, virtualLinkSet);
        return virtualLink;
    }

    public void removeLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet != null) {
            this.networkIdVirtualLinkSetMap.compute(networkId, (id, existingVirtualLinks) -> {
                if (existingVirtualLinks == null || existingVirtualLinks.isEmpty()) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.builder().addAll((Iterable)Sets.difference((Set)existingVirtualLinks, (Set)ImmutableSet.copyOf((Collection)virtualLinkSet))).build();
            });
        }
    }

    public VirtualPort addPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, Port realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet == null) {
            virtualPortSet = new HashSet<VirtualPort>();
        }
        Device device = (Device)this.deviceIdVirtualDeviceMap.get(deviceId);
        Preconditions.checkNotNull((Object)device, (Object)("The device has not been created for deviceId: " + deviceId));
        DefaultVirtualPort virtualPort = new DefaultVirtualPort(networkId, device, portNumber, realizedBy);
        virtualPortSet.add((VirtualPort)virtualPort);
        this.networkIdVirtualPortSetMap.put(networkId, virtualPortSet);
        return virtualPort;
    }

    public void removePort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet != null) {
            this.networkIdVirtualPortSetMap.compute(networkId, (id, existingVirtualPorts) -> {
                if (existingVirtualPorts == null || existingVirtualPorts.isEmpty()) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.builder().addAll((Iterable)Sets.difference((Set)existingVirtualPorts, (Set)ImmutableSet.copyOf((Collection)virtualPortSet))).build();
            });
        }
    }

    public Set<VirtualNetwork> getNetworks(TenantId tenantId) {
        Set<NetworkId> networkIdSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        HashSet virtualNetworkSet = new HashSet();
        if (networkIdSet != null) {
            networkIdSet.forEach(networkId -> virtualNetworkSet.add(this.networkIdVirtualNetworkMap.get(networkId)));
        }
        return ImmutableSet.copyOf(virtualNetworkSet);
    }

    public Set<VirtualDevice> getDevices(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        HashSet virtualDeviceSet = new HashSet();
        if (deviceIdSet != null) {
            deviceIdSet.forEach(deviceId -> virtualDeviceSet.add(this.deviceIdVirtualDeviceMap.get(deviceId)));
        }
        return ImmutableSet.copyOf(virtualDeviceSet);
    }

    public Set<VirtualLink> getLinks(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet virtualLinkSet = new HashSet();
        virtualLinkSet.addAll(this.networkIdVirtualLinkSetMap.get(networkId));
        return ImmutableSet.copyOf(virtualLinkSet);
    }

    public Set<VirtualPort> getPorts(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet virtualPortSet = new HashSet();
        virtualPortSet.addAll(this.networkIdVirtualPortSetMap.get(networkId));
        return ImmutableSet.copyOf(virtualPortSet);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<NetworkId, VirtualNetwork> {
        private InternalMapListener() {
        }

        public void event(MapEvent<NetworkId, VirtualNetwork> event) {
            NetworkId networkId = (NetworkId)Preconditions.checkNotNull((Object)event.key());
            VirtualNetworkEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = VirtualNetworkEvent.Type.NETWORK_ADDED;
                    break;
                }
                case UPDATE: {
                    if (event.oldValue().value() != null && event.newValue().value() == null) {
                        type = VirtualNetworkEvent.Type.NETWORK_REMOVED;
                        break;
                    }
                    type = VirtualNetworkEvent.Type.NETWORK_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = VirtualNetworkEvent.Type.NETWORK_REMOVED;
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedVirtualNetworkStore.this.notifyDelegate((Event)new VirtualNetworkEvent(type, networkId));
        }
    }

    private class InternalSetListener
    implements SetEventListener<TenantId> {
        private InternalSetListener() {
        }

        public void event(SetEvent<TenantId> event) {
            VirtualNetworkEvent.Type type = null;
            switch (event.type()) {
                case ADD: {
                    type = VirtualNetworkEvent.Type.TENANT_REGISTERED;
                    break;
                }
                case REMOVE: {
                    type = VirtualNetworkEvent.Type.TENANT_UNREGISTERED;
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedVirtualNetworkStore.this.notifyDelegate((Event)new VirtualNetworkEvent(type, null));
        }
    }
}

