/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.mcast.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.incubator.store.mcast.impl.MulticastData;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.mcast.McastStore;
import org.onosproject.net.mcast.McastStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedMcastStore
extends AbstractStore<McastEvent, McastStoreDelegate>
implements McastStore {
    private static final String MCASTRIB = "mcast-rib-table";
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected ConsistentMap<McastRoute, MulticastData> mcastRib;
    protected Map<McastRoute, MulticastData> mcastRoutes;
    private final MapEventListener<McastRoute, MulticastData> mcastMapListener = new McastMapListener();
    private Map<McastRoute, Set<ConnectPoint>> localSink = new ConcurrentHashMap<McastRoute, Set<ConnectPoint>>();

    @Activate
    public void activate() {
        this.mcastRib = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(MCASTRIB)).withSerializer(Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{AtomicReference.class, MulticastData.class, McastRoute.class, McastRoute.Type.class}).build()))).build();
        this.mcastRib.addListener(this.mcastMapListener);
        this.mcastRoutes = this.mcastRib.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void storeRoute(McastRoute route, McastStore.Type operation) {
        switch (operation) {
            case ADD: {
                this.mcastRoutes.putIfAbsent(route, MulticastData.empty());
                break;
            }
            case REMOVE: {
                this.mcastRoutes.remove(route);
                break;
            }
            default: {
                this.log.warn("Unknown mcast operation type: {}", (Object)operation);
            }
        }
    }

    public void storeSource(McastRoute route, ConnectPoint source) {
        MulticastData data = this.mcastRoutes.compute(route, (k, v) -> {
            if (v == null) {
                return new MulticastData(source);
            }
            v.setSource(source);
            return v;
        });
    }

    public void storeSink(McastRoute route, ConnectPoint sink, McastStore.Type operation) {
        MulticastData data = this.mcastRoutes.compute(route, (k, v) -> {
            switch (operation) {
                case ADD: {
                    if (v == null) {
                        v = MulticastData.empty();
                    }
                    v.appendSink(sink);
                    break;
                }
                case REMOVE: {
                    if (v == null) break;
                    v.removeSink(sink);
                    break;
                }
                default: {
                    this.log.warn("Unknown mcast operation type: {}", (Object)operation);
                }
            }
            return v;
        });
    }

    public ConnectPoint sourceFor(McastRoute route) {
        return this.mcastRoutes.getOrDefault(route, MulticastData.empty()).source();
    }

    public Set<ConnectPoint> sinksFor(McastRoute route) {
        return this.mcastRoutes.getOrDefault(route, MulticastData.empty()).sinks();
    }

    public Set<McastRoute> getRoutes() {
        return this.mcastRoutes.keySet();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class McastMapListener
    implements MapEventListener<McastRoute, MulticastData> {
        private McastMapListener() {
        }

        public void event(MapEvent<McastRoute, MulticastData> event) {
            McastRoute route = (McastRoute)event.key();
            switch (event.type()) {
                case INSERT: {
                    Preconditions.checkState((event.newValue() != null ? 1 : 0) != 0, (Object)"Map insert event should have newValue");
                    MulticastData newValue = (MulticastData)event.newValue().value();
                    if (newValue.source() != null) {
                        DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SOURCE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, newValue.sinks(), (ConnectPoint)newValue.source())));
                    }
                    if (!newValue.sinks().isEmpty()) {
                        newValue.sinks().forEach(sink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)sink, (ConnectPoint)newValue.source()))));
                    }
                    if (newValue.source() == null && newValue.sinks().isEmpty()) {
                        DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.ROUTE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route)));
                    }
                    DistributedMcastStore.this.localSink.put(route, newValue.sinks());
                    break;
                }
                case REMOVE: {
                    Preconditions.checkState((event.oldValue() != null ? 1 : 0) != 0, (Object)"Map remove event should have oldValue");
                    MulticastData oldValue = (MulticastData)event.oldValue().value();
                    DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.ROUTE_REMOVED, McastRouteInfo.mcastRouteInfo((McastRoute)route)));
                    oldValue.sinks().forEach(sink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_REMOVED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)sink, (ConnectPoint)oldValue.source()))));
                    DistributedMcastStore.this.localSink.remove(route);
                    break;
                }
                case UPDATE: {
                    Preconditions.checkState((event.newValue() != null ? 1 : 0) != 0, (Object)"Map update event should have newValue");
                    Preconditions.checkState((event.oldValue() != null ? 1 : 0) != 0, (Object)"Map update event should have oldValue");
                    MulticastData newValue = (MulticastData)event.newValue().value();
                    MulticastData oldValue = (MulticastData)event.oldValue().value();
                    if (newValue.source() != null && oldValue.source() == null) {
                        DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SOURCE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, newValue.sinks(), (ConnectPoint)newValue.source())));
                    }
                    newValue.sinks().stream().filter(sink -> !((Set)DistributedMcastStore.this.localSink.get(route)).contains(sink)).forEach(addedSink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)addedSink, (ConnectPoint)newValue.source()))));
                    ((Set)DistributedMcastStore.this.localSink.get(route)).stream().filter(sink -> !newValue.sinks().contains(sink)).forEach(removedSink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_REMOVED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)removedSink, (ConnectPoint)newValue.source()))));
                    DistributedMcastStore.this.localSink.put(route, newValue.sinks());
                    break;
                }
            }
        }
    }
}

