/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class LocalRouteStore
extends AbstractStore<RouteEvent, RouteStoreDelegate>
implements RouteStore {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<RouteTableId, RouteTable> routeTables;
    private static final RouteTableId IPV4 = new RouteTableId("ipv4");
    private static final RouteTableId IPV6 = new RouteTableId("ipv6");
    private Map<IpAddress, MacAddress> nextHops = new ConcurrentHashMap<IpAddress, MacAddress>();

    @Activate
    public void activate() {
        this.routeTables = new ConcurrentHashMap<RouteTableId, RouteTable>();
        this.routeTables.put(IPV4, new RouteTable());
        this.routeTables.put(IPV6, new RouteTable());
    }

    public void updateRoute(Route route) {
        this.getDefaultRouteTable(route).update(route);
    }

    public void removeRoute(Route route) {
        RouteTable table = this.getDefaultRouteTable(route);
        table.remove(route);
        Collection<Route> routes = table.getRoutesForNextHop(route.nextHop());
        if (routes.isEmpty()) {
            this.nextHops.remove(route.nextHop());
        }
    }

    public Set<RouteTableId> getRouteTables() {
        return this.routeTables.keySet();
    }

    public Collection<Route> getRoutes(RouteTableId table) {
        RouteTable routeTable = this.routeTables.get(table);
        if (routeTable == null) {
            return Collections.emptySet();
        }
        return routeTable.getRoutes();
    }

    public Route longestPrefixMatch(IpAddress ip) {
        return this.getDefaultRouteTable(ip).longestPrefixMatch(ip);
    }

    public Collection<Route> getRoutesForNextHop(IpAddress ip) {
        return this.getDefaultRouteTable(ip).getRoutesForNextHop(ip);
    }

    public void updateNextHop(IpAddress ip, MacAddress mac) {
        Collection<Route> routes = this.getDefaultRouteTable(ip).getRoutesForNextHop(ip);
        if (!routes.isEmpty() && !mac.equals((Object)this.nextHops.get(ip))) {
            MacAddress oldMac = this.nextHops.put(ip, mac);
            for (Route route : routes) {
                if (oldMac == null) {
                    this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, new ResolvedRoute(route, mac)));
                    continue;
                }
                this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, new ResolvedRoute(route, mac)));
            }
        }
    }

    public void removeNextHop(IpAddress ip, MacAddress mac) {
        if (this.nextHops.remove(ip, mac)) {
            Collection<Route> routes = this.getDefaultRouteTable(ip).getRoutesForNextHop(ip);
            for (Route route : routes) {
                this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(route, null)));
            }
        }
    }

    public MacAddress getNextHop(IpAddress ip) {
        return this.nextHops.get(ip);
    }

    public Map<IpAddress, MacAddress> getNextHops() {
        return ImmutableMap.copyOf(this.nextHops);
    }

    private RouteTable getDefaultRouteTable(Route route) {
        return this.getDefaultRouteTable(route.prefix().address());
    }

    private RouteTable getDefaultRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.routeTables.get(routeTableId);
    }

    private static String createBinaryString(IpPrefix ipPrefix) {
        byte[] octets = ipPrefix.address().toOctets();
        StringBuilder result = new StringBuilder(ipPrefix.prefixLength());
        result.append("0");
        for (int i = 0; i < ipPrefix.prefixLength(); ++i) {
            int byteOffset = i / 8;
            byte value = octets[byteOffset];
            int bitOffset = i % 8;
            int mask = 1 << 7 - bitOffset;
            boolean isSet = (value & mask) != 0;
            result.append(isSet ? "1" : "0");
        }
        return result.toString();
    }

    private class RouteTable {
        private final InvertedRadixTree<Route> routeTable;
        private final Map<IpPrefix, Route> routes = new ConcurrentHashMap<IpPrefix, Route>();
        private final Multimap<IpAddress, Route> reverseIndex = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

        public RouteTable() {
            this.routeTable = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Route route) {
            RouteTable routeTable = this;
            synchronized (routeTable) {
                Route oldRoute = this.routes.put(route.prefix(), route);
                this.routeTable.put((CharSequence)LocalRouteStore.createBinaryString(route.prefix()), (Object)route);
                this.reverseIndex.put((Object)route.nextHop(), (Object)route);
                if (oldRoute != null) {
                    this.reverseIndex.remove((Object)oldRoute.nextHop(), (Object)oldRoute);
                    if (this.reverseIndex.get((Object)oldRoute.nextHop()).isEmpty()) {
                        LocalRouteStore.this.nextHops.remove(oldRoute.nextHop());
                    }
                }
                if (route.equals((Object)oldRoute)) {
                    return;
                }
                MacAddress nextHopMac = (MacAddress)LocalRouteStore.this.nextHops.get(route.nextHop());
                if (oldRoute != null && !oldRoute.nextHop().equals((Object)route.nextHop())) {
                    if (nextHopMac == null) {
                        LocalRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(oldRoute, null)));
                    } else {
                        LocalRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, new ResolvedRoute(route, nextHopMac)));
                    }
                    return;
                }
                if (nextHopMac != null) {
                    LocalRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, new ResolvedRoute(route, nextHopMac)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Route route) {
            RouteTable routeTable = this;
            synchronized (routeTable) {
                Route removed = this.routes.remove(route.prefix());
                this.routeTable.remove((CharSequence)LocalRouteStore.createBinaryString(route.prefix()));
                if (removed != null) {
                    this.reverseIndex.remove((Object)removed.nextHop(), (Object)removed);
                    LocalRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(route, null)));
                }
            }
        }

        public Collection<Route> getRoutesForNextHop(IpAddress ip) {
            return this.reverseIndex.get((Object)ip);
        }

        public Collection<Route> getRoutes() {
            Iterator it = this.routeTable.getKeyValuePairsForKeysStartingWith((CharSequence)"").iterator();
            LinkedList<Route> routes = new LinkedList<Route>();
            while (it.hasNext()) {
                KeyValuePair entry = (KeyValuePair)it.next();
                routes.add((Route)entry.getValue());
            }
            return routes;
        }

        public Route longestPrefixMatch(IpAddress ip) {
            Iterable prefixes = this.routeTable.getValuesForKeysPrefixing((CharSequence)LocalRouteStore.createBinaryString(ip.toIpPrefix()));
            Iterator it = prefixes.iterator();
            Route route = null;
            while (it.hasNext()) {
                route = (Route)it.next();
            }
            return route;
        }
    }
}

