/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.DefaultVirtualDevice;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.DefaultVirtualNetwork;
import org.onosproject.incubator.net.virtual.DefaultVirtualPort;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkStoreDelegate;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedVirtualNetworkStore
extends AbstractStore<VirtualNetworkEvent, VirtualNetworkStoreDelegate>
implements VirtualNetworkStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private IdGenerator idGenerator;
    private DistributedSet<TenantId> tenantIdSet;
    private final SetEventListener<TenantId> setListener = new InternalSetListener();
    private ConsistentMap<NetworkId, VirtualNetwork> networkIdVirtualNetworkConsistentMap;
    private Map<NetworkId, VirtualNetwork> networkIdVirtualNetworkMap;
    private final MapEventListener<NetworkId, VirtualNetwork> virtualMapListener = new InternalMapListener();
    private ConsistentMap<TenantId, Set<NetworkId>> tenantIdNetworkIdSetConsistentMap;
    private Map<TenantId, Set<NetworkId>> tenantIdNetworkIdSetMap;
    private ConsistentMap<DeviceId, VirtualDevice> deviceIdVirtualDeviceConsistentMap;
    private Map<DeviceId, VirtualDevice> deviceIdVirtualDeviceMap;
    private ConsistentMap<NetworkId, Set<DeviceId>> networkIdDeviceIdSetConsistentMap;
    private Map<NetworkId, Set<DeviceId>> networkIdDeviceIdSetMap;
    private ConsistentMap<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetConsistentMap;
    private Map<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetMap;
    private ConsistentMap<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetConsistentMap;
    private Map<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetMap;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TenantId.class}).register(new Class[]{NetworkId.class}).register(new Class[]{VirtualNetwork.class}).register(new Class[]{DefaultVirtualNetwork.class}).register(new Class[]{VirtualDevice.class}).register(new Class[]{DefaultVirtualDevice.class}).register(new Class[]{VirtualLink.class}).register(new Class[]{DefaultVirtualLink.class}).register(new Class[]{VirtualPort.class}).register(new Class[]{DefaultVirtualPort.class}).register(new Class[]{Device.class}).register(new Class[]{TunnelId.class}).nextId(500).build("VirtualNetworkStore"));

    @Activate
    public void activate() {
        this.idGenerator = this.coreService.getIdGenerator("virtual-network-ids");
        this.tenantIdSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId")).withRelaxedReadConsistency()).build()).asDistributedSet();
        this.tenantIdSet.addListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualnetwork")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualNetworkConsistentMap.addListener(this.virtualMapListener);
        this.networkIdVirtualNetworkMap = this.networkIdVirtualNetworkConsistentMap.asJavaMap();
        this.tenantIdNetworkIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId-networkIds")).withRelaxedReadConsistency()).build();
        this.tenantIdNetworkIdSetMap = this.tenantIdNetworkIdSetConsistentMap.asJavaMap();
        this.deviceIdVirtualDeviceConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-deviceId-virtualdevice")).withRelaxedReadConsistency()).build();
        this.deviceIdVirtualDeviceMap = this.deviceIdVirtualDeviceConsistentMap.asJavaMap();
        this.networkIdDeviceIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-deviceIds")).withRelaxedReadConsistency()).build();
        this.networkIdDeviceIdSetMap = this.networkIdDeviceIdSetConsistentMap.asJavaMap();
        this.networkIdVirtualLinkSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtuallinks")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualLinkSetMap = this.networkIdVirtualLinkSetConsistentMap.asJavaMap();
        this.networkIdVirtualPortSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualportss")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualPortSetMap = this.networkIdVirtualPortSetConsistentMap.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tenantIdSet.removeListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap.removeListener(this.virtualMapListener);
        this.log.info("Stopped");
    }

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    public void addTenantId(TenantId tenantId) {
        this.tenantIdSet.add((Object)tenantId);
    }

    public void removeTenantId(TenantId tenantId) {
        this.tenantIdSet.remove((Object)tenantId);
    }

    public Set<TenantId> getTenantIds() {
        return ImmutableSet.copyOf(this.tenantIdSet);
    }

    public VirtualNetwork addNetwork(TenantId tenantId) {
        Preconditions.checkState((boolean)this.tenantIdSet.contains((Object)tenantId), (Object)("The tenant has not been registered. " + (String)tenantId.id()));
        DefaultVirtualNetwork virtualNetwork = new DefaultVirtualNetwork(this.genNetworkId(), tenantId);
        this.networkIdVirtualNetworkMap.put(virtualNetwork.id(), (VirtualNetwork)virtualNetwork);
        Set<NetworkId> networkIdSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        if (networkIdSet == null) {
            networkIdSet = new HashSet<NetworkId>();
        }
        networkIdSet.add(virtualNetwork.id());
        this.tenantIdNetworkIdSetMap.put(tenantId, networkIdSet);
        return virtualNetwork;
    }

    private NetworkId genNetworkId() {
        return NetworkId.networkId((long)this.idGenerator.getNewId());
    }

    public void removeNetwork(NetworkId networkId) {
        if (this.networkExists(networkId)) {
            VirtualNetwork virtualNetwork = this.networkIdVirtualNetworkMap.remove(networkId);
            if (virtualNetwork == null) {
                return;
            }
            TenantId tenantId = virtualNetwork.tenantId();
            HashSet networkIdSet = new HashSet();
            this.tenantIdNetworkIdSetMap.get(tenantId).forEach(networkId1 -> {
                if (((Long)networkId1.id()).equals(networkId.id())) {
                    networkIdSet.add(networkId1);
                }
            });
            this.tenantIdNetworkIdSetMap.compute(virtualNetwork.tenantId(), (id, existingNetworkIds) -> {
                if (existingNetworkIds == null || existingNetworkIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingNetworkIds, (Set)networkIdSet));
            });
        }
    }

    private boolean networkExists(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)"The network identifier cannot be null.");
        return this.networkIdVirtualNetworkMap.containsKey(networkId);
    }

    public VirtualDevice addDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        if (deviceIdSet == null) {
            deviceIdSet = new HashSet<DeviceId>();
        }
        DefaultVirtualDevice virtualDevice = new DefaultVirtualDevice(networkId, deviceId);
        this.deviceIdVirtualDeviceMap.put(deviceId, (VirtualDevice)virtualDevice);
        deviceIdSet.add(deviceId);
        this.networkIdDeviceIdSetMap.put(networkId, deviceIdSet);
        return virtualDevice;
    }

    public void removeDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet deviceIdSet = new HashSet();
        this.networkIdDeviceIdSetMap.get(networkId).forEach(deviceId1 -> {
            if (deviceId1.equals((Object)deviceId)) {
                deviceIdSet.add(deviceId1);
            }
        });
        if (deviceIdSet != null) {
            this.networkIdDeviceIdSetMap.compute(networkId, (id, existingDeviceIds) -> {
                if (existingDeviceIds == null || existingDeviceIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingDeviceIds, (Set)deviceIdSet));
            });
            this.deviceIdVirtualDeviceMap.remove(deviceId);
        }
    }

    public VirtualLink addLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst, Link.State state, TunnelId realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        Preconditions.checkState((this.getLink(networkId, src, dst) == null ? 1 : 0) != 0, (Object)"The virtual link already exists");
        DefaultVirtualLink virtualLink = DefaultVirtualLink.builder().networkId(networkId).src(src).dst(dst).state(state).tunnelId(realizedBy).build();
        virtualLinkSet.add((VirtualLink)virtualLink);
        this.networkIdVirtualLinkSetMap.put(networkId, virtualLinkSet);
        return virtualLink;
    }

    public void updateLink(VirtualLink virtualLink, TunnelId tunnelId, Link.State state) {
        Preconditions.checkState((boolean)this.networkExists(virtualLink.networkId()), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(virtualLink.networkId());
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        virtualLinkSet.remove(virtualLink);
        DefaultVirtualLink newVirtualLink = DefaultVirtualLink.builder().networkId(virtualLink.networkId()).src(virtualLink.src()).dst(virtualLink.dst()).tunnelId(tunnelId).state(state).build();
        virtualLinkSet.add((VirtualLink)newVirtualLink);
        this.networkIdVirtualLinkSetMap.put(newVirtualLink.networkId(), virtualLinkSet);
    }

    public VirtualLink removeLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        VirtualLink virtualLink = this.getLink(networkId, src, dst);
        if (virtualLink == null) {
            return null;
        }
        HashSet<VirtualLink> virtualLinkSet = new HashSet<VirtualLink>();
        virtualLinkSet.add(virtualLink);
        if (virtualLinkSet != null) {
            this.networkIdVirtualLinkSetMap.compute(networkId, (id, existingVirtualLinks) -> {
                if (existingVirtualLinks == null || existingVirtualLinks.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingVirtualLinks, (Set)virtualLinkSet));
            });
        }
        return virtualLink;
    }

    public VirtualPort addPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, Port realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet == null) {
            virtualPortSet = new HashSet<VirtualPort>();
        }
        Device device = (Device)this.deviceIdVirtualDeviceMap.get(deviceId);
        Preconditions.checkNotNull((Object)device, (Object)("The device has not been created for deviceId: " + deviceId));
        DefaultVirtualPort virtualPort = new DefaultVirtualPort(networkId, device, portNumber, realizedBy);
        virtualPortSet.add((VirtualPort)virtualPort);
        this.networkIdVirtualPortSetMap.put(networkId, virtualPortSet);
        return virtualPort;
    }

    public void removePort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet virtualPortSet = new HashSet();
        this.networkIdVirtualPortSetMap.get(networkId).forEach(port -> {
            if (port.element().id().equals(deviceId) && port.number().equals((Object)portNumber)) {
                virtualPortSet.add(port);
            }
        });
        if (virtualPortSet != null) {
            this.networkIdVirtualPortSetMap.compute(networkId, (id, existingVirtualPorts) -> {
                if (existingVirtualPorts == null || existingVirtualPorts.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingVirtualPorts, (Set)virtualPortSet));
            });
        }
    }

    public Set<VirtualNetwork> getNetworks(TenantId tenantId) {
        Set<NetworkId> networkIdSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        HashSet virtualNetworkSet = new HashSet();
        if (networkIdSet != null) {
            networkIdSet.forEach(networkId -> virtualNetworkSet.add(this.networkIdVirtualNetworkMap.get(networkId)));
        }
        return ImmutableSet.copyOf(virtualNetworkSet);
    }

    public Set<VirtualDevice> getDevices(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        HashSet virtualDeviceSet = new HashSet();
        if (deviceIdSet != null) {
            deviceIdSet.forEach(deviceId -> virtualDeviceSet.add(this.deviceIdVirtualDeviceMap.get(deviceId)));
        }
        return ImmutableSet.copyOf(virtualDeviceSet);
    }

    public Set<VirtualLink> getLinks(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        return ImmutableSet.copyOf(virtualLinkSet);
    }

    public VirtualLink getLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            return null;
        }
        VirtualLink virtualLink = null;
        for (VirtualLink link : virtualLinkSet) {
            if (!link.src().equals((Object)src) || !link.dst().equals((Object)dst)) continue;
            virtualLink = link;
            break;
        }
        return virtualLink;
    }

    public Set<VirtualPort> getPorts(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet == null) {
            virtualPortSet = new HashSet<VirtualPort>();
        }
        if (deviceId == null) {
            return ImmutableSet.copyOf(virtualPortSet);
        }
        HashSet portSet = new HashSet();
        virtualPortSet.forEach(virtualPort -> {
            if (virtualPort.element().id().equals(deviceId)) {
                portSet.add(virtualPort);
            }
        });
        return ImmutableSet.copyOf(portSet);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<NetworkId, VirtualNetwork> {
        private InternalMapListener() {
        }

        public void event(MapEvent<NetworkId, VirtualNetwork> event) {
            NetworkId networkId = (NetworkId)Preconditions.checkNotNull((Object)event.key());
            VirtualNetworkEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = VirtualNetworkEvent.Type.NETWORK_ADDED;
                    break;
                }
                case UPDATE: {
                    if (event.oldValue().value() != null && event.newValue().value() == null) {
                        type = VirtualNetworkEvent.Type.NETWORK_REMOVED;
                        break;
                    }
                    type = VirtualNetworkEvent.Type.NETWORK_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = VirtualNetworkEvent.Type.NETWORK_REMOVED;
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedVirtualNetworkStore.this.notifyDelegate((Event)new VirtualNetworkEvent(type, networkId));
        }
    }

    private class InternalSetListener
    implements SetEventListener<TenantId> {
        private InternalSetListener() {
        }

        public void event(SetEvent<TenantId> event) {
            VirtualNetworkEvent.Type type = null;
            switch (event.type()) {
                case ADD: {
                    type = VirtualNetworkEvent.Type.TENANT_REGISTERED;
                    break;
                }
                case REMOVE: {
                    type = VirtualNetworkEvent.Type.TENANT_UNREGISTERED;
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedVirtualNetworkStore.this.notifyDelegate((Event)new VirtualNetworkEvent(type, null));
        }
    }
}

