/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.DefaultVirtualDevice;
import org.onosproject.incubator.net.virtual.DefaultVirtualHost;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.DefaultVirtualNetwork;
import org.onosproject.incubator.net.virtual.DefaultVirtualPort;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntent;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkStoreDelegate;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedVirtualNetworkStore
extends AbstractStore<VirtualNetworkEvent, VirtualNetworkStoreDelegate>
implements VirtualNetworkStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private IdGenerator idGenerator;
    private DistributedSet<TenantId> tenantIdSet;
    private final SetEventListener<TenantId> setListener = new InternalSetListener();
    private ConsistentMap<NetworkId, VirtualNetwork> networkIdVirtualNetworkConsistentMap;
    private Map<NetworkId, VirtualNetwork> networkIdVirtualNetworkMap;
    private final MapEventListener<NetworkId, VirtualNetwork> virtualNetworkMapListener = new InternalMapListener<NetworkId, VirtualNetwork>((mapEventType, virtualNetwork) -> {
        VirtualNetworkEvent.Type eventType = mapEventType.equals((Object)MapEvent.Type.INSERT) ? VirtualNetworkEvent.Type.NETWORK_ADDED : (mapEventType.equals((Object)MapEvent.Type.UPDATE) ? VirtualNetworkEvent.Type.NETWORK_UPDATED : (mapEventType.equals((Object)MapEvent.Type.REMOVE) ? VirtualNetworkEvent.Type.NETWORK_REMOVED : null));
        return eventType == null ? null : new VirtualNetworkEvent(eventType, virtualNetwork.id());
    });
    private ConsistentMap<TenantId, Set<NetworkId>> tenantIdNetworkIdSetConsistentMap;
    private Map<TenantId, Set<NetworkId>> tenantIdNetworkIdSetMap;
    private ConsistentMap<DeviceId, VirtualDevice> deviceIdVirtualDeviceConsistentMap;
    private Map<DeviceId, VirtualDevice> deviceIdVirtualDeviceMap;
    private final MapEventListener<DeviceId, VirtualDevice> virtualDeviceMapListener = new InternalMapListener<DeviceId, VirtualDevice>((mapEventType, virtualDevice) -> {
        VirtualNetworkEvent.Type eventType = mapEventType.equals((Object)MapEvent.Type.INSERT) ? VirtualNetworkEvent.Type.VIRTUAL_DEVICE_ADDED : (mapEventType.equals((Object)MapEvent.Type.UPDATE) ? VirtualNetworkEvent.Type.VIRTUAL_DEVICE_UPDATED : (mapEventType.equals((Object)MapEvent.Type.REMOVE) ? VirtualNetworkEvent.Type.VIRTUAL_DEVICE_REMOVED : null));
        return eventType == null ? null : new VirtualNetworkEvent(eventType, virtualDevice.networkId(), virtualDevice);
    });
    private ConsistentMap<NetworkId, Set<DeviceId>> networkIdDeviceIdSetConsistentMap;
    private Map<NetworkId, Set<DeviceId>> networkIdDeviceIdSetMap;
    private ConsistentMap<HostId, VirtualHost> hostIdVirtualHostConsistentMap;
    private Map<HostId, VirtualHost> hostIdVirtualHostMap;
    private ConsistentMap<NetworkId, Set<HostId>> networkIdHostIdSetConsistentMap;
    private Map<NetworkId, Set<HostId>> networkIdHostIdSetMap;
    private ConsistentMap<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetConsistentMap;
    private Map<NetworkId, Set<VirtualLink>> networkIdVirtualLinkSetMap;
    private ConsistentMap<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetConsistentMap;
    private Map<NetworkId, Set<VirtualPort>> networkIdVirtualPortSetMap;
    private ConsistentMap<Key, IntentData> intentKeyIntentDataConsistentMap;
    private Map<Key, IntentData> intentKeyIntentDataMap;
    private ConsistentMap<Key, Set<TunnelId>> intentKeyTunnelIdSetConsistentMap;
    private Map<Key, Set<TunnelId>> intentKeyTunnelIdSetMap;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TenantId.class}).register(new Class[]{NetworkId.class}).register(new Class[]{VirtualNetwork.class}).register(new Class[]{DefaultVirtualNetwork.class}).register(new Class[]{VirtualDevice.class}).register(new Class[]{DefaultVirtualDevice.class}).register(new Class[]{VirtualHost.class}).register(new Class[]{DefaultVirtualHost.class}).register(new Class[]{VirtualLink.class}).register(new Class[]{DefaultVirtualLink.class}).register(new Class[]{VirtualPort.class}).register(new Class[]{DefaultVirtualPort.class}).register(new Class[]{Device.class}).register(new Class[]{TunnelId.class}).register(new Class[]{IntentData.class}).register(new Class[]{VirtualNetworkIntent.class}).register(new Class[]{WallClockTimestamp.class}).nextId(500).build());

    @Activate
    public void activate() {
        this.idGenerator = this.coreService.getIdGenerator("virtual-network-ids");
        this.tenantIdSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId")).withRelaxedReadConsistency()).build()).asDistributedSet();
        this.tenantIdSet.addListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualnetwork")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualNetworkConsistentMap.addListener(this.virtualNetworkMapListener);
        this.networkIdVirtualNetworkMap = this.networkIdVirtualNetworkConsistentMap.asJavaMap();
        this.tenantIdNetworkIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-tenantId-networkIds")).withRelaxedReadConsistency()).build();
        this.tenantIdNetworkIdSetMap = this.tenantIdNetworkIdSetConsistentMap.asJavaMap();
        this.deviceIdVirtualDeviceConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-deviceId-virtualdevice")).withRelaxedReadConsistency()).build();
        this.deviceIdVirtualDeviceConsistentMap.addListener(this.virtualDeviceMapListener);
        this.deviceIdVirtualDeviceMap = this.deviceIdVirtualDeviceConsistentMap.asJavaMap();
        this.networkIdDeviceIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-deviceIds")).withRelaxedReadConsistency()).build();
        this.networkIdDeviceIdSetMap = this.networkIdDeviceIdSetConsistentMap.asJavaMap();
        this.hostIdVirtualHostConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-hostId-virtualhost")).withRelaxedReadConsistency()).build();
        this.hostIdVirtualHostMap = this.hostIdVirtualHostConsistentMap.asJavaMap();
        this.networkIdHostIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-hostIds")).withRelaxedReadConsistency()).build();
        this.networkIdHostIdSetMap = this.networkIdHostIdSetConsistentMap.asJavaMap();
        this.networkIdVirtualLinkSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtuallinks")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualLinkSetMap = this.networkIdVirtualLinkSetConsistentMap.asJavaMap();
        this.networkIdVirtualPortSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-networkId-virtualports")).withRelaxedReadConsistency()).build();
        this.networkIdVirtualPortSetMap = this.networkIdVirtualPortSetConsistentMap.asJavaMap();
        this.intentKeyTunnelIdSetConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-intentKey-tunnelIds")).withRelaxedReadConsistency()).build();
        this.intentKeyTunnelIdSetMap = this.intentKeyTunnelIdSetConsistentMap.asJavaMap();
        this.intentKeyIntentDataConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(SERIALIZER)).withName("onos-intentKey-intentData")).withRelaxedReadConsistency()).build();
        this.intentKeyIntentDataMap = this.intentKeyIntentDataConsistentMap.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tenantIdSet.removeListener(this.setListener);
        this.networkIdVirtualNetworkConsistentMap.removeListener(this.virtualNetworkMapListener);
        this.deviceIdVirtualDeviceConsistentMap.removeListener(this.virtualDeviceMapListener);
        this.log.info("Stopped");
    }

    public void addTenantId(TenantId tenantId) {
        this.tenantIdSet.add((Object)tenantId);
    }

    public void removeTenantId(TenantId tenantId) {
        this.tenantIdSet.remove((Object)tenantId);
    }

    public Set<TenantId> getTenantIds() {
        return ImmutableSet.copyOf(this.tenantIdSet);
    }

    public VirtualNetwork addNetwork(TenantId tenantId) {
        Preconditions.checkState((boolean)this.tenantIdSet.contains((Object)tenantId), (Object)("The tenant has not been registered. " + (String)tenantId.id()));
        DefaultVirtualNetwork virtualNetwork = new DefaultVirtualNetwork(this.genNetworkId(), tenantId);
        this.networkIdVirtualNetworkMap.put(virtualNetwork.id(), (VirtualNetwork)virtualNetwork);
        Set<NetworkId> networkIdSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        if (networkIdSet == null) {
            networkIdSet = new HashSet<NetworkId>();
        }
        networkIdSet.add(virtualNetwork.id());
        this.tenantIdNetworkIdSetMap.put(tenantId, networkIdSet);
        return virtualNetwork;
    }

    private NetworkId genNetworkId() {
        NetworkId networkId;
        while (!(networkId = NetworkId.networkId((long)this.idGenerator.getNewId())).isVirtualNetworkId()) {
        }
        return networkId;
    }

    public void removeNetwork(NetworkId networkId) {
        if (this.networkExists(networkId)) {
            VirtualNetwork virtualNetwork = this.networkIdVirtualNetworkMap.remove(networkId);
            if (virtualNetwork == null) {
                return;
            }
            TenantId tenantId = virtualNetwork.tenantId();
            HashSet networkIdSet = new HashSet();
            this.tenantIdNetworkIdSetMap.get(tenantId).forEach(networkId1 -> {
                if (((Long)networkId1.id()).equals(networkId.id())) {
                    networkIdSet.add(networkId1);
                }
            });
            this.tenantIdNetworkIdSetMap.compute(virtualNetwork.tenantId(), (id, existingNetworkIds) -> {
                if (existingNetworkIds == null || existingNetworkIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingNetworkIds, (Set)networkIdSet));
            });
        }
    }

    private boolean networkExists(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)"The network identifier cannot be null.");
        return this.networkIdVirtualNetworkMap.containsKey(networkId);
    }

    public VirtualDevice addDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        if (deviceIdSet == null) {
            deviceIdSet = new HashSet<DeviceId>();
        }
        DefaultVirtualDevice virtualDevice = new DefaultVirtualDevice(networkId, deviceId);
        this.deviceIdVirtualDeviceMap.put(deviceId, (VirtualDevice)virtualDevice);
        deviceIdSet.add(deviceId);
        this.networkIdDeviceIdSetMap.put(networkId, deviceIdSet);
        return virtualDevice;
    }

    public void removeDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet deviceIdSet = new HashSet();
        this.networkIdDeviceIdSetMap.get(networkId).forEach(deviceId1 -> {
            if (deviceId1.equals((Object)deviceId)) {
                deviceIdSet.add(deviceId1);
            }
        });
        if (deviceIdSet != null) {
            this.networkIdDeviceIdSetMap.compute(networkId, (id, existingDeviceIds) -> {
                if (existingDeviceIds == null || existingDeviceIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingDeviceIds, (Set)deviceIdSet));
            });
            this.deviceIdVirtualDeviceMap.remove(deviceId);
        }
    }

    public VirtualHost addHost(NetworkId networkId, HostId hostId, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<HostId> hostIdSet = this.networkIdHostIdSetMap.get(networkId);
        if (hostIdSet == null) {
            hostIdSet = new HashSet<HostId>();
        }
        DefaultVirtualHost virtualhost = new DefaultVirtualHost(networkId, hostId, mac, vlan, location, ips);
        this.hostIdVirtualHostMap.put(hostId, (VirtualHost)virtualhost);
        hostIdSet.add(hostId);
        this.networkIdHostIdSetMap.put(networkId, hostIdSet);
        return virtualhost;
    }

    public void removeHost(NetworkId networkId, HostId hostId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet hostIdSet = new HashSet();
        this.networkIdHostIdSetMap.get(networkId).forEach(hostId1 -> {
            if (hostId1.equals((Object)hostId)) {
                hostIdSet.add(hostId1);
            }
        });
        if (hostIdSet != null) {
            this.networkIdHostIdSetMap.compute(networkId, (id, existingHostIds) -> {
                if (existingHostIds == null || existingHostIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingHostIds, (Set)hostIdSet));
            });
            this.hostIdVirtualHostMap.remove(hostId);
        }
    }

    public VirtualLink addLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst, Link.State state, TunnelId realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        Preconditions.checkState((this.getLink(networkId, src, dst) == null ? 1 : 0) != 0, (Object)"The virtual link already exists");
        DefaultVirtualLink virtualLink = DefaultVirtualLink.builder().networkId(networkId).src(src).dst(dst).state(state).tunnelId(realizedBy).build();
        virtualLinkSet.add((VirtualLink)virtualLink);
        this.networkIdVirtualLinkSetMap.put(networkId, virtualLinkSet);
        return virtualLink;
    }

    public void updateLink(VirtualLink virtualLink, TunnelId tunnelId, Link.State state) {
        Preconditions.checkState((boolean)this.networkExists(virtualLink.networkId()), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(virtualLink.networkId());
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        virtualLinkSet.remove(virtualLink);
        DefaultVirtualLink newVirtualLink = DefaultVirtualLink.builder().networkId(virtualLink.networkId()).src(virtualLink.src()).dst(virtualLink.dst()).tunnelId(tunnelId).state(state).build();
        virtualLinkSet.add((VirtualLink)newVirtualLink);
        this.networkIdVirtualLinkSetMap.put(newVirtualLink.networkId(), virtualLinkSet);
    }

    public VirtualLink removeLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        VirtualLink virtualLink = this.getLink(networkId, src, dst);
        if (virtualLink == null) {
            return null;
        }
        HashSet<VirtualLink> virtualLinkSet = new HashSet<VirtualLink>();
        virtualLinkSet.add(virtualLink);
        if (virtualLinkSet != null) {
            this.networkIdVirtualLinkSetMap.compute(networkId, (id, existingVirtualLinks) -> {
                if (existingVirtualLinks == null || existingVirtualLinks.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingVirtualLinks, (Set)virtualLinkSet));
            });
        }
        return virtualLink;
    }

    public VirtualPort addPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, ConnectPoint realizedBy) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet == null) {
            virtualPortSet = new HashSet<VirtualPort>();
        }
        Device device = (Device)this.deviceIdVirtualDeviceMap.get(deviceId);
        Preconditions.checkNotNull((Object)device, (Object)("The device has not been created for deviceId: " + deviceId));
        boolean exist = virtualPortSet.stream().anyMatch(p -> p.element().id().equals(deviceId) && p.number().equals((Object)portNumber));
        Preconditions.checkState((!exist ? 1 : 0) != 0, (Object)"The requested Port Number is already in use");
        DefaultVirtualPort virtualPort = new DefaultVirtualPort(networkId, device, portNumber, realizedBy);
        virtualPortSet.add((VirtualPort)virtualPort);
        this.networkIdVirtualPortSetMap.put(networkId, virtualPortSet);
        this.notifyDelegate((Event)new VirtualNetworkEvent(VirtualNetworkEvent.Type.VIRTUAL_PORT_ADDED, networkId, (VirtualPort)virtualPort));
        return virtualPort;
    }

    public void bindPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, ConnectPoint realizedBy) {
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        VirtualPort vPort = virtualPortSet.stream().filter(p -> p.element().id().equals(deviceId) && p.number().equals((Object)portNumber)).findFirst().get();
        Preconditions.checkNotNull((Object)vPort, (Object)"The virtual port has not been added.");
        Device device = (Device)this.deviceIdVirtualDeviceMap.get(deviceId);
        Preconditions.checkNotNull((Object)device, (Object)("The device has not been created for deviceId: " + deviceId));
        virtualPortSet.remove(vPort);
        vPort = new DefaultVirtualPort(networkId, device, portNumber, realizedBy);
        virtualPortSet.add(vPort);
        this.networkIdVirtualPortSetMap.put(networkId, virtualPortSet);
        this.notifyDelegate((Event)new VirtualNetworkEvent(VirtualNetworkEvent.Type.VIRTUAL_PORT_UPDATED, networkId, vPort));
    }

    public void removePort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        HashSet virtualPortSet = new HashSet();
        this.networkIdVirtualPortSetMap.get(networkId).forEach(port -> {
            if (port.element().id().equals(deviceId) && port.number().equals((Object)portNumber)) {
                virtualPortSet.add(port);
            }
        });
        if (!virtualPortSet.isEmpty()) {
            AtomicBoolean portRemoved = new AtomicBoolean(false);
            this.networkIdVirtualPortSetMap.compute(networkId, (id, existingVirtualPorts) -> {
                if (existingVirtualPorts == null || existingVirtualPorts.isEmpty()) {
                    return new HashSet();
                }
                portRemoved.set(true);
                return new HashSet(Sets.difference((Set)existingVirtualPorts, (Set)virtualPortSet));
            });
            if (portRemoved.get()) {
                virtualPortSet.forEach(virtualPort -> this.notifyDelegate((Event)new VirtualNetworkEvent(VirtualNetworkEvent.Type.VIRTUAL_PORT_REMOVED, networkId, virtualPort)));
            }
        }
    }

    public Set<VirtualNetwork> getNetworks(TenantId tenantId) {
        Set<NetworkId> networkIdSet = this.tenantIdNetworkIdSetMap.get(tenantId);
        HashSet virtualNetworkSet = new HashSet();
        if (networkIdSet != null) {
            networkIdSet.forEach(networkId -> virtualNetworkSet.add(this.networkIdVirtualNetworkMap.get(networkId)));
        }
        return ImmutableSet.copyOf(virtualNetworkSet);
    }

    public VirtualNetwork getNetwork(NetworkId networkId) {
        return this.networkIdVirtualNetworkMap.get(networkId);
    }

    public Set<VirtualDevice> getDevices(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<DeviceId> deviceIdSet = this.networkIdDeviceIdSetMap.get(networkId);
        HashSet virtualDeviceSet = new HashSet();
        if (deviceIdSet != null) {
            deviceIdSet.forEach(deviceId -> virtualDeviceSet.add(this.deviceIdVirtualDeviceMap.get(deviceId)));
        }
        return ImmutableSet.copyOf(virtualDeviceSet);
    }

    public Set<VirtualHost> getHosts(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<HostId> hostIdSet = this.networkIdHostIdSetMap.get(networkId);
        HashSet virtualHostSet = new HashSet();
        if (hostIdSet != null) {
            hostIdSet.forEach(hostId -> virtualHostSet.add(this.hostIdVirtualHostMap.get(hostId)));
        }
        return ImmutableSet.copyOf(virtualHostSet);
    }

    public Set<VirtualLink> getLinks(NetworkId networkId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            virtualLinkSet = new HashSet<VirtualLink>();
        }
        return ImmutableSet.copyOf(virtualLinkSet);
    }

    public VirtualLink getLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Set<VirtualLink> virtualLinkSet = this.networkIdVirtualLinkSetMap.get(networkId);
        if (virtualLinkSet == null) {
            return null;
        }
        VirtualLink virtualLink = null;
        for (VirtualLink link : virtualLinkSet) {
            if (!link.src().equals((Object)src) || !link.dst().equals((Object)dst)) continue;
            virtualLink = link;
            break;
        }
        return virtualLink;
    }

    public Set<VirtualPort> getPorts(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkState((boolean)this.networkExists(networkId), (Object)"The network has not been added.");
        Set<VirtualPort> virtualPortSet = this.networkIdVirtualPortSetMap.get(networkId);
        if (virtualPortSet == null) {
            virtualPortSet = new HashSet<VirtualPort>();
        }
        if (deviceId == null) {
            return ImmutableSet.copyOf(virtualPortSet);
        }
        HashSet portSet = new HashSet();
        virtualPortSet.forEach(virtualPort -> {
            if (virtualPort.element().id().equals(deviceId)) {
                portSet.add(virtualPort);
            }
        });
        return ImmutableSet.copyOf(portSet);
    }

    public synchronized void addOrUpdateIntent(Intent intent, IntentState state) {
        Preconditions.checkNotNull((Object)intent, (Object)"Intent cannot be null");
        IntentData intentData = this.removeIntent(intent.key());
        intentData = intentData == null ? new IntentData(intent, state, (Timestamp)new WallClockTimestamp(System.currentTimeMillis())) : new IntentData(intent, state, intentData.version());
        this.intentKeyIntentDataMap.put(intent.key(), intentData);
    }

    public IntentData removeIntent(Key intentKey) {
        Preconditions.checkNotNull((Object)intentKey, (Object)"Intent key cannot be null");
        return this.intentKeyIntentDataMap.remove(intentKey);
    }

    public void addTunnelId(Intent intent, TunnelId tunnelId) {
        Set<TunnelId> tunnelIdSet = this.intentKeyTunnelIdSetMap.remove(intent.key());
        if (tunnelIdSet == null) {
            tunnelIdSet = new HashSet<TunnelId>();
        }
        tunnelIdSet.add(tunnelId);
        this.intentKeyTunnelIdSetMap.put(intent.key(), tunnelIdSet);
    }

    public Set<TunnelId> getTunnelIds(Intent intent) {
        Set<TunnelId> tunnelIdSet = this.intentKeyTunnelIdSetMap.get(intent.key());
        return tunnelIdSet == null ? new HashSet<TunnelId>() : ImmutableSet.copyOf(tunnelIdSet);
    }

    public void removeTunnelId(Intent intent, TunnelId tunnelId) {
        HashSet tunnelIdSet = new HashSet();
        this.intentKeyTunnelIdSetMap.get(intent.key()).forEach(tunnelId1 -> {
            if (tunnelId1.equals((Object)tunnelId)) {
                tunnelIdSet.add(tunnelId);
            }
        });
        if (!tunnelIdSet.isEmpty()) {
            this.intentKeyTunnelIdSetMap.compute(intent.key(), (key, existingTunnelIds) -> {
                if (existingTunnelIds == null || existingTunnelIds.isEmpty()) {
                    return new HashSet();
                }
                return new HashSet(Sets.difference((Set)existingTunnelIds, (Set)tunnelIdSet));
            });
        }
    }

    public Set<Intent> getIntents() {
        HashSet intents = new HashSet();
        this.intentKeyIntentDataMap.values().forEach(intentData -> intents.add(intentData.intent()));
        return ImmutableSet.copyOf(intents);
    }

    public Intent getIntent(Key key) {
        IntentData intentData = this.intentKeyIntentDataMap.get(key);
        return intentData == null ? null : intentData.intent();
    }

    public Set<IntentData> getIntentData() {
        return ImmutableSet.copyOf(this.intentKeyIntentDataMap.values());
    }

    public IntentData getIntentData(Key key) {
        IntentData intentData = this.intentKeyIntentDataMap.get(key);
        return intentData == null ? null : new IntentData(intentData);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalMapListener<K, V>
    implements MapEventListener<K, V> {
        private final BiFunction<MapEvent.Type, V, VirtualNetworkEvent> createEvent;

        InternalMapListener(BiFunction<MapEvent.Type, V, VirtualNetworkEvent> createEvent) {
            this.createEvent = createEvent;
        }

        public void event(MapEvent<K, V> event) {
            Preconditions.checkNotNull((Object)event.key());
            VirtualNetworkEvent vnetEvent = null;
            switch (event.type()) {
                case INSERT: {
                    vnetEvent = this.createEvent.apply(event.type(), event.newValue().value());
                    break;
                }
                case UPDATE: {
                    if (event.oldValue().value() != null && event.newValue().value() == null) {
                        vnetEvent = this.createEvent.apply(MapEvent.Type.REMOVE, event.oldValue().value());
                        break;
                    }
                    vnetEvent = this.createEvent.apply(event.type(), event.newValue().value());
                    break;
                }
                case REMOVE: {
                    if (event.oldValue() == null) break;
                    vnetEvent = this.createEvent.apply(event.type(), event.oldValue().value());
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            if (vnetEvent != null) {
                DistributedVirtualNetworkStore.this.notifyDelegate(vnetEvent);
            }
        }
    }

    private class InternalSetListener
    implements SetEventListener<TenantId> {
        private InternalSetListener() {
        }

        public void event(SetEvent<TenantId> event) {
            VirtualNetworkEvent.Type type = null;
            switch (event.type()) {
                case ADD: {
                    type = VirtualNetworkEvent.Type.TENANT_REGISTERED;
                    break;
                }
                case REMOVE: {
                    type = VirtualNetworkEvent.Type.TENANT_UNREGISTERED;
                    break;
                }
                default: {
                    DistributedVirtualNetworkStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedVirtualNetworkStore.this.notifyDelegate((Event)new VirtualNetworkEvent(type, null));
        }
    }
}

