/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.store.routing.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.routing.NextHopData;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouteStore
extends AbstractStore<RouteEvent, RouteStoreDelegate>
implements RouteStore {
    public StorageService storageService;
    private static final RouteTableId IPV4 = new RouteTableId("ipv4");
    private static final RouteTableId IPV6 = new RouteTableId("ipv6");
    private static final Logger log = LoggerFactory.getLogger(DistributedRouteStore.class);
    private final MapEventListener<IpPrefix, Route> routeTableListener = new RouteTableListener();
    private final MapEventListener<IpAddress, NextHopData> nextHopListener = new NextHopListener();
    private final Map<RouteTableId, ConsistentMap<IpPrefix, Route>> routeTables = Maps.newHashMap();
    private final Map<RouteTableId, InvertedRadixTree<Route>> localRouteTables = Maps.newHashMap();
    private ConsistentMap<IpAddress, NextHopData> nextHops;

    public DistributedRouteStore(StorageService storageService) {
        this.storageService = storageService;
    }

    public void activate() {
        ConsistentMap<IpPrefix, Route> ipv4RouteTable = this.createRouteTable(IPV4);
        ConsistentMap<IpPrefix, Route> ipv6RouteTable = this.createRouteTable(IPV6);
        this.routeTables.put(IPV4, ipv4RouteTable);
        this.routeTables.put(IPV6, ipv6RouteTable);
        this.localRouteTables.put(IPV4, (InvertedRadixTree<Route>)this.createLocalRouteTable());
        this.localRouteTables.put(IPV6, (InvertedRadixTree<Route>)this.createLocalRouteTable());
        this.nextHops = this.createNextHopTable();
        this.routeTables.values().forEach(routeTable -> routeTable.addListener(this.routeTableListener, (Executor)Executors.newSingleThreadExecutor()));
        this.nextHops.addListener(this.nextHopListener, (Executor)Executors.newSingleThreadExecutor());
        log.info("Started");
    }

    public void deactivate() {
        this.routeTables.values().forEach(routeTable -> {
            routeTable.removeListener(this.routeTableListener);
            routeTable.destroy();
        });
        this.nextHops.removeListener(this.nextHopListener);
        this.nextHops.destroy();
        this.routeTables.clear();
        this.localRouteTables.clear();
        this.nextHops.clear();
        log.info("Stopped");
    }

    public void updateRoute(Route route) {
        this.getDefaultRouteTable(route).put(route.prefix(), route);
    }

    public void removeRoute(Route route) {
        this.getDefaultRouteTable(route).remove(route.prefix());
        if (this.getRoutesForNextHop(route.nextHop()).isEmpty()) {
            this.nextHops.remove((Object)route.nextHop());
        }
    }

    public Set<RouteTableId> getRouteTables() {
        return this.routeTables.keySet();
    }

    public Collection<Route> getRoutes(RouteTableId table) {
        ConsistentMap<IpPrefix, Route> routeTable = this.routeTables.get(table);
        return routeTable != null ? (Collection)routeTable.values().stream().map(Versioned::value).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public Route longestPrefixMatch(IpAddress ip) {
        Iterable prefixes = this.getDefaultLocalRouteTable(ip).getValuesForKeysPrefixing((CharSequence)DistributedRouteStore.createBinaryString(ip.toIpPrefix()));
        Iterator it = prefixes.iterator();
        Route route = null;
        while (it.hasNext()) {
            route = (Route)it.next();
        }
        return route;
    }

    public Collection<Route> getRoutesForNextHop(IpAddress ip) {
        return this.getDefaultRouteTable(ip).values().stream().filter(route -> route.nextHop().equals((Object)ip)).collect(Collectors.toList());
    }

    public void updateNextHop(IpAddress ip, NextHopData nextHopData) {
        Preconditions.checkNotNull((Object)ip);
        Preconditions.checkNotNull((Object)nextHopData);
        Collection<Route> routes = this.getRoutesForNextHop(ip);
        if (!routes.isEmpty() && !nextHopData.equals((Object)this.getNextHop(ip))) {
            this.nextHops.put((Object)ip, (Object)nextHopData);
        }
    }

    public void removeNextHop(IpAddress ip, NextHopData nextHopData) {
        Preconditions.checkNotNull((Object)ip);
        Preconditions.checkNotNull((Object)nextHopData);
        this.nextHops.remove((Object)ip, (Object)nextHopData);
    }

    public NextHopData getNextHop(IpAddress ip) {
        return (NextHopData)Versioned.valueOrNull((Versioned)this.nextHops.get((Object)ip));
    }

    public Map<IpAddress, NextHopData> getNextHops() {
        return this.nextHops.asJavaMap();
    }

    private ConsistentMap<IpPrefix, Route> createRouteTable(RouteTableId tableId) {
        KryoNamespace routeTableSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Route.class}).register(new Class[]{Route.Source.class}).build();
        return (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-routes-" + tableId.name())).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)routeTableSerializer))).build();
    }

    private ConcurrentInvertedRadixTree<Route> createLocalRouteTable() {
        return new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
    }

    private ConsistentMap<IpAddress, NextHopData> createNextHopTable() {
        KryoNamespace.Builder nextHopSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{NextHopData.class});
        return (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-nexthops")).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)nextHopSerializer.build()))).build();
    }

    private Map<IpPrefix, Route> getDefaultRouteTable(Route route) {
        return this.getDefaultRouteTable(route.prefix().address());
    }

    private Map<IpPrefix, Route> getDefaultRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.routeTables.get(routeTableId).asJavaMap();
    }

    private InvertedRadixTree<Route> getDefaultLocalRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.localRouteTables.get(routeTableId);
    }

    private static String createBinaryString(IpPrefix ipPrefix) {
        byte[] octets = ipPrefix.address().toOctets();
        StringBuilder result = new StringBuilder(ipPrefix.prefixLength());
        result.append("0");
        for (int i = 0; i < ipPrefix.prefixLength(); ++i) {
            int byteOffset = i / 8;
            byte value = octets[byteOffset];
            int bitOffset = i % 8;
            int mask = 1 << 7 - bitOffset;
            boolean isSet = (value & mask) != 0;
            result.append(isSet ? "1" : "0");
        }
        return result.toString();
    }

    private class NextHopListener
    implements MapEventListener<IpAddress, NextHopData> {
        private NextHopListener() {
        }

        public void event(MapEvent<IpAddress, NextHopData> event) {
            Collection<Route> routes = DistributedRouteStore.this.getRoutesForNextHop((IpAddress)event.key());
            switch (event.type()) {
                case INSERT: {
                    NextHopData nextHopData = (NextHopData)Preconditions.checkNotNull((Object)event.newValue().value());
                    routes.forEach(route -> DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, new ResolvedRoute(route, nextHopData.mac(), nextHopData.location()))));
                    break;
                }
                case UPDATE: {
                    NextHopData nextHopData = (NextHopData)Preconditions.checkNotNull((Object)event.newValue().value());
                    NextHopData oldNextHopData = (NextHopData)Preconditions.checkNotNull((Object)event.oldValue().value());
                    routes.forEach(route -> {
                        if (oldNextHopData == null) {
                            DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, new ResolvedRoute(route, nextHopData.mac(), nextHopData.location())));
                        } else if (!oldNextHopData.equals((Object)nextHopData)) {
                            DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, new ResolvedRoute(route, nextHopData.mac(), nextHopData.location()), new ResolvedRoute(route, oldNextHopData.mac(), oldNextHopData.location())));
                        }
                    });
                    break;
                }
                case REMOVE: {
                    NextHopData oldNextHopData = (NextHopData)Preconditions.checkNotNull((Object)event.oldValue().value());
                    routes.forEach(route -> DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(route, oldNextHopData.mac(), oldNextHopData.location()))));
                    break;
                }
                default: {
                    log.warn("Unknown MapEvent type: {}", (Object)event.type());
                }
            }
        }
    }

    private class RouteTableListener
    implements MapEventListener<IpPrefix, Route> {
        private RouteTableListener() {
        }

        public void event(MapEvent<IpPrefix, Route> event) {
            switch (event.type()) {
                case INSERT: {
                    Route route = (Route)Preconditions.checkNotNull((Object)event.newValue().value());
                    NextHopData nextHopData = DistributedRouteStore.this.getNextHop(route.nextHop());
                    DistributedRouteStore.this.getDefaultLocalRouteTable(route.nextHop()).put((CharSequence)DistributedRouteStore.createBinaryString(route.prefix()), (Object)route);
                    if (nextHopData == null) break;
                    DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_ADDED, new ResolvedRoute(route, nextHopData.mac(), nextHopData.location())));
                    break;
                }
                case UPDATE: {
                    Route route = (Route)Preconditions.checkNotNull((Object)event.newValue().value());
                    Route prevRoute = (Route)Preconditions.checkNotNull((Object)event.oldValue().value());
                    NextHopData nextHopData = DistributedRouteStore.this.getNextHop(route.nextHop());
                    NextHopData prevNextHopData = DistributedRouteStore.this.getNextHop(prevRoute.nextHop());
                    DistributedRouteStore.this.getDefaultLocalRouteTable(route.nextHop()).put((CharSequence)DistributedRouteStore.createBinaryString(route.prefix()), (Object)route);
                    if (nextHopData == null && prevNextHopData != null) {
                        DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(prevRoute, prevNextHopData.mac(), prevNextHopData.location())));
                    } else if (nextHopData != null && prevNextHopData != null) {
                        DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, new ResolvedRoute(route, nextHopData.mac(), nextHopData.location()), new ResolvedRoute(prevRoute, prevNextHopData.mac(), prevNextHopData.location())));
                    }
                    this.cleanupNextHop(prevRoute.nextHop());
                    break;
                }
                case REMOVE: {
                    Route prevRoute = (Route)Preconditions.checkNotNull((Object)event.oldValue().value());
                    NextHopData prevNextHopData = DistributedRouteStore.this.getNextHop(prevRoute.nextHop());
                    DistributedRouteStore.this.getDefaultLocalRouteTable(prevRoute.nextHop()).remove((CharSequence)DistributedRouteStore.createBinaryString(prevRoute.prefix()));
                    if (prevNextHopData != null) {
                        DistributedRouteStore.this.notifyDelegate((Event)new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, new ResolvedRoute(prevRoute, prevNextHopData.mac(), prevNextHopData.location())));
                    }
                    this.cleanupNextHop(prevRoute.nextHop());
                    break;
                }
                default: {
                    log.warn("Unknown MapEvent type: {}", (Object)event.type());
                }
            }
        }

        private void cleanupNextHop(IpAddress ip) {
            if (DistributedRouteStore.this.getDefaultRouteTable(ip).values().stream().noneMatch(route -> route.nextHop().equals((Object)ip))) {
                DistributedRouteStore.this.nextHops.remove((Object)ip);
            }
        }
    }
}

