/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.impl.DefaultIsisController;
import org.onosproject.isis.controller.topology.IsisRouterListener;

public class DefaultIsisControllerTest {
    private ObjectMapper mapper;
    private JsonNode jsonNode;
    private DefaultIsisController defaultIsisController;
    private String jsonString = "{                \"processes\": [{                                \"processId\": \"4.4.4.4\",                                \"interface\": [{                                                \"interfaceIndex\": \"2\",                                                \"macAddress\": \"08:00:27:b7:ab:bf\",                                                \"interfaceIp\": \"192.168.56.101\",                                                \"networkMask\": \"255.255.255.224\",                                                \"intermediateSystemName\": \"ROUTERONE\",                                                \"systemId\": \"2929.2929.2929\",                                                \"lanId\": \"0000.0000.0000.00\",                                                \"idLength\": \"0\",                                                \"maxAreaAddresses\": \"3\",                                                \"reservedPacketCircuitType\": \"1\",                                                \"circuitId\": \"10\",                                                \"networkType\": \"2\",                                                \"areaAddress\": \"490000\",                                                \"areaLength\": \"3\",                                                \"lspId\": \"1313131313130000\",                                                \"holdingTime\": \"50\",                                                \"helloInterval\": \"10\",                                                \"priority\": \"0\"                                }]                }]}";
    private IsisRouterListener isisRouterListener;

    @Before
    public void setUp() throws Exception {
        this.defaultIsisController = new DefaultIsisController();
        this.mapper = new ObjectMapper();
        this.jsonNode = this.mapper.readTree(this.jsonString);
        this.isisRouterListener = (IsisRouterListener)EasyMock.createNiceMock(IsisRouterListener.class);
    }

    @After
    public void tearDown() throws Exception {
        this.defaultIsisController = null;
    }

    @Test
    public void testActivate() throws Exception {
        this.defaultIsisController.activate();
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testDeactivate() throws Exception {
        this.defaultIsisController.activate();
        this.defaultIsisController.deactivate();
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAllConfiguredProcesses() throws Exception {
        this.defaultIsisController.allConfiguredProcesses();
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdateConfig() throws Exception {
        this.defaultIsisController.updateConfig(this.jsonNode);
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testaddRouterListener() throws Exception {
        this.defaultIsisController.addRouterListener(this.isisRouterListener);
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testremoveRouterListener() throws Exception {
        this.defaultIsisController.removeRouterListener(this.isisRouterListener);
        Assert.assertThat((Object)this.defaultIsisController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

