/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisNeighbor;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.DefaultIsisNeighbor;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdb;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.Csnp;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.pdu.P2PHelloPdu;
import org.onosproject.isis.io.isispacket.pdu.Psnp;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntry;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;

public class DefaultIsisInterfaceTest {
    private final MacAddress macAddress = MacAddress.valueOf((String)"AA:BB:CC:DD:EE:FF");
    private final MacAddress macAddress1 = MacAddress.valueOf((String)"AA:CC:CC:DD:EE:FF");
    private final Ip4Address ip4Address = Ip4Address.valueOf((String)"10.10.0.0");
    private final byte[] mask = new byte[]{-1, -1, -1, -32};
    private final byte[] mask1 = new byte[]{0, 0, 0, 0};
    private final String intSysName = "ROUTER";
    private final String sysId = "1111.1111.1111";
    private final String areaAddr = "49.002";
    private final byte[] csnpBytes = new byte[]{0, 67, 18, 52, 18, 52, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 9, 32, 4, -81, 18, 52, 18, 52, 0, 18, 0, 0, 0, 0, 0, 41, -92, -30, 4, -81, 41, 41, 41, 41, 41, 41, 0, 0, 0, 0, 0, 1, 91, 126};
    private IsisInterfaceState resultIfState;
    private DefaultIsisInterface defaultIsisInterface;
    private IsisHeader isisHeader;
    private IsisInterface isisInterface;
    private Set<MacAddress> resultSet;
    private int resultInt;
    private IsisLsdb resultLsdb;
    private IsisNeighbor resultNeighborList;
    private Ip4Address resultIPv4Addr;
    private MacAddress resultMacAddr;
    private byte[] resultByteArr;
    private String resultStr;
    private IsisNetworkType resultNwType;
    private List<Ip4Address> ip4Addresses = new ArrayList<Ip4Address>();
    private DefaultIsisNeighbor defaultIsisNeighbor;
    private IsisNeighbor result;
    private IsisLsdb result1;
    private Set<MacAddress> result2;
    private Channel result3;
    private IsisMessage isisMessage;
    private IsisLsdb isisLsdb;
    private Channel channel;
    private L1L2HelloPdu helloPdu;
    private LsPdu lsPdu;
    private Csnp csnp;
    private Psnp psnp;
    private P2PHelloPdu p2PHelloPdu;
    private boolean result4;
    private String result5;

    @Before
    public void setUp() throws Exception {
        this.channel = (Channel)EasyMock.createNiceMock(Channel.class);
        this.defaultIsisInterface = new DefaultIsisInterface();
        this.defaultIsisInterface.setInterfaceMacAddress(this.macAddress);
        this.isisHeader = new IsisHeader();
        this.isisHeader.setIrpDiscriminator((byte)1);
        this.helloPdu = new L1L2HelloPdu(this.isisHeader);
        this.isisInterface = new DefaultIsisInterface();
        this.defaultIsisNeighbor = new DefaultIsisNeighbor((HelloPdu)this.helloPdu, this.isisInterface);
        this.defaultIsisNeighbor.setNeighborMacAddress(this.macAddress);
        this.isisLsdb = new DefaultIsisLsdb();
    }

    @After
    public void tearDown() throws Exception {
        this.defaultIsisInterface = null;
        this.helloPdu = null;
        this.isisInterface = null;
        this.resultNeighborList = null;
    }

    @Test
    public void testInterfaceIndex() throws Exception {
        this.defaultIsisInterface.setInterfaceIndex(2);
        this.resultInt = this.defaultIsisInterface.interfaceIndex();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testSetInterfaceIndex() throws Exception {
        this.defaultIsisInterface.setInterfaceIndex(2);
        this.resultInt = this.defaultIsisInterface.interfaceIndex();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testInterfaceIpAddress() throws Exception {
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.resultIPv4Addr = this.defaultIsisInterface.interfaceIpAddress();
        Assert.assertThat((Object)this.resultIPv4Addr, (Matcher)CoreMatchers.is((Object)this.ip4Address));
    }

    @Test
    public void testSetInterfaceIpAddress() throws Exception {
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.resultIPv4Addr = this.defaultIsisInterface.interfaceIpAddress();
        Assert.assertThat((Object)this.resultIPv4Addr, (Matcher)CoreMatchers.is((Object)this.ip4Address));
    }

    @Test
    public void testNetworkMask() throws Exception {
        this.defaultIsisInterface.setNetworkMask(this.mask);
        this.resultByteArr = this.defaultIsisInterface.networkMask();
        Assert.assertThat((Object)this.resultByteArr, (Matcher)CoreMatchers.is((Object)this.mask));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.defaultIsisInterface.setNetworkMask(this.mask);
        this.resultByteArr = this.defaultIsisInterface.networkMask();
        Assert.assertThat((Object)this.resultByteArr, (Matcher)CoreMatchers.is((Object)this.mask));
    }

    @Test
    public void testGetInterfaceMacAddress() throws Exception {
        this.defaultIsisInterface.setInterfaceMacAddress(this.macAddress);
        this.resultMacAddr = this.defaultIsisInterface.getInterfaceMacAddress();
        Assert.assertThat((Object)this.resultMacAddr, (Matcher)CoreMatchers.is((Object)this.macAddress));
    }

    @Test
    public void testSetInterfaceMacAddress() throws Exception {
        this.defaultIsisInterface.setInterfaceMacAddress(this.macAddress);
        this.resultMacAddr = this.defaultIsisInterface.getInterfaceMacAddress();
        Assert.assertThat((Object)this.resultMacAddr, (Matcher)CoreMatchers.is((Object)this.macAddress));
    }

    @Test
    public void testIntermediateSystemName() throws Exception {
        this.defaultIsisInterface.setIntermediateSystemName("ROUTER");
        this.resultStr = this.defaultIsisInterface.intermediateSystemName();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"ROUTER"));
    }

    @Test
    public void testSetIntermediateSystemName() throws Exception {
        this.defaultIsisInterface.setIntermediateSystemName("ROUTER");
        this.resultStr = this.defaultIsisInterface.intermediateSystemName();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"ROUTER"));
    }

    @Test
    public void testSystemId() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.systemId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetSystemId() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.systemId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testL1LanId() throws Exception {
        this.defaultIsisInterface.setL1LanId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.l1LanId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetL1LanId() throws Exception {
        this.defaultIsisInterface.setL1LanId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.l1LanId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testL2LanId() throws Exception {
        this.defaultIsisInterface.setL2LanId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.l2LanId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetL2LanId() throws Exception {
        this.defaultIsisInterface.setL2LanId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.l2LanId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testGetIdLength() throws Exception {
        this.defaultIsisInterface.setIdLength(8);
        this.resultInt = this.defaultIsisInterface.getIdLength();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void testSetIdLength() throws Exception {
        this.defaultIsisInterface.setIdLength(8);
        this.resultInt = this.defaultIsisInterface.getIdLength();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void testGetMaxAreaAddresses() throws Exception {
        this.defaultIsisInterface.setMaxAreaAddresses(3);
        this.resultInt = this.defaultIsisInterface.getMaxAreaAddresses();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetMaxAreaAddresses() throws Exception {
        this.defaultIsisInterface.setMaxAreaAddresses(3);
        this.resultInt = this.defaultIsisInterface.getMaxAreaAddresses();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testReservedPacketCircuitType() throws Exception {
        this.defaultIsisInterface.setReservedPacketCircuitType(1);
        this.resultInt = this.defaultIsisInterface.reservedPacketCircuitType();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetReservedPacketCircuitType() throws Exception {
        this.defaultIsisInterface.setReservedPacketCircuitType(1);
        this.resultInt = this.defaultIsisInterface.reservedPacketCircuitType();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNetworkType() throws Exception {
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.BROADCAST);
        this.resultNwType = this.defaultIsisInterface.networkType();
        Assert.assertThat((Object)this.resultNwType, (Matcher)CoreMatchers.is((Object)IsisNetworkType.BROADCAST));
    }

    @Test
    public void testSetNetworkType() throws Exception {
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.BROADCAST);
        this.resultNwType = this.defaultIsisInterface.networkType();
        Assert.assertThat((Object)this.resultNwType, (Matcher)CoreMatchers.is((Object)IsisNetworkType.BROADCAST));
    }

    @Test
    public void testAreaAddress() throws Exception {
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.resultStr = this.defaultIsisInterface.areaAddress();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"49.002"));
    }

    @Test
    public void testSetAreaAddress() throws Exception {
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.resultStr = this.defaultIsisInterface.areaAddress();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"49.002"));
    }

    @Test
    public void testGetAreaLength() throws Exception {
        this.defaultIsisInterface.setAreaLength(3);
        this.resultInt = this.defaultIsisInterface.getAreaLength();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetAreaLength() throws Exception {
        this.defaultIsisInterface.setAreaLength(3);
        this.resultInt = this.defaultIsisInterface.getAreaLength();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testHoldingTime() throws Exception {
        this.defaultIsisInterface.setHoldingTime(10);
        this.resultInt = this.defaultIsisInterface.holdingTime();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetHoldingTime() throws Exception {
        this.defaultIsisInterface.setHoldingTime(10);
        this.resultInt = this.defaultIsisInterface.holdingTime();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testPriority() throws Exception {
        this.defaultIsisInterface.setPriority(1);
        this.resultInt = this.defaultIsisInterface.priority();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetPriority() throws Exception {
        this.defaultIsisInterface.setPriority(1);
        this.resultInt = this.defaultIsisInterface.priority();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testHelloInterval() throws Exception {
        this.defaultIsisInterface.setHelloInterval(10);
        this.resultInt = this.defaultIsisInterface.helloInterval();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetHelloInterval() throws Exception {
        this.defaultIsisInterface.setHelloInterval(10);
        this.resultInt = this.defaultIsisInterface.helloInterval();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testInterfaceState() throws Exception {
        this.defaultIsisInterface.setInterfaceState(IsisInterfaceState.UP);
        this.resultIfState = this.defaultIsisInterface.interfaceState();
        Assert.assertThat((Object)this.resultIfState, (Matcher)CoreMatchers.is((Object)IsisInterfaceState.UP));
    }

    @Test
    public void testSetInterfaceState() throws Exception {
        this.defaultIsisInterface.setInterfaceState(IsisInterfaceState.UP);
        this.resultIfState = this.defaultIsisInterface.interfaceState();
        Assert.assertThat((Object)this.resultIfState, (Matcher)CoreMatchers.is((Object)IsisInterfaceState.UP));
    }

    @Test
    public void testCircuitId() throws Exception {
        this.defaultIsisInterface.setCircuitId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.circuitId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetCircuitId() throws Exception {
        this.defaultIsisInterface.setCircuitId("1111.1111.1111");
        this.resultStr = this.defaultIsisInterface.circuitId();
        Assert.assertThat((Object)this.resultStr, (Matcher)CoreMatchers.is((Object)"1111.1111.1111"));
    }

    @Test
    public void testSetAllConfiguredInterfaceIps() throws Exception {
        this.ip4Addresses.add(this.ip4Address);
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveNeighbor() throws Exception {
        this.defaultIsisInterface.removeNeighbor((IsisNeighbor)this.defaultIsisNeighbor);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLookup() throws Exception {
        this.result = this.defaultIsisInterface.lookup(this.defaultIsisNeighbor.neighborMacAddress());
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testIsisLsdb() throws Exception {
        this.result1 = this.defaultIsisInterface.isisLsdb();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testNeighbors() throws Exception {
        this.result2 = this.defaultIsisInterface.neighbors();
        Assert.assertThat(this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testChannel() throws Exception {
        this.result3 = this.defaultIsisInterface.channel();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testProcessIsisMessage() throws Exception {
        this.helloPdu = new L1L2HelloPdu(this.isisHeader);
        this.helloPdu.setSourceMac(this.macAddress1);
        this.helloPdu.setIsisPduType(IsisPduType.L2HELLOPDU.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.BROADCAST);
        this.isisMessage = this.helloPdu;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessIsisMessage1() throws Exception {
        this.lsPdu = new LsPdu(this.isisHeader);
        this.lsPdu.setSourceMac(this.macAddress1);
        this.lsPdu.setIsisPduType(IsisPduType.L2LSPDU.value());
        this.isisMessage = this.lsPdu;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessIsisMessage2() throws Exception {
        this.csnp = new Csnp(this.isisHeader);
        this.csnp.setSourceMac(this.macAddress1);
        this.csnp.setIsisPduType(IsisPduType.L2CSNP.value());
        this.isisMessage = this.csnp;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessIsisMessage3() throws Exception {
        this.psnp = new Psnp(this.isisHeader);
        this.psnp.setSourceMac(this.macAddress1);
        this.psnp.setIsisPduType(IsisPduType.L2PSNP.value());
        this.isisMessage = this.psnp;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessIsisMessage4() throws Exception {
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.isisMessage = this.p2PHelloPdu;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testValidateHelloMessage() throws Exception {
        this.helloPdu = new L1L2HelloPdu(this.isisHeader);
        this.result4 = this.defaultIsisInterface.validateHelloMessage((HelloPdu)this.helloPdu);
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testProcessL1L2HelloPduMessage() throws Exception {
        this.helloPdu = new L1L2HelloPdu(this.isisHeader);
        this.helloPdu.setSourceMac(this.macAddress1);
        this.helloPdu.setCircuitType((byte)IsisRouterType.L2.value());
        this.defaultIsisInterface.processL1L2HelloPduMessage((IsisMessage)this.helloPdu, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L2.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee1() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L2.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setReservedPacketCircuitType(IsisRouterType.L2.value());
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.defaultIsisInterface.setNetworkMask(this.mask1);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee2() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress("49.002");
        this.p2PHelloPdu.addTlv((IsisTlv)areaAddressTlv);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L1.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setReservedPacketCircuitType(IsisRouterType.L1.value());
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.defaultIsisInterface.setNetworkMask(this.mask1);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee3() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
        adjacencyStateTlv.setNeighborSystemId("1111.1111.1111");
        adjacencyStateTlv.setAdjacencyType((byte)IsisInterfaceState.DOWN.value());
        this.p2PHelloPdu.addTlv((IsisTlv)adjacencyStateTlv);
        tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress("49.002");
        this.p2PHelloPdu.addTlv((IsisTlv)areaAddressTlv);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L1.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setReservedPacketCircuitType(IsisRouterType.L1.value());
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.defaultIsisInterface.setNetworkMask(this.mask1);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee4() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
        adjacencyStateTlv.setNeighborSystemId("1111.1111.1111");
        adjacencyStateTlv.setAdjacencyType((byte)IsisInterfaceState.INITIAL.value());
        this.p2PHelloPdu.addTlv((IsisTlv)adjacencyStateTlv);
        tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress("49.002");
        this.p2PHelloPdu.addTlv((IsisTlv)areaAddressTlv);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L1.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setReservedPacketCircuitType(IsisRouterType.L1L2.value());
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.defaultIsisInterface.setNetworkMask(this.mask1);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessP2pHelloPduMessagee5() throws Exception {
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.p2PHelloPdu = new P2PHelloPdu(this.isisHeader);
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.ADJACENCYSTATE.value());
        AdjacencyStateTlv adjacencyStateTlv = new AdjacencyStateTlv(tlvHeader);
        adjacencyStateTlv.setNeighborSystemId("1111.1111.1111");
        adjacencyStateTlv.setAdjacencyType((byte)IsisInterfaceState.UP.value());
        this.p2PHelloPdu.addTlv((IsisTlv)adjacencyStateTlv);
        tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.AREAADDRESS.value());
        AreaAddressTlv areaAddressTlv = new AreaAddressTlv(tlvHeader);
        areaAddressTlv.addAddress("49.002");
        this.p2PHelloPdu.addTlv((IsisTlv)areaAddressTlv);
        this.p2PHelloPdu.setIsisPduType(IsisPduType.P2PHELLOPDU.value());
        this.p2PHelloPdu.setSourceMac(this.macAddress1);
        this.p2PHelloPdu.setCircuitType((byte)IsisRouterType.L2.value());
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setReservedPacketCircuitType(IsisRouterType.L1L2.value());
        this.defaultIsisInterface.setAreaAddress("49.002");
        this.defaultIsisInterface.setAllConfiguredInterfaceIps(this.ip4Addresses);
        this.defaultIsisInterface.setInterfaceIpAddress(this.ip4Address);
        this.defaultIsisInterface.setNetworkMask(this.mask1);
        this.defaultIsisInterface.processIsisMessage((IsisMessage)this.p2PHelloPdu, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testStartHelloSender() throws Exception {
        this.defaultIsisInterface.startHelloSender(this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLspKeyP2P() throws Exception {
        this.result5 = this.defaultIsisInterface.lspKeyP2P("1111.1111.1111");
        Assert.assertThat((Object)this.result5, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessLsPduMessage() throws Exception {
        this.lsPdu = new LsPdu(this.isisHeader);
        this.lsPdu.setSourceMac(this.macAddress1);
        this.lsPdu.setIsisPduType(IsisPduType.L2LSPDU.value());
        this.lsPdu.setLspId("1111.1111.1111");
        this.isisMessage = this.lsPdu;
        this.defaultIsisInterface.setNetworkType(IsisNetworkType.P2P);
        this.defaultIsisInterface.setSystemId("1111.1111.1111");
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessPsnPduMessage() throws Exception {
        this.psnp = new Psnp(this.isisHeader);
        this.psnp.setSourceMac(this.macAddress1);
        this.psnp.setIsisPduType(IsisPduType.L2PSNP.value());
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.LSPENTRY.value());
        tlvHeader.setTlvLength(0);
        LspEntriesTlv lspEntriesTlv = new LspEntriesTlv(tlvHeader);
        LspEntry lspEntry = new LspEntry();
        lspEntry.setLspChecksum(0);
        lspEntry.setLspSequenceNumber(0);
        lspEntry.setRemainingTime(0);
        lspEntriesTlv.addLspEntry(lspEntry);
        this.psnp.addTlv((IsisTlv)lspEntriesTlv);
        this.isisMessage = this.psnp;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessCsnPduMessage() throws Exception {
        ChannelBuffer channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.csnpBytes);
        this.csnp = new Csnp(this.isisHeader);
        this.csnp.readFrom(channelBuffer);
        this.csnp.setSourceMac(this.macAddress1);
        this.csnp.setIsisPduType(IsisPduType.L2CSNP.value());
        this.isisMessage = this.csnp;
        this.defaultIsisInterface.processIsisMessage(this.isisMessage, this.isisLsdb, this.channel);
        Assert.assertThat((Object)this.defaultIsisInterface, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

