/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.DefaultIsisNeighbor;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;

public class DefaultIsisNeighborTest {
    private final String areaId = "490001";
    private final String systemId = "2929.2929.2929";
    private final String lanId = "0000.0000.0000.00";
    private DefaultIsisNeighbor isisNeighbor;
    private IsisInterface isisInterface;
    private IsisMessage isisMessage;
    private IsisHeader isisHeader;
    private int result;
    private String result1;
    private Ip4Address interfaceIp = Ip4Address.valueOf((String)"10.10.10.10");
    private Ip4Address result2;
    private MacAddress macAddress = MacAddress.valueOf((String)"a4:23:05:00:00:00");
    private MacAddress result3;
    private IsisRouterType isisRouterType;
    private IsisInterfaceState isisInterfaceState;
    private byte result4;

    @Before
    public void setUp() throws Exception {
        this.isisHeader = new IsisHeader();
        this.isisMessage = new L1L2HelloPdu(this.isisHeader);
        this.isisInterface = new DefaultIsisInterface();
        this.isisNeighbor = new DefaultIsisNeighbor((HelloPdu)this.isisMessage, this.isisInterface);
    }

    @After
    public void tearDown() throws Exception {
        this.isisHeader = null;
        this.isisMessage = null;
        this.isisInterface = null;
        this.isisNeighbor = null;
    }

    @Test
    public void testLocalExtendedCircuitId() throws Exception {
        this.isisNeighbor.setLocalExtendedCircuitId(1);
        this.result = this.isisNeighbor.localExtendedCircuitId();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetLocalExtendedCircuitId() throws Exception {
        this.isisNeighbor.setLocalExtendedCircuitId(1);
        this.result = this.isisNeighbor.localExtendedCircuitId();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNeighborAreaId() throws Exception {
        this.isisNeighbor.setNeighborAreaId("490001");
        this.result1 = this.isisNeighbor.neighborAreaId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"490001"));
    }

    @Test
    public void testSetNeighborAreaId() throws Exception {
        this.isisNeighbor.setNeighborAreaId("490001");
        this.result1 = this.isisNeighbor.neighborAreaId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"490001"));
    }

    @Test
    public void testNeighborSystemId() throws Exception {
        this.isisNeighbor.setNeighborSystemId("2929.2929.2929");
        this.result1 = this.isisNeighbor.neighborSystemId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testSetNeighborSystemId() throws Exception {
        this.isisNeighbor.setNeighborSystemId("2929.2929.2929");
        this.result1 = this.isisNeighbor.neighborSystemId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testInterfaceIp() throws Exception {
        this.isisNeighbor.setInterfaceIp(this.interfaceIp);
        this.result2 = this.isisNeighbor.interfaceIp();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)this.interfaceIp));
    }

    @Test
    public void testSetInterfaceIp() throws Exception {
        this.isisNeighbor.setInterfaceIp(this.interfaceIp);
        this.result2 = this.isisNeighbor.interfaceIp();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)this.interfaceIp));
    }

    @Test
    public void testNeighborMacAddress() throws Exception {
        this.isisNeighbor.setNeighborMacAddress(this.macAddress);
        this.result3 = this.isisNeighbor.neighborMacAddress();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)this.macAddress));
    }

    @Test
    public void testSetNeighborMacAddress() throws Exception {
        this.isisNeighbor.setNeighborMacAddress(this.macAddress);
        this.result3 = this.isisNeighbor.neighborMacAddress();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)this.macAddress));
    }

    @Test
    public void testHoldingTime() throws Exception {
        this.isisNeighbor.setHoldingTime(1);
        this.result = this.isisNeighbor.holdingTime();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetHoldingTime() throws Exception {
        this.isisNeighbor.setHoldingTime(1);
        this.result = this.isisNeighbor.holdingTime();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testRouterType() throws Exception {
        this.isisNeighbor.setRouterType(IsisRouterType.L1);
        this.isisRouterType = this.isisNeighbor.routerType();
        Assert.assertThat((Object)this.isisRouterType, (Matcher)CoreMatchers.is((Object)IsisRouterType.L1));
    }

    @Test
    public void testSetRouterType() throws Exception {
        this.isisNeighbor.setRouterType(IsisRouterType.L1);
        this.isisRouterType = this.isisNeighbor.routerType();
        Assert.assertThat((Object)this.isisRouterType, (Matcher)CoreMatchers.is((Object)IsisRouterType.L1));
    }

    @Test
    public void testL1LanId() throws Exception {
        this.isisNeighbor.setL1LanId("2929.2929.2929");
        this.result1 = this.isisNeighbor.l1LanId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"2929.2929.2929"));
    }

    @Test
    public void testSetL1LanId() throws Exception {
        this.isisNeighbor.setL1LanId("0000.0000.0000.00");
        this.result1 = this.isisNeighbor.l1LanId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"0000.0000.0000.00"));
    }

    @Test
    public void testL2LanId() throws Exception {
        this.isisNeighbor.setL2LanId("0000.0000.0000.00");
        this.result1 = this.isisNeighbor.l2LanId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"0000.0000.0000.00"));
    }

    @Test
    public void testSetL2LanId() throws Exception {
        this.isisNeighbor.setL2LanId("0000.0000.0000.00");
        this.result1 = this.isisNeighbor.l2LanId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)"0000.0000.0000.00"));
    }

    @Test
    public void testInterfaceState() throws Exception {
        this.isisNeighbor.setNeighborState(IsisInterfaceState.DOWN);
        this.isisInterfaceState = this.isisNeighbor.neighborState();
        Assert.assertThat((Object)this.isisInterfaceState, (Matcher)CoreMatchers.is((Object)IsisInterfaceState.DOWN));
    }

    @Test
    public void testSetNeighborState() throws Exception {
        this.isisNeighbor.setNeighborState(IsisInterfaceState.DOWN);
        this.isisInterfaceState = this.isisNeighbor.neighborState();
        Assert.assertThat((Object)this.isisInterfaceState, (Matcher)CoreMatchers.is((Object)IsisInterfaceState.DOWN));
    }

    @Test
    public void testLocalCircuitId() throws Exception {
        this.isisNeighbor.setLocalCircuitId((byte)1);
        this.result4 = this.isisNeighbor.localCircuitId();
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetLocalCircuitId() throws Exception {
        this.isisNeighbor.setLocalCircuitId((byte)1);
        this.result4 = this.isisNeighbor.localCircuitId();
        Assert.assertThat((Object)this.result4, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNeighborState() throws Exception {
        this.isisNeighbor.setNeighborState(IsisInterfaceState.DOWN);
        this.isisInterfaceState = this.isisNeighbor.neighborState();
        Assert.assertThat((Object)this.isisInterfaceState, (Matcher)CoreMatchers.is((Object)IsisInterfaceState.DOWN));
    }

    @Test
    public void testStartHoldingTimeCheck() throws Exception {
        this.isisNeighbor.startHoldingTimeCheck();
        Assert.assertThat((Object)this.isisNeighbor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStopHoldingTimeCheck() throws Exception {
        this.isisNeighbor.stopHoldingTimeCheck();
        Assert.assertThat((Object)this.isisNeighbor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testStartInactivityTimeCheck() throws Exception {
        this.isisNeighbor.startInactivityTimeCheck();
        Assert.assertThat((Object)this.isisNeighbor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testStopInactivityTimeCheck() throws Exception {
        this.isisNeighbor.startInactivityTimeCheck();
        Assert.assertThat((Object)this.isisNeighbor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testNeighborDown() throws Exception {
        this.isisNeighbor.neighborDown();
        Assert.assertThat((Object)this.isisNeighbor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

