/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.DefaultIsisProcess;
import org.onosproject.isis.controller.impl.IsisChannelHandler;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;

public class IsisChannelHandlerTest {
    private final String processId = "1";
    private final byte[] config = new byte[]{0, 0, 0, 0, 0, 0, 0};
    private IsisChannelHandler isisChannelHandler;
    private Controller controller;
    private IsisProcess isisProcess;
    private List<IsisProcess> isisProcessList = new ArrayList<IsisProcess>();
    private ChannelHandlerContext channelHandlerContext;
    private ChannelStateEvent channelStateEvent;
    private ExceptionEvent exceptionEvent;
    private MessageEvent messageEvent;
    private IsisMessage isisMessage;
    private List<IsisInterface> isisInterfaceList = new ArrayList<IsisInterface>();
    private Ip4Address ip4Address = Ip4Address.valueOf((String)"10.10.10.10");

    @Before
    public void setUp() throws Exception {
        this.controller = (Controller)EasyMock.createNiceMock(Controller.class);
        this.isisProcess = (IsisProcess)EasyMock.createNiceMock(IsisProcess.class);
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createNiceMock(ChannelHandlerContext.class);
        this.channelStateEvent = (ChannelStateEvent)EasyMock.createNiceMock(ChannelStateEvent.class);
        this.exceptionEvent = (ExceptionEvent)EasyMock.createNiceMock(ExceptionEvent.class);
        this.messageEvent = (MessageEvent)EasyMock.createNiceMock(MessageEvent.class);
        this.isisMessage = (IsisMessage)EasyMock.createNiceMock(L1L2HelloPdu.class);
        this.isisMessage.setInterfaceIndex(2);
        this.isisChannelHandler = new IsisChannelHandler(this.controller, this.isisProcessList);
    }

    @After
    public void tearDown() throws Exception {
        this.isisChannelHandler = null;
    }

    @Test
    public void testInitializeInterfaceMap() throws Exception {
        this.isisChannelHandler.initializeInterfaceMap();
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testUpdateInterfaceMap() throws Exception {
        DefaultIsisInterface isisInterface = new DefaultIsisInterface();
        DefaultIsisInterface isisInterface1 = new DefaultIsisInterface();
        isisInterface.setInterfaceIpAddress(this.ip4Address);
        isisInterface.setInterfaceIndex(1);
        this.isisInterfaceList.add((IsisInterface)isisInterface);
        DefaultIsisProcess isisProcess = new DefaultIsisProcess();
        isisProcess.setIsisInterfaceList(this.isisInterfaceList);
        this.isisProcessList.add((IsisProcess)isisProcess);
        this.isisChannelHandler.updateInterfaceMap(this.isisProcessList);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.isisProcessList = new ArrayList<IsisProcess>();
        isisInterface1.setInterfaceIpAddress(this.ip4Address);
        isisInterface1.setInterfaceIndex(1);
        isisInterface1.setInterfaceIpAddress(this.ip4Address);
        isisInterface1.setInterfaceIndex(1);
        isisInterface1.setSystemId("9999.9999.9999");
        isisInterface1.setIntermediateSystemName("router");
        isisInterface1.setReservedPacketCircuitType(3);
        isisInterface1.setCircuitId("10");
        isisInterface1.setNetworkType(IsisNetworkType.BROADCAST);
        isisInterface1.setAreaAddress("490001");
        isisInterface1.setHoldingTime(50);
        isisInterface1.setHelloInterval(10);
        this.isisInterfaceList.add((IsisInterface)isisInterface1);
        isisProcess.setIsisInterfaceList(this.isisInterfaceList);
        this.isisProcessList.add((IsisProcess)isisProcess);
        this.isisChannelHandler.updateInterfaceMap(this.isisProcessList);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInitializeInterfaceIpList() throws Exception {
        this.isisChannelHandler.initializeInterfaceIpList();
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testChannelConnected() throws Exception {
        this.isisChannelHandler.channelConnected(this.channelHandlerContext, this.channelStateEvent);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testChannelDisconnected() throws Exception {
        this.isisChannelHandler.channelDisconnected(this.channelHandlerContext, this.channelStateEvent);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testExceptionCaught() throws Exception {
        this.isisChannelHandler.exceptionCaught(this.channelHandlerContext, this.exceptionEvent);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testMessageReceived() throws Exception {
        this.isisChannelHandler.messageReceived(this.channelHandlerContext, this.messageEvent);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessIsisMessage() throws Exception {
        this.isisChannelHandler.processIsisMessage(this.isisMessage, this.channelHandlerContext);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStartHelloSender() throws Exception {
        this.isisChannelHandler.startHelloSender();
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStopHelloSender() throws Exception {
        this.isisChannelHandler.stopHelloSender();
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSentConfigPacket() throws Exception {
        this.isisChannelHandler.sentConfigPacket(this.config);
        Assert.assertThat((Object)this.isisChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

