/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.IsisHelloPduSender;

public class IsisHelloPduSenderTest {
    private final String systemId = "1234.1234.1234";
    private final String areaId = "490001";
    private final String circuitId = "0";
    private final String lanId = "0000.0000.0000.00";
    private Channel channel;
    private DefaultIsisInterface isisInterface;
    private DefaultIsisInterface isisInterface1;
    private IsisHelloPduSender isisHelloPduSender;
    private IsisHelloPduSender isisHelloPduSender1;
    private Ip4Address interfaceAddress = Ip4Address.valueOf((String)"10.10.10.10");

    @Before
    public void setUp() throws Exception {
        this.channel = (Channel)EasyMock.createNiceMock(Channel.class);
        this.isisInterface = new DefaultIsisInterface();
        this.isisInterface1 = new DefaultIsisInterface();
    }

    @After
    public void tearDown() throws Exception {
        this.channel = null;
        this.isisInterface = null;
    }

    @Test(expected=Exception.class)
    public void testRun() throws Exception {
        this.isisInterface.setNetworkType(IsisNetworkType.P2P);
        this.isisInterface.setCircuitId("0");
        this.isisInterface.setSystemId("1234.1234.1234");
        this.isisInterface.setAreaAddress("490001");
        this.isisInterface.setInterfaceIpAddress(this.interfaceAddress);
        this.isisHelloPduSender = new IsisHelloPduSender(this.channel, (IsisInterface)this.isisInterface);
        this.isisHelloPduSender.run();
        Assert.assertThat((Object)this.isisHelloPduSender, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.isisInterface1.setNetworkType(IsisNetworkType.BROADCAST);
        this.isisInterface1.setCircuitId("0");
        this.isisInterface1.setSystemId("1234.1234.1234");
        this.isisInterface1.setAreaAddress("490001");
        this.isisInterface1.setInterfaceIpAddress(this.interfaceAddress);
        this.isisInterface1.setReservedPacketCircuitType(1);
        this.isisInterface1.setL1LanId("0000.0000.0000.00");
        this.isisHelloPduSender1 = new IsisHelloPduSender(this.channel, (IsisInterface)this.isisInterface1);
        this.isisHelloPduSender1.run();
        Assert.assertThat((Object)this.isisHelloPduSender1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.isisInterface1.setNetworkType(IsisNetworkType.BROADCAST);
        this.isisInterface1.setCircuitId("0");
        this.isisInterface1.setSystemId("1234.1234.1234");
        this.isisInterface1.setAreaAddress("490001");
        this.isisInterface1.setInterfaceIpAddress(this.interfaceAddress);
        this.isisInterface1.setReservedPacketCircuitType(2);
        this.isisInterface1.setL2LanId("0000.0000.0000.00");
        this.isisHelloPduSender1 = new IsisHelloPduSender(this.channel, (IsisInterface)this.isisInterface1);
        this.isisHelloPduSender1.run();
        Assert.assertThat((Object)this.isisHelloPduSender1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.isisInterface1.setNetworkType(IsisNetworkType.BROADCAST);
        this.isisInterface1.setCircuitId("0");
        this.isisInterface1.setSystemId("1234.1234.1234");
        this.isisInterface1.setAreaAddress("490001");
        this.isisInterface1.setInterfaceIpAddress(this.interfaceAddress);
        this.isisInterface1.setReservedPacketCircuitType(3);
        this.isisInterface1.setL1LanId("0000.0000.0000.00");
        this.isisInterface1.setL2LanId("0000.0000.0000.00");
        this.isisHelloPduSender1 = new IsisHelloPduSender(this.channel, (IsisInterface)this.isisInterface1);
        this.isisHelloPduSender1.run();
        Assert.assertThat((Object)this.isisHelloPduSender1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

