/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import com.google.common.primitives.Bytes;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.impl.IsisMessageEncoder;
import org.onosproject.isis.io.util.IsisUtil;

public class IsisMessageEncoderTest {
    private final String id = "127.0.0.1";
    private final byte[] hello = new byte[]{-125, 20, 1, 0, 17, 1, 0, 0, 2, 51, 51, 51, 51, 51, 51, 0, 100, 5, -39, -126, 1, 4, 3, 73, 0, 0, -127, 1, -52, -124, 4, -64, -88, 56, 102};
    private IsisMessageEncoder isisMessageEncoder;
    private ChannelHandlerContext ctx;
    private Channel channel;
    private SocketAddress socketAddress;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.isisMessageEncoder = new IsisMessageEncoder();
    }

    @After
    public void tearDown() throws Exception {
        this.channel = null;
        this.isisMessageEncoder = null;
    }

    @Test
    public void testEncode() throws Exception {
        this.socketAddress = InetSocketAddress.createUnresolved("127.0.0.1", 7000);
        byte[] array = IsisUtil.getPaddingTlvs((int)this.hello.length);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{this.hello, array}));
        MatcherAssert.assertThat((Object)this.isisMessageEncoder.encode(this.ctx, this.channel, (Object)this.channelBuffer.array()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

