/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.channel.ChannelPipeline;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.DefaultIsisProcess;
import org.onosproject.isis.controller.impl.IsisChannelHandler;
import org.onosproject.isis.controller.impl.IsisPipelineFactory;

public class IsisPipelineFactoryTest {
    private IsisPipelineFactory isisPipelineFactory;
    private IsisChannelHandler isisChannelHandler;
    private List<IsisProcess> isisProcessList = new ArrayList<IsisProcess>();
    private Controller controller;
    private ChannelPipeline channelPipeline;
    private DefaultIsisProcess isisProcess;
    private String processId = "1";
    private DefaultIsisInterface isisInterface;
    private List<IsisInterface> isisInterfaces = new ArrayList<IsisInterface>();

    @Before
    public void setUp() throws Exception {
        this.controller = new Controller();
        this.isisProcess = new DefaultIsisProcess();
        this.isisInterface = new DefaultIsisInterface();
        this.isisInterfaces.add((IsisInterface)this.isisInterface);
        this.isisProcess.setIsisInterfaceList(this.isisInterfaces);
        this.isisProcess.setProcessId(this.processId);
        this.isisProcessList.add((IsisProcess)this.isisProcess);
        this.isisChannelHandler = new IsisChannelHandler(this.controller, this.isisProcessList);
        this.isisPipelineFactory = new IsisPipelineFactory(this.isisChannelHandler);
    }

    @After
    public void tearDown() throws Exception {
        this.controller = null;
        this.isisChannelHandler = null;
        this.isisPipelineFactory = null;
    }

    @Test
    public void testGetPipeline() throws Exception {
        this.channelPipeline = this.isisPipelineFactory.getPipeline();
        Assert.assertThat((Object)this.channelPipeline, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ChannelPipeline.class)));
    }
}

