/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisLspBin;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdbAge;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLspBin;
import org.onosproject.isis.controller.impl.lsdb.DefaultLspWrapper;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;

public class DefaultIsisLsdbAgeTest {
    private DefaultIsisLsdbAge defaultIsisLsdbAge;
    private IsisLspBin isisLspBin;
    private int resultInt;
    private IsisLspBin resultLspBin;
    private DefaultLspWrapper lspWrapper;
    private LsPdu lsPdu;
    private IsisHeader isisHeader;
    private String lspId = "1234.1234.1234";

    @Before
    public void setUp() throws Exception {
        this.defaultIsisLsdbAge = new DefaultIsisLsdbAge();
        this.isisLspBin = new DefaultIsisLspBin(1);
        this.lspWrapper = new DefaultLspWrapper();
        this.lspWrapper.setBinNumber(1);
        this.isisHeader = new IsisHeader();
        this.lsPdu = new LsPdu(this.isisHeader);
        this.lsPdu.setLspId(this.lspId);
        this.lspWrapper.setLsPdu(this.lsPdu);
    }

    @After
    public void tearDown() throws Exception {
        this.defaultIsisLsdbAge = null;
        this.isisLspBin = null;
    }

    @Test
    public void testAgeCounter() throws Exception {
        this.resultInt = this.defaultIsisLsdbAge.ageCounter();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAgeCounterRollOver() throws Exception {
        this.resultInt = this.defaultIsisLsdbAge.ageCounterRollOver();
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAddLspBin() throws Exception {
        this.defaultIsisLsdbAge.addLspBin(1400, this.isisLspBin);
        this.resultLspBin = this.defaultIsisLsdbAge.getLspBin(1);
        Assert.assertThat((Object)this.resultLspBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLspBin() throws Exception {
        this.defaultIsisLsdbAge.addLspBin(1, this.isisLspBin);
        this.resultLspBin = this.defaultIsisLsdbAge.getLspBin(1);
        Assert.assertThat((Object)this.resultLspBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveLspFromBin() throws Exception {
        this.defaultIsisLsdbAge.addLspBin(1400, this.isisLspBin);
        this.defaultIsisLsdbAge.removeLspFromBin((LspWrapper)this.lspWrapper);
        Assert.assertThat((Object)this.resultLspBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testAge2Bin() throws Exception {
        this.defaultIsisLsdbAge.age2Bin(1);
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.defaultIsisLsdbAge.age2Bin(-1);
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStartDbAging() throws Exception {
        this.defaultIsisLsdbAge.startDbAging();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAgeLsp() throws Exception {
        this.defaultIsisLsdbAge.age2Bin(1);
        this.defaultIsisLsdbAge.startDbAging();
        this.defaultIsisLsdbAge.ageLsp();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testMaxAgeLsa() throws Exception {
        this.defaultIsisLsdbAge.age2Bin(1);
        this.defaultIsisLsdbAge.startDbAging();
        this.defaultIsisLsdbAge.maxAgeLsa();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.defaultIsisLsdbAge.age2Bin(1400);
        this.defaultIsisLsdbAge.startDbAging();
        this.defaultIsisLsdbAge.maxAgeLsa();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRefreshLsa() throws Exception {
        this.defaultIsisLsdbAge.age2Bin(1);
        this.defaultIsisLsdbAge.startDbAging();
        this.defaultIsisLsdbAge.refreshLsa();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.defaultIsisLsdbAge.age2Bin(1400);
        this.defaultIsisLsdbAge.startDbAging();
        this.defaultIsisLsdbAge.refreshLsa();
        Assert.assertThat((Object)this.defaultIsisLsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

