/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisLsdbAge;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdb;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.AttachedToOtherAreas;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;

public class DefaultIsisLsdbTest {
    private final int l1LspSeqNo = 1;
    private final int l2LspSeqNo = 1;
    private final String srcId = "1111.1111.1111";
    private DefaultIsisLsdb defaultIsisLsdb;
    private IsisLsdbAge lsdbAge = null;
    private int resultInt;
    private Map<String, LspWrapper> resultMap = new ConcurrentHashMap<String, LspWrapper>();
    private IsisLsdb resultLsdb;
    private LspWrapper resultLspWrapper;
    private List<LspWrapper> lspWrapperList;
    private LsPdu lsPdu;
    private IsisHeader isisHeader;
    private DefaultIsisInterface defaultIsisInterface;
    private String lspId = "1234.1234.1234.00-00";
    private String result;

    @Before
    public void setUp() throws Exception {
        this.defaultIsisInterface = new DefaultIsisInterface();
        this.isisHeader = new IsisHeader();
        this.lsPdu = new LsPdu(this.isisHeader);
        this.lsPdu.setLspId(this.lspId);
        this.lsPdu.setAttachedToOtherAreas(AttachedToOtherAreas.DEFAULTMETRIC);
        this.lsPdu.setIsisPduType(IsisPduType.L1LSPDU.value());
        this.defaultIsisLsdb = new DefaultIsisLsdb();
    }

    @After
    public void tearDown() throws Exception {
        this.defaultIsisLsdb = null;
    }

    @Test
    public void testInitializeDb() throws Exception {
        this.defaultIsisLsdb.initializeDb();
        Assert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testSetL1LspSeqNo() throws Exception {
        this.defaultIsisLsdb.setL1LspSeqNo(1);
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetL2LspSeqNo() throws Exception {
        this.defaultIsisLsdb.setL2LspSeqNo(1);
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLspKey() throws Exception {
        this.defaultIsisLsdb.lspKey("1111.1111.1111");
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetL1Db() throws Exception {
        this.resultMap = this.defaultIsisLsdb.getL1Db();
        Assert.assertThat((Object)this.resultMap.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetL2Db() throws Exception {
        this.resultMap = this.defaultIsisLsdb.getL2Db();
        Assert.assertThat((Object)this.resultMap.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsisLsdb() throws Exception {
        this.resultLsdb = this.defaultIsisLsdb.isisLsdb();
        Assert.assertThat((Object)this.resultLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testFindLsp() throws Exception {
        this.resultLspWrapper = this.defaultIsisLsdb.findLsp(IsisPduType.L1HELLOPDU, "1111.1111.1111");
        Assert.assertThat((Object)this.resultLspWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testAllLspHeaders() throws Exception {
        this.defaultIsisLsdb.addLsp((IsisMessage)this.lsPdu, false, (IsisInterface)this.defaultIsisInterface);
        this.lspWrapperList = this.defaultIsisLsdb.allLspHeaders(true);
        Assert.assertThat(this.lspWrapperList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.defaultIsisLsdb.addLsp((IsisMessage)this.lsPdu, true, (IsisInterface)this.defaultIsisInterface);
        this.lspWrapperList = this.defaultIsisLsdb.allLspHeaders(true);
        Assert.assertThat(this.lspWrapperList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsNewerOrSameLsp() throws Exception {
        this.result = this.defaultIsisLsdb.isNewerOrSameLsp((IsisMessage)this.lsPdu, (IsisMessage)this.lsPdu);
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)"same"));
    }

    @Test
    public void testLsSequenceNumber() throws Exception {
        this.resultInt = this.defaultIsisLsdb.lsSequenceNumber(IsisPduType.L1LSPDU);
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
        this.resultInt = this.defaultIsisLsdb.lsSequenceNumber(IsisPduType.L2LSPDU);
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
        this.resultInt = this.defaultIsisLsdb.lsSequenceNumber(IsisPduType.L1CSNP);
        Assert.assertThat((Object)this.resultInt, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testdeleteLsp() throws Exception {
        this.defaultIsisLsdb.deleteLsp((IsisMessage)this.lsPdu);
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.lsPdu.setIsisPduType(IsisPduType.L2LSPDU.value());
        this.defaultIsisLsdb.deleteLsp((IsisMessage)this.lsPdu);
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.lsPdu.setIsisPduType(IsisPduType.L1CSNP.value());
        this.defaultIsisLsdb.deleteLsp((IsisMessage)this.lsPdu);
        Assert.assertThat((Object)this.defaultIsisLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

