/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl.lsdb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisLsdbAge;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.impl.DefaultIsisInterface;
import org.onosproject.isis.controller.impl.lsdb.DefaultIsisLsdbAge;
import org.onosproject.isis.controller.impl.lsdb.DefaultLspWrapper;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;

public class DefaultLspWrapperTest {
    private DefaultLspWrapper defaultLspWrapper;
    private String processing = "processing";
    private String result;
    private int result1;
    private IsisInterface isisInterface;
    private IsisInterface result2;
    private IsisPduType isisPduType;
    private boolean result3;
    private LsPdu lsPdu;
    private LsPdu pdu;
    private DefaultIsisLsdbAge defaultIsisLsdbAge;
    private IsisLsdbAge lsdbAge;

    @Before
    public void setUp() throws Exception {
        this.defaultLspWrapper = new DefaultLspWrapper();
        this.isisInterface = new DefaultIsisInterface();
        this.pdu = new LsPdu(new IsisHeader());
        this.defaultIsisLsdbAge = new DefaultIsisLsdbAge();
        this.defaultIsisLsdbAge.startDbAging();
    }

    @After
    public void tearDown() throws Exception {
        this.defaultLspWrapper = null;
    }

    @Test
    public void testLspProcessing() throws Exception {
        this.defaultLspWrapper.setLspProcessing(this.processing);
        this.result = this.defaultLspWrapper.lspProcessing();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLspProcessing() throws Exception {
        this.defaultLspWrapper.setLspProcessing(this.processing);
        this.result = this.defaultLspWrapper.lspProcessing();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLspAgeReceived() throws Exception {
        this.defaultLspWrapper.setLspAgeReceived(1);
        this.result1 = this.defaultLspWrapper.lspAgeReceived();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLspAgeReceived() throws Exception {
        this.defaultLspWrapper.setLspAgeReceived(1);
        this.result1 = this.defaultLspWrapper.lspAgeReceived();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsisInterface() throws Exception {
        this.defaultLspWrapper.setIsisInterface(this.isisInterface);
        this.result2 = this.defaultLspWrapper.isisInterface();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetIsisInterface() throws Exception {
        this.defaultLspWrapper.setIsisInterface(this.isisInterface);
        this.result2 = this.defaultLspWrapper.isisInterface();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAgeCounterWhenReceived() throws Exception {
        this.defaultLspWrapper.setAgeCounterWhenReceived(1);
        this.result1 = this.defaultLspWrapper.ageCounterWhenReceived();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetAgeCounterWhenReceived() throws Exception {
        this.defaultLspWrapper.setAgeCounterWhenReceived(1);
        this.result1 = this.defaultLspWrapper.ageCounterWhenReceived();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAgeCounterRollOverWhenAdded() throws Exception {
        this.defaultLspWrapper.setAgeCounterRollOverWhenAdded(1);
        this.result1 = this.defaultLspWrapper.ageCounterRollOverWhenAdded();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetAgeCounterRollOverWhenAdded() throws Exception {
        this.defaultLspWrapper.setAgeCounterRollOverWhenAdded(1);
        this.result1 = this.defaultLspWrapper.ageCounterRollOverWhenAdded();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLspType() throws Exception {
        this.defaultLspWrapper.setLspType(IsisPduType.L1LSPDU);
        this.isisPduType = this.defaultLspWrapper.lspType();
        Assert.assertThat((Object)this.isisPduType, (Matcher)CoreMatchers.is((Object)IsisPduType.L1LSPDU));
    }

    @Test
    public void testSetLspType() throws Exception {
        this.defaultLspWrapper.setLspType(IsisPduType.L1LSPDU);
        this.isisPduType = this.defaultLspWrapper.lspType();
        Assert.assertThat((Object)this.isisPduType, (Matcher)CoreMatchers.is((Object)IsisPduType.L1LSPDU));
    }

    @Test
    public void testIsSelfOriginated() throws Exception {
        this.defaultLspWrapper.setSelfOriginated(true);
        this.result3 = this.defaultLspWrapper.isSelfOriginated();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetSelfOriginated() throws Exception {
        this.defaultLspWrapper.setSelfOriginated(true);
        this.result3 = this.defaultLspWrapper.isSelfOriginated();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testBinNumber() throws Exception {
        this.defaultLspWrapper.setBinNumber(1);
        this.result1 = this.defaultLspWrapper.binNumber();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetBinNumber() throws Exception {
        this.defaultLspWrapper.setBinNumber(1);
        this.result1 = this.defaultLspWrapper.binNumber();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testLsPdu() throws Exception {
        this.defaultLspWrapper.setLsPdu(this.pdu);
        this.lsPdu = this.defaultLspWrapper.lsPdu();
        Assert.assertThat((Object)this.lsPdu, (Matcher)CoreMatchers.is((Object)this.pdu));
    }

    @Test
    public void testSetLsPdu() throws Exception {
        this.defaultLspWrapper.setLsPdu(this.pdu);
        this.lsPdu = this.defaultLspWrapper.lsPdu();
        Assert.assertThat((Object)this.lsPdu, (Matcher)CoreMatchers.is((Object)this.pdu));
    }

    @Test
    public void testlsdbAge() throws Exception {
        this.defaultLspWrapper.setLsdbAge((IsisLsdbAge)this.defaultIsisLsdbAge);
        this.lsdbAge = this.defaultLspWrapper.lsdbAge();
        Assert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Object)this.defaultIsisLsdbAge));
    }

    @Test
    public void testSetLsdbAge() throws Exception {
        this.defaultLspWrapper.setLsdbAge((IsisLsdbAge)this.defaultIsisLsdbAge);
        this.lsdbAge = this.defaultLspWrapper.lsdbAge();
        Assert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Object)this.defaultIsisLsdbAge));
    }

    @Test
    public void testRemainingLifetime() throws Exception {
        this.defaultLspWrapper.setLsdbAge((IsisLsdbAge)this.defaultIsisLsdbAge);
        this.defaultLspWrapper.setAgeCounterWhenReceived(1);
        this.defaultLspWrapper.currentAge();
        this.defaultLspWrapper.setRemainingLifetime(1);
        this.result1 = this.defaultLspWrapper.remainingLifetime();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetRemainingLifetime() throws Exception {
        this.defaultLspWrapper.setLsdbAge((IsisLsdbAge)this.defaultIsisLsdbAge);
        this.defaultLspWrapper.setAgeCounterWhenReceived(1);
        this.defaultLspWrapper.currentAge();
        this.defaultLspWrapper.setRemainingLifetime(1);
        this.result1 = this.defaultLspWrapper.remainingLifetime();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)1));
    }
}

