/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.isis.controller.IsisController;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.impl.Controller;
import org.onosproject.isis.controller.topology.IsisAgent;
import org.onosproject.isis.controller.topology.IsisLink;
import org.onosproject.isis.controller.topology.IsisLinkListener;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.controller.topology.IsisRouterListener;
import org.onosproject.net.driver.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultIsisController
implements IsisController {
    protected static final Logger log = LoggerFactory.getLogger(DefaultIsisController.class);
    private final Controller controller = new Controller();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    protected Set<IsisRouterListener> isisRouterListener = new HashSet<IsisRouterListener>();
    protected Set<IsisLinkListener> isisLinkListener = Sets.newHashSet();
    protected IsisAgent agent = new InternalDeviceConfig();

    @Activate
    public void activate() {
        log.debug("ISISControllerImpl activate");
        this.controller.setAgent(this.agent);
    }

    @Deactivate
    public void deactivate() {
        this.controller.isisDeactivate();
        log.debug("ISISControllerImpl deActivate");
    }

    public void addRouterListener(IsisRouterListener listener) {
        if (!this.isisRouterListener.contains(listener)) {
            this.isisRouterListener.add(listener);
        }
    }

    public void removeRouterListener(IsisRouterListener listener) {
        this.isisRouterListener.remove(listener);
    }

    public void addLinkListener(IsisLinkListener listener) {
        this.isisLinkListener.add(listener);
    }

    public void removeLinkListener(IsisLinkListener listener) {
        this.isisLinkListener.remove(listener);
    }

    public Set<IsisRouterListener> listener() {
        return this.isisRouterListener;
    }

    public Set<IsisLinkListener> linkListener() {
        return this.isisLinkListener;
    }

    public List<IsisProcess> allConfiguredProcesses() {
        List<IsisProcess> processes = this.controller.getAllConfiguredProcesses();
        return processes;
    }

    public void updateConfig(JsonNode jsonNode) {
        log.debug("updateConfig::IsisList::processes::{}", (Object)jsonNode);
        try {
            this.controller.updateConfig(jsonNode);
        }
        catch (Exception e) {
            log.debug("Error::updateConfig::{}", (Object)e.getMessage());
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalDeviceConfig
    implements IsisAgent {
        private InternalDeviceConfig() {
        }

        public boolean addConnectedRouter(IsisRouter isisRouter) {
            for (IsisRouterListener l : DefaultIsisController.this.listener()) {
                l.routerAdded(isisRouter);
            }
            return true;
        }

        public void removeConnectedRouter(IsisRouter isisRouter) {
            for (IsisRouterListener l : DefaultIsisController.this.listener()) {
                l.routerRemoved(isisRouter);
            }
        }

        public void addLink(IsisLink isisLink) {
            for (IsisLinkListener l : DefaultIsisController.this.linkListener()) {
                l.addLink(isisLink);
            }
        }

        public void deleteLink(IsisLink isisLink) {
            for (IsisLinkListener l : DefaultIsisController.this.linkListener()) {
                l.deleteLink(isisLink);
            }
        }
    }
}

