/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.controller.IsisLsdb;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.controller.IsisNeighbor;
import org.onosproject.isis.controller.IsisNetworkType;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.controller.LspWrapper;
import org.onosproject.isis.controller.impl.DefaultIsisNeighbor;
import org.onosproject.isis.controller.impl.IsisHelloPduSender;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.Csnp;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.pdu.P2PHelloPdu;
import org.onosproject.isis.io.isispacket.pdu.Psnp;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntriesTlv;
import org.onosproject.isis.io.isispacket.tlv.LspEntry;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.util.IsisUtil;
import org.onosproject.isis.io.util.LspGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIsisInterface
implements IsisInterface {
    private static final Logger log = LoggerFactory.getLogger(DefaultIsisInterface.class);
    boolean flagValue = false;
    private int interfaceIndex;
    private Ip4Address interfaceIpAddress;
    private byte[] networkMask;
    private MacAddress interfaceMacAddress;
    private String intermediateSystemName;
    private String systemId;
    private String l1LanId = "0000.0000.0000.00";
    private String l2LanId = "0000.0000.0000.00";
    private int idLength;
    private int maxAreaAddresses;
    private int reservedPacketCircuitType;
    private IsisNetworkType networkType;
    private String areaAddress;
    private int areaLength;
    private int holdingTime;
    private int priority;
    private String circuitId;
    private int helloInterval;
    private Map<MacAddress, IsisNeighbor> neighborList = new ConcurrentHashMap<MacAddress, IsisNeighbor>();
    private IsisHelloPduSender isisHelloPduSender = null;
    private ScheduledExecutorService exServiceHello = null;
    private IsisInterfaceState interfaceState = IsisInterfaceState.DOWN;
    private IsisLsdb isisLsdb = null;
    private List<Ip4Address> allConfiguredInterfaceIps = null;
    private Channel channel;
    private boolean helloSenderStarted = false;

    public IsisLsdb isisLsdb() {
        return this.isisLsdb;
    }

    public void setAllConfiguredInterfaceIps(List<Ip4Address> allConfiguredInterfaces) {
        this.allConfiguredInterfaceIps = allConfiguredInterfaces;
    }

    public void removeNeighbor(IsisNeighbor isisNeighbor) {
        log.debug("Neighbor removed - {}", (Object)isisNeighbor.neighborMacAddress());
        isisNeighbor.stopHoldingTimeCheck();
        isisNeighbor.stopInactivityTimeCheck();
        this.neighborList.remove(isisNeighbor.neighborMacAddress());
    }

    public void removeNeighbors() {
        Set<MacAddress> neighbors = this.neighbors();
        for (MacAddress mac : neighbors) {
            this.removeNeighbor(this.lookup(mac));
            log.debug("Neighbor removed - {}", (Object)mac);
        }
        this.neighborList.clear();
    }

    public IsisNeighbor lookup(MacAddress isisNeighborMac) {
        return this.neighborList.get(isisNeighborMac);
    }

    public Set<MacAddress> neighbors() {
        return this.neighborList.keySet();
    }

    public Channel channel() {
        return this.channel;
    }

    public int interfaceIndex() {
        return this.interfaceIndex;
    }

    public void setInterfaceIndex(int interfaceIndex) {
        this.interfaceIndex = interfaceIndex;
    }

    public Ip4Address interfaceIpAddress() {
        return this.interfaceIpAddress;
    }

    public void setInterfaceIpAddress(Ip4Address interfaceIpAddress) {
        this.interfaceIpAddress = interfaceIpAddress;
    }

    public byte[] networkMask() {
        return this.networkMask;
    }

    public void setNetworkMask(byte[] networkMask) {
        this.networkMask = networkMask;
    }

    public MacAddress getInterfaceMacAddress() {
        return this.interfaceMacAddress;
    }

    public void setInterfaceMacAddress(MacAddress interfaceMacAddress) {
        this.interfaceMacAddress = interfaceMacAddress;
    }

    public String intermediateSystemName() {
        return this.intermediateSystemName;
    }

    public void setIntermediateSystemName(String intermediateSystemName) {
        this.intermediateSystemName = intermediateSystemName;
    }

    public String systemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String l1LanId() {
        return this.l1LanId;
    }

    public void setL1LanId(String l1LanId) {
        this.l1LanId = l1LanId;
    }

    public String l2LanId() {
        return this.l2LanId;
    }

    public void setL2LanId(String l2LanId) {
        this.l2LanId = l2LanId;
    }

    public int getIdLength() {
        return this.idLength == 0 ? 6 : this.idLength;
    }

    public void setIdLength(int idLength) {
        this.idLength = idLength;
    }

    public int getMaxAreaAddresses() {
        return this.maxAreaAddresses;
    }

    public void setMaxAreaAddresses(int maxAreaAddresses) {
        this.maxAreaAddresses = maxAreaAddresses;
    }

    public int reservedPacketCircuitType() {
        return this.reservedPacketCircuitType;
    }

    public void setReservedPacketCircuitType(int reservedPacketCircuitType) {
        this.reservedPacketCircuitType = reservedPacketCircuitType;
    }

    public IsisNetworkType networkType() {
        return this.networkType;
    }

    public void setNetworkType(IsisNetworkType networkType) {
        this.networkType = networkType;
    }

    public String areaAddress() {
        return this.areaAddress;
    }

    public void setAreaAddress(String areaAddress) {
        this.areaAddress = areaAddress;
    }

    public int getAreaLength() {
        return this.areaLength;
    }

    public void setAreaLength(int areaLength) {
        this.areaLength = areaLength;
    }

    public int holdingTime() {
        return this.holdingTime;
    }

    public void setHoldingTime(int holdingTime) {
        this.holdingTime = holdingTime;
    }

    public int priority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int helloInterval() {
        return this.helloInterval;
    }

    public void setHelloInterval(int helloInterval) {
        this.helloInterval = helloInterval;
    }

    public IsisInterfaceState interfaceState() {
        return this.interfaceState;
    }

    public void setInterfaceState(IsisInterfaceState interfaceState) {
        this.interfaceState = interfaceState;
    }

    public String circuitId() {
        return this.circuitId;
    }

    public void setCircuitId(String circuitId) {
        this.circuitId = circuitId;
    }

    public void processIsisMessage(IsisMessage isisMessage, IsisLsdb isisLsdb, Channel channel) {
        log.debug("IsisInterfaceImpl::processIsisMessage...!!!");
        this.channel = channel;
        if (isisMessage.sourceMac().equals((Object)this.interfaceMacAddress)) {
            log.debug("Received our own message {}...!!!", (Object)isisMessage.isisPduType());
            return;
        }
        if (isisMessage.isisPduType() == IsisPduType.P2PHELLOPDU && this.networkType.equals((Object)IsisNetworkType.BROADCAST)) {
            return;
        }
        if ((isisMessage.isisPduType() == IsisPduType.L1HELLOPDU || isisMessage.isisPduType() == IsisPduType.L2HELLOPDU) && this.networkType.equals((Object)IsisNetworkType.P2P)) {
            return;
        }
        if (this.isisLsdb == null) {
            this.isisLsdb = isisLsdb;
        }
        switch (isisMessage.isisPduType()) {
            case L1HELLOPDU: 
            case L2HELLOPDU: {
                this.processL1L2HelloPduMessage(isisMessage, channel);
                break;
            }
            case P2PHELLOPDU: {
                this.processP2pHelloPduMessage(isisMessage, channel);
                break;
            }
            case L1LSPDU: 
            case L2LSPDU: {
                this.processLsPduMessage(isisMessage, channel);
                break;
            }
            case L1CSNP: 
            case L2CSNP: {
                this.processCsnPduMessage(isisMessage, channel);
                break;
            }
            case L1PSNP: 
            case L2PSNP: {
                this.processPsnPduMessage(isisMessage, channel);
                break;
            }
            default: {
                log.debug("Unknown packet to process...!!!");
            }
        }
    }

    public boolean validateHelloMessage(HelloPdu helloPdu) {
        Ip4Address neighborIp;
        boolean isValid = false;
        if (helloPdu.circuitType() == IsisRouterType.L1.value() && this.reservedPacketCircuitType == IsisRouterType.L2.value() || helloPdu.circuitType() == IsisRouterType.L2.value() && this.reservedPacketCircuitType == IsisRouterType.L1.value()) {
            return false;
        }
        List interfaceIpAddresses = helloPdu.interfaceIpAddresses();
        Ip4Address ip4Address = neighborIp = helloPdu.interfaceIpAddresses() != null ? (Ip4Address)interfaceIpAddresses.get(0) : Ip4Address.valueOf((String)"0.0.0.0");
        if (!IsisUtil.sameNetwork((Ip4Address)this.interfaceIpAddress, (Ip4Address)neighborIp, (byte[])this.networkMask)) {
            return false;
        }
        if (helloPdu.circuitType() == IsisRouterType.L1.value()) {
            List areas = helloPdu.areaAddress();
            for (String area : areas) {
                if (!this.areaAddress.equals(area)) continue;
                isValid = true;
            }
        } else if (helloPdu.circuitType() == IsisRouterType.L2.value() || helloPdu.circuitType() == IsisRouterType.L1L2.value()) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isNeighborInList(MacAddress neighborMac) {
        return this.neighborList.containsKey(neighborMac);
    }

    private void addNeighbouringRouter(IsisNeighbor neighbor) {
        this.neighborList.put(neighbor.neighborMacAddress(), neighbor);
    }

    private IsisNeighbor neighbouringRouter(MacAddress neighborMac) {
        return this.neighborList.get(neighborMac);
    }

    public void processL1L2HelloPduMessage(IsisMessage isisMessage, Channel channel) {
        log.debug("Enters processL1L2HelloPduMessage ...!!!");
        log.debug("IsisInterfaceImpl::processHelloMessage...!!!");
        L1L2HelloPdu helloPacket = (L1L2HelloPdu)isisMessage;
        log.debug("IsisInterfaceImpl::processHelloMessage::Interface Type {} ISISInterfaceState {} ", (Object)this.networkType, (Object)this.interfaceState);
        if (!this.validateHelloMessage((HelloPdu)helloPacket)) {
            return;
        }
        IsisNeighbor neighbor = this.neighbouringRouter(isisMessage.sourceMac());
        if (!this.isNeighborInList(isisMessage.sourceMac())) {
            neighbor = new DefaultIsisNeighbor((HelloPdu)helloPacket, this);
            this.addNeighbouringRouter(neighbor);
        }
        neighbor.setHoldingTime(helloPacket.holdingTime());
        neighbor.stopInactivityTimeCheck();
        neighbor.startInactivityTimeCheck();
        String lanId = helloPacket.lanId();
        if (IsisPduType.L1HELLOPDU == helloPacket.isisPduType()) {
            this.buildUpdateAndSendSelfGeneratedLspIfDisChange(this.l1LanId, lanId, channel, IsisRouterType.get((int)helloPacket.circuitType()));
            this.l1LanId = lanId;
            neighbor.setL1LanId(lanId);
        } else if (IsisPduType.L2HELLOPDU == helloPacket.isisPduType()) {
            this.buildUpdateAndSendSelfGeneratedLspIfDisChange(this.l2LanId, lanId, channel, IsisRouterType.get((int)helloPacket.circuitType()));
            this.l2LanId = lanId;
            neighbor.setL2LanId(lanId);
        }
        List neighbors = helloPacket.neighborList();
        if (neighbors != null) {
            for (MacAddress macAddress : neighbors) {
                if (!this.interfaceMacAddress.equals((Object)macAddress)) continue;
                neighbor.setNeighborState(IsisInterfaceState.UP);
                this.buildStoreAndSendSelfGeneratedLspIfNotExistInDb(channel, IsisRouterType.get((int)helloPacket.circuitType()));
                break;
            }
        }
    }

    private void buildStoreAndSendSelfGeneratedLspIfNotExistInDb(Channel channel, IsisRouterType neighborRouterType) {
        this.channel = channel;
        String lspKey = this.isisLsdb.lspKey(this.systemId);
        LspWrapper wrapper = null;
        if (this.reservedPacketCircuitType == IsisRouterType.L1.value()) {
            wrapper = this.isisLsdb.findLsp(IsisPduType.L1LSPDU, lspKey);
            if (wrapper == null) {
                LsPdu lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L1LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            }
        } else if (this.reservedPacketCircuitType == IsisRouterType.L2.value()) {
            wrapper = this.isisLsdb.findLsp(IsisPduType.L2LSPDU, lspKey);
            if (wrapper == null) {
                LsPdu lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L2LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            }
        } else if (this.reservedPacketCircuitType == IsisRouterType.L1L2.value()) {
            LsPdu lsp;
            if ((neighborRouterType == IsisRouterType.L1 || neighborRouterType == IsisRouterType.L1L2) && (wrapper = this.isisLsdb.findLsp(IsisPduType.L1LSPDU, lspKey)) == null) {
                lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L1LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            }
            if ((neighborRouterType == IsisRouterType.L2 || neighborRouterType == IsisRouterType.L1L2) && (wrapper = this.isisLsdb.findLsp(IsisPduType.L2LSPDU, lspKey)) == null) {
                lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L2LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            }
        }
    }

    private void buildUpdateAndSendSelfGeneratedLspIfDisChange(String previousLanId, String latestLanId, Channel channel, IsisRouterType neighborRouterType) {
        this.channel = channel;
        if (!previousLanId.equals(latestLanId)) {
            String lspKey = this.isisLsdb.lspKey(this.systemId);
            if (this.reservedPacketCircuitType == IsisRouterType.L1.value()) {
                LsPdu lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L1LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            } else if (this.reservedPacketCircuitType == IsisRouterType.L2.value() && (neighborRouterType == IsisRouterType.L2 || neighborRouterType == IsisRouterType.L1L2)) {
                LsPdu lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L2LSPDU, this.allConfiguredInterfaceIps);
                this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                this.sendLsp(lsp, channel);
            } else if (this.reservedPacketCircuitType == IsisRouterType.L1L2.value()) {
                LsPdu lsp;
                if (neighborRouterType == IsisRouterType.L1 || neighborRouterType == IsisRouterType.L1L2) {
                    lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L1LSPDU, this.allConfiguredInterfaceIps);
                    this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                    this.sendLsp(lsp, channel);
                }
                if (neighborRouterType == IsisRouterType.L2 || neighborRouterType == IsisRouterType.L1L2) {
                    lsp = new LspGenerator().getLsp((IsisInterface)this, lspKey, IsisPduType.L2LSPDU, this.allConfiguredInterfaceIps);
                    this.isisLsdb.addLsp((IsisMessage)lsp, true, (IsisInterface)this);
                    this.sendLsp(lsp, channel);
                }
            }
        }
    }

    private void sendLsp(LsPdu lsp, Channel channel) {
        byte[] lspBytes = lsp.asBytes();
        lspBytes = IsisUtil.addLengthAndMarkItInReserved((byte[])lspBytes, (int)8, (int)9, (int)6);
        lspBytes = IsisUtil.addChecksum((byte[])lspBytes, (int)24, (int)25);
        if (channel != null && channel.isConnected() && channel.isOpen()) {
            channel.write((Object)IsisUtil.framePacket((byte[])lspBytes, (int)this.interfaceIndex));
        }
    }

    public void processP2pHelloPduMessage(IsisMessage isisMessage, Channel channel) {
        log.debug("Enters processP2pHelloPduMessage ...!!!");
        P2PHelloPdu helloPacket = (P2PHelloPdu)isisMessage;
        log.debug("IsisInterfaceImpl::processHelloMessage::Interface Type {} OSPFInterfaceState {} ", (Object)this.networkType, (Object)this.interfaceState);
        if (!this.validateHelloMessage((HelloPdu)helloPacket)) {
            return;
        }
        IsisNeighbor neighbor = null;
        List tlvs = ((P2PHelloPdu)isisMessage).tlvs();
        AdjacencyStateTlv stateTlv = null;
        for (IsisTlv tlv : tlvs) {
            if (!(tlv instanceof AdjacencyStateTlv)) continue;
            stateTlv = (AdjacencyStateTlv)tlv;
            break;
        }
        if (stateTlv == null) {
            neighbor = this.neighbouringRouter(isisMessage.sourceMac());
            if (neighbor == null) {
                neighbor = new DefaultIsisNeighbor((HelloPdu)helloPacket, this);
                this.addNeighbouringRouter(neighbor);
            }
            neighbor.setNeighborState(IsisInterfaceState.DOWN);
            this.buildStoreAndSendSelfGeneratedLspIfNotExistInDb(channel, IsisRouterType.get((int)helloPacket.circuitType()));
        } else if (stateTlv.adjacencyType() == IsisInterfaceState.DOWN.value()) {
            neighbor = this.neighbouringRouter(isisMessage.sourceMac());
            if (neighbor == null) {
                neighbor = new DefaultIsisNeighbor((HelloPdu)helloPacket, this);
                this.addNeighbouringRouter(neighbor);
            }
            neighbor.setLocalExtendedCircuitId(stateTlv.localCircuitId());
        } else if (stateTlv.adjacencyType() == IsisInterfaceState.INITIAL.value()) {
            neighbor = this.neighbouringRouter(isisMessage.sourceMac());
            if (neighbor == null) {
                neighbor = new DefaultIsisNeighbor((HelloPdu)helloPacket, this);
                this.addNeighbouringRouter(neighbor);
            }
            neighbor.setNeighborState(IsisInterfaceState.INITIAL);
            neighbor.setLocalExtendedCircuitId(stateTlv.localCircuitId());
        } else if (stateTlv.adjacencyType() == IsisInterfaceState.UP.value()) {
            neighbor = this.neighbouringRouter(isisMessage.sourceMac());
            neighbor.setNeighborState(IsisInterfaceState.UP);
            neighbor.setLocalExtendedCircuitId(stateTlv.localCircuitId());
            this.buildStoreAndSendSelfGeneratedLspIfNotExistInDb(channel, IsisRouterType.get((int)helloPacket.circuitType()));
        }
        neighbor.setHoldingTime(helloPacket.holdingTime());
        neighbor.stopInactivityTimeCheck();
        neighbor.startInactivityTimeCheck();
    }

    public void processLsPduMessage(IsisMessage isisMessage, Channel channel) {
        log.debug("Enters processLsPduMessage ...!!!");
        IsisNeighbor neighbor = this.neighbouringRouter(isisMessage.sourceMac());
        if (this.networkType == IsisNetworkType.BROADCAST && neighbor == null) {
            return;
        }
        LsPdu lsPdu = (LsPdu)isisMessage;
        LspWrapper wrapper = this.isisLsdb.findLsp(lsPdu.isisPduType(), lsPdu.lspId());
        if (wrapper == null || this.isisLsdb.isNewerOrSameLsp((IsisMessage)lsPdu, wrapper.lsPdu()).equalsIgnoreCase("latest")) {
            if (wrapper != null) {
                String lspKey = this.isisLsdb.lspKey(this.systemId);
                if (lsPdu.lspId().equals(lspKey)) {
                    lsPdu.setSequenceNumber(lsPdu.sequenceNumber() + 1);
                    if (lsPdu.pduType() == IsisPduType.L1LSPDU.value()) {
                        this.isisLsdb.setL1LspSeqNo(lsPdu.sequenceNumber());
                    } else if (lsPdu.pduType() == IsisPduType.L2LSPDU.value()) {
                        this.isisLsdb.setL2LspSeqNo(lsPdu.sequenceNumber());
                    }
                    this.isisLsdb.addLsp((IsisMessage)lsPdu, true, (IsisInterface)this);
                    this.sendLsp(lsPdu, channel);
                } else {
                    this.isisLsdb.addLsp((IsisMessage)lsPdu, false, (IsisInterface)this);
                }
            } else {
                this.isisLsdb.addLsp((IsisMessage)lsPdu, false, (IsisInterface)this);
            }
        }
        if (this.networkType() == IsisNetworkType.P2P) {
            IsisPduType psnpType = null;
            if (IsisPduType.get((int)lsPdu.pduType()) == IsisPduType.L1LSPDU) {
                psnpType = IsisPduType.L1PSNP;
            } else if (IsisPduType.get((int)lsPdu.pduType()) == IsisPduType.L2LSPDU) {
                psnpType = IsisPduType.L2PSNP;
            }
            IsisHeader isisHeader = new LspGenerator().getHeader(psnpType);
            Psnp psnp = new Psnp(isisHeader);
            psnp.setSourceId(this.lspKeyP2P(this.systemId));
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(TlvType.LSPENTRY.value());
            tlvHeader.setTlvLength(0);
            LspEntriesTlv lspEntriesTlv = new LspEntriesTlv(tlvHeader);
            LspEntry lspEntry = new LspEntry();
            lspEntry.setLspChecksum(lsPdu.checkSum());
            lspEntry.setLspId(lsPdu.lspId());
            lspEntry.setLspSequenceNumber(lsPdu.sequenceNumber());
            lspEntry.setRemainingTime(lsPdu.remainingLifeTime());
            lspEntriesTlv.addLspEntry(lspEntry);
            psnp.addTlv((IsisTlv)lspEntriesTlv);
            byte[] psnpBytes = psnp.asBytes();
            psnpBytes = IsisUtil.addLengthAndMarkItInReserved((byte[])psnpBytes, (int)8, (int)9, (int)6);
            this.flagValue = false;
            if (channel != null && channel.isConnected() && channel.isOpen()) {
                channel.write((Object)IsisUtil.framePacket((byte[])psnpBytes, (int)this.interfaceIndex));
            }
        }
    }

    public void processPsnPduMessage(IsisMessage isisMessage, Channel channel) {
        log.debug("Enters processPsnPduMessage ...!!!");
        IsisNeighbor neighbor = this.neighbouringRouter(isisMessage.sourceMac());
        if (this.networkType == IsisNetworkType.BROADCAST && neighbor == null) {
            return;
        }
        Psnp psnPacket = (Psnp)isisMessage;
        List isisTlvs = psnPacket.getAllTlv();
        for (IsisTlv isisTlv : isisTlvs) {
            if (!(isisTlv instanceof LspEntriesTlv)) continue;
            LspEntriesTlv lspEntriesTlv = (LspEntriesTlv)isisTlv;
            List lspEntryList = lspEntriesTlv.lspEntry();
            for (LspEntry lspEntry : lspEntryList) {
                String lspKey = lspEntry.lspId();
                LspWrapper lspWrapper = this.isisLsdb.findLsp(psnPacket.isisPduType(), lspKey);
                if (lspWrapper == null || !lspWrapper.isSelfOriginated()) continue;
                this.sendLsp((LsPdu)lspWrapper.lsPdu(), channel);
            }
        }
    }

    public void processCsnPduMessage(IsisMessage isisMessage, Channel channel) {
        String lspKey;
        LspWrapper wrapper;
        log.debug("Enters processCsnPduMessage ...!!!");
        IsisNeighbor neighbor = this.neighbouringRouter(isisMessage.sourceMac());
        if (this.networkType == IsisNetworkType.BROADCAST && neighbor == null) {
            return;
        }
        Csnp csnPacket = (Csnp)isisMessage;
        IsisPduType psnPduType = IsisPduType.L2CSNP.equals((Object)csnPacket.isisPduType()) ? IsisPduType.L2PSNP : IsisPduType.L1PSNP;
        IsisPduType lsPduType = IsisPduType.L2CSNP.equals((Object)csnPacket.isisPduType()) ? IsisPduType.L2LSPDU : IsisPduType.L1LSPDU;
        ArrayList<LspEntry> lspEntryRequestList = new ArrayList<LspEntry>();
        boolean selfOriginatedFound = false;
        List isisTlvs = csnPacket.getAllTlv();
        for (IsisTlv isisTlv : isisTlvs) {
            if (!(isisTlv instanceof LspEntriesTlv)) continue;
            LspEntriesTlv lspEntriesTlv = (LspEntriesTlv)isisTlv;
            List lspEntryList = lspEntriesTlv.lspEntry();
            for (LspEntry lspEntry : lspEntryList) {
                String lspKey2 = lspEntry.lspId();
                LspWrapper lspWrapper = this.isisLsdb.findLsp(lsPduType, lspKey2);
                if (lspWrapper != null) {
                    LsPdu lsPdu = (LsPdu)lspWrapper.lsPdu();
                    if (lspWrapper.isSelfOriginated()) {
                        selfOriginatedFound = true;
                        if (lspEntry.lspSequenceNumber() >= lsPdu.sequenceNumber()) continue;
                        this.sendLsp(lsPdu, channel);
                        continue;
                    }
                    if (lsPdu.sequenceNumber() >= lspEntry.lspSequenceNumber()) continue;
                    lspEntryRequestList.add(lspEntry);
                    this.flagValue = true;
                    continue;
                }
                lspEntryRequestList.add(lspEntry);
                this.flagValue = true;
            }
        }
        if (this.flagValue) {
            this.sendPsnPduMessage(lspEntryRequestList, psnPduType, channel);
            lspEntryRequestList.clear();
        }
        if (!selfOriginatedFound && (wrapper = this.isisLsdb.findLsp(lsPduType, lspKey = this.isisLsdb.lspKey(this.systemId))) != null) {
            this.sendLsp((LsPdu)wrapper.lsPdu(), channel);
        }
    }

    private void sendPsnPduMessage(List<LspEntry> lspEntryRequestList, IsisPduType isisPduType, Channel channel) {
        IsisHeader isisHeader = new LspGenerator().getHeader(isisPduType);
        Psnp psnp = new Psnp(isisHeader);
        psnp.setSourceId(this.lspKeyP2P(this.systemId));
        TlvHeader tlvHeader = new TlvHeader();
        tlvHeader.setTlvType(TlvType.LSPENTRY.value());
        tlvHeader.setTlvLength(0);
        LspEntriesTlv lspEntriesTlv = new LspEntriesTlv(tlvHeader);
        for (LspEntry lspEntry : lspEntryRequestList) {
            lspEntry.setLspChecksum(0);
            lspEntry.setLspSequenceNumber(0);
            lspEntry.setRemainingTime(0);
            lspEntriesTlv.addLspEntry(lspEntry);
        }
        psnp.addTlv((IsisTlv)lspEntriesTlv);
        byte[] psnpBytes = psnp.asBytes();
        psnpBytes = IsisUtil.addLengthAndMarkItInReserved((byte[])psnpBytes, (int)8, (int)9, (int)6);
        this.flagValue = false;
        if (channel != null && channel.isConnected() && channel.isOpen()) {
            channel.write((Object)IsisUtil.framePacket((byte[])psnpBytes, (int)this.interfaceIndex));
        }
    }

    public String lspKeyP2P(String systemId) {
        StringBuilder lspKey = new StringBuilder();
        lspKey.append(systemId);
        lspKey.append(".00");
        return lspKey.toString();
    }

    public void startHelloSender(Channel channel) {
        log.debug("IsisInterfaceImpl::startHelloSender");
        if (!this.helloSenderStarted) {
            this.isisHelloPduSender = new IsisHelloPduSender(channel, this);
            this.exServiceHello = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> helloHandle = this.exServiceHello.scheduleAtFixedRate(this.isisHelloPduSender, 0L, this.helloInterval, TimeUnit.SECONDS);
            this.helloSenderStarted = true;
        }
    }

    public void stopHelloSender() {
        log.debug("IsisInterfaceImpl::stopHelloSender");
        this.exServiceHello.shutdown();
        this.helloSenderStarted = false;
    }
}

