/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.impl;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterface;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.controller.IsisNeighbor;
import org.onosproject.isis.controller.IsisPduType;
import org.onosproject.isis.controller.IsisRouterType;
import org.onosproject.isis.io.isispacket.pdu.HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.P2PHelloPdu;
import org.onosproject.isis.io.util.IsisConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIsisNeighbor
implements IsisNeighbor {
    private static final Logger log = LoggerFactory.getLogger(DefaultIsisNeighbor.class);
    private String neighborAreaId;
    private String neighborSystemId;
    private Ip4Address interfaceIp;
    private MacAddress neighborMacAddress;
    private volatile int holdingTime;
    private int neighborDownInterval;
    private IsisRouterType routerType;
    private String l1LanId;
    private String l2LanId;
    private byte localCircuitId;
    private int localExtendedCircuitId;
    private IsisInterfaceState neighborState = IsisInterfaceState.INITIAL;
    private InternalInactivityTimeCheck inActivityTimeCheckTask;
    private ScheduledExecutorService exServiceInActivity;
    private InternalHoldingTimeCheck holdingTimeCheckTask;
    private ScheduledExecutorService exServiceHoldingTimeCheck;
    private boolean inActivityTimerScheduled = false;
    private IsisInterface isisInterface;

    public DefaultIsisNeighbor(HelloPdu helloMessage, IsisInterface isisInterface) {
        this.neighborMacAddress = helloMessage.sourceMac();
        List areaAddresses = helloMessage.areaAddress();
        this.neighborAreaId = areaAddresses != null ? (String)areaAddresses.get(0) : "";
        this.neighborSystemId = helloMessage.sourceId();
        List interfaceIpAddresses = helloMessage.interfaceIpAddresses();
        this.interfaceIp = helloMessage.interfaceIpAddresses() != null ? (Ip4Address)interfaceIpAddresses.get(0) : IsisConstants.DEFAULTIP;
        this.neighborDownInterval = this.holdingTime = helloMessage.holdingTime();
        this.routerType = IsisRouterType.get((int)helloMessage.circuitType());
        if (helloMessage instanceof L1L2HelloPdu) {
            if (IsisPduType.L1HELLOPDU == helloMessage.isisPduType()) {
                this.l1LanId = ((L1L2HelloPdu)helloMessage).lanId();
            } else if (IsisPduType.L2HELLOPDU == helloMessage.isisPduType()) {
                this.l2LanId = ((L1L2HelloPdu)helloMessage).lanId();
            }
        } else if (helloMessage instanceof P2PHelloPdu) {
            this.localCircuitId = ((P2PHelloPdu)helloMessage).localCircuitId();
        }
        this.isisInterface = isisInterface;
        this.startHoldingTimeCheck();
        log.debug("Neighbor added - {}", (Object)this.neighborMacAddress);
    }

    public int localExtendedCircuitId() {
        return this.localExtendedCircuitId;
    }

    public void setLocalExtendedCircuitId(int localExtendedCircuitId) {
        this.localExtendedCircuitId = localExtendedCircuitId;
    }

    public String neighborAreaId() {
        return this.neighborAreaId;
    }

    public void setNeighborAreaId(String neighborAreaId) {
        this.neighborAreaId = neighborAreaId;
    }

    public String neighborSystemId() {
        return this.neighborSystemId;
    }

    public void setNeighborSystemId(String neighborSystemId) {
        this.neighborSystemId = neighborSystemId;
    }

    public Ip4Address interfaceIp() {
        return this.interfaceIp;
    }

    public void setInterfaceIp(Ip4Address interfaceIp) {
        this.interfaceIp = interfaceIp;
    }

    public MacAddress neighborMacAddress() {
        return this.neighborMacAddress;
    }

    public void setNeighborMacAddress(MacAddress neighborMacAddress) {
        this.neighborMacAddress = neighborMacAddress;
    }

    public int holdingTime() {
        return this.holdingTime;
    }

    public void setHoldingTime(int holdingTime) {
        this.holdingTime = holdingTime;
    }

    public IsisRouterType routerType() {
        return this.routerType;
    }

    public void setRouterType(IsisRouterType routerType) {
        this.routerType = routerType;
    }

    public String l1LanId() {
        return this.l1LanId;
    }

    public void setL1LanId(String l1LanId) {
        this.l1LanId = l1LanId;
    }

    public String l2LanId() {
        return this.l2LanId;
    }

    public void setL2LanId(String l2LanId) {
        this.l2LanId = l2LanId;
    }

    public IsisInterfaceState interfaceState() {
        return this.neighborState;
    }

    public void setNeighborState(IsisInterfaceState neighborState) {
        this.neighborState = neighborState;
    }

    public byte localCircuitId() {
        return this.localCircuitId;
    }

    public void setLocalCircuitId(byte localCircuitId) {
        this.localCircuitId = localCircuitId;
    }

    public IsisInterfaceState neighborState() {
        return this.neighborState;
    }

    public void startHoldingTimeCheck() {
        log.debug("IsisNeighbor::startHoldingTimeCheck");
        this.holdingTimeCheckTask = new InternalHoldingTimeCheck();
        this.exServiceHoldingTimeCheck = Executors.newSingleThreadScheduledExecutor();
        this.exServiceHoldingTimeCheck.scheduleAtFixedRate(this.holdingTimeCheckTask, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stopHoldingTimeCheck() {
        log.debug("IsisNeighbor::stopHoldingTimeCheck ");
        this.exServiceHoldingTimeCheck.shutdown();
    }

    public void startInactivityTimeCheck() {
        if (!this.inActivityTimerScheduled) {
            log.debug("IsisNeighbor::startInactivityTimeCheck");
            this.inActivityTimeCheckTask = new InternalInactivityTimeCheck();
            this.exServiceInActivity = Executors.newSingleThreadScheduledExecutor();
            this.exServiceInActivity.scheduleAtFixedRate(this.inActivityTimeCheckTask, this.neighborDownInterval, this.neighborDownInterval, TimeUnit.SECONDS);
            this.inActivityTimerScheduled = true;
        }
    }

    public void stopInactivityTimeCheck() {
        if (this.inActivityTimerScheduled) {
            log.debug("IsisNeighbor::stopInactivityTimeCheck ");
            this.exServiceInActivity.shutdown();
            this.inActivityTimerScheduled = false;
        }
    }

    public void neighborDown() {
        log.debug("Neighbor Down {} and NeighborSystemId {}", (Object)this.neighborMacAddress, (Object)this.neighborSystemId);
        this.stopInactivityTimeCheck();
        this.isisInterface.setL1LanId("0000.0000.0000.00");
        this.isisInterface.setL2LanId("0000.0000.0000.00");
        this.neighborState = IsisInterfaceState.DOWN;
        this.stopInactivityTimeCheck();
        this.stopHoldingTimeCheck();
        this.isisInterface.removeNeighbor((IsisNeighbor)this);
        this.isisInterface.isisLsdb().removeTopology((IsisNeighbor)this, this.isisInterface);
    }

    private class InternalHoldingTimeCheck
    implements Runnable {
        InternalHoldingTimeCheck() {
        }

        @Override
        public void run() {
            DefaultIsisNeighbor.this.holdingTime--;
            if (DefaultIsisNeighbor.this.holdingTime <= 0) {
                log.debug("Calling neighbor down. Holding time is 0.");
                DefaultIsisNeighbor.this.neighborDown();
            }
        }
    }

    private class InternalInactivityTimeCheck
    implements Runnable {
        InternalInactivityTimeCheck() {
        }

        @Override
        public void run() {
            log.debug("Neighbor Not Heard till the past router dead interval .");
            DefaultIsisNeighbor.this.neighborDown();
        }
    }
}

